/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#ifndef __GTK_USERGROUP_H_
#define __GTK_USERGROUP_H_

#ifdef HAVE_CONFIG_H
#	include <config.h>
#endif

#define _(s) (gchar *) gettext (s)

#include <gdk/gdk.h>
#include <glade/glade.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

	
#define GTK_TYPE_USERGROUP          (gtk_usergroup_get_type ())
#define GTK_USERGROUP(obj)          GTK_CHECK_CAST (obj, gtk_usergroup_get_type (), GtkUserGroup)
#define GTK_USERGROUP_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, gtk_usergroup_get_type (), GtkUserGroupClass)
#define IS_GTK_USERGROUP(obj)       GTK_CHECK_TYPE (obj, gtk_usergroup_get_type ())

	
typedef struct _GtkUserGroup      GtkUserGroup;
typedef struct _GtkUserGroupClass GtkUserGroupClass;

//
struct _GtkUserGroup
{
	GtkWindow window;
  
  	GladeXML *xml;
	
	GtkTreeView  *view_users,  *view_groups;
	GtkListStore *store_users, *store_groups;
	
	/*** ***/
	
	/* Private */
	/*GtkWidget *validate_user_widget;
	void (*validate_user_function) (GtkWidget *, gpointer *);
	
	GtkWidget *validate_group_widget;
	void (*validate_group_function) (GtkWidget *, gpointer *);
	
	GtkListStore *list_users, list_groups;*/
	
	/* public */
	
	uid_t uid;
	gchar *user_name;
	
	gid_t gid;
	gchar *group_name;

};

struct _GtkUserGroupClass
{
	GtkWindowClass parent_class;

	void (* validate_user) (GtkUserGroup *gtk_usergroup);
	void (* validate_group) (GtkUserGroup *gtk_usergroup);
	void (* cancel)   (GtkUserGroup *gtk_usergroup);	//NOT IMPLEMENTED
};


GType    gtk_usergoup_get_type (void);
GtkWidget *gtk_usergroup_new     (void);	

//Add the Validate callback function 
/*void gtk_usergroup_set_validate_user(GtkUserGroup *gtk_usergroup, GtkWidget *widget,
	void *function);
void gtk_usergroup_set_validate_group(GtkUserGroup *gtk_usergroup, GtkWidget *widget,
	void *function);*/

//void gtk_usergroup_hide_users(GtkUserGroup *gtk_usergroup);

#ifdef __cplusplus
}
#endif /* __cplusplus */
	
#endif
