/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gdk/gdk.h>
#include <gtk/gtk.h>


#ifndef _GTK_ACL_VIEW_H_
#define _GTK_ACL_VIEW_H_

#include "gperms.h"


#define _(s) (gchar *) gettext (s)

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

	
#define GTK_TYPE_ACL_VIEW          (gtk_acl_view_get_type ())
#define GTK_ACL_VIEW(obj)          GTK_CHECK_CAST (obj, gtk_acl_view_get_type (), GtkAclView)
#define GTK_ACL_VIEW_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, gtk_acl_view_get_type(), GtkAclViewClass)
#define IS_GTK_ACL_VIEW(obj)       GTK_CHECK_TYPE (obj, gtk_acl_view_get_type ())
	

typedef struct _GtkAclView      GtkAclView;
typedef struct _GtkAclViewClass GtkAclViewClass;

//
struct _GtkAclView
{
	GtkTreeView treeview;
  
	GtkTreeStore *store;	
	GtkTreeIter iter_user;
	GtkTreeIter iter_group;
	GPerms       *perms;
	
	/* PUBLIC */
};

//
struct _GtkAclViewClass
{
	GtkTreeViewClass parent_class;

};

enum {
	COL_TYPE = 0,
	COL_NAME,
	COL_ID,
	COL_READ,
	COL_WRITE,
	COL_EXECUTE	
};


GtkType    gtk_acl_view_get_type(void);
GtkWidget *gtk_acl_view_new();



/* End widget internal function */

//set the g_perms model
void gtk_acl_set_perms(GtkAclView *gtk_acl_view, GPerms *g_perms);


/* Load the the acl permission into the GtkAclView
 * PARAMETERS :
 *	filename : name of file
 *	type : TYPE_ACCESS or TYPE_DEFAULT
 */
//void gtk_acl_view_load_file(GtkAclView *gtk_acl_view, const gchar *filename, gint type);



/* Delete the selected acl
 */
void gtk_acl_view_delete(GtkAclView *gtk_acl_view);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif //_GTK_ACL_VIEW_H_
