/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 

#include <libintl.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "gtkaclview.h"
//#include "gtkaclview-callbacks.h"


static void gtk_acl_view_class_init (GtkAclViewClass *class);
static void gtk_acl_view_init(GtkAclView *gtk_acl_view);

void gtk_acl_view_load(GtkAclView *gtk_acl_view);

//CALLBACKS
void on_add_user (GPerms *g_perms, gpointer data); //GPerms add-user signal
void on_del_user (GPerms *g_perms, gpointer data); //GPerms del-user signal
void on_add_group(GPerms *g_perms, gpointer data);
void on_del_group(GPerms *g_perms, gpointer data);

void gtk_acl_view_on_toggle_read(GtkCellRendererToggle *cell, gchar *path_str,
	gpointer data);
void gtk_acl_view_on_toggle_write(GtkCellRendererToggle *cell, gchar *path_str,
	gpointer data);
void gtk_acl_view_on_toggle_execute(GtkCellRendererToggle *cell, gchar *path_str,
	gpointer data);
static void on_init_default(GPerms *g_perms, gpointer data);	//GPerms init-default signal
static void on_clear_default(GPerms *g_perms, gpointer data);	//GPerms clear-default signal
static void on_set_user(GPerms *g_perms, gpointer data);	//GPerms set-user signal
static void on_set_group(GPerms *g_perms, gpointer data);	//GPerms set-group signal

//INTERNALY
static void create_view(GtkAclView *gtk_acl_view);



//
GtkType gtk_acl_view_get_type(void)
{
	static GType gtk_acl_view_type = 0;

	if (!gtk_acl_view_type) 
	{
		static const GTypeInfo gtk_acl_view_info =
		{
			sizeof (GtkAclViewClass),
			NULL,
			NULL,
			(GClassInitFunc)  gtk_acl_view_class_init,
			NULL,
			NULL,
			sizeof (GtkAclView),
			0,
			(GInstanceInitFunc) gtk_acl_view_init
		};

		gtk_acl_view_type = g_type_register_static (GTK_TYPE_TREE_VIEW, 
				"GtkAclView", &gtk_acl_view_info, 0);
	}

	return gtk_acl_view_type;
}

//
static void gtk_acl_view_class_init (GtkAclViewClass *class)
{
	GtkObjectClass *object_class;

	object_class = (GtkObjectClass *) class;
  
	/*gtk_usergroup_signals[VALIDATE] = 
		g_signal_new ("validate",
				G_OBJECT_CLASS_TYPE(object_class),
				GTK_RUN_FIRST,
				G_STRUCT_OFFSET (GtkUserGroupClass, validate),
				NULL, NULL,
				g_cclosure_marshal_VOID__VOID, GTK_TYPE_NONE, 0);*/
  
	//class->validate = NULL;
}


//
static void gtk_acl_view_init(GtkAclView *gtk_acl_view)
{
	gtk_acl_view->store = gtk_tree_store_new(6, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, 
		G_TYPE_BOOLEAN,	G_TYPE_BOOLEAN, G_TYPE_BOOLEAN);
	
	gtk_tree_view_set_model(GTK_TREE_VIEW(gtk_acl_view), GTK_TREE_MODEL(gtk_acl_view->store));
	
	//Acl Tree View
	create_view(gtk_acl_view);
	
}

//
GtkWidget *gtk_acl_view_new()
{
	GtkAclView *gtk_acl_view;

	gtk_acl_view = g_object_new(GTK_TYPE_ACL_VIEW, NULL);
	return GTK_WIDGET(gtk_acl_view);
}


/********* **********/

//Define the g_perms model
void gtk_acl_view_set_perms(GtkAclView *gtk_acl_view, GPerms *g_perms)
{
	gtk_acl_view->perms = g_perms;
	
	g_signal_connect(G_OBJECT(g_perms), "add-user", G_CALLBACK(on_add_user), 
		GINT_TO_POINTER(gtk_acl_view));
	g_signal_connect(G_OBJECT(g_perms), "del-user", G_CALLBACK(on_del_user),
		GINT_TO_POINTER(gtk_acl_view));
	
	g_signal_connect(G_OBJECT(g_perms), "add-group", G_CALLBACK(on_add_group),
		GINT_TO_POINTER(gtk_acl_view));
	g_signal_connect(G_OBJECT(g_perms), "del-group", G_CALLBACK(on_del_group),
		GINT_TO_POINTER(gtk_acl_view));
	
	g_signal_connect(G_OBJECT(g_perms), "init-default", G_CALLBACK(on_init_default),
		GINT_TO_POINTER(gtk_acl_view));
	g_signal_connect(G_OBJECT(g_perms), "clear-default", G_CALLBACK(on_clear_default),
		GINT_TO_POINTER(gtk_acl_view));

	g_signal_connect(G_OBJECT(g_perms), "set-user", G_CALLBACK(on_set_user),
		GINT_TO_POINTER(gtk_acl_view));
	g_signal_connect(G_OBJECT(g_perms), "set_group", G_CALLBACK(on_set_group),
		GINT_TO_POINTER(gtk_acl_view));
	
	gtk_acl_view_load(gtk_acl_view);
}


//
void gtk_acl_view_load(GtkAclView *gtk_acl_view)
{
	gint type;
	GtkTreeIter iter_others_root, iter_mask_root;
	GtkTreeIter iter;
	GPermsEntry *entry_perms;

	g_log(0, G_LOG_LEVEL_DEBUG, "GtkAclView : Load");
		
	//gtk_tree_store_clear(gtk_acl_view->store);

	entry_perms = g_perms_get_entry(gtk_acl_view->perms, P_FIRST_ENTRY);
	if (entry_perms == NULL)
		return;
	
	gtk_tree_store_append(GTK_TREE_STORE(gtk_acl_view->store), 
		&gtk_acl_view->iter_user, NULL);
	gtk_tree_store_append(GTK_TREE_STORE(gtk_acl_view->store), 
		&gtk_acl_view->iter_group, NULL);
	gtk_tree_store_append(GTK_TREE_STORE(gtk_acl_view->store), 
		&iter_others_root, NULL);

	
	
	//
	while (entry_perms) 
	{
		GtkTreeIter iter_user;
		
		if (entry_perms->type == P_USER_OWNER)
		{
			gtk_tree_store_set(
				GTK_TREE_STORE(gtk_acl_view->store), &gtk_acl_view->iter_user, 
				COL_TYPE   , _("Users"),
				COL_ID     , g_strdup_printf("%u", entry_perms->id),
				COL_NAME   , entry_perms->name,
				COL_READ   , entry_perms->read,
				COL_WRITE  , entry_perms->write,
				COL_EXECUTE, entry_perms->exec,
				-1);
		}

		
		if (entry_perms->type == P_USER)
		{			
			gtk_tree_store_append(
				GTK_TREE_STORE(gtk_acl_view->store), &iter, 
				&gtk_acl_view->iter_user);			
			gtk_tree_store_set(
				GTK_TREE_STORE(gtk_acl_view->store), &iter, 
				COL_ID     , g_strdup_printf("%u", entry_perms->id), 
				COL_NAME   , entry_perms->name, 
				COL_READ   , entry_perms->read,
				COL_WRITE  , entry_perms->write,
				COL_EXECUTE, entry_perms->exec,
				-1);
		}

		
		if (entry_perms->type == P_GROUP_OWNER) 
		{
			gtk_tree_store_set(
				GTK_TREE_STORE(gtk_acl_view->store), &gtk_acl_view->iter_group,
				COL_TYPE   , _("Groups"),
				COL_ID     , g_strdup_printf("%u", entry_perms->id), 
				COL_NAME   , entry_perms->name, 
				COL_READ   , entry_perms->read,
				COL_WRITE  , entry_perms->write,
				COL_EXECUTE, entry_perms->exec,
				-1);
		}

		
		if (entry_perms->type == P_GROUP)
		{
			gtk_tree_store_append(
				GTK_TREE_STORE(gtk_acl_view->store), &iter,
				&gtk_acl_view->iter_group);
			gtk_tree_store_set(
				GTK_TREE_STORE(gtk_acl_view->store), &iter, 
				COL_ID     , g_strdup_printf("%u", entry_perms->id), 
				COL_NAME   , entry_perms->name, 
				COL_READ   , entry_perms->read,
				COL_WRITE  , entry_perms->write,
				COL_EXECUTE, entry_perms->exec,
				-1);

		}
			
		
		if (entry_perms->type == P_OTHER)
		{
			gtk_tree_store_set(
				GTK_TREE_STORE(gtk_acl_view->store), &iter_others_root, 
				COL_TYPE   , _("Others"),
				COL_READ   , entry_perms->read,
				COL_WRITE  , entry_perms->write,
				COL_EXECUTE, entry_perms->exec,
				-1);
		}

			
		if (entry_perms->type == P_MASK)
		{
			gtk_tree_store_append(GTK_TREE_STORE(gtk_acl_view->store),
				&iter_mask_root, NULL);
		
			gtk_tree_store_set(
				GTK_TREE_STORE(gtk_acl_view->store), &iter_mask_root, 
				COL_TYPE   , _("Mask"),
				COL_READ   , entry_perms->read,
				COL_WRITE  , entry_perms->write,
				COL_EXECUTE, entry_perms->exec,
				-1);
		}
									
		
		if (entry_perms)
			g_free(entry_perms);
			
		entry_perms = g_perms_get_entry(gtk_acl_view->perms, P_NEXT_ENTRY);
	}
	
	//A modifier
	gtk_tree_view_expand_all(GTK_TREE_VIEW(gtk_acl_view));
	
	//Special perms
	/*struct _special_entry_perms *special_perms;
	
	special_perms = g_perms_get_special_perms(gtk_acl->perms);
	
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(gtk_acl->check_special[0]), 
		special_perms->suid);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(gtk_acl->check_special[1]), 
		special_perms->sgid);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(gtk_acl->check_special[2]), 
		special_perms->sticky);
	
	gtk_acl_gray(gtk_acl);*/
}

//Delete the current selected entry
void gtk_acl_view_delete(GtkAclView *gtk_acl_view)
{
	GtkTreeModel *tree_store;
	GtkTreePath *path;
	GtkTreeViewColumn *column;
	gint *indices;
	gint depth;
	
	g_log(0, G_LOG_LEVEL_DEBUG, "GtkAclView: Delete selected entry", 0);
	
	gtk_tree_view_get_cursor(GTK_TREE_VIEW(gtk_acl_view), &path, &column);
	if (path == NULL)
		return;
	
	indices = gtk_tree_path_get_indices(path);
	depth   = gtk_tree_path_get_depth(path);

	
	//User ACL (and not Unix)
	if ((indices[0] == 0) && (depth == 2)) 
	{
		GtkTreeSelection *selection;
		GtkTreeIter iter;
		gchar *id;
		uid_t uid;
		
		g_log(0, G_LOG_LEVEL_DEBUG, "GtkAclView: Delete user entry", 0);

		selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(gtk_acl_view));
		if (!gtk_tree_selection_get_selected(GTK_TREE_SELECTION(selection), 
							&tree_store, &iter)) {
			return;
		}
		
		gtk_tree_model_get(GTK_TREE_MODEL(gtk_acl_view->store), &iter, COL_ID, &id, -1);
	
		uid = (uid_t) atoi(id);
		if (g_perms_del_user(gtk_acl_view->perms, uid) == -1)
			return;
		
		//Remove user from tree
		g_perms_del_user(gtk_acl_view->perms, uid);
		//gtk_tree_store_remove(GTK_TREE_STORE(gtk_acl_view->store), &iter);
		
	}
	
	//Group
	if ((indices[0] == 1) && (depth == 2)) 
	{
		GtkTreeSelection *selection;
		GtkTreeIter iter;
		gchar *id;
		gid_t gid;

		selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(gtk_acl_view));
		if (!gtk_tree_selection_get_selected(GTK_TREE_SELECTION(selection), 
							&tree_store, &iter)) {
			return;
		}
		
		gtk_tree_model_get(GTK_TREE_MODEL(gtk_acl_view->store), &iter, COL_ID, &id, -1);

		gid = (gid_t) atoi(id);
		g_perms_del_group(gtk_acl_view->perms, gid);
		
	}
}


/******** CALLBACKS **********/

//GPerms add-user signal
void on_add_user(GPerms *g_perms, gpointer data)
{
	GtkAclView *gtk_acl_view;
	GtkTreeIter iter_user;
	
	g_log(0, G_LOG_LEVEL_DEBUG, "GtkAclView: Catch add-user signal", 0);

	gtk_acl_view = GTK_ACL_VIEW(GPOINTER_TO_INT(data));
	
	g_assert(g_perms->entry);
	
	//printf("Ajout d'un utilisateur\n");
	gtk_tree_store_append(GTK_TREE_STORE(gtk_acl_view->store), &iter_user,
		&gtk_acl_view->iter_user);
	gtk_tree_store_set(GTK_TREE_STORE(gtk_acl_view->store), &iter_user, 
			COL_ID     , g_strdup_printf("%u", g_perms->entry->id), 
			COL_NAME   , g_perms->entry->name, 
			COL_READ   , g_perms->entry->read,
			COL_WRITE  , g_perms->entry->write,
			COL_EXECUTE, g_perms->entry->exec,
			-1);

	gtk_tree_view_expand_all(GTK_TREE_VIEW(gtk_acl_view));
}

//
void on_del_user(GPerms *g_perms, gpointer data)
{	
	GtkAclView *gtk_acl_view;
	GtkTreeIter iter;
	gchar *id;
	uid_t gid;
	guint i;
	
	g_log(0, G_LOG_LEVEL_DEBUG, "GtkAclView: Catch del-user signal", 0);

	gtk_acl_view = GTK_ACL_VIEW(GPOINTER_TO_INT(data));	
	
	
	//Scan each users entry
	for (i=0; 1; i++)
	{
		if (gtk_tree_model_iter_nth_child(GTK_TREE_MODEL(gtk_acl_view->store), &iter,
			&gtk_acl_view->iter_user, i) == FALSE)
			return;
		
		gtk_tree_model_get(GTK_TREE_MODEL(gtk_acl_view->store), &iter, COL_ID, &id, -1);
		gid = (gid_t) atoi(id);
		
		if (gid == gtk_acl_view->perms->entry->id)
		{
			gtk_tree_store_remove(GTK_TREE_STORE(gtk_acl_view->store), &iter);
			return;
		}
			
	}
}

//GPerms add-user signal
void on_add_group(GPerms *g_perms, gpointer data)
{
	GtkAclView *gtk_acl_view;
	GtkTreeIter iter_group;
	
	g_log(0, G_LOG_LEVEL_DEBUG, "GtkAclView: Catch add-group signal with gid=%d", g_perms->entry->id);

	gtk_acl_view = GTK_ACL_VIEW(GPOINTER_TO_INT(data));
	
	g_assert(g_perms->entry);
	
	//printf("Ajout d'un utilisateur\n");
	gtk_tree_store_append(GTK_TREE_STORE(gtk_acl_view->store), &iter_group,
		&gtk_acl_view->iter_group);
	gtk_tree_store_set(GTK_TREE_STORE(gtk_acl_view->store), &iter_group, 
			COL_ID     , g_strdup_printf("%u", g_perms->entry->id), 
			COL_NAME   , g_perms->entry->name, 
			COL_READ   , g_perms->entry->read,
			COL_WRITE  , g_perms->entry->write,
			COL_EXECUTE, g_perms->entry->exec,
			-1);

	gtk_tree_view_expand_all(GTK_TREE_VIEW(gtk_acl_view));
}


/* Handle connect to del-group GPerms signal.
   Remove group to view_access
 */
void on_del_group(GPerms *g_perms, gpointer data)
{
	GtkAclView *gtk_acl_view;
	GtkTreeIter iter;
	gchar *id;
	gid_t gid;
	guint i;
	
	g_log(0, G_LOG_LEVEL_DEBUG, "GtkAclView: Catch del-group signal with gid=%d", g_perms->entry->id);

	gtk_acl_view = GTK_ACL_VIEW(GPOINTER_TO_INT(data));	
	
	
	//Scan each group entry
	for (i=0; 1; i++)
	{
		if (gtk_tree_model_iter_nth_child(GTK_TREE_MODEL(gtk_acl_view->store), &iter,
			&gtk_acl_view->iter_group, i) == FALSE)
			return;
		
		gtk_tree_model_get(GTK_TREE_MODEL(gtk_acl_view->store), &iter, COL_ID, &id, -1);
		gid = (gid_t) atoi(id);
		
		if (gid == gtk_acl_view->perms->entry->id)
		{
			gtk_tree_store_remove(GTK_TREE_STORE(gtk_acl_view->store), &iter);
			return;
		}
			
	}
}


//
void gtk_acl_view_on_toggle_read(GtkCellRendererToggle *cell, gchar *path_str,
	gpointer data)
{
	GtkAclView *gtk_acl_view;
	GtkTreeIter iter;
	GtkTreePath *path;
	
	gchar    *id;
	gboolean  state, update_perm;	
	gint *indices;
	
	
	gtk_acl_view = GTK_ACL_VIEW(data);
	
	path = gtk_tree_path_new_from_string(path_str);
	gtk_tree_model_get_iter(GTK_TREE_MODEL(gtk_acl_view->store), &iter, path);
	
	gtk_tree_model_get(GTK_TREE_MODEL(gtk_acl_view->store), &iter, 
		COL_ID, &id, 
		COL_READ, &state, -1);
	
	indices = gtk_tree_path_get_indices(path);
	
	
	//For unix user
	if (indices[0] == 0)
		update_perm = g_perms_set_perm(gtk_acl_view->perms, P_USER, (uid_t) atoi(id),
			P_READ, !state);
				
	//For Groups
	if (indices[0] == 1)
		update_perm = g_perms_set_perm(gtk_acl_view->perms, P_GROUP, (uid_t) atoi(id), 
			P_READ, !state);

	//For Others
	if (indices[0] == 2)
		update_perm = g_perms_set_perm(gtk_acl_view->perms, P_OTHER, 0, P_READ, !state);
		
	//For Mask
	if (indices[0] == 3)
		update_perm = g_perms_set_perm(gtk_acl_view->perms, P_MASK, 0, P_READ, !state);
			
	
	if (update_perm)
		gtk_tree_store_set(GTK_TREE_STORE(gtk_acl_view->store), &iter, COL_READ, !state, -1);
	
	//gtk_acl_view_load(gtk_acl_view);
}

//
void gtk_acl_view_on_toggle_write(GtkCellRendererToggle *cell, gchar *path_str,
	gpointer data)
{
	GtkAclView *gtk_acl_view;
	GtkTreeIter iter;
	GtkTreePath *path;
	
	gchar    *id;
	gboolean  state, update_perm;	
	gint *indices;
	
	
	gtk_acl_view = GTK_ACL_VIEW(data);
	
	path = gtk_tree_path_new_from_string(path_str);
	gtk_tree_model_get_iter(GTK_TREE_MODEL(gtk_acl_view->store), &iter, path);
	
	gtk_tree_model_get(GTK_TREE_MODEL(gtk_acl_view->store), &iter, 
		COL_ID, &id, 
		COL_WRITE, &state, -1);
	
	indices = gtk_tree_path_get_indices(path);
	
	
	//For unix user
	if (indices[0] == 0)
		update_perm = g_perms_set_perm(gtk_acl_view->perms, P_USER, (uid_t) atoi(id),
			P_WRITE, !state);
		
	//For Groups
	if (indices[0] == 1)
		update_perm = g_perms_set_perm(gtk_acl_view->perms, P_GROUP, (uid_t) atoi(id), 
			P_WRITE, !state);

	//For Others
	if (indices[0] == 2)
		update_perm = g_perms_set_perm(gtk_acl_view->perms, P_OTHER, 0, P_WRITE, !state);
		
	//For Mask
	if (indices[0] == 3)
		update_perm = g_perms_set_perm(gtk_acl_view->perms, P_MASK, 0, P_WRITE, !state);
			
	
	if (update_perm)
		gtk_tree_store_set(GTK_TREE_STORE(gtk_acl_view->store), &iter, COL_WRITE, 
			!state, -1);
}


//
void gtk_acl_view_on_toggle_execute(GtkCellRendererToggle *cell, gchar *path_str,
	gpointer data)
{
	GtkAclView *gtk_acl_view;
	GtkTreeIter iter;
	GtkTreePath *path;
	
	gchar    *id;
	gboolean  state, update_perm;	
	gint *indices;
	
	
	gtk_acl_view = GTK_ACL_VIEW(data);
	
	path = gtk_tree_path_new_from_string(path_str);
	gtk_tree_model_get_iter(GTK_TREE_MODEL(gtk_acl_view->store), &iter, path);
	
	gtk_tree_model_get(GTK_TREE_MODEL(gtk_acl_view->store), &iter, 
		COL_ID, &id, 
		COL_EXECUTE, &state, -1);
	
	indices = gtk_tree_path_get_indices(path);
	
	//For unix user
	if (indices[0] == 0)
		update_perm = g_perms_set_perm(gtk_acl_view->perms, P_USER, (uid_t) atoi(id),
			P_EXECUTE, !state);
		
	//For Groups
	if (indices[0] == 1)
		update_perm = g_perms_set_perm(gtk_acl_view->perms, P_GROUP, (uid_t) atoi(id), 
			P_EXECUTE, !state);

	//For Others
	if (indices[0] == 2)
		update_perm = g_perms_set_perm(gtk_acl_view->perms, P_OTHER, 0, P_EXECUTE, !state);
		
	//For Mask
	if (indices[0] == 3)
		update_perm = g_perms_set_perm(gtk_acl_view->perms, P_MASK, 0, P_EXECUTE, !state);
			
	
	if (update_perm)
		gtk_tree_store_set(GTK_TREE_STORE(gtk_acl_view->store), &iter, COL_EXECUTE, 
			!state, -1);
}

//
static void on_init_default(GPerms *g_perms, gpointer data)
{
	GtkAclView *gtk_acl_view;
	
	gtk_acl_view = GTK_ACL_VIEW(GPOINTER_TO_INT(data));
	
	g_log(0, G_LOG_LEVEL_DEBUG, "GtkAclView : Catch init-default Signal", 0);
	gtk_acl_view_load(GTK_ACL_VIEW(gtk_acl_view));
}

//
static void on_clear_default(GPerms *g_perms, gpointer data)
{
	GtkAclView *gtk_acl_view;
	
	gtk_acl_view = GTK_ACL_VIEW(GPOINTER_TO_INT(data));
	
	g_log(0, G_LOG_LEVEL_DEBUG, "GtkAclView : Catch clear-default Signal", 0);
	gtk_tree_store_clear(GTK_TREE_STORE(gtk_acl_view->store));
}

//
static void on_set_user(GPerms *g_perms, gpointer data)
{
	GtkAclView *gtk_acl_view;
	
	gtk_acl_view = GTK_ACL_VIEW(GPOINTER_TO_INT(data));
	
	g_log(0, G_LOG_LEVEL_DEBUG, "GtkAclView : Catch set-user Signal", 0);

	GtkTreeIter iter;
	gchar *name;

	if (gtk_tree_model_iter_nth_child(GTK_TREE_MODEL(gtk_acl_view->store), &iter,
		NULL, 0) == FALSE)
	{
		g_printf(_("Can't get user iter\n"));
		return;
	}
		
	gtk_tree_model_get(GTK_TREE_MODEL(gtk_acl_view->store), &iter, COL_NAME, &name, -1);
	g_log(0, G_LOG_LEVEL_DEBUG, "GtkAclView : Current owner is %s", name);
	
	gchar id[255];
	g_sprintf(id, "%d", g_perms->entry->id);
	gtk_tree_store_set(GTK_TREE_MODEL(gtk_acl_view->store), &iter, 
		COL_NAME, g_perms->entry->name,
		COL_ID,  id,
		-1);
		

}

//
static void on_set_group(GPerms *g_perms, gpointer data)
{
	GtkAclView *gtk_acl_view;
	
	gtk_acl_view = GTK_ACL_VIEW(GPOINTER_TO_INT(data));
	
	g_log(0, G_LOG_LEVEL_DEBUG, "GtkAclView : Catch set-group Signal", 0);

	GtkTreeIter iter;
	gchar *name;

	if (gtk_tree_model_iter_nth_child(GTK_TREE_MODEL(gtk_acl_view->store), &iter,
		NULL, 1) == FALSE)
	{
		g_printf(_("Can't get group iter\n"));
		return;
	}
		
	gtk_tree_model_get(GTK_TREE_MODEL(gtk_acl_view->store), &iter, COL_NAME, &name, -1);
	g_log(0, G_LOG_LEVEL_DEBUG, "GtkAclView : Current owner is %s", name);
	
	gchar id[255];
	g_sprintf(id, "%d", g_perms->entry->id);
	gtk_tree_store_set(GTK_TREE_MODEL(gtk_acl_view->store), &iter, 
		COL_NAME, g_perms->entry->name,
		COL_ID,  id,
		-1);
}

/******** INTERNALY **********/

//
static void create_view(GtkAclView *gtk_acl_view)
{
	GtkTreeViewColumn *col;
	GtkCellRenderer   *cell_renderer;
 
	
	//Column type
	col = gtk_tree_view_column_new();
	gtk_tree_view_column_set_title(col, (gchar *) _("Type"));
	gtk_tree_view_append_column(GTK_TREE_VIEW(gtk_acl_view), col);
	cell_renderer = gtk_cell_renderer_text_new();
	gtk_tree_view_column_pack_start(col, cell_renderer, TRUE);
	gtk_tree_view_column_add_attribute(col, cell_renderer, "text", COL_TYPE);

	//Column Name
	col = gtk_tree_view_column_new();
	gtk_tree_view_column_set_title(col, (gchar *) _("Name"));
	
	gtk_tree_view_append_column(GTK_TREE_VIEW(gtk_acl_view), col);
	cell_renderer = gtk_cell_renderer_text_new();
	gtk_tree_view_column_pack_start(col, cell_renderer, TRUE);
	gtk_tree_view_column_add_attribute(col, cell_renderer, "text", COL_NAME);
	
	//Column Id
	col = gtk_tree_view_column_new();
	gtk_tree_view_column_set_title(col, (gchar *) _("Id"));
	gtk_tree_view_append_column(GTK_TREE_VIEW(gtk_acl_view), col);
	cell_renderer = gtk_cell_renderer_text_new();
	gtk_tree_view_column_pack_start(col, cell_renderer, TRUE);
	gtk_tree_view_column_add_attribute(col, cell_renderer, "text", COL_ID);
	
	//Column Read
	col = gtk_tree_view_column_new();
	gtk_tree_view_column_set_title(col, _("Read"));
	gtk_tree_view_append_column(GTK_TREE_VIEW(gtk_acl_view), col);
	cell_renderer = gtk_cell_renderer_toggle_new();
	g_signal_connect(G_OBJECT(cell_renderer), "toggled", 
		G_CALLBACK(gtk_acl_view_on_toggle_read), gtk_acl_view);
	gtk_tree_view_column_pack_start(col, cell_renderer, TRUE);
	gtk_tree_view_column_add_attribute(col, cell_renderer, "active", COL_READ);
	
	//Column Write
	col = gtk_tree_view_column_new();
	gtk_tree_view_column_set_title(col, _("Write"));
	gtk_tree_view_append_column(GTK_TREE_VIEW(gtk_acl_view), col);
	cell_renderer = gtk_cell_renderer_toggle_new();
	g_signal_connect(G_OBJECT(cell_renderer), "toggled", 
		G_CALLBACK(gtk_acl_view_on_toggle_write), gtk_acl_view);
	gtk_tree_view_column_pack_start(col, cell_renderer, TRUE);
	gtk_tree_view_column_add_attribute(col, cell_renderer, "active", COL_WRITE);
	
	//Column Exec
	col = gtk_tree_view_column_new();
	gtk_tree_view_column_set_title(col, _("Exec"));
	gtk_tree_view_append_column(GTK_TREE_VIEW(gtk_acl_view), col);
	cell_renderer = gtk_cell_renderer_toggle_new();
	g_signal_connect(G_OBJECT(cell_renderer), "toggled", 
		G_CALLBACK(gtk_acl_view_on_toggle_execute), gtk_acl_view);
	gtk_tree_view_column_pack_start(col, cell_renderer, TRUE);
	gtk_tree_view_column_add_attribute(col, cell_renderer, "active", COL_EXECUTE);
}
