/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <glade/glade.h>


#ifndef _GTK_ACL_H_
#define _GTK_ACL_H_

#include "gperms.h"
#include "gtkaclview.h"
#include "gtkusergroup.h"


#define _(s) (gchar *) gettext (s)

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

	
#define GTK_TYPE_ACL          (gtk_acl_get_type ())
#define GTK_ACL(obj)          GTK_CHECK_CAST (obj, gtk_acl_get_type (), GtkAcl)
#define GTK_ACL_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, gtk_acl_get_type(), GtkAclClass)
#define IS_GTK_ACL(obj)       GTK_CHECK_TYPE (obj, gtk_acl_get_type ())
	

typedef struct _GtkAcl      GtkAcl;
typedef struct _GtkAclClass GtkAclClass;

//
struct _GtkAcl
{
	GtkWindow  window;
	GladeXML  *xml;
  
	GtkWidget *view_access, *view_default;	//GtkAclView
	GtkWidget *win_access,*win_default;	//GktUserGroup gtk_usergroup
	GtkWidget *win_owner;			//GktUserGroup gtk_usergroup
	
	GPerms *perms_access, *perms_default;
};

//
struct _GtkAclClass
{
	GtkWindowClass parent_class;

};


GtkType    gtk_acl_get_type        (void);


/* End widget internal function */



enum {
	UNIX_USER = 0,
	UNIX_GROUP,
	UNIX_OTHER
};


GtkWidget *gtk_acl_new();


/*
 * type : TYPE_ACCESS ou TYPE_DEFAULT
 */
//gboolean gtk_acl_load_file(GtkAcl *gtk_acl, const gchar *filename);


//void gtk_acl_load(GtkAcl *gtk_acl);
void gtk_acl_gray(GtkAcl *gtk_acl);


/* Ajoute un utilisateur et l'affiche dans la vue*/
//void gtk_acl_add_user(GtkAcl *gtk_acl, uid_t uid);

/*void gtk_acl_del_user(GtkAcl *gtk_acl, uid_t uid);
void gtk_acl_add_group(GtkAcl *gtk_acl, gpointer gid);
void gtk_acl_del_group(GtkAcl *gtk_acl, gid_t gid);*/

void gtk_acl_set_user_owner(GtkAcl *gtk_acl, gpointer gid);
void gtk_acl_set_group_owner(GtkAcl *gtk_acl, gpointer gid);

void gtk_acl_set_advanced_mode(GtkAcl *gtk_acl, const gboolean state);

#ifdef __cplusplus
}
#endif /* __cplusplus */
	
#endif
