/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 

#include <libintl.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "gtkacl.h"
#include "gtkusergroup.h"
#include "gtkacl-callbacks.h"


#define MESSAGE_BOX(format, error)	\
	{GtkWidget *message_box;\
	message_box = gtk_message_dialog_new(NULL, GTK_DIALOG_MODAL, \
			GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, format, error); \
		gtk_dialog_run (GTK_DIALOG (message_box)); \
 		gtk_widget_destroy (message_box);}
		
#define MESSAGE_BOX_ERROR() MESSAGE_BOX("%s", g_strerror(errno))
		

enum {	
	ADD_ACL,
	LAST_SIGNAL
};
static gint gtk_acl_signals[LAST_SIGNAL] = { 0 };

//
static void gtk_acl_class_init (GtkAclClass *class);
static void gtk_acl_init(GtkAcl *gtk_acl);

//CALLBACKS
static void on_init_defaults(GtkWidget *button, gpointer user_data);
static void on_clear_default(GtkButton *button, gpointer data);
static void on_validate_user_owner(GtkWidget *usergroup, gpointer *data);
static void on_validate_group_owner(GtkWidget *usergroup, gpointer *data);
static void on_set_owner(GtkWidget *button, gpointer *data);


//
GtkType gtk_acl_get_type(void)
{
	static GType gtk_acl_type = 0;

	if (!gtk_acl_type) {
		static const GTypeInfo gtk_acl_info =
		{
			sizeof (GtkAclClass),
			NULL,
			NULL,
			(GClassInitFunc)  gtk_acl_class_init,
			NULL,
			NULL,
			sizeof (GtkAcl),
			0,
			(GInstanceInitFunc) gtk_acl_init
		};

		gtk_acl_type = g_type_register_static (GTK_TYPE_WINDOW, 
				"GtkAcl", &gtk_acl_info, 0);
	}

	return gtk_acl_type;
}

//
static void gtk_acl_class_init (GtkAclClass *class)
{
	GtkObjectClass *object_class;

	object_class = (GtkObjectClass *) class;
  
	/*gtk_usergroup_signals[VALIDATE] = 
		g_signal_new ("validate",
				G_OBJECT_CLASS_TYPE(object_class),
				GTK_RUN_FIRST,
				G_STRUCT_OFFSET (GtkUserGroupClass, validate),
				NULL, NULL,
				g_cclosure_marshal_VOID__VOID, GTK_TYPE_NONE, 0);*/
  
	//class->validate = NULL;
}


//
static void gtk_acl_init(GtkAcl *gtk_acl)
{
	GladeXML  *xml;
	GtkWidget *check;


	xml = glade_xml_new(PACKAGE_DATA_DIR"/gtkacl.glade", "box_main", NULL);
	if (!xml)
	{
		g_warning(_("Cannot load glade interface file"));
		return;
	}
	gtk_acl->xml = xml;
	gtk_container_add(GTK_CONTAINER(gtk_acl), glade_xml_get_widget(gtk_acl->xml, "box_main"));
	gtk_widget_show_all( glade_xml_get_widget(gtk_acl->xml, "box_main"));

	g_signal_connect(G_OBJECT(glade_xml_get_widget(gtk_acl->xml, "button_quit")),
		"clicked", G_CALLBACK(gtk_acl_on_destroy), GINT_TO_POINTER(gtk_acl));
	
	//Add Aclview for Access
	gtk_acl->view_access = gtk_acl_view_new();
	gtk_container_add(GTK_CONTAINER(glade_xml_get_widget(gtk_acl->xml, "scrolledwindow_access")),
		GTK_WIDGET(gtk_acl->view_access));
	gtk_widget_show_all(GTK_WIDGET(gtk_acl->view_access));
	
	//Add Aclview for Default
	gtk_acl->view_default = gtk_acl_view_new();
	gtk_container_add(GTK_CONTAINER(glade_xml_get_widget(gtk_acl->xml, "scrolledwindow_default")),
		GTK_WIDGET(gtk_acl->view_default));
	gtk_widget_show(GTK_WIDGET(gtk_acl->view_default));
	
	//Connect Signals for ACCESS
	gtk_acl->win_access = gtk_usergroup_new();
	g_signal_connect(G_OBJECT(gtk_acl->win_access), "validate-user", 
		G_CALLBACK(gtk_acl_on_validate_user_access), GINT_TO_POINTER(gtk_acl));
	g_signal_connect(G_OBJECT(gtk_acl->win_access), "validate-group", 
		G_CALLBACK(gtk_acl_on_validate_group_access), GINT_TO_POINTER(gtk_acl));
		
	g_signal_connect(G_OBJECT(glade_xml_get_widget(gtk_acl->xml, "button_access_add")),
		"clicked", G_CALLBACK(gtk_acl_on_append_access), GINT_TO_POINTER(gtk_acl));
		
	g_signal_connect(G_OBJECT(glade_xml_get_widget(gtk_acl->xml, "button_access_del")),
		"clicked", G_CALLBACK(gtk_acl_on_remove_access), GINT_TO_POINTER(gtk_acl));
	
	//Connect Signals for DEFAULT
	gtk_acl->win_default = gtk_usergroup_new();
	g_signal_connect(G_OBJECT(gtk_acl->win_default), "validate-user", 
		G_CALLBACK(gtk_acl_on_validate_user_default), GINT_TO_POINTER(gtk_acl));
	g_signal_connect(G_OBJECT(gtk_acl->win_default), "validate-group", 
		G_CALLBACK(gtk_acl_on_validate_group_default), GINT_TO_POINTER(gtk_acl));
		
	g_signal_connect(G_OBJECT(glade_xml_get_widget(gtk_acl->xml, "button_default_add")),
		"clicked", G_CALLBACK(gtk_acl_on_append_default), GINT_TO_POINTER(gtk_acl));
		
	g_signal_connect(G_OBJECT(glade_xml_get_widget(gtk_acl->xml, "button_default_del")),
		"clicked", G_CALLBACK(gtk_acl_on_remove_default), GINT_TO_POINTER(gtk_acl));
	
	//Connect Signals for OWNER
	gtk_acl->win_owner = gtk_usergroup_new();
	g_signal_connect(G_OBJECT(gtk_acl->win_owner), "validate-user", 
		G_CALLBACK(on_validate_user_owner), GINT_TO_POINTER(gtk_acl));
	g_signal_connect(G_OBJECT(gtk_acl->win_owner), "validate-group", 
		G_CALLBACK(on_validate_group_owner), GINT_TO_POINTER(gtk_acl));
	g_signal_connect(G_OBJECT(glade_xml_get_widget(gtk_acl->xml, "button_owner")),
		"clicked", G_CALLBACK(on_set_owner), GINT_TO_POINTER(gtk_acl));
	
	
	//Connect signals for specials permissions	
	check = glade_xml_get_widget(gtk_acl->xml, "check_suid");
	g_signal_connect(G_OBJECT(check),  "toggled", G_CALLBACK(gtk_acl_on_toggle_suid), 
		GINT_TO_POINTER(gtk_acl));
	
	check = glade_xml_get_widget(gtk_acl->xml, "check_sgid");
	g_signal_connect(G_OBJECT(check),  "toggled", G_CALLBACK(gtk_acl_on_toggle_sgid), 
		GINT_TO_POINTER(gtk_acl));
	
	check = glade_xml_get_widget(gtk_acl->xml, "check_sticky");
	g_signal_connect(G_OBJECT(check),  "toggled", G_CALLBACK(gtk_acl_on_toggle_sticky),
		GINT_TO_POINTER(gtk_acl));
	
	
	//
	g_signal_connect(G_OBJECT(glade_xml_get_widget(gtk_acl->xml, "button_defaults_clear")),
		"clicked", G_CALLBACK(on_clear_default), GINT_TO_POINTER(gtk_acl));
	g_signal_connect(G_OBJECT(glade_xml_get_widget(gtk_acl->xml, "button_defaults_init")),
		"clicked", G_CALLBACK(on_init_defaults), GINT_TO_POINTER(gtk_acl));
}



//
GtkWidget *gtk_acl_new()
{
	GtkAcl *gtk_acl;

	gtk_acl = g_object_new (GTK_TYPE_ACL, NULL);
	return GTK_WIDGET(gtk_acl);
}

/***** MANUPULATION FUNCTIONS *****/

//
gboolean gtk_acl_load_file(GtkAcl *gtk_acl, const gchar *filename)
{	
	//GPerms *perms_access, *perms_default;
	
	gtk_acl->perms_access = g_perms_new();
	g_perms_load_file(gtk_acl->perms_access, filename, P_ACCESS);
	gtk_acl_view_set_perms(gtk_acl->view_access, gtk_acl->perms_access);
	
	gtk_acl->perms_default = g_perms_new();
	g_perms_load_file(gtk_acl->perms_default, filename, P_DEFAULT);
	gtk_acl_view_set_perms(gtk_acl->view_default, gtk_acl->perms_default);
	//gtk_acl_view_load_file(gtk_acl->view_default, filename, TYPE_DEFAULT);
	
	//
	GPermsSpecialEntry *special_entry_perms;
	GtkWidget *check;

	special_entry_perms = g_perms_get_special_perms(gtk_acl->perms_access);
	
	check = glade_xml_get_widget(gtk_acl->xml, "check_suid");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), special_entry_perms->suid);
	
	check = glade_xml_get_widget(gtk_acl->xml, "check_sgid");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), special_entry_perms->sgid);
	
	check = glade_xml_get_widget(gtk_acl->xml, "check_sticky");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), special_entry_perms->sticky);

	
	/*if (g_perms_load_file(gtk_acl->perms_access, filename, TYPE_ACCESS) == FALSE)
	{
		MESSAGE_BOX("Wrong path!", 0);		
		return FALSE;
	}*/
	
	
	//gtk_widget_set_sensitive(GTK_WIDGET(gtk_acl->menu_mode), FALSE);
	//gtk_widget_set_sensitive(GTK_WIDGET(gtk_acl->frame_default), FALSE);
	
	/*
	if (gtk_acl->perms_access->mode == P_MODE_ACL)
	{
		//gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(gtk_acl->check_acl), TRUE);
		/*if (gtk_acl->perms->is_directory == TRUE)			
			gtk_widget_set_sensitive(GTK_WIDGET(gtk_acl->menu_mode), TRUE);*/
	/*}
	else ;
		//gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(gtk_acl->check_acl), FALSE);
	*/
	//gtk_acl_load(gtk_acl, gtk_acl->store_access, gtk_acl->perms_access);
	
	return TRUE;
}


/*void gtk_acl_load(GtkAcl *gtk_acl, GtkTreeStore *store, GPerms *perms)
{
	
}*/



//
/*void gtk_acl_add_user(GtkAcl *gtk_acl, uid_t uid)
{
	if (g_perms_add_user(gtk_acl->perms, uid) == -1)
		MESSAGE_BOX(_("Cannot add user!"), 0);
	
	gtk_acl_load(gtk_acl);
}*/


//
/*void gtk_acl_del_user(GtkAcl *gtk_acl, uid_t uid)
{
	if (g_perms_del_user(gtk_acl->perms, uid) == -1)
		MESSAGE_BOX_ERROR();
	
	//gtk_acl_load(gtk_acl);
}*/


//
/*void gtk_acl_del_group(GtkAcl *gtk_acl, gid_t gid)
{
	/*if (g_perms_del_group(gtk_acl->perms, gid) == -1)
		MESSAGE_BOX_ERROR();
		
	//gtk_acl_load(gtk_acl);
}*/


//
/*void gtk_acl_add_group(GtkAcl *gtk_acl, gpointer gid)
{
	if (g_perms_add_group(gtk_acl->perms, (gid_t) gid) == -1)
		MESSAGE_BOX_ERROR();
	
	//gtk_acl_load(gtk_acl);
}*/



//
void gtk_acl_set_user_owner(GtkAcl *gtk_acl, gpointer uid)
{
	/*if (g_perms_set_user_owner(gtk_acl->perms, (uid_t) uid) == -1)
		MESSAGE_BOX_ERROR();

	//gtk_acl_load(gtk_acl);*/
}


//
void gtk_acl_set_group_owner(GtkAcl *gtk_acl, gpointer gid)
{
	/*if (g_perms_set_group_owner(gtk_acl->perms, (gid_t) gid) == -1)
		MESSAGE_BOX_ERROR();
		

	gtk_acl_load(gtk_acl);	*/
}

//
void gtk_acl_set_advanced_mode(GtkAcl *gtk_acl, const gboolean state)
{ 
	/*GtkTreeViewColumn *column;
	
	column = gtk_tree_view_get_column(GTK_TREE_VIEW(gtk_acl->view), COL_ID);
	if (column == NULL)
		return;
	
	gtk_tree_view_column_set_visible(GTK_TREE_VIEW_COLUMN(column), state);
	
	
	if (state == FALSE) 
	{*/
		/*gtk_widget_hide(gtk_acl->special[0]);
		gtk_widget_hide(gtk_acl->special[1]);
		gtk_widget_hide(gtk_acl->special[2]);*/
		
	/*	gtk_widget_hide(gtk_acl->frame_specials);
		gtk_widget_hide(gtk_acl->frame_default);
		
		//gtk_widget_hide(gtk_acl->menu_mode);
	}
	
	
	if (state == TRUE) 
	{
		/*gtk_widget_show(gtk_acl->special[0]);
		gtk_widget_show(gtk_acl->special[1]);
		gtk_widget_show(gtk_acl->special[2]);
		*/
	/*	gtk_widget_show_all(gtk_acl->frame_specials);
		gtk_widget_show_all(gtk_acl->frame_default);
		//gtk_widget_show(gtk_acl->menu_mode);
	}*/
	
	
}


//
void gtk_acl_gray(GtkAcl *gtk_acl)
{
	/*uid_t uid;
	GtkTreeIter iter;
	gchar *char_uid;

	//IF USER IS THE OWNER ALLOW ADD AND DEL
	if (gtk_tree_model_get_iter_from_string(GTK_TREE_MODEL(gtk_acl->store), &iter, "0"))
	{
		gtk_tree_model_get(GTK_TREE_MODEL(gtk_acl->store), &iter, COL_ID, &char_uid, -1);
		uid = atoi(char_uid);
		if (getuid() == uid)
		{
			gtk_widget_set_sensitive(gtk_acl->button_add, TRUE);
			gtk_widget_set_sensitive(gtk_acl->button_del, TRUE);
		}
		else
		{
			gtk_widget_set_sensitive(gtk_acl->button_add, FALSE);
			gtk_widget_set_sensitive(gtk_acl->button_del, FALSE);
		}
	}
	*/
	
	//IF USER IS THE OWNER ALLOW ADD, DEL AND CHANGE OWNER
	//if (getuid() == 0)	/* Maybe Use geteuid ? */
	/*{
		gtk_widget_set_sensitive(gtk_acl->button_owner, TRUE);
		gtk_widget_set_sensitive(gtk_acl->button_add, TRUE);
		gtk_widget_set_sensitive(gtk_acl->button_del, TRUE);
	}
	else
	{
		gtk_widget_set_sensitive(gtk_acl->button_owner, FALSE);
	}*/
	

	
}


/****** CALLBACKS *****/

//
static void on_init_defaults(GtkWidget *button, gpointer user_data)
{
	GtkAcl *gtk_acl;
	
	gtk_acl = GTK_ACL(GPOINTER_TO_INT(user_data));
	
	g_perms_init_default(gtk_acl->perms_default);
	//gtk_acl_view_load(gtk_acl->view_default);
}

//
static void on_clear_default(GtkButton *button, gpointer data)
{
	GtkAcl *gtk_acl;
	
	gtk_acl = GTK_ACL(GPOINTER_TO_INT(data));
	

	g_perms_clear(gtk_acl->perms_default);
	//gtk_acl_view_load(gtk_acl->view_default);
}

//
static void on_validate_user_owner(GtkWidget *usergroup, gpointer *data)
{
	GtkAcl *gtk_acl;
	GtkUserGroup *gtk_usergroup;
	
	g_log(0, G_LOG_LEVEL_DEBUG, "GtkAcl : Catch validate-user Signal", 0);
	
	gtk_acl = GTK_ACL(GPOINTER_TO_INT(data));
	gtk_usergroup = GTK_USERGROUP(usergroup);

	
	if (g_perms_set_user_owner(gtk_acl->perms_access, gtk_usergroup->uid) == -1)
		//MESSAGE_BOX(_("Cannot add user"), 0);
		MESSAGE_BOX_ERROR();
	//gtk_acl_view_load(gtk_acl->view_access);
}

//
static void on_validate_group_owner(GtkWidget *usergroup, gpointer *data)
{
	GtkAcl *gtk_acl;
	GtkUserGroup *gtk_usergroup;
	
	g_log(0, G_LOG_LEVEL_DEBUG, "GtkAcl : Catch validate-group Signal", 0);
	
	gtk_acl = GTK_ACL(GPOINTER_TO_INT(data));
	gtk_usergroup = GTK_USERGROUP(usergroup);

	
	if (g_perms_set_group_owner(gtk_acl->perms_access, gtk_usergroup->gid) == -1)
		//MESSAGE_BOX(_("Cannot add user"), 0);
		MESSAGE_BOX_ERROR();
	//gtk_acl_view_load(gtk_acl->view_access);
}

//
static void on_set_owner(GtkWidget *button, gpointer *data) 
{
	GtkAcl *gtk_acl;
	
	gtk_acl = GTK_ACL(GPOINTER_TO_INT(data));
	gtk_widget_show(GTK_WIDGET(gtk_acl->win_owner));
}
