/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "gtkacl.h"


#ifndef _GTK_ACL_CALLBACKS_H_
#define _GTK_ACL_CALLBACKS_H_


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

void gtk_acl_on_set_owner(GtkWidget *button, gpointer *data);



void gtk_acl_on_toggle_suid(GtkWidget *togglebutton, gpointer data);
void gtk_acl_on_toggle_sgid(GtkWidget *togglebutton, gpointer user_data);
void gtk_acl_on_toggle_sticky(GtkWidget *togglebutton, gpointer user_data);

//void gtk_acl_on_avanced_toggled(GtkToggleButton *togglebutton, gpointer user_data);

//void gtk_acl_on_show_access(GtkMenuItem *menuitem, gpointer user_data);
//void gtk_acl_on_show_default(GtkMenuItem *menuitem, gpointer user_data);

//Add and del bouton callbacks
void gtk_acl_on_append_access(GtkWidget *button, gpointer *data);
void gtk_acl_on_append_default(GtkWidget *button, gpointer *data);
void gtk_acl_on_remove_access(GtkWidget *button, gpointer *data);
void gtk_acl_on_remove_default(GtkWidget *button, gpointer *data);

//Validate the usergroup selection
void gtk_acl_on_validate_user_access(GtkWidget *usergroup, gpointer *data);
void gtk_acl_on_validate_group_access(GtkWidget *usergroup, gpointer *data);
void gtk_acl_on_validate_user_default(GtkWidget *usergroup, gpointer *data);
void gtk_acl_on_validate_group_default(GtkWidget *usergroup, gpointer *data);


//void gtk_acl_on_clear_defaults(GtkButton *button, gpointer data);


//void gtk_acl_on_init_defaults(GtkWidget *button, gpointer user_data);


void gtk_acl_on_destroy(GtkWidget *button, gpointer data);

	
#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
