/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <errno.h>

#include "gtkacl.h"
#include "gtkacl-callbacks.h"


#define MESSAGE_BOX(format, error)	\
	{GtkWidget *message_box;\
	message_box = gtk_message_dialog_new(NULL, GTK_DIALOG_MODAL, \
			GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, format, error); \
		gtk_dialog_run (GTK_DIALOG (message_box)); \
 		gtk_widget_destroy (message_box);}
		
#define MESSAGE_BOX_ERROR() MESSAGE_BOX("%s", g_strerror(errno))


/***** CALLBACKS *****/

//
void gtk_acl_on_append_access(GtkWidget *button, gpointer *data)
{
	GtkAcl *gtk_acl;
	
	gtk_acl = GTK_ACL(GPOINTER_TO_INT(data));
	gtk_widget_show_all(GTK_WIDGET(gtk_acl->win_access));
}

//
void gtk_acl_on_append_default(GtkWidget *button, gpointer *data)
{
	GtkAcl *gtk_acl;
	
	gtk_acl = GTK_ACL(GPOINTER_TO_INT(data));
	gtk_widget_show_all(GTK_WIDGET(gtk_acl->win_default));
}

//
void gtk_acl_on_validate_user_access(GtkWidget *usergroup, gpointer *data)
{
	GtkAcl *gtk_acl;
	GtkUserGroup *gtk_usergroup;
	
	gtk_acl = GTK_ACL(data);
	gtk_usergroup = GTK_USERGROUP(usergroup);
	
	if (g_perms_add_user(gtk_acl->perms_access, gtk_usergroup->uid) == -1)
		//MESSAGE_BOX(_("Cannot add user"), 0);
		MESSAGE_BOX_ERROR();
	//gtk_acl_view_load(gtk_acl->view_access);
}

//
void gtk_acl_on_validate_group_access(GtkWidget *usergroup, gpointer *data)
{
	GtkAcl *gtk_acl;
	GtkUserGroup *gtk_usergroup;
	
	gtk_acl = GTK_ACL(GPOINTER_TO_INT(data));
	gtk_usergroup = GTK_USERGROUP(usergroup);
	
	g_perms_add_group(gtk_acl->perms_access, gtk_usergroup->gid);
	//gtk_acl_view_load(gtk_acl->view_access);
}

//
void gtk_acl_on_validate_user_default(GtkWidget *usergroup, gpointer *data)
{
	GtkAcl *gtk_acl;
	GtkUserGroup *gtk_usergroup;
	
	gtk_acl = GTK_ACL(data);
	gtk_usergroup = GTK_USERGROUP(usergroup);
	
	g_perms_add_user(gtk_acl->perms_default, gtk_usergroup->uid);
	//gtk_acl_view_load(gtk_acl->view_default);
}

//
void gtk_acl_on_validate_group_default(GtkWidget *usergroup, gpointer *data)
{
	GtkAcl *gtk_acl;
	GtkUserGroup *gtk_usergroup;
	
	gtk_acl = GTK_ACL(data);
	gtk_usergroup = GTK_USERGROUP(usergroup);
	
	g_perms_add_group(gtk_acl->perms_default, gtk_usergroup->gid);
	//gtk_acl_view_load(gtk_acl->view_default);
}

//
void gtk_acl_on_remove_access(GtkWidget *button, gpointer *data)
{
	GtkAcl *gtk_acl;
	gtk_acl= GTK_ACL(GPOINTER_TO_INT(data));
	
	gtk_acl_view_delete(GTK_ACL_VIEW(gtk_acl->view_access));	
}

//
void gtk_acl_on_remove_default(GtkWidget *button, gpointer *data)
{
	GtkAcl *gtk_acl;
	
	gtk_acl= GTK_ACL(data);
	
	gtk_acl_view_delete(GTK_ACL_VIEW(gtk_acl->view_default));
}


//
void gtk_acl_on_toggle_suid(GtkWidget *togglebutton, gpointer data)
{
	GtkAcl   *gtk_acl;
	gboolean  state;
	GPermsSpecialEntry *special_entry_perms;
	
	gtk_acl = GTK_ACL(data);
	
	state = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(togglebutton));
	g_perms_set_special_perms(gtk_acl->perms_access, P_SUID, state);
	
	special_entry_perms = g_perms_get_special_perms(gtk_acl->perms_access);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(togglebutton),
		special_entry_perms->suid);
}

//
void gtk_acl_on_toggle_sgid(GtkWidget *togglebutton, gpointer data)
{
	GtkAcl   *gtk_acl;
	gboolean  state;
	GPermsSpecialEntry *special_entry_perms;
	
	gtk_acl = GTK_ACL(data);

	state = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(togglebutton));
	g_perms_set_special_perms(gtk_acl->perms_access, P_SGID, state);
	
	special_entry_perms = g_perms_get_special_perms(gtk_acl->perms_access);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(togglebutton),
		special_entry_perms->sgid);
}

//
void gtk_acl_on_toggle_sticky(GtkWidget *togglebutton, gpointer user_data)
{
	GtkAcl   *gtk_acl;
	gboolean  state;
	GPermsSpecialEntry *special_entry_perms;
	
	gtk_acl = GTK_ACL(user_data);
	
	state = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(togglebutton));
	g_perms_set_special_perms(gtk_acl->perms_access, P_STICKY, state);
	
	special_entry_perms = g_perms_get_special_perms(gtk_acl->perms_access);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(togglebutton), 
		special_entry_perms->sticky);
}


//
void gtk_acl_on_avanced_toggled(GtkWidget *togglebutton, gpointer data)
{
	GtkAcl *gtk_acl;
	
	gtk_acl = GTK_ACL(data);
	
	gtk_acl_set_advanced_mode(gtk_acl,
		gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(togglebutton)));	
}


//
void gtk_acl_on_show_access(GtkMenuItem *menuitem, gpointer user_data)
{
	GtkAcl *gtk_acl;
	
	gtk_acl = user_data;
	
	/*gtk_acl_load_file(gtk_acl, gtk_acl->perms->filename, TYPE_ACCESS);	
	gtk_widget_set_sensitive(GTK_WIDGET(gtk_acl->frame_default), FALSE);*/
}

//
void gtk_acl_on_show_default(GtkMenuItem *menuitem, gpointer user_data)
{
	GtkAcl *gtk_acl;
	
	gtk_acl = user_data;
	
	/*gtk_acl_load_file(gtk_acl, gtk_acl->perms->filename, TYPE_DEFAULT);
	gtk_widget_set_sensitive(GTK_WIDGET(gtk_acl->frame_default), TRUE);*/
	
}

//
void gtk_acl_on_destroy(GtkWidget *button, gpointer data)
{
	GtkAcl *gtk_acl;
	gtk_acl = GTK_ACL(data);
	
	gtk_widget_destroy(GTK_WIDGET(gtk_acl));
	
}
