/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 


#ifndef _G_PERMS_H_
#define _G_PERMS_H_

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <glib.h>

#ifdef HAVE_LIBACL
#include <acl/libacl.h>
#endif



//
struct _entry_perms
{
	gint      type;
	gint      id;
	gchar    *name;
	/*gboolean  suid;
	gboolean  sgid;
	gboolean  sticky;*/
	gboolean  read;
	gboolean  write;
	gboolean  exec;
};

//
struct _special_entry_perms
{
	gboolean  suid;
	gboolean  sgid;
	gboolean  sticky;
};


#ifdef HAVE_LIBACL
enum {
	FIRST_ENTRY = ACL_FIRST_ENTRY,
	NEXT_ENTRY  = ACL_NEXT_ENTRY
};
#else
enum {
	FIRST_ENTRY = 1,
	NEXT_ENTRY  = 2
};
#endif

//
typedef enum _p_attributs
{
	P_SUID    = 32,
	P_SGID    = 16,
	P_STICKY  = 8,
	P_READ    = 4,
	P_WRITE   = 2,
	P_EXECUTE = 1
} p_attributs;

//
typedef enum _p_mode
{
	P_MODE_UNIX,
	P_MODE_ACL
} p_mode;

//
typedef enum _p_type 
{
	P_USER_OWNER  = 1,
	P_USER = 2,
	P_GROUP_OWNER = 4,
	P_GROUP = 8,
	P_OTHER = 16,
	P_MASK  = 32
} p_type;



typedef struct _GPerms GPerms;

//
struct _GPerms 
{
	gchar *filename;
	#ifdef HAVE_LIBACL
	acl_t acl;
	acl_entry_t acl_entry;
	#endif
	
	
	//
	guint nb_users, nb_groups, mask;
	
	
	gint unix_entry_ptr;
	p_mode mode;
	
	struct _entry_perms *(*func_get_entry) (GPerms *, const gint);
	gint (*func_set_perm) (GPerms *, const gint, const guint, gint, const gboolean);

	
};


GPerms *g_perms_new(void);
void g_perms_delete(GPerms *self);
gboolean g_perms_init(GPerms *self);
void g_perms_end(GPerms *self);

//
gint g_perms_load_file(GPerms *g_perms, const gchar *filename);
struct _entry_perms *g_perms_get_entry(GPerms *g_perms, const gint type);
#ifdef HAVE_LIBACL
acl_entry_t g_perms_found_entry(GPerms *g_perms, const gint type , const guint id);
#endif

gint g_perms_add_user (GPerms *g_perms, uid_t uid);
gint g_perms_add_group(GPerms *g_perms, gid_t gid);
gint g_perms_del_user (GPerms *g_perms, gid_t gid);
gint g_perms_del_group(GPerms *g_perms, gid_t gid);

gint g_perms_set_perm(GPerms *g_perms, const gint type, const guint id, 
	gint perm, const gboolean state);

gint g_perms_set_user_owner (GPerms *g_perms, uid_t uid);
gint g_perms_set_group_owner(GPerms *g_perms, gid_t gid);

struct _special_entry_perms *g_perms_get_special_perms(GPerms *g_perms);
gint g_perms_set_special_perms(GPerms *g_perms, p_attributs perm, const gboolean state);




#endif	/*_GPERMS_H_*/
