/*
 * This file is part of Gterm.
 *
 * Gterm is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Foobar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Foobar; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


struct Settings
{
  gchar *title;                 /* Terminal title */
  gchar *term;                  /* Terminal emulation */
  gchar *wd;                    /* Initial working directory */
  gchar *cmd;                   /* Use command instead $SHELL */
  gchar *locale;                /* Locale to use */
#ifdef USE_MENU
  gchar *menu;                  /* Menu description file */
#endif
  glong lines;                  /* Store lines */
  glong width, height;          /* Window geometry */
  PangoFontDescription *font;   /* Font to use */
  GdkColor fore, back;  		/* Terminal colors */
  gboolean have_bold, have_dim; /* bold and dim flags */
  GdkColor bold, dim;           /* bold and dim colors */
  GdkColor cursor;              /* cursor colors */
  GdkColor hlite;				/* highlight color */
  GdkColor *palette;            /* Terminal color palette */
  gint palsize;                 /* Palette size */
  gboolean audible, blink, login, sb, is_shell;   /* Some switches */
  GHashTable *envs;             /* Set of environment variables */
  GList *tmpls;                 /* List of templates */
};

extern struct Settings cfg;
