/********************************************************************************
*
* HelpMenu.c
*
* Contains functions:
*    HelpHandler
*    AboutHandler
*
* Functions for Help menu items.
*
* Copyright  2008 Spencer A. Buckner
* http://savannah.gnu.org/projects/gsegrafix
*
* This file is part of GSEGrafix, a scientific and engineering plotting program.
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
********************************************************************************/


#include <gnome.h>


void ErrorDialog ( const char *message_str );


/* Declare external variables */
extern char app_id[];
extern char app_version[];
extern GdkPixbuf *pixbuf_logo;


void HelpHandler ( void )
   {
   /* Declare variables */
   int i;
   unsigned int size;
   char *filename, *argv_child[3];
   const char *error_str[] =
      { "Cannot find help file, gsegrafix.xhtml." };
   GnomeProgram *program;


   /* Display help file (doesn't work) */
   /* gnome_help_display("gsegrafix", NULL, NULL); */


   /* Set pointers to NULL */
   filename = NULL;
   for ( i=1; i<=3; i++ )
      argv_child[i-1] = NULL;


   /* Get help filename */
   program = gnome_program_get();
   filename = gnome_program_locate_file(program,
                                        GNOME_FILE_DOMAIN_APP_HELP,
                                        "gsegrafix/C/gsegrafix.xhtml",
                                        TRUE,
                                        NULL);


   /* Display help file */
   if ( filename == NULL )
      ErrorDialog(error_str[0]);
   else
      {
      size = strlen("htmlview");
      argv_child[0] = malloc(size + 1);
      sprintf(argv_child[0], "htmlview");
      size = strlen(filename);
      argv_child[1] = malloc(size + 1);
      sprintf(argv_child[1], filename);
      argv_child[2] = NULL;
      if ( g_spawn_async(NULL,
                         argv_child,
                         NULL,
                         G_SPAWN_SEARCH_PATH,
                         NULL,
                         NULL,
                         NULL,
                         NULL) == 0 )

         {
         ErrorDialog(error_str[0]);
         free(filename);
         for ( i=1; i<=3; i++ )
            free(argv_child[i-1]);
         }
      }

   free(filename);
   for ( i=1; i<=3; i++ )
      free(argv_child[i-1]);

   return;
   }


void AboutHandler ( void )
   {
   /* Declare variables */
   const char *authors[] = { "S. A. Buckner <http://savannah.gnu.org/projects/gsegrafix>", NULL };
   const char *documenters[] = { "S. A. Buckner <http://savannah.gnu.org/projects/gsegrafix>", NULL };
   const char license[] =
      "This program is free software: you can redistribute it and/or modify\n"
      "it under the terms of the GNU General Public License as published by\n"
      "the Free Software Foundation, either version 3 of the License, or\n"
      "(at your option) any later version.\n"
      "\n"
      "This program is distributed in the hope that it will be useful,\n"
      "but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
      "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
      "GNU General Public License for more details.\n"
      "\n"
      "You should have received a copy of the GNU General Public License\n"
      "along with this program.  If not, see <http://www.gnu.org/licenses/>.";


   /* Create dialog box */
   gtk_show_about_dialog(NULL,
                         "name", "GSEGrafix",
                         "version", app_version,
                         "comments", "GSEGrafix is a GNOME application for creating\n"
                                     "scientific and engineering plots.",
                         "copyright", "Copyright \xC2\xA9 2008 Spencer A. Buckner",
                         "website", "http://savannah.gnu.org/projects/gsegrafix",
                         "authors", authors,
                         "documenters", documenters,
                         "license", license,
                         "logo", pixbuf_logo,
                         NULL);

   return;
   }

