/********************************************************************************
*
* DrawTickLabelsLog.c
*
* Draws tick-mark labels for logarithmic axes of two-dimensional plots.
*
* Copyright  2008 Spencer A. Buckner
* http://savannah.gnu.org/projects/gsegrafix
*
* This file is part of GSEGrafix, a scientific and engineering plotting program.
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
********************************************************************************/


#include <math.h>
#include "gsegraf.h"


void DrawTickLabelsLog ( void )
   {
   /* Declare variables */
   int i, nxticks, nyticks, xdecades, ydecades;
   double x1_box, x2_box, y1_box, y2_box, xmin, xmax, ymin, ymax,
          xtick, ytick, tickvalue, tickvaluelog, x1, x2, y1, y2;
   char string[21];
   GnomeCanvasItem *text;


   /* Check plot_box parameter */
   if ( strcmp(p_plot_param->plot_box, "off") == 0 )
      return;


   /* Check axis_type parameter */
   if ( strcmp(p_plot_param->axis_type, "linear") == 0 )
      return;


   /* Specify plot box minimum and maximum values */
   x1_box = p_plot_box_data->xmin;
   x2_box = p_plot_box_data->xmax;
   y1_box = p_plot_box_data->ymin;
   y2_box = p_plot_box_data->ymax;


   /* Draw x-axis tick-mark labels */
   if ( strcmp(p_plot_param->x_tick_marks, "on")  == 0 &&
        strcmp(p_plot_param->x_tick_labels, "on") == 0 &&
        (strcmp(p_plot_param->axis_type, "semilogx") == 0 ||
         strcmp(p_plot_param->axis_type, "loglog") == 0) )
      {
      /* Specify axis-label values */
      nxticks = p_ticklabels->nxvalues;
      xmin = floor(p_ticklabels->xvalues[0]);
      xmax = ceil(p_ticklabels->xvalues[nxticks-1]);
      xdecades = roundint(xmax - xmin);
      if ( xdecades <= 10 )
         nxticks = xdecades + 1;
      else
         {
         nxticks = p_ticklabels->nxvalues;
         xmin = p_ticklabels->xvalues[0];
         xmax = p_ticklabels->xvalues[nxticks-1];
         }
      p_ticklabels->nxvalues = nxticks;

      /* Draw labels */
      for ( i=1; i<=nxticks; i++ )
         {
         xtick = x1_box + (i - 1.0)/(nxticks - 1.0)*(x2_box - x1_box);
         ytick = y2_box;

         tickvaluelog = roundint(xmin + (i - 1.0)/(nxticks - 1.0)*(xmax - xmin));
         p_ticklabels->xvalues[i-1] = tickvaluelog;
         tickvalue = pow(10.0, tickvaluelog);
         memset(string, 0, strlen(string));
         sprintf(string, "%g", tickvalue);

         text = gnome_canvas_item_new(group,
                                      GNOME_TYPE_CANVAS_TEXT,
                                      "text", string,
                                      "x", xtick,
                                      "y", ytick + 8.0,
                                      "anchor", GTK_ANCHOR_NORTH,
                                      "font-desc", font_tick_labels,
                                      "fill_color_rgba", 0x000000FF,
                                      NULL);
         }
      }


   /* Draw y-axis tick-mark labels */
   if ( strcmp(p_plot_param->y_tick_marks, "on")  == 0 &&
        strcmp(p_plot_param->y_tick_labels, "on") == 0 &&
        (strcmp(p_plot_param->axis_type, "semilogy") == 0 ||
         strcmp(p_plot_param->axis_type, "loglog") == 0) )
      {
      /* Specify axis-label values */
      nyticks = p_ticklabels->nyvalues;
      ymin = floor(p_ticklabels->yvalues[0]);
      ymax = ceil(p_ticklabels->yvalues[nyticks-1]);
      ydecades = roundint(ymax - ymin);
      if ( ydecades <= 10 )
         nyticks = ydecades + 1;
      else
         {
         nyticks = p_ticklabels->nyvalues;
         ymin = p_ticklabels->yvalues[0];
         ymax = p_ticklabels->yvalues[nyticks-1];
         }
      p_ticklabels->nyvalues = nyticks;

      /* Draw labels */
      width_ytick_labels = 0.0;
      for ( i=1; i<=nyticks; i++ )
         {
         xtick = x1_box;
         ytick = y2_box - (i - 1.0)/(nyticks - 1.0)*(y2_box - y1_box);

         tickvaluelog = roundint(ymin + (i - 1.0)/(nyticks - 1.0)*(ymax - ymin));
         p_ticklabels->yvalues[i-1] = tickvaluelog;
         tickvalue = pow(10.0, tickvaluelog);
         memset(string, 0, strlen(string));
         sprintf(string, "%g", tickvalue);

         text = gnome_canvas_item_new(group,
                                      GNOME_TYPE_CANVAS_TEXT,
                                      "text", string,
                                      "x", xtick - 8.0,
                                      "y", ytick,
                                      "anchor", GTK_ANCHOR_EAST,
                                      "font-desc", font_tick_labels,
                                      "fill_color_rgba", 0x000000FF,
                                      NULL);

         gnome_canvas_item_get_bounds(text, &x1, &y1, &x2, &y2);
         if ( x2 - x1 > width_ytick_labels )
            width_ytick_labels = x2 - x1;
         }
      }

   return;
   }
