/*******************************************************************************
*
* DrawGrid.c
*
* Draws grid lines and tick marks for linear axes of two-dimensional plots.
*
* Copyright  2008 Spencer A. Buckner
* http://savannah.gnu.org/projects/gsegrafix
*
* This file is part of GSEGrafix, a scientific and engineering plotting program.
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
*******************************************************************************/


#include "gsegraf.h"


void DrawGrid ( void )
   {
   /* Declare variables */
   int i, nxticks, nyticks;
   double x1_box, x2_box, y1_box, y2_box,
          xmin, xmax, ymin, ymax, dx, dy,
          xscale, yscale, xtick, ytick;
   GnomeCanvasPoints *points;
   GnomeCanvasItem *line;


   /* Check plot_box parameter */
   if ( strcmp(p_plot_param->plot_box, "off") == 0 )
      return;


   /* Check axis_type parameter */
   if ( strcmp(p_plot_param->axis_type, "loglog") == 0 )
      return;


   /* Get plot box minimum and maximum values */
   x1_box = p_plot_box_data->xmin;
   x2_box = p_plot_box_data->xmax;
   y1_box = p_plot_box_data->ymin;
   y2_box = p_plot_box_data->ymax;


   /* Get axis label values */
   nxticks = p_ticklabels->nxvalues;
   nyticks = p_ticklabels->nyvalues;
   xmin = p_ticklabels->xvalues[0];
   xmax = p_ticklabels->xvalues[nxticks-1];
   ymin = p_ticklabels->yvalues[0];
   ymax = p_ticklabels->yvalues[nyticks-1];
   xmin = xmin - p_ticklabels->xoffset1;
   xmax = xmax + p_ticklabels->xoffset2;
   ymin = ymin - p_ticklabels->yoffset1;
   ymax = ymax + p_ticklabels->yoffset2;


   /* Calculate axis scale factors */
   xscale = (x2_box - x1_box)/(xmax - xmin);
   yscale = (y2_box - y1_box)/(ymax - ymin);


   /* Draw grid lines */
   if ( strcmp(p_plot_param->grid, "on1") == 0 ||
        strcmp(p_plot_param->grid, "on2") == 0 )
      {
      if ( strcmp(p_plot_param->x_tick_marks, "on") == 0 &&
           (strcmp(p_plot_param->axis_type, "linear")   == 0 ||
            strcmp(p_plot_param->axis_type, "semilogy") == 0) )
         {
         points = gnome_canvas_points_new(2);

         for ( i=1; i<=nxticks; i++ )
            {
            xtick = x1_box + (p_ticklabels->xvalues[i-1] - xmin)*xscale;
            points->coords[0] = xtick;
            points->coords[1] = y1_box;
            points->coords[2] = xtick;
            points->coords[3] = y2_box;
            if ( gridchar1 == 'l' )
               DrawLine(points, gridcolor, 1);
            else if ( gridchar1 == 'd' )
               DrawDashedLine(points, gridcolor, 1);
            }

         gnome_canvas_points_unref(points);
         }

      if ( strcmp(p_plot_param->y_tick_marks, "on") == 0 &&
           (strcmp(p_plot_param->axis_type, "linear")   == 0 ||
            strcmp(p_plot_param->axis_type, "semilogx") == 0) )
         {
         points = gnome_canvas_points_new(2);

         for ( i=1; i<=nyticks; i++ )
            {
            ytick = y2_box - (p_ticklabels->yvalues[i-1] - ymin)*yscale;
            points->coords[0] = x1_box;
            points->coords[1] = ytick;
            points->coords[2] = x2_box;
            points->coords[3] = ytick;
            if ( gridchar1 == 'l' )
               DrawLine(points, gridcolor, 1);
            else if ( gridchar1 == 'd' )
               DrawDashedLine(points, gridcolor, 1);
            }

         gnome_canvas_points_unref(points);
         }
      }


   /* Draw x-axis tick marks */
   if ( strcmp(p_plot_param->x_tick_marks, "on") == 0 &&
        (strcmp(p_plot_param->axis_type, "linear")   == 0 ||
         strcmp(p_plot_param->axis_type, "semilogy") == 0) )
      {
      points = gnome_canvas_points_new(2);

      dx = (xmax - xmin)/(nxticks - 1.0);
      for ( i=1; i<=nxticks; i++ )
         {
         xtick = x1_box + (p_ticklabels->xvalues[i-1] - xmin)*xscale;
         ytick = y2_box;

         points->coords[0] = xtick;
         points->coords[1] = ytick;
         points->coords[2] = xtick;
         points->coords[3] = ytick - tick_major;

         line = gnome_canvas_item_new(group,
                                      GNOME_TYPE_CANVAS_LINE,
                                      "points", points,
                                      "fill_color_rgba", 0x000000FF,
                                      "width_pixels", 1,
                                      NULL);

         ytick = y1_box;
         points->coords[0] = xtick;
         points->coords[1] = ytick;
         points->coords[2] = xtick;
         points->coords[3] = ytick + tick_major;

         line = gnome_canvas_item_new(group,
                                      GNOME_TYPE_CANVAS_LINE,
                                      "points", points,
                                      "fill_color_rgba", 0x000000FF,
                                      "width_pixels", 1,
                                      NULL);
         }

      gnome_canvas_points_unref(points);
      }


   /* Draw y-axis tick marks */
   if ( strcmp(p_plot_param->y_tick_marks, "on") == 0 &&
        (strcmp(p_plot_param->axis_type, "linear")   == 0 ||
         strcmp(p_plot_param->axis_type, "semilogx") == 0) )
      {
      points = gnome_canvas_points_new(2);

      dy = (ymax - ymin)/(nyticks - 1.0);
      for ( i=1; i<=nyticks; i++ )
         {
         xtick = x1_box;
         ytick = y2_box - (p_ticklabels->yvalues[i-1] - ymin)*yscale;

         points->coords[0] = xtick;
         points->coords[1] = ytick;
         points->coords[2] = xtick + tick_major;
         points->coords[3] = ytick;

         line = gnome_canvas_item_new(group,
                                      GNOME_TYPE_CANVAS_LINE,
                                      "points", points,
                                      "fill_color_rgba", 0x000000FF,
                                      "width_pixels", 1,
                                      NULL);

         xtick = x2_box;
         points->coords[0] = xtick;
         points->coords[1] = ytick;
         points->coords[2] = xtick - tick_major;
         points->coords[3] = ytick;

         line = gnome_canvas_item_new(group,
                                      GNOME_TYPE_CANVAS_LINE,
                                      "points", points,
                                      "fill_color_rgba", 0x000000FF,
                                      "width_pixels", 1,
                                      NULL);
         }

      gnome_canvas_points_unref(points);
      }

   return;
   }
