/********************************************************************************
*
* EventHandler.c
*
* Handles events.
*
* Copyright  2008 Spencer A. Buckner
* http://savannah.gnu.org/projects/gsegrafix
*
* This file is part of GSEGrafix, a scientific and engineering plotting program.
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
********************************************************************************/


#include "gsegraf.h"


/* Event handler */
gboolean EventHandler ( GtkWidget *window, GdkEvent *event )
   {
   /* Declare variables */
   int state, keyval,
       window_width_old, window_height_old,
       window_width_new, window_height_new;
   static int flag, flag_button1;
   static double x1_window, y1_window, x2_window, y2_window;
   double x1_box, x2_box, y1_box, y2_box,
          x1, x2, y1, y2, max_dimension,
          xtext1, xtext2, ytext1, ytext2;
   char label[21], string[51];
   static GnomeCanvasItem *zoom_rectangle;
   GnomeCanvasItem *text, *rectangle;


   /* Get plot box minimum and maximum values */
   x1_box = p_plot_box_data->xmin;
   x2_box = p_plot_box_data->xmax;
   y1_box = p_plot_box_data->ymin;
   y2_box = p_plot_box_data->ymax;


   /* Detect events */
   switch (event->type)
      {
      case GDK_DELETE:
         FreeMemory();
         gtk_main_quit();
         break;

      case GDK_DESTROY:
         FreeMemory();
         gtk_main_quit();
         break;

      case GDK_KEY_PRESS:
         state  = ((GdkEventKey*) event)->state;
         keyval = ((GdkEventKey*) event)->keyval;
         if ( state == 4 && keyval == 99 )
            {
            /* Ctrl-C */
            FreeMemory();
            gtk_main_quit();
            }
         else if ( state == 0 && keyval == 65362 )
            {
            /* Up arrow */
            if ( flag_contour_labels == 1 )
               ViewLabelCallback(1);
            }
         else if ( state == 0 && keyval == 65364 )
            {
            /* Down arrow */
            if ( flag_contour_labels == 1 )
               ViewLabelCallback(-1);
            }
         break;


      case GDK_BUTTON_PRESS:
         if ( flag_2d_rect == 1 )
            {
            /* Get window coordinates of mouse position 1 for zoom rectangle */
            if ( ((GdkEventButton*) event)->button == 1 &&
                 flag_contour_labels == 0 )
               {
               flag_button1 = 0;

               x1_window = ((GdkEventButton*) event)->x;
               y1_window = ((GdkEventButton*) event)->y;

               if ( x1_window < x1_box )
                  x1_window = x1_box;
               else if ( x1_window > x2_box )
                  x1_window = x2_box;

               if ( y1_window < y1_box )
                  y1_window = y1_box;
               else if ( y1_window > y2_box )
                  y1_window = y2_box;

               x2_window = x1_window;
               y2_window = y1_window;

               zoom_rectangle = gnome_canvas_item_new(group,
                                                      GNOME_TYPE_CANVAS_RECT,
                                                      "x1", x1_window,
                                                      "x2", x2_window,
                                                      "y1", y1_window,
                                                      "y2", y2_window,
                                                      "fill_color_rgba", 0xC0C0C040,
                                                      "outline_color_rgba", 0x000000FF,
                                                      "width_pixels", 1,
                                                      NULL);

               flag_button1 = 1;
               }

            /* Write 2d contour-plot labels */
            else if ( ((GdkEventButton*) event)->button == 1 &&
                      flag_contour_labels == 1 )
               {
               /* Get mouse coordinates */
               xmouse = ((GdkEventButton*) event)->x;
               ymouse = ((GdkEventButton*) event)->y;
               ViewLabelCallback(0);

               /* Write label */
               if ( contour_label != NULL )
                  {
                  memset(label, 0, sizeof(label));
                  sprintf(label, "%g", *contour_label);
                  text = gnome_canvas_item_new(group,
                                               GNOME_TYPE_CANVAS_TEXT,
                                               "text", label,
                                               "x", xmouse,
                                               "y", ymouse,
                                               "anchor", GTK_ANCHOR_CENTER,
                                               "justification", GTK_JUSTIFY_CENTER,
                                               "font-desc", font_text,
                                               "fill_color_rgba", 0x000000FF,
                                               NULL);

                  gnome_canvas_item_get_bounds(text, &xtext1, &ytext1, &xtext2, &ytext2);

                  rectangle = gnome_canvas_item_new(group,
                                                    GNOME_TYPE_CANVAS_RECT,
                                                    "x1", xtext1,
                                                    "x2", xtext2,
                                                    "y1", ytext1,
                                                    "y2", ytext2,
                                                    "fill_color_rgba", 0xFFFFFFFF,
                                                    "outline_color_rgba", 0xFFFFFFFF,
                                                    "width_pixels", 1,
                                                    NULL);

                  gnome_canvas_item_raise_to_top(text);
                  }
               }
            }

         /* Zoom out */
         if ( ((GdkEventButton*) event)->button == 3 &&
              flag_contour_labels == 0 )
            {
            /* Stop coordinates display */
            flag = 0;
            if ( flag_coords_display == 1 )
               {
               ViewCoordsDisplayHandler();
               flag = 1;
               }

            /* Destroy old canvas group and zoom out */
            if ( gdk_pointer_is_grabbed() == TRUE )
               gdk_pointer_ungrab(GDK_CURRENT_TIME);
            gtk_object_destroy(GTK_OBJECT(group));
            gdk_window_set_cursor((GdkWindow *) window->window, NULL);
            group = GNOME_CANVAS_GROUP(gnome_canvas_item_new(group_root,
                                                             GNOME_TYPE_CANVAS_GROUP,
                                                             "x", 0.0,
                                                             "y", 0.0,
                                                             NULL));
            ZoomOut();

            /* Restart coordinates display */
            if ( flag == 1 )
               ViewCoordsDisplayHandler();
            }
         break;

      case GDK_MOTION_NOTIFY:
         /* Get window coordinates of mouse position and draw zoom rectangle */
         if ( flag_2d_rect == 1 && flag_button1 == 1 && flag_contour_labels == 0 )
            {
            /* Grab mouse pointer */
            if ( gdk_pointer_is_grabbed() != TRUE )
               gdk_pointer_grab(window->window,
                                TRUE,
                                GDK_POINTER_MOTION_MASK,
                                window->window,
                                NULL,
                                GDK_CURRENT_TIME);

            /* Get mouse window coordinates */
            x2_window = ((GdkEventMotion*) event)->x;
            y2_window = ((GdkEventMotion*) event)->y;

            if ( x2_window < x1_box )
               x2_window = x1_box;
            else if ( x2_window > x2_box )
               x2_window = x2_box;

            if ( y2_window < y1_box )
               y2_window = y1_box;
            else if ( y2_window > y2_box )
               y2_window = y2_box;

            if ( x2_window >= x1_window )
               {
               x2 = x2_window;
               x1 = x1_window;
               }
            else
               {
               x2 = x1_window;
               x1 = x2_window;
               }

            if ( y2_window >= y1_window )
               {
               y2 = y2_window;
               y1 = y1_window;
               }
            else
               {
               y2 = y1_window;
               y1 = y2_window;
               }

            /* Draw rectangle */
            g_object_set(zoom_rectangle, "x1", x1, "x2", x2, "y1", y1, "y2", y2, NULL);
            }

         /* Write x and y coords of mouse in lower left corner of plot window */
         if ( flag_2d == 1 && flag_coords_display == 1 )
            {
            /* Grab mouse pointer */
            if ( gdk_pointer_is_grabbed() != TRUE )
               gdk_pointer_grab(window->window,
                                TRUE,
                                GDK_POINTER_MOTION_MASK,
                                window->window,
                                NULL,
                                GDK_CURRENT_TIME);

            /* Get mouse window coordinates */
            xmouse = ((GdkEventMotion*) event)->x;
            ymouse = ((GdkEventMotion*) event)->y;

            /* Write values to plot window */
            ViewCoordsDisplayCallback();
            memset(string, 0, sizeof(string));
            if ( xy_coords_data[0] != NULL && xy_coords_data[1] != NULL )
               {
               if ( flag_2d_rect == 1 )
                  sprintf(string, "x = %g\ny = %g", *xy_coords_data[0], *xy_coords_data[1]);
               else if ( flag_polar == 1 )
                  sprintf(string, "\xCE\xB8 = %g\nr = %g", *xy_coords_data[0], *xy_coords_data[1]);
               }
            g_object_set(text_xy_coords_data, "text", string, NULL);
            }

         /* Write z values of 2d-contour data in upper left corner of plot window */
         if ( flag_2d_rect == 1 && flag_contour_labels == 1 )
            {
            /* Grab mouse pointer */
            gdk_pointer_grab(window->window,
                             TRUE,
                             GDK_POINTER_MOTION_MASK,
                             window->window,
                             NULL,
                             GDK_CURRENT_TIME);

            /* Get mouse window coordinates */
            xmouse = ((GdkEventMotion*) event)->x;
            ymouse = ((GdkEventMotion*) event)->y;

            /* Write values to plot window */
            ViewLabelCallback(0);
            memset(string, 0, sizeof(string));
            if ( zcontour_data != NULL )
               sprintf(string, "plot %d\nz = %g", icontour_plots, *zcontour_data);
            else
               sprintf(string, "plot %d", icontour_plots);
            g_object_set(text_contour_data, "text", string, NULL);
            }
         break;

      case GDK_BUTTON_RELEASE:
         /* Zoom in */
         if ( flag_2d_rect == 1 &&
              flag_button1 == 1 &&
              ((GdkEventButton*) event)->button == 1 &&
              flag_contour_labels == 0 )
            {
            flag_button1 = 0;

            /* Stop coordinates display */
            flag = 0;
            if ( flag_coords_display == 1 )
               {
               ViewCoordsDisplayHandler();
               flag = 1;
               }

            /* Ungrab mouse pointer and destroy last rectangle  */
            if ( gdk_pointer_is_grabbed() == TRUE )
               gdk_pointer_ungrab(GDK_CURRENT_TIME);
            gtk_object_destroy(GTK_OBJECT(zoom_rectangle));

            /* Check rectangle coordinates */
            if ( x2_window != x1_window && y2_window != y1_window )
               {
               /* Destroy old canvas group */
               gtk_object_destroy(GTK_OBJECT(group));

               /* Create new canvas group */
               group = GNOME_CANVAS_GROUP(gnome_canvas_item_new(group_root,
                                                                GNOME_TYPE_CANVAS_GROUP,
                                                                "x", 0.0,
                                                                "y", 0.0,
                                                                NULL));

               /* Redraw plot */
               ZoomIn(x1_window, y1_window, x2_window, y2_window);
               }

            /* Restart coordinates display */
            if ( flag == 1 )
               ViewCoordsDisplayHandler();
            }
         break;

      case GDK_CONFIGURE:
         /* Draw graph first time */
         if ( p_window_data->flag == 1 )
            {
            GetAxisLabelPixbufs();
            DrawGraph();
            p_window_data->flag = 2;
            flag_button1 = 0;
            break;
            }

         /* Get old window size data */
         window_width_old  = p_window_data->width;
         window_height_old = p_window_data->height;

         /* Save new window size data */
         p_window_data->width  = ((GdkEventConfigure*) event)->width;
         p_window_data->height = ((GdkEventConfigure*) event)->height;

         /* Get new window size data */
         window_width_new  = p_window_data->width;
         window_height_new = p_window_data->height;

         /* Check window size change */
         if ( window_width_new  == window_width_old &&
              window_height_new == window_height_old )
            break;

         /* Calculate new tick-mark and dashed-line variables */
         if ( window_width_new >= window_height_new )
            max_dimension = window_width_new;
         else
            max_dimension = window_height_new;
         tick_major = (8.0/768.0)*max_dimension;
         tick_minor = 0.5*tick_major;
         dash = tick_major;
         space = 0.5*dash;

         /* Stop coordinates display */
         flag = 0;
         if ( flag_coords_display == 1 )
            {
            ViewCoordsDisplayHandler();
            flag = 1;
            }

         /* Destroy old canvas group */
         gtk_object_destroy(GTK_OBJECT(group));

         /* Create new canvas group */
         group = GNOME_CANVAS_GROUP(gnome_canvas_item_new(group_root,
                                                          GNOME_TYPE_CANVAS_GROUP,
                                                          "x", 0.0,
                                                          "y", 0.0,
                                                          NULL));

         /* Draw graph */
         DrawGraph();

         /* Restart coordinates display */
         if ( flag == 1 )
            ViewCoordsDisplayHandler();

         break;

      default:
         break;
      }

   return FALSE;
   }
