/********************************************************************************
*
* DrawGrid3d.c
*
* Draws grid lines for 3-dimensional plots.
*
* Copyright  2008 Spencer A. Buckner
* http://savannah.gnu.org/projects/gsegrafix
*
* This file is part of GSEGrafix, a scientific and engineering plotting program.
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
********************************************************************************/


#include "gsegraf.h"


void DrawGrid3d ( void )
   {
   /* Declare variables */
   int quadrant, i, nxticks, nyticks, nzticks, nticks;
   double origin[3], axis1[3], axis2[3], axis3[3],
          xmin, xmax, ymin, ymax, zmin, zmax,
          *tickvalues, xscale, yscale, axismin,
          x1, x2, x3, x4, y1, y2, y3, y4, xtick, ytick,
          x11, y11, x22, y22, x33, y33, x44, y44;
   GnomeCanvasPoints *points;


   /* Check plot_box and grid parameters */
   if ( strcmp(p_plot_param->plot_box, "off") == 0 ||
        strcmp(p_plot_param->grid, "off") == 0 )
      return;


   /* Get quadrant */
   quadrant = p_plot_param_3d->quadrant;


   /* Get axes */
   for ( i=1; i<=3; i++ )
      {
      axis1[i-1] = p_plot_param_3d->axis1[i-1];
      axis2[i-1] = p_plot_param_3d->axis2[i-1];
      axis3[i-1] = p_plot_param_3d->axis3[i-1];
      }


   /* Get origin */
   for ( i=1; i<=3; i++ )
      origin[i-1] = p_plot_param_3d->origin[i-1];


   /* Get minimum and maximum axis values */
   nxticks = p_ticklabels->nxvalues;
   nyticks = p_ticklabels->nyvalues;
   nzticks = p_ticklabels->nzvalues;
   xmin = p_ticklabels->xvalues[0];
   xmax = p_ticklabels->xvalues[nxticks-1];
   ymin = p_ticklabels->yvalues[0];
   ymax = p_ticklabels->yvalues[nyticks-1];
   zmin = p_ticklabels->zvalues[0];
   zmax = p_ticklabels->zvalues[nzticks-1];
   xmin = xmin - p_ticklabels->xoffset1;
   xmax = xmax + p_ticklabels->xoffset2;
   ymin = ymin - p_ticklabels->yoffset1;
   ymax = ymax + p_ticklabels->yoffset2;
   zmin = zmin - p_ticklabels->zoffset1;
   zmax = zmax + p_ticklabels->zoffset2;


   /* Axis 1 tick-mark parameters */
   if ( quadrant == 1 )
      {
      x1 = origin[1] + axis2[1];
      y1 = origin[2] - axis2[2];
      x2 = origin[1] + axis1[1] + axis2[1];
      y2 = origin[2] - axis1[2] - axis2[2];
      xscale =  axis1[1]/(xmax - xmin);
      yscale = -axis1[2]/(xmax - xmin);
      nticks = nxticks;
      tickvalues = &p_ticklabels->xvalues[0];
      axismin = xmin;
      }

   else if ( quadrant == 2 )
      {
      x1 = origin[1] + axis2[1];
      y1 = origin[2] - axis2[2];
      x2 = origin[1] + axis1[1] + axis2[1];
      y2 = origin[2] - axis1[2] - axis2[2];
      xscale =  axis1[1]/(ymax - ymin);
      yscale = -axis1[2]/(ymax - ymin);
      nticks = nyticks;
      tickvalues = &p_ticklabels->yvalues[0];
      axismin = ymin;
      }

   else if ( quadrant == 3 )
      {
      x1 = origin[1] + axis1[1] + axis2[1];
      y1 = origin[2] - axis1[2] - axis2[2];
      x2 = origin[1] + axis2[1];
      y2 = origin[2] - axis2[2];
      xscale = -axis1[1]/(xmax - xmin);
      yscale =  axis1[2]/(xmax - xmin);
      nticks = nxticks;
      tickvalues = &p_ticklabels->xvalues[0];
      axismin = xmin;
      }

   else
      {
      x1 = origin[1] + axis1[1] + axis2[1];
      y1 = origin[2] - axis1[2] - axis2[2];
      x2 = origin[1] + axis2[1];
      y2 = origin[2] - axis2[2];
      xscale = -axis1[1]/(ymax - ymin);
      yscale =  axis1[2]/(ymax - ymin);
      nticks = nyticks;
      tickvalues = &p_ticklabels->yvalues[0];
      axismin = ymin;
      }


   /* Draw axis1 grid lines */
   if ( ((quadrant == 1 || quadrant == 3) && strcmp(p_plot_param->x_tick_marks, "on") == 0) ||
        ((quadrant == 2 || quadrant == 4) && strcmp(p_plot_param->y_tick_marks, "on") == 0) )
      {
      points = gnome_canvas_points_new(2);

      x11 = x1;
      y11 = y1;
      x22 = x2;
      y22 = y2;
      x33 = x1 - axis2[1];
      y33 = y1 + axis2[2];
      x44 = x2 - axis2[1];
      y44 = y2 + axis2[2];
      for ( i=1; i<=nticks; i++ )
         {
         xtick = x11 + (tickvalues[i-1] - axismin)*xscale;
         ytick = y11 + (tickvalues[i-1] - axismin)*yscale;
         points->coords[0] = xtick;
         points->coords[1] = ytick;

         xtick = x33 + (tickvalues[i-1] - axismin)*xscale;
         ytick = y33 + (tickvalues[i-1] - axismin)*yscale;
         points->coords[2] = xtick;
         points->coords[3] = ytick;

         if ( gridchar1 == 'l' )
            DrawLine(points, gridcolor, 1);
         else if ( gridchar1 == 'd' )
            DrawDashedLine(points, gridcolor, 1);
         }

      x11 = x1 - axis2[1];
      y11 = y1 + axis2[2];
      x22 = x2 - axis2[1];
      y22 = y2 + axis2[2];
      x33 = x1 - axis2[1] - axis3[1];
      y33 = y1 + axis2[2] - axis3[2];
      x44 = x2 - axis2[1] - axis3[1];
      y44 = y2 + axis2[2] - axis3[2];
      for ( i=1; i<=nticks; i++ )
         {
         xtick = x11 + (tickvalues[i-1] - axismin)*xscale;
         ytick = y11 + (tickvalues[i-1] - axismin)*yscale;
         points->coords[0] = xtick;
         points->coords[1] = ytick;

         xtick = x33 + (tickvalues[i-1] - axismin)*xscale;
         ytick = y33 + (tickvalues[i-1] - axismin)*yscale;
         points->coords[2] = xtick;
         points->coords[3] = ytick;

         if ( gridchar1 == 'l' )
            DrawLine(points, gridcolor, 1);
         else if ( gridchar1 == 'd' )
            DrawDashedLine(points, gridcolor, 1);
         }

      gnome_canvas_points_unref(points);
      }


   /* Axis 2 tick-mark parameters */
   if ( quadrant == 1 )
      {
      x1 = origin[1] + axis1[1];
      y1 = origin[2] - axis1[2];
      x2 = origin[1] + axis1[1] + axis2[1];
      y2 = origin[2] - axis1[2] - axis2[2];
      xscale =  axis2[1]/(ymax - ymin);
      yscale = -axis2[2]/(ymax - ymin);
      nticks = nyticks;
      tickvalues = &p_ticklabels->yvalues[0];
      axismin = ymin;
      }

   else if ( quadrant == 2 )
      {
      x1 = origin[1] + axis1[1] + axis2[1];
      y1 = origin[2] - axis1[2] - axis2[2];
      x2 = origin[1] + axis1[1];
      y2 = origin[2] - axis1[2];
      xscale = -axis2[1]/(xmax - xmin);
      yscale =  axis2[2]/(xmax - xmin);
      nticks = nxticks;
      tickvalues = &p_ticklabels->xvalues[0];
      axismin = xmin;
      }

   else if ( quadrant == 3 )
      {
      x1 = origin[1] + axis1[1] + axis2[1];
      y1 = origin[2] - axis1[2] - axis2[2];
      x2 = origin[1] + axis1[1];
      y2 = origin[2] - axis1[2];
      xscale = -axis2[1]/(ymax - ymin);
      yscale =  axis2[2]/(ymax - ymin);
      nticks = nyticks;
      tickvalues = &p_ticklabels->yvalues[0];
      axismin = ymin;
      }

   else if ( quadrant == 4 )
      {
      x1 = origin[1] + axis1[1];
      y1 = origin[2] - axis1[2];
      x2 = origin[1] + axis1[1] + axis2[1];
      y2 = origin[2] - axis1[2] - axis2[2];
      xscale =  axis2[1]/(xmax - xmin);
      yscale = -axis2[2]/(xmax - xmin);
      nticks = nxticks;
      tickvalues = &p_ticklabels->xvalues[0];
      axismin = xmin;
      }


   /* Draw axis2 grid lines */
   if ( ((quadrant == 1 || quadrant == 3) && strcmp(p_plot_param->y_tick_marks, "on") == 0) ||
        ((quadrant == 2 || quadrant == 4) && strcmp(p_plot_param->x_tick_marks, "on") == 0) )
      {
      points = gnome_canvas_points_new(2);

      x11 = x1;
      y11 = y1;
      x22 = x2;
      y22 = y2;
      x33 = x1 - axis1[1];
      y33 = y1 + axis1[2];
      x44 = x2 - axis1[1];
      y44 = y2 + axis1[2];
      for ( i=1; i<=nticks; i++ )
         {
         xtick = x11 + (tickvalues[i-1] - axismin)*xscale;
         ytick = y11 + (tickvalues[i-1] - axismin)*yscale;
         points->coords[0] = xtick;
         points->coords[1] = ytick;

         xtick = x33 + (tickvalues[i-1] - axismin)*xscale;
         ytick = y33 + (tickvalues[i-1] - axismin)*yscale;
         points->coords[2] = xtick;
         points->coords[3] = ytick;

         if ( gridchar1 == 'l' )
            DrawLine(points, gridcolor, 1);
         else if ( gridchar1 == 'd' )
            DrawDashedLine(points, gridcolor, 1);
         }

      x11 = x1 - axis1[1];
      y11 = y1 + axis1[2];
      x22 = x2 - axis1[1];
      y22 = y2 + axis1[2];
      x33 = x1 - axis1[1] + axis3[1];
      y33 = y1 + axis1[2] - axis3[2];
      x44 = x2 - axis1[1] + axis3[1];
      y44 = y2 + axis1[2] - axis3[2];
      for ( i=1; i<=nticks; i++ )
         {
         xtick = x11 + (tickvalues[i-1] - axismin)*xscale;
         ytick = y11 + (tickvalues[i-1] - axismin)*yscale;
         points->coords[0] = xtick;
         points->coords[1] = ytick;

         xtick = x33 + (tickvalues[i-1] - axismin)*xscale;
         ytick = y33 + (tickvalues[i-1] - axismin)*yscale;
         points->coords[2] = xtick;
         points->coords[3] = ytick;

         if ( gridchar1 == 'l' )
            DrawLine(points, gridcolor, 1);
         else if ( gridchar1 == 'd' )
            DrawDashedLine(points, gridcolor, 1);
         }

      gnome_canvas_points_unref(points);
      }


   /* Draw axis3 grid lines */
   if ( strcmp(p_plot_param->z_tick_marks, "on") == 0 )
      {
      points = gnome_canvas_points_new(2);

      x1 = origin[1];
      y1 = origin[2];
      x2 = origin[1] + axis3[1];
      y2 = origin[2] - axis3[2];
      x3 = origin[1] + axis1[1];
      y3 = origin[2] - axis1[2];
      x4 = origin[1] + axis1[1] + axis3[1];
      y4 = origin[2] - axis1[2] - axis3[2];
      xscale =  axis3[1]/(zmax - zmin);
      yscale = -axis3[2]/(zmax - zmin);
      nticks = nzticks;
      for ( i=1; i<=nticks; i++ )
         {
         xtick = x1 + (p_ticklabels->zvalues[i-1] - zmin)*xscale;
         ytick = y1 + (p_ticklabels->zvalues[i-1] - zmin)*yscale;
         points->coords[0] = xtick;
         points->coords[1] = ytick;

         xtick = x3 + (p_ticklabels->zvalues[i-1] - zmin)*xscale;
         ytick = y3 + (p_ticklabels->zvalues[i-1] - zmin)*yscale;
         points->coords[2] = xtick;
         points->coords[3] = ytick;

         if ( gridchar1 == 'l' )
            DrawLine(points, gridcolor, 1);
         else if ( gridchar1 == 'd' )
            DrawDashedLine(points, gridcolor, 1);
         }

      x1 = origin[1];
      y1 = origin[2];
      x2 = origin[1] + axis3[1];
      y2 = origin[2] - axis3[2];
      x3 = origin[1] + axis2[1];
      y3 = origin[2] - axis2[2];
      x4 = origin[1] + axis2[1] + axis3[1];
      y4 = origin[2] - axis2[2] - axis3[2];
      for ( i=1; i<=nticks; i++ )
         {
         xtick = x1 + (p_ticklabels->zvalues[i-1] - zmin)*xscale;
         ytick = y1 + (p_ticklabels->zvalues[i-1] - zmin)*yscale;
         points->coords[0] = xtick;
         points->coords[1] = ytick;

         xtick = x3 + (p_ticklabels->zvalues[i-1] - zmin)*xscale;
         ytick = y3 + (p_ticklabels->zvalues[i-1] - zmin)*yscale;
         points->coords[2] = xtick;
         points->coords[3] = ytick;

         if ( gridchar1 == 'l' )
            DrawLine(points, gridcolor, 1);
         else if ( gridchar1 == 'd' )
            DrawDashedLine(points, gridcolor, 1);
         }

      gnome_canvas_points_unref(points);
      }

   return;
   }
