################################################################################
##
## Source-directory Makefile.am
## Processing Makefile.am with automake produces Makefile.in
##
## Copyright 2017 John Darrington <john@darrington.wattle.id.au>
## Copyright © 2008, 2009, 2010 Spencer A. Buckner
## http://savannah.gnu.org/projects/gsegrafix
##
## This file is part of GSEGrafix, a scientific and engineering plotting program.
##
## This program is free software: you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation, either version 3 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program.  If not, see <http://www.gnu.org/licenses/>.
##
################################################################################

noinst_PROGRAMS = nsa

bin_PROGRAMS = gse


noinst_LIBRARIES = libgsegrafix.a

libgsegrafix_a_CFLAGS =  $(PANGO_CAIRO_CFLAGS) $(PANGO_CFLAGS) $(GLIB_CFLAGS) $(GDK_PIXBUF_CFLAGS) $(GDK_CFLAGS) \
	-I $(top_srcdir)/src


libgsegrafix_a_SOURCES = \
src/AutoScale.c \
src/AutoScale.h \
src/AxesEqual.c \
src/AxesEqual.h \
src/AxisLimits.c \
src/AxisLimits.h \
src/CheckParamData.c \
src/CheckParamData.h \
src/Clip.c \
src/Clip.h \
src/ColorPlot2d.c \
src/ColorPlot2d.h \
src/ColorPlot3d.c \
src/ColorPlot3d.h \
src/ContourPlot2d.c \
src/ContourPlot2d.h \
src/ContourPlot3d.c \
src/ContourPlot3d.h \
src/DataMinMax.c \
src/DataMinMax.h \
src/DataMinMax3d.c \
src/DataMinMax3d.h \
src/DrawAxisLabels.c \
src/DrawAxisLabels.h \
src/DrawBackgroundImage.c \
src/DrawBackgroundImage.h \
src/DrawContours3d.c \
src/DrawContours3d.h \
src/DrawDateTime.c \
src/DrawDateTime.h \
src/DrawGraph.c \
src/DrawGraph.h \
src/DrawGrid.c \
src/DrawGrid.h \
src/DrawGrid2d.c \
src/DrawGrid2d.h \
src/DrawGrid3d.c \
src/DrawGrid3d.h \
src/DrawGridLog.c \
src/DrawGridLog.h \
src/DrawImage.c \
src/DrawImage.h \
src/DrawLabels3d.c \
src/DrawLabels3d.h \
src/DrawLegend.c \
src/DrawLegend.h \
src/DrawLines.c \
src/DrawLines.h \
src/DrawLines2d.h \
src/DrawSymbols.c \
src/DrawSymbols.h \
src/DrawText.c \
src/DrawText.h \
src/DrawTickLabels.c \
src/DrawTickLabels.h \
src/DrawTickLabels2d.c \
src/DrawTickLabels2d.h \
src/DrawTickLabelsLog.c \
src/DrawTickLabelsLog.h \
src/DrawTickMarks.c \
src/DrawTickMarks.h \
src/DrawTickMarks3d.c \
src/DrawTickMarks3d.h \
src/FileRead.c \
src/FileRead.h \
src/FileRead3d.c \
src/FileRead3d.h \
src/GetWindowCoords.c \
src/GetWindowCoords.h \
src/Histogram.c \
src/Histogram.h \
src/Initialize3d.c \
src/Initialize3d.h \
src/InitializePlot.c \
src/InitializePlot.h \
src/MeshPlot3d.c \
src/MeshPlot3d.h \
src/Misc.c \
src/Misc.h \
src/PlotData2d.c \
src/PlotData2d.h \
src/PlotData3d.c \
src/PlotData3d.h \
src/PlotEllipses.c \
src/PlotEllipses.h \
src/PlotInterp3d.c \
src/PlotInterp3d.h \
src/PlotLines.c \
src/PlotLines.h \
src/PlotNormal3d.c \
src/PlotNormal3d.h \
src/PlotPoints3d.c \
src/PlotPoints3d.h \
src/PlotRectangles.c \
src/PlotRectangles.h \
src/PlotSymbols.c \
src/PlotSymbols.h \
src/PolarPlot.c \
src/PolarPlot.h \
src/ReadParamFile.c \
src/ReadParamFile.h \
src/ZoomIn.c \
src/ZoomIn.h \
src/ZoomOut.c \
src/ZoomOut.h \
src/dummy-gnome.c \
src/dummy-gnome.h \
src/gse-cairo.c \
src/gse-cairo.h \
src/gse-context.c \
src/gse-context.h \
src/gsegraf.h




# New simple application
nsa_LDADD = libgsegrafix.a

nsa_CFLAGS = $(GTK_CFLAGS) \
	-I $(top_srcdir)/src

nsa_LDFLAGS = $(GTK_LIBS) -lm 

nsa_SOURCES = src/nsa.c


# Complicated Interactive Application
gse_LDADD = libgsegrafix.a

gse_CFLAGS = $(GTK_CFLAGS) \
	-I $(top_srcdir)/src

gse_LDFLAGS = $(GTK_LIBS) -lm 

gse_SOURCES = src/gse.c
