/*******************************************************************************
*
* gsegraf.h
*
* Declares structures, external variables, and function prototypes for gsegraf
* executable.
*
* Copyright  2008, 2009, 2010, 2011, 2012 Spencer A. Buckner
* http://savannah.gnu.org/projects/gsegrafix
*
* This file is part of GSEGrafix, a scientific and engineering plotting program.
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
*******************************************************************************/

#ifndef GSEGRAF_H
#define GSEGRAF_H

#include <dummy-gnome.h>
#include <glib.h>
#include <setjmp.h>

#include <pango/pango.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#include <cairo.h>

extern const char symbol_string[]  ;
extern const char symbol_string1[] ;
extern const char symbol_string2[] ;
extern const char color_string[]   ;

/* Anchor types */
typedef enum
{
  GSE_ANCHOR_CENTER,
  GSE_ANCHOR_NORTH,
  GSE_ANCHOR_NORTH_WEST,
  GSE_ANCHOR_NORTH_EAST,
  GSE_ANCHOR_SOUTH,
  GSE_ANCHOR_SOUTH_WEST,
  GSE_ANCHOR_SOUTH_EAST,
  GSE_ANCHOR_WEST,
  GSE_ANCHOR_EAST,
} GseAnchorType;

typedef struct
   {
   double xmin, xmax, ymin, ymax;
   } plot_box_data_type;


typedef struct
   {
   int  nplots;
   char axis_type[10];
   char grid[4];
   char minor_ticks[4];
   char axis_scale[6];
   double axis_limits[6];
   char date_time_anchor[10];
   char plot_box[4];
   char x_tick_marks[4], y_tick_marks[4], z_tick_marks[4];
   char x_tick_labels[4], y_tick_labels[4], z_tick_labels[4];
   } plot_param_type;


typedef struct
   {
   double xmin, xmax, ymin, ymax, zmin, zmax;
   } data_min_max_type;


struct tick_labels
{
  int nvalues;
  double values[11];
  double offset1;
  double offset2;
};

typedef struct
   {
   int quadrant;
     double phi, theta, phi_ref, theta_ref, axis_length, plot_width, plot_height,
       origin[3], axis1[3], axis2[3], axis3[3], Ryz[9];
} plot_param_3d_type;



#define deg2rad (M_PI / 180.0)

struct datum
{
  double x, y, z;
};

struct data3d
{
  int nx;
  int ny;
  double *x ; // An array of nx doubles
  double *y ; // An array of ny doubles
  double *z ; // An array of nx*ny doubles, indexed x,y order
};

struct plot_parameters
{
  unsigned int stylesizes;

  int styleflags;
  
  char stylechar1, stylechar2;

  guint32 stylecolor1, stylecolor2,  alphacolor;

  guint32 meshcolors, contourcolors;
  
  guint32  fill_colors_rgba, outline_colors_rgba;
  double zblack, zwhite, bin_widths, stemvalues;
  int ninterp;
  int ndata;

  char bin_values[9];
  char bin_refs[9];
  char stemflags[4];
  char plot_types[10];

  int    *nlinebreak;
  int nlinebreaks;

  double binmin, binmax, histmin, histmax;
  double *yhist;
  int nbins;
  struct datum *samples;
  struct data3d samples3d;
};

struct gse_ctx
{
  GError *err;
  GQuark domain;
  jmp_buf finish;

  cairo_t *cr;

  int window_height;
  int window_width;
  
  /* Declare structure pointers */
  plot_param_type    plot_param;
  plot_box_data_type plot_box_data;

  struct tick_labels xtick_labels;
  struct tick_labels ytick_labels;
  struct tick_labels ztick_labels;

  struct tick_labels xtick_labels_ref;
  struct tick_labels ytick_labels_ref;
  struct tick_labels ztick_labels_ref;

  
  data_min_max_type  data_min_max;
  plot_param_3d_type plot_param_3d;

  /* Declare a gnome canvas group pointers */
  GnomeCanvasGroup *group;

  /* Declare tick-mark and dashed-line variables */
  double tick_major, tick_minor, dash, space_dash, space_dot;

  /* Declare color variables and pointers for colors specified by color characters */
  guint32 color_rgba[17];


/* Declare color variables for all colors with maximum saturation from blue to green to red */
  int n_color_spectrum_1, n_color_spectrum_2;
  guint32 color_spectrum_1[1021], color_spectrum_2[769];
  
/* Declare pango font-description pointers and font-size variables */
PangoFontDescription *font_date_time,
                     *font_legend,
                     *font_text,
                     *font_tick_labels,
                     *font_axis_labels,
                     *font_title;

double font_size_date_time,
       font_size_legend,
       font_size_text,
       font_size_tick_labels,
       font_size_axis_labels,
       font_size_title;

  /* Declare tick-label size variables */
  double width_ytick_labels,
    width_axis1_tick_labels,
    width_axis2_tick_labels,
    width_axis3_tick_labels;

  /* Declare plot-parameter variables and pointers */
  int maxline;
  gboolean axis_limits[6];
  int minor_ticks_flag;
  int ncontours;
  int background_image_style;

  char gridchar1, gridchar2;

  guint32 canvas_fg_color, canvas_bg_color, gridcolor;

  char *line, *string_get;
  const char*p_param_file;

  struct plot_parameters *plot_parameters;

  char *xlabel, *ylabel, *zlabel;
  
  char date_time[21];

  char *font_name;

  char *background_image_file;

  char *title;

  void     ( *symbol_func1[12] ) (struct gse_ctx *, double x, double y, guint32 fill_color_rgba, guint32 outline_color_rgba,
                                 unsigned int size );
  
  void     ( *symbol_func2[4] ) (struct gse_ctx *, double x, double y, guint32 fill_color_rgba, unsigned int size );
};

#endif
