/*
  This file is part of GSEGrafix, a scientific and engineering plotting 
  program.

  Copyright (C) 2017 John Darrington

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef DUMMY_GNOME_H
#define DUMMY_GNOME_H

#include <glib.h>

typedef gpointer GnomeCanvasItem ;
typedef struct
{
  int num_points;
  double *coords;
} GnomeCanvasPoints;
GnomeCanvasItem* gnome_canvas_item_new(GnomeCanvasItem *x,...);
GnomeCanvasPoints *gnome_canvas_points_new (int);
void gnome_canvas_points_unref (GnomeCanvasPoints *pts);

void gnome_canvas_item_set (GnomeCanvasItem*,...);
void gnome_canvas_item_raise_to_top (GnomeCanvasItem*);
void* gnome_canvas_item_get_bounds();
void *art_affine_rotate (double *, int);
void *art_affine_translate (double *, int, int);
void *gnome_canvas_item_affine_absolute (void *, double*);
void *gnome_canvas_item_affine_relative (void*, double*);
typedef gpointer GnomeCanvasGroup;
enum
  {GNOME_TYPE_CANVAS_PIXBUF ,
   GNOME_TYPE_CANVAS_LINE ,
   GNOME_TYPE_CANVAS_TEXT ,
   GNOME_TYPE_CANVAS_RECT,
   GNOME_TYPE_CANVAS_POLYGON,
   GNOME_TYPE_CANVAS_ELLIPSE,
  };

#endif
