/*
  This file is part of GSEGrafix, a scientific and engineering plotting 
  program.

  Copyright (C) 2017 John Darrington

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "dummy-gnome.h"
#include <stdlib.h>

GnomeCanvasPoints *
gnome_canvas_points_new (int n)
{
  GnomeCanvasPoints *ptr = malloc (sizeof *ptr);

  ptr->num_points = n;
  ptr->coords = calloc (sizeof (double), n * 2);

  return ptr;
}

void
gnome_canvas_points_unref (GnomeCanvasPoints *pts)
{
  free (pts->coords);
  free (pts);
}


GnomeCanvasItem*
gnome_canvas_item_new(GnomeCanvasItem *x,...)
{
  g_critical ("Unreplaced %s\n", __FUNCTION__);
  return NULL;
}



void* gnome_canvas_item_get_bounds()
{
  return NULL;
}


void
gnome_canvas_item_set (GnomeCanvasItem*x ,...)
{
}

void
gnome_canvas_item_raise_to_top (GnomeCanvasItem*x)
{
}

