/*******************************************************************************
*
* ZoomOut.c
*
* Causes plot to zoom out to original plot.
*
* Copyright  2008, 2009, 2010, 2011, 2012 Spencer A. Buckner
* http://savannah.gnu.org/projects/gsegrafix
*
* This file is part of GSEGrafix, a scientific and engineering plotting program.
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
*******************************************************************************/

#include "ZoomOut.h"
#include "PlotData2d.h"
#include "DrawBackgroundImage.h"
#include "DrawGrid2d.h"
#include "DrawGridLog.h"
#include "PlotRectangles.h"
#include "PlotEllipses.h"
#include "DrawDateTime.h"
#include "DrawText.h"
#include "PlotLines.h"
#include "PlotSymbols.h"
#include "DrawLegend.h"
#include "DrawImage.h"
#include "PlotData3d.h"
#include "DrawLabels3d.h"
#include "DrawTickLabels2d.h"
#include "DrawTickLabelsLog.h"
#include "DrawAxisLabels.h"
#include "DrawGrid3d.h"
#include "DrawTickMarks3d.h"
#include "DrawGraph.h"

#include "gsegraf.h"

#include <string.h>

void ZoomOut (struct gse_ctx *context)
   {
   /* Declare variables */
   int i, nx, ny, nz;


   /* Draw original plot */
   if ( strcmp(context->plot_param.axis_type, "linear")   == 0 ||
        strcmp(context->plot_param.axis_type, "semilogx") == 0 ||
        strcmp(context->plot_param.axis_type, "semilogy") == 0 ||
        strcmp(context->plot_param.axis_type, "loglog")   == 0 )
      {
	/* Get tick-mark reference values */
	context->xtick_labels = context->xtick_labels_ref;
	context->ytick_labels = context->ytick_labels_ref;
	context->ztick_labels = context->ztick_labels_ref;
      }

   else if ( strcmp(context->plot_param.axis_type, "polar") == 0 )
      {
	/* Get tick-mark reference values */
	context->xtick_labels = context->xtick_labels_ref;
	context->ytick_labels = context->ytick_labels_ref;
      }

   else if ( strcmp(context->plot_param.axis_type, "3d") == 0 )
      {
      /* Get tick-mark reference values */
	context->xtick_labels = context->xtick_labels_ref;
	context->ytick_labels = context->ytick_labels_ref;
	context->ztick_labels = context->ztick_labels_ref;
	
	
	/* Get view-angle reference values */
	context->plot_param_3d.phi   = context->plot_param_3d.phi_ref;
	context->plot_param_3d.theta = context->plot_param_3d.theta_ref;
      }
   }
