/*******************************************************************************
*
* ZoomIn.c
*
* Causes plot to zoom to indicated rectangle.
*
* Copyright  2008, 2009, 2010, 2011, 2012 Spencer A. Buckner
* http://savannah.gnu.org/projects/gsegrafix
*
* This file is part of GSEGrafix, a scientific and engineering plotting program.
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
*******************************************************************************/

#include "ZoomIn.h"
#include "AxisLimits.h"
#include "AxesEqual.h"
#include "DrawBackgroundImage.h"
#include "DrawGrid2d.h"
#include "DrawGridLog.h"
#include "PlotRectangles.h"
#include "PlotEllipses.h"
#include "DrawLegend.h"
#include "DrawImage.h"
#include "DrawDateTime.h"
#include "DrawText.h"
#include "PlotLines.h"
#include "PlotSymbols.h"
#include "PlotData2d.h"
#include "DrawTickLabels2d.h"
#include "DrawTickLabelsLog.h"
#include "DrawAxisLabels.h"
#include "DrawGraph.h"

#include <math.h>
#include "gsegraf.h"

#include <string.h>

void
ZoomIn (struct gse_ctx *context, double x1_window, double y1_window, double x2_window, double y2_window )
   {
     if (x1_window == x2_window)
       return;

     if (y1_window == y2_window)
       return;
     
   /* Declare variables */
   int i, nxvalues, nyvalues, nzvalues;
   double x1_box, y1_box, x2_box, y2_box,
          xmin, xmax, ymin, ymax, zmin, zmax,
          xscale, yscale,
          x1, y1, x2, y2;


   /* Get plot box minimum and maximum values */
   x1_box = context->plot_box_data.xmin;
   x2_box = context->plot_box_data.xmax;
   y1_box = context->plot_box_data.ymin;
   y2_box = context->plot_box_data.ymax;


   /* Get axis minimum and maximum values */
   nxvalues = context->xtick_labels.nvalues;
   nyvalues = context->ytick_labels.nvalues;
   nzvalues = context->ztick_labels.nvalues;
   xmin = context->xtick_labels.values[0];
   xmax = context->xtick_labels.values[nxvalues-1];
   ymin = context->ytick_labels.values[0];
   ymax = context->ytick_labels.values[nyvalues-1];
   zmin = context->ztick_labels.values[0];
   zmax = context->ztick_labels.values[nzvalues-1];
   xmin = xmin - context->xtick_labels.offset1;
   xmax = xmax + context->xtick_labels.offset2;
   ymin = ymin - context->ytick_labels.offset1;
   ymax = ymax + context->ytick_labels.offset2;
   zmin = zmin - context->ztick_labels.offset1;
   zmax = zmax + context->ztick_labels.offset2;

   if ( strcmp(context->plot_param.axis_type, "semilogx") == 0 ||
        strcmp(context->plot_param.axis_type, "loglog")   == 0 )
      {
      xmin = floor(xmin);
      xmax = ceil(xmax);
      }

   if ( strcmp(context->plot_param.axis_type, "semilogy") == 0 ||
        strcmp(context->plot_param.axis_type, "loglog")   == 0 )
      {
      ymin = floor(ymin);
      ymax = ceil(ymax);
      }


   /* Calculate new data minimum and maximum values */
   xscale = (x2_box - x1_box)/(xmax - xmin);
   yscale = (y2_box - y1_box)/(ymax - ymin);
   x1 = xmin + (x1_window - x1_box)/xscale;
   x2 = xmin + (x2_window - x1_box)/xscale;
   y1 = ymin - (y1_window - y2_box)/yscale;
   y2 = ymin - (y2_window - y2_box)/yscale;


   /* Save new data minimum and maximum values */
   if ( x1 < x2 )
      {
      context->data_min_max.xmin = x1;
      context->data_min_max.xmax = x2;
      }
   else
      {
      context->data_min_max.xmin = x2;
      context->data_min_max.xmax = x1;
      }

   if ( y1 < y2 )
      {
      context->data_min_max.ymin = y1;
      context->data_min_max.ymax = y2;
      }
   else
      {
      context->data_min_max.ymin = y2;
      context->data_min_max.ymax = y1;
      }

   context->data_min_max.zmin = zmin;
   context->data_min_max.zmax = zmax;


   /* Set tick-label offsets to zero */
   context->xtick_labels.offset1 = 0.0;
   context->xtick_labels.offset2 = 0.0;
   context->ytick_labels.offset1 = 0.0;
   context->ytick_labels.offset2 = 0.0;


   /* Turn axis limits off */
   for ( i=1; i<=4; i++ )
      context->axis_limits[i-1] = FALSE;
   for ( i=5; i<=6; i++ )
      context->axis_limits[i-1] = TRUE;
   context->plot_param.axis_limits[4] = zmin;
   context->plot_param.axis_limits[5] = zmax;


   /* Draw plot */
   if ( strcmp(context->plot_param.axis_type, "linear")   == 0 ||
        strcmp(context->plot_param.axis_type, "semilogx") == 0 ||
        strcmp(context->plot_param.axis_type, "semilogy") == 0 ||
        strcmp(context->plot_param.axis_type, "loglog")   == 0 )
      {
	AxisLimits(context, 0);
	if ( strcmp(context->plot_param.axis_type, "linear") == 0 &&
	     strcmp(context->plot_param.axis_scale, "equal") == 0 )
	  AxesEqual(context, 0);
      }
   }
