/*******************************************************************************
 *
 * PlotData3d.c
 *
 * Plots a two-dimensional projection of three-dimensional data.
 *
 * Copyright  2008, 2009, 2010, 2011, 2012 Spencer A. Buckner
 * http://savannah.gnu.org/projects/gsegrafix
 *
 * This file is part of GSEGrafix, a scientific and engineering plotting program.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *******************************************************************************/

#include "PlotData3d.h"
#include "PlotPoints3d.h"
#include "MeshPlot3d.h"
#include "ContourPlot3d.h"
#include "ColorPlot3d.h"

#include "gsegraf.h"

#include <string.h>

void
PlotData3d (struct gse_ctx *context)
{
  int iplot, nplots;
  /* Plot data */
  nplots = context->plot_param.nplots;
  for ( iplot=1; iplot<=nplots; iplot++ )
    {
      const struct plot_parameters *the_plot = &context->plot_parameters[iplot-1];
      if ( strncmp (the_plot->plot_types, "points", 10) == 0 )
	{
	  /* Plot 3d line data */
	  PlotPoints3d(context, iplot);
	}
      else if ( strncmp (the_plot->plot_types, "mesh", 10) == 0 )
	{
	  /* Plot 3d mesh data */
	  int nx = the_plot->samples3d.nx;
	  int ny = the_plot->samples3d.ny;
	  MeshPlot3d(context, iplot, nx, ny);
	}

      else if ( strncmp (the_plot->plot_types, "contour", 10) == 0 )
	{
	  /* Plot 3d contour data */
	  int nx = the_plot->samples3d.nx;
	  int ny = the_plot->samples3d.ny;
	  ContourPlot3d(context, iplot, nx, ny);
	}


      else if ( strncmp (the_plot->plot_types, "color", 10) == 0 )
	{
	  /* Plot 3d color data */
	  int nx = the_plot->samples3d.nx;
	  int ny = the_plot->samples3d.ny;
	  ColorPlot3d(context, iplot, nx, ny);
	}
    }
}
