/*
  This file is part of GSEGrafix, a scientific and engineering plotting 
  program.

  Copyright (C) 2017 John Darrington

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <stdbool.h>

struct gse_ctx;


struct data_parser
{
  /* A scanf format string to parse numeric data */
  char  *formats;

  /* A scanf format string to parse modifiers (typicaly asterisks) */
  char  *formats_mod;

  int *nformats;

  char *filenames;

  int *nfilenames;

  char *save_filename;
  bool close_after_save;
};

void     InitializePlot (struct gse_ctx *);
void PlotBox (struct gse_ctx *context);




