/*
  This file is part of GSEGrafix, a scientific and engineering plotting 
  program.

  Copyright (C) 2017 John Darrington

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include <glib.h>
#include <dummy-gnome.h>

struct gse_ctx;
/* DrawSymbols.c */
void     DrawLine (struct gse_ctx *, GnomeCanvasPoints *points, int n_points, guint32 fill_color_rgba, unsigned int line_width );
void     DrawDashedLine (struct gse_ctx *, GnomeCanvasPoints *points, guint32 fill_color_rgba, unsigned int line_width );
void     DrawDottedLine (struct gse_ctx *, GnomeCanvasPoints *points, guint32 fill_color_rgba, unsigned int size );
void     DrawCircle (struct gse_ctx *, double x, double y, guint32 fill_color_rgba, guint32 outline_color_rgba, unsigned int size );
void     DrawTriangle (struct gse_ctx *, double x, double y, guint32 fill_color_rgba, guint32 outline_color_rgba, unsigned int size );
void     DrawSquare (struct gse_ctx *, double x, double y, guint32 fill_color_rgba, guint32 outline_color_rgba, unsigned int size );
void     DrawDiamond (struct gse_ctx *, double x, double y, guint32 fill_color_rgba, guint32 outline_color_rgba, unsigned int size );
void     DrawPentagon (struct gse_ctx *, double x, double y, guint32 fill_color_rgba, guint32 outline_color_rgba, unsigned int size );
void     DrawHexagon (struct gse_ctx *, double x, double y, guint32 fill_color_rgba, guint32 outline_color_rgba, unsigned int size );
void     DrawPlus (struct gse_ctx *, double x, double y, guint32 fill_color_rgba, unsigned int size );
void     DrawX (struct gse_ctx *,  double x, double y, guint32 fill_color_rgba, unsigned int size );
void     DrawStar (struct gse_ctx *,  double x, double y, guint32 fill_color_rgba, unsigned int size );
void     DrawAsterisk (struct gse_ctx *,  double x, double y, guint32 fill_color_rgba, unsigned int size );
void     DrawBar (struct gse_ctx *,  double x1, double y1, double x2, double y2,
                   guint32 fill_color_rgba, guint32 outline_color_rgba );
void     DrawMesh (struct gse_ctx *,  double x1, double y1, double x2, double y2,
                    guint32 fill_color_rgba, guint32 outline_color_rgba, int flag );
void     DrawContour (struct gse_ctx *, double x1, double y1, double x2, double y2,
                       guint32 fill_color_rgba, guint32 outline_color_rgba, int flag );
void     DrawColorPlot (struct gse_ctx *, double x1, double y1, double x2, double y2 );

