/*******************************************************************************
*
* DrawGridLog.c
*
* Draws grid lines and tick marks for logarithmic axes of two-dimensional plots.
*
* Copyright  2008, 2009, 2010, 2011, 2012 Spencer A. Buckner
* http://savannah.gnu.org/projects/gsegrafix
*
* This file is part of GSEGrafix, a scientific and engineering plotting program.
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
*******************************************************************************/

#include "DrawGridLog.h"
#include "DrawGrid.h"
#include "DrawTickMarks.h"
#include <math.h>
#include "gsegraf.h"

#include <string.h> // for strcmp

void DrawGridLog (struct gse_ctx *context)
   {
   /* Declare variables */
   double x1_box, x2_box, y1_box, y2_box;


   /* Check plot_box parameter */
   if ( strcmp(context->plot_param.plot_box, "off") == 0 )
      return;


   /* Check axis_type parameter */
   if ( strcmp(context->plot_param.axis_type, "linear") == 0 )
      return;


   /* Specify plot box minimum and maximum values */
   x1_box = context->plot_box_data.xmin;
   x2_box = context->plot_box_data.xmax;
   y1_box = context->plot_box_data.ymin;
   y2_box = context->plot_box_data.ymax;


   /* Draw grid lines */
   if ( strcmp(context->plot_param.grid, "on1") == 0 ||
        strcmp(context->plot_param.grid, "on2") == 0 )
      {
      if ( strcmp(context->plot_param.x_tick_marks, "on") == 0 &&
           (strcmp(context->plot_param.axis_type, "semilogx") == 0 ||
            strcmp(context->plot_param.axis_type, "loglog")   == 0) )
         {
	   DrawGrid(context, "log",
                  x1_box, y2_box, x2_box, y2_box, x1_box, y1_box,
                  context->xtick_labels.nvalues, &context->xtick_labels.values[0],
                  context->xtick_labels.offset1, context->xtick_labels.offset2);
         }


      if ( strcmp(context->plot_param.y_tick_marks, "on") == 0 &&
           (strcmp(context->plot_param.axis_type, "semilogy") == 0 ||
            strcmp(context->plot_param.axis_type, "loglog")   == 0) )
         {
	   DrawGrid(context, "log",
                  x1_box, y2_box, x1_box, y1_box, x2_box, y2_box,
                  context->ytick_labels.nvalues, &context->ytick_labels.values[0],
                  context->ytick_labels.offset1, context->ytick_labels.offset2);
         }
      }


   /* Draw x-axis tick marks */
   if ( strcmp(context->plot_param.x_tick_marks, "on") == 0 &&
        (strcmp(context->plot_param.axis_type, "semilogx") == 0 ||
         strcmp(context->plot_param.axis_type, "loglog")   == 0) )
      {
	DrawTickMarks(context, "log", context->minor_ticks_flag, 0,
                    x1_box, y2_box, x2_box, y2_box,
                    context->xtick_labels.nvalues, &context->xtick_labels.values[0],
                    context->xtick_labels.offset1, context->xtick_labels.offset2,
                    90.0*deg2rad);   /* lower x-axis */

	DrawTickMarks(context, "log", context->minor_ticks_flag, 0,
                    x1_box, y1_box, x2_box, y1_box,
                    context->xtick_labels.nvalues, &context->xtick_labels.values[0],
                    context->xtick_labels.offset1, context->xtick_labels.offset2,
                    -90.0*deg2rad);   /* upper x-axis */
      }


   /* Draw y-axis tick marks */
   if ( strcmp(context->plot_param.y_tick_marks, "on") == 0 &&
        (strcmp(context->plot_param.axis_type, "semilogy") == 0 ||
         strcmp(context->plot_param.axis_type, "loglog")   == 0) )
      {
	DrawTickMarks(context, "log", context->minor_ticks_flag, 0,
                    x1_box, y2_box, x1_box, y1_box,
                    context->ytick_labels.nvalues, &context->ytick_labels.values[0],
                    context->ytick_labels.offset1, context->ytick_labels.offset2,
                    0.0*deg2rad);   /* left y-axis */

	DrawTickMarks(context, "log", context->minor_ticks_flag, 0,
                    x2_box, y2_box, x2_box, y1_box,
                    context->ytick_labels.nvalues, &context->ytick_labels.values[0],
                    context->ytick_labels.offset1, context->ytick_labels.offset2,
                    180.0*deg2rad);   /* right y-axis */
      }

   return;
   }
