/*******************************************************************************
*
* DrawGraph.c
*
* Draws graph.
*
* Copyright  2008, 2009, 2010, 2011, 2012 Spencer A. Buckner
* http://savannah.gnu.org/projects/gsegrafix
*
* This file is part of GSEGrafix, a scientific and engineering plotting program.
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
*******************************************************************************/

#include "DrawGraph.h"
#include "PolarPlot.h"
#include "PlotData3d.h"
#include "DrawLabels3d.h"
#include "DrawTickMarks3d.h"
#include "DrawGrid3d.h"
#include "Initialize3d.h"
#include "AxesEqual.h"
#include "DrawBackgroundImage.h"
#include "DrawGrid2d.h"
#include "PlotRectangles.h"
#include "PlotEllipses.h"
#include "DrawGridLog.h"
#include "PlotData2d.h"
#include "PlotLines.h"
#include "PlotSymbols.h"
#include "DrawTickLabels2d.h"
#include "DrawTickLabelsLog.h"
#include "DrawAxisLabels.h"
#include "DrawLegend.h"
#include "DrawText.h"
#include "DrawImage.h"
#include "DrawDateTime.h"
#include "InitializePlot.h"

#include <string.h> // for strcmp

#include "gsegraf.h"

void
DrawCartesian (struct gse_ctx *context)
{
  DrawBackgroundImage(context);
  DrawGrid2d(context);
  DrawGridLog(context);
  PlotData2d(context);
  if ( strcmp(context->plot_param.axis_type, "linear") == 0 )
    {
      PlotRectangles(context);
      PlotEllipses(context);
    }
  PlotLines(context);
  PlotSymbols(context);
  DrawTickLabels2d(context);
  DrawTickLabelsLog(context);
  DrawAxisLabels(context);
  DrawLegend(context);
  DrawText(context);
  DrawImage(context);
  DrawDateTime(context);
}

void
DrawPolar (struct gse_ctx *context)
{
  /* Draw Plot */
  DrawBackgroundImage(context);
  PolarPlot(context);
  DrawLegend(context);
  DrawText(context);
  DrawImage(context);
  DrawDateTime(context);
}

void
DrawCartesian3d (struct gse_ctx *context)
{
  Initialize3d(context);
  DrawGrid3d(context);
  DrawTickMarks3d(context);
  DrawLabels3d(context);
  PlotData3d(context);
  PlotLines(context);
  PlotSymbols(context);
  DrawLegend(context);
  DrawText(context);
  DrawImage(context);
  DrawDateTime(context);
}

void
DrawGraph (struct gse_ctx *context)
   {
   /* Draw graph */
   if ( strcmp(context->plot_param.axis_type, "linear")   == 0 ||
        strcmp(context->plot_param.axis_type, "semilogx") == 0 ||
        strcmp(context->plot_param.axis_type, "semilogy") == 0 ||
        strcmp(context->plot_param.axis_type, "loglog")   == 0 )
      {
	PlotBox (context);
      /* Draw Plot */
      DrawCartesian (context);
      }
   else if ( strcmp(context->plot_param.axis_type, "polar") == 0 )
      {
	DrawPolar (context);
      }
   else if ( strcmp(context->plot_param.axis_type, "3d") == 0 )
      {
	/* Draw Plot */
	DrawCartesian3d (context);
      }
   }

