/*******************************************************************************
*
* DrawAxisLabels.c
*
* Draws plot box, axis labels, and title for two-dimensional plots.
*
* Copyright  2008, 2009, 2010, 2011, 2012 Spencer A. Buckner
* http://savannah.gnu.org/projects/gsegrafix
*
* This file is part of GSEGrafix, a scientific and engineering plotting program.
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
*******************************************************************************/


#include <math.h>
#include <string.h>
#include "gsegraf.h"

#include "gse-cairo.h"

void DrawAxisLabels (struct gse_ctx *context)
   {
   /* Declare variables */
   double x1_box, x2_box, y1_box, y2_box, x, y;

   /* Get plot box minimum and maximum values */
   x1_box = context->plot_box_data.xmin;
   x2_box = context->plot_box_data.xmax;
   y1_box = context->plot_box_data.ymin;
   y2_box = context->plot_box_data.ymax;

   /* Draw plot box rectangle */
   if ( strcmp(context->plot_param.plot_box, "on") == 0 )
     {
       gse_cairo_render_rectangle (context->cr,
				   x1_box, y1_box,
				   x2_box - x1_box,
				   y2_box - y1_box,
				   2,
				   context->canvas_fg_color,
				   0xFFFFFF00);
     }

   /* Draw x-axis label */
   if ( context->xlabel != NULL )
      {
      x = (x1_box + x2_box)/2.0;
      if ( strcmp(context->plot_param.plot_box, "on") == 0 &&
           strcmp(context->plot_param.x_tick_marks, "on") == 0 &&
           strcmp(context->plot_param.x_tick_labels, "on") == 0 )
         y = y2_box + 8.0 + context->font_size_tick_labels + 8.0;
      else
         y = y2_box + 8.0;
      gse_cairo_render_text (context->cr, context->xlabel,
			     x, y,
			     GSE_ANCHOR_NORTH,
			     context->canvas_fg_color,
			     context->font_axis_labels);
      }


   /* Draw y-axis label */
   if ( context->ylabel != NULL)
      {
      if ( strcmp(context->plot_param.plot_box, "on") == 0 &&
           strcmp(context->plot_param.y_tick_marks, "on") == 0 &&
           strcmp(context->plot_param.y_tick_labels, "on") == 0 )
         x = x1_box - 8.0 - context->width_ytick_labels - 8.0;
      else
         x = x1_box - 8.0;
      y = (y1_box + y2_box)/2.0;


      gse_cairo_render_text_with_extents (context->cr, context->ylabel, x, y,
			     GSE_ANCHOR_WEST,
			     context->canvas_fg_color,
			     context->font_axis_labels,
					  -M_PI / 2.0, 0,0,0,0
			     );
      }


   /* Draw plot title */
   if ( context->title != NULL )
      {
      x = (x1_box + x2_box)/2.0;
      y = y1_box - 8.0;
      gse_cairo_render_text (context->cr, context->title,
			     x, y,
			     GSE_ANCHOR_SOUTH,
			     context->canvas_fg_color,
			     context->font_title);
      }

   return;
   }

