-- Lua script for the GRUB 'winter' theme.

-- Random number generator (brain dead)
seed = 42373
function rand(min,max)
  seed = seed * 97 + 17 * min * max
  return seed % (max - min + 1) + min
end

font_family = "Helvetica Bold"

-- Number of words on screen concurrently.
num_words = 6

strings =
{
  "GRUB", "GRUB", "GRUB", "GRUB", "GRUB", "GRUB", "GRUB", "GRUB",
  "GRUB", "GRUB", "GRUB", "GRUB", "GRUB", "GRUB", "GRUB", "GRUB",
  "GRUB rocks!",
}

point_sizes = { 8, 10, 12, 14, 14, 18, 18, 18, 18, 24, 24, 24 }

-- Utility function to create a color.
function color(r,g,b)
  return { r=r, g=g, b=b }
end

-- The possible colors to use for text.
colors =
{
  color(1, 155, 183),
  color(2, 168, 184),
  color(203, 250, 254),
  color(0, 185, 212),
}

-- Create a new word with random attributes.
function new_random_word()
  local w={}
  w.speed = rand(3,7)
  w.x = rand(-200, -100)
  w.y = rand(40, 440)

  if rand(1, 10) >= 8 then
    -- Image
    local images = { "ubuntu", "gentoo", "kubuntu" }
    local s = images[rand(1, #images)]
    w.bitmap = Bitmap.load("/boot/grub/themes/icons/"..s..".png")
    w.draw = function (self)
               video.draw_bitmap(self.bitmap, self.x, self.y)
             end
  else
    -- Text
    w.text = strings[rand(1, #strings)]
    w.color = colors[rand(1, #colors)]
    w.point_size = point_sizes[rand(1, #point_sizes)]
    w.draw = function (self)
               video.draw_string(self.text,
                                 font_family .. " " .. self.point_size,
                                 self.color, self.x, self.y)
             end
  end

  return w
end

-- The theme class
Theme = {}
Theme.__index = Theme
function Theme:new (o)
  -- Create the instance.
  o = o or {}
  setmetatable (o, self)

  -- Initialize it.
  self.words={}
  while table.getn(self.words) < num_words do
    table.insert(self.words, new_random_word())
  end

  return o
end

-- This function is called during the painting of the desktop.
-- It can draw things that will be overlaid on the desktop background,
-- behind the menu itself.
function Theme:draw_desktop()
  -- Draw the words.
  for _, w in ipairs(self.words) do
    w:draw()
  end

  -- Update the word positions and
  -- refresh words when they reach the edge.
  for i,w in ipairs(self.words) do
    w.x = w.x + w.speed
    if w.x >= 640 then
      self.words[i] = new_random_word()
    end
  end
end

-- Create a global instance of the Theme class.
theme = Theme:new()



---- LUA COMPONENT TEST ----

Test1 = {}
Test1.__index = Test1
function Test1:new (o)
  -- Create the instance.
  o = o or {}
  setmetatable (o, self)
  return o
end

function Test1:paint()
   video.draw_string("HELLO!!", "aqui 11", color(255,255,0), 5, 5)
end

function Test1:destroy()
end

componentFactory = {
  test1 = function() return Test1:new(); end
}

