/*
 *  grotto - a roguelike RPG
 *  Copyright (C) 2006 Tobias Heinzen
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
 
#include "headers/monster.hpp"

char *MONSTER::skill_out( struct SKILL skill )
{
	char *buffer = new char[255]; char bar[BAR_WIDTH]; this->create_bar( skill,bar );
	sprintf( buffer,"        [%s] %d%%",bar,(int)((skill.level*100)/skill.learned) );
	return buffer;
}

void MONSTER::evolve( int evolution,int dungeon_level )
{
	this->hp.learned = (evolution/100000)*3 + (evolution%100000)*1 - 15;
	this->hp.level = this->hp.learned;
	this->max_dmg = (10 + ((evolution/100000)-5)*7 + ((evolution%100000)-5)*2)/4 + (dungeon_level/3);
}

int MONSTER::dmg()
{
	return RANDOM( (int)(max_dmg/2),max_dmg );	
}

char *MONSTER::hp_out()
{
	return this->skill_out( this->hp );	
}

char *MONSTER::mp_out()
{
	return this->skill_out( this->mp );
}
