/*
 *  grotto - a roguelike RPG
 *  Copyright (C) 2006 Tobias Heinzen
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
 
#include "headers/menu.hpp"

void MENU::print_menu()
{
	LIST<char *> *temp = &(this->entries); int i=0,start = this->selection - 1,end = start + MEWINDOW_HEIGHT - 2;
	if( end > this->count )
	{
		start = this->count - (MEWINDOW_HEIGHT-2);
		end   = this->count;	
	}
	if( start < 0 || start > this->count )
		start = 0;
	while( 1 )
	{
		if( temp->next == NULL ) break;
		temp = temp->next;
		if( i+1 == this->selection && i >= start && i < end )
		{
			wattron( this->win,A_BOLD );
			mvwprintw( this->win,1+i-start,1,"> %s",temp->item );
		}
		else if( i >= start && i < end )
			mvwprintw( this->win,1+i-start,1,"  %s",temp->item );
		wattroff( this->win,A_BOLD ); ++i;				
	}
}

void MENU::add_entry( char *text )
{
	LIST<char *> *temp = &(this->entries);
	while( 1 )
	{
		if( temp->next == NULL ) break;
		temp = temp->next;
	}
	temp->next = new LIST<char *>;
	temp->next->item = text;
	this->count++;
}

void MENU::clear()
{
	this->count = 0; this->entries.next = 0;	
}

void MENU::show()
{
	BOX box; this->win = box.create( MEWINDOW_WIDTH,MEWINDOW_HEIGHT,0,0 ); keypad( this->win,TRUE ); 
	this->selection = 1; nodelay( this->win,1 );
	
	while( 1 )
	{
		int c = wgetch( this->win );
		if( c == KEY_UP )
		{
			this->selection--;
			if( this->selection < 1 )
				this->selection = this->count;	
		}
		if( c == KEY_DOWN )
		{
			this->selection++;	
			if( this->selection > this->count )
				this->selection = 1;
		}
		if( c == 10 )
			break;
		if( c != ERR ) wclear( this->win );
		
		this->print_menu();
		box.display();
	}
}
