/*
 *  grotto - a roguelike RPG
 *  Copyright (C) 2006 Tobias Heinzen
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
 
#ifndef MENU_HPP
#define MENU_HPP

#include <ncurses.h>
#include "list.hpp"
#include "box.hpp"

#define MEWINDOW_WIDTH	20
#define MEWINDOW_HEIGHT	10

class MENU
{
	private:
		LIST<char *> entries;
		int count;
		WINDOW *win;
		void print_menu();
		
	public:
		int selection;
		void clear();
		void add_entry( char *text );
		void show();
};

#endif
