/*
 *  grotto - a roguelike RPG
 *  Copyright (C) 2006 Tobias Heinzen
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef MAP_HPP
#define MAP_HPP

#include <ncurses.h>
#include <stdlib.h>
#include <string.h>
#include "tiles.h"
#include "tuple.h"

#define MAP_WIDTH	80
#define MAP_HEIGHT	24
#define MAP(x,y) 	this->field[ x+y*MAP_WIDTH ]

#define RANDOM(a,b)	a + (int)((float)(b-a) * rand() / (RAND_MAX + 1.0))//a+rand()%(b-a)

class MAP
{
	private:
		char field[ MAP_WIDTH*MAP_HEIGHT ];
		struct TUPLE player;
		bool accessable( int x,int y,char map[] );
		
	public:
		struct TUPLE put_object( char object ); 
		char get_tile( int position );
		struct TUPLE get_player();
		struct TUPLE set_player( int x,int y );
		void generate();	
		void draw();
};

#endif
