/*
 *  grotto - a roguelike RPG
 *  Copyright (C) 2006 Tobias Heinzen
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
 
#ifndef INVENTORY_HPP
#define INVENTORY_HPP

#include <ncurses.h>
#include "tuple.h"
#include "box.hpp"

#define IWINDOW_WIDTH	50
#define IWINDOW_HEIGHT	7

class INVENTORY
{
	private:
	public:
		int potions;
		int aethers;
		int gold;

		void init();
		void show();
		void potion_update( int modifier );
		void aether_update( int modifier );
		void gold_update( int modifier );
		bool has_aether(); bool has_potion();
};

#endif
