/*
 *  grotto - a roguelike RPG
 *  Copyright (C) 2006 Tobias Heinzen
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
 
#define GAME_MESSAGES
#include "headers/lang.h"
#include "headers/game.hpp"

void GAME::map_init()
{
	this->map.generate();
	this->map.put_object( TILE_STAIRWAY );
	if( (this->hero.dungeon_level)%SELL_LEVEL == 0 && this-hero.dungeon_level != 0 )
	{
		this->map.put_object( TILE_SELLER  );
		this->map.put_object( TILE_TRAINER );
		this->map.put_object( TILE_WIZARD  );
	}
	else
	{
		for( int i=0;i<RANDOM( 1,3 )-1;i++ )
			this->map.put_object( TILE_POTION );
		for( int i=0;i<RANDOM( 1,3 )-1;i++ )
			this->map.put_object( TILE_AETHER );
	}
}

void GAME::mainloop()
{	
	this->hero.init();
	this->map_init();
	while( 1 )
	{		
		int c = getch();
		int dir = 0; struct TUPLE player = map.get_player();
		if( c == 'q' ) break;	
		if( c == KEY_UP ) 	 dir = -MAP_WIDTH;
		if( c == KEY_DOWN )	 dir = +MAP_WIDTH;
		if( c == KEY_LEFT )	 dir = -1;
		if( c == KEY_RIGHT ) dir = +1;
		if( c == 'c' ) this->hero.show();
		if( c == 'i' ) this->hero.inventory.show();
		if( c == 'm' && this->hero.inventory.has_aether() ) 
		{
			MESSAGEBOX box; box.create( msg_use_aether,countof( msg_use_aether ) ); box.show();
			this->hero.fill_mp(); this->hero.inventory.aether_update( -1 );
		}
		if( c == 'p' && this->hero.inventory.has_potion() )
		{
			MESSAGEBOX box; box.create( msg_use_potion,countof( msg_use_potion ) ); box.show();
			this->hero.fill_hp(); this->hero.inventory.potion_update( -1 );			
		}
		
		if( dir != 0 )
		{
			this->hero.update_life( 1 ); this->hero.update_mana( 1 );	
		}
		
				
		if( dir != 0 && RANDOM( 0,25 )+1 == 25 && this->hero.dungeon_level%SELL_LEVEL != 0 )
		{
			FIGHT fight; fight.init( &this->hero ); fight.loop();
		}
		
		if( this->map.get_tile( player.x+player.y*MAP_WIDTH+dir ) == TILE_STAIRWAY )
		{
			this->hero.dungeon_level++; this->map_init();
			player = this->map.get_player();
		}
		
		if( this->map.get_tile( player.x+player.y*MAP_WIDTH+dir ) == TILE_POTION )
		{
			this->hero.inventory.potion_update( 1 );
			MESSAGEBOX box; box.create( msg_potion,countof( msg_potion ) ); box.show();
		}

		if( this->map.get_tile( player.x+player.y*MAP_WIDTH+dir ) == TILE_AETHER )
		{
			this->hero.inventory.aether_update( 1 );
			MESSAGEBOX box; box.create( msg_aether,countof( msg_aether ) ); box.show();
		}
		
		if( this->map.get_tile( player.x+player.y*MAP_WIDTH+dir ) == TILE_SELLER )
		{
			SELLER seller; seller.init( &(this->hero) ); seller.loop();	
		}
		
		if( this->map.get_tile( player.x+player.y*MAP_WIDTH+dir ) == TILE_TRAINER )
		{
			TRAINER trainer; trainer.init( &(this->hero) ); trainer.loop();
		}

		if( this->map.get_tile( player.x+player.y*MAP_WIDTH+dir ) == TILE_WIZARD )
		{
			WIZARD wizard; wizard.show( &this->hero );
		}
						
		if( 
			this->map.get_tile( player.x+player.y*MAP_WIDTH+dir ) != TILE_WALL &&
			this->map.get_tile( player.x+player.y*MAP_WIDTH+dir ) != TILE_SELLER &&
			this->map.get_tile( player.x+player.y*MAP_WIDTH+dir ) != TILE_TRAINER &&
			this->map.get_tile( player.x+player.y*MAP_WIDTH+dir ) != TILE_WIZARD
		  )
			player = this->map.set_player( player.x+dir%MAP_WIDTH,player.y+dir/MAP_WIDTH );
		
		if( this->hero.is_dead() ) break;
			
		this->map.draw();
		mvprintw( 0,1,"dungeon level:\t%d",this->hero.dungeon_level );
		refresh();
	}	
}
