/*
 *  grotto - a roguelike RPG
 *  Copyright (C) 2006 Tobias Heinzen
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
 
#define FIGHT_MENUES
#define FIGHT_MESSAGES
#include "headers/lang.h"
#include "headers/fight.hpp"

void FIGHT::loop()
{
	clear(); refresh(); MENU menu; 
	
	// creating the monster
	monster.init(); monster.evolve( this->player->powerindex(),this->player->dungeon_level );
	
	while( 1 )
	{	
		//status of the player	
		BOX box_status; WINDOW *win_status = box_status.create( 50,4,20,0 );
		mvwprintw( win_status,1,2,"HP: %s",this->player->hp_out() );
		mvwprintw( win_status,2,2,"MP: %s",this->player->mp_out() );
		box_status.display();
		
		//status of the monster
		BOX box_monster; WINDOW *win_monster = box_monster.create( 50,3,30,21 );
		mvwprintw( win_monster,1,2,"%s",this->monster.hp_out() );	
		box_monster.display();

		// display mana costs in menu
		char magic[255]; sprintf( magic,"Magic! (%d MP)",this->player->mana_cost( ATTACK ) );
		char heal[255]; sprintf( heal,"Heal! (%d MP)",this->player->mana_cost( HEAL ) );
		menu_fight[MENU_FIGHT_MAGIC-1] = magic; menu_fight[MENU_FIGHT_HEAL-1] = heal;

		// preparing menu
		menu.clear();
		for( int i=0;i<(int)countof( menu_fight );++i )
			menu.add_entry( menu_fight[i] );
		
		char msg[80]; char foe[80];
		char *messages[3] = { "","","" }; int dmg;
		
		// user does his thing 
		while( 1 )
		{
			// display menu and wait
			menu.show();
			// choose action
			if( menu.selection == MENU_FIGHT_ATTACK )
			{
				dmg = this->player->physical_dmg(); this->monster.update_life( -dmg );		
				this->player->learn_skill( SKILL_ATTACK ); this->player->learn_skill( SKILL_STRENGTH );
				sprintf( msg,"You hit the enemy for %d",dmg ); messages[0] = msg;
				break;
			}
			if( menu.selection == MENU_FIGHT_MAGIC && this->player->has_enough_mana( ATTACK ) )
			{
				dmg = this->player->magical_dmg(); this->monster.update_life( -dmg );
				this->player->update_mana( -this->player->mana_cost( ATTACK ) );
				this->player->learn_skill( SKILL_MAGIC_OFF ); this->player->learn_skill( SKILL_INTELLIGENCE );
				sprintf( msg,"You're magic hits the enemy for %d",dmg ); messages[0] = msg;
				break;
			}
			else if( menu.selection == MENU_FIGHT_MAGIC )
			{
				MESSAGEBOX box; box.create( msg_mana,countof( msg_mana ) ); box.show();
				clear(); refresh(); box_status.display(); box_monster.display();
			}
			if( menu.selection == MENU_FIGHT_HEAL && this->player->has_enough_mana( HEAL ) )
			{
				dmg = this->player->healing(); this->player->update_life( dmg );
				this->player->update_mana( -this->player->mana_cost( HEAL ) );
				this->player->learn_skill( SKILL_MAGIC_DEF ); this->player->learn_skill( SKILL_INTELLIGENCE );
				sprintf( msg,"You heal yourself for %d",dmg ); messages[0] = msg;
				break;
			}
			else if( menu.selection == MENU_FIGHT_HEAL )
			{
				MESSAGEBOX box; box.create( msg_mana,countof( msg_mana ) ); box.show();
				clear(); refresh(); box_status.display(); box_monster.display();				
			}
		}
		
		// and now for the monster *harhar*
		if( !this->monster.is_dead() )
		{
			dmg = this->monster.dmg(); this->player->update_life( -dmg );
			sprintf( foe,"The enemy hits you for %d",dmg ); messages[1] = foe;
		}
		else
		{
			int gold = RANDOM( 1,this->player->dungeon_level );
			sprintf( foe,"You found %d gold",gold ); messages[2] = foe;
			messages[1] = "You defeated the enemy";	this->player->inventory.gold_update( gold );	
		}
		
		if( this->player->is_dead() )
			messages[2] = "You have been defeated!";
		
		MESSAGEBOX box; box.create( messages,countof( messages ) ); box.show();
		clear(); refresh();
		
		if( this->monster.is_dead() ) break;
		if( this->player->is_dead() ) break;	
	}
}

void FIGHT::init( CHARACTER *character )
{
	this->player = character;	
}
