/*
 *  grotto - a roguelike RPG
 *  Copyright (C) 2006 Tobias Heinzen
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "headers/box.hpp"

WINDOW *BOX::create( int width,int height,int x,int y )
{
	this->handler = newwin( height,width,y,x );
	keypad( this->handler,TRUE );	
	return this->handler;
}

void BOX::show()
{
	nodelay( this->handler,1 );
	while( 1 )
	{
		int c = wgetch( this->handler );
		if( c == ' ' ) break;
		this->display();
	}	
}

void BOX::display()
{
	wborder( this->handler,'|','|','-','-','+','+','+','+' );
	wrefresh( this->handler );	
}
