/* images.c
 * Copyright (C) 2005 Sylvain Cresto <sylvain.cresto@tiscali.fr>
 *
 * This file is part of graveman!
 *
 * graveman! is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or
 * (at your option) any later version.
 * 
 * graveman! is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA. 
 * 
 * URL: http://www.nongnu.org/graveman/
 *
 */


#include "graveman.h"

GdkPixbuf *GDirIcone, *GFileIcone, *GCDIcone, *GAudioIcone, *GCDRWIcone, *GCDpetiteIcone,
  *GCDRWpetiteIcone, *GpetiteGraver, *GGraver, *GISOpetiteIcone, *GEraseCdrw, *GFileImage,
  *GDVDpetiteIcone, *GDVDRWpetiteIcone;


void load_all_images()
{
  GDirIcone = create_pixbuf("folder5-petit.png");
  GFileIcone = create_pixbuf("stock_new.png");
  GFileImage = create_pixbuf("file_image.png");
  GCDIcone = create_pixbuf("gnome-dev-cdrom.png");
  GAudioIcone = create_pixbuf("gnome-dev-cdrom-audio-24.png");
  GCDRWIcone = create_pixbuf("i-cdrom.png");
  GCDRWpetiteIcone = create_pixbuf("petitcdrw.png");
  GDVDRWpetiteIcone = create_pixbuf("petitdvdrw.png");
  GCDpetiteIcone = create_pixbuf("petitcd.png");
  GDVDpetiteIcone = create_pixbuf("petitdvd.png");
  GISOpetiteIcone = create_pixbuf("petitiso.png");
  GpetiteGraver = create_pixbuf("graver-petite.png");
  GGraver = create_pixbuf("graver.png");
  GEraseCdrw = create_pixbuf("erase-cdrw.png");
}

void free_all_images()
{
  g_object_unref(GEraseCdrw);
  g_object_unref(GGraver);
  g_object_unref(GISOpetiteIcone);
  g_object_unref(GpetiteGraver);
  g_object_unref(GDVDRWpetiteIcone);
  g_object_unref(GCDRWpetiteIcone);
  g_object_unref(GDVDpetiteIcone);
  g_object_unref(GCDpetiteIcone);
  g_object_unref(GCDRWIcone);
  g_object_unref(GAudioIcone);
  g_object_unref(GCDIcone);
  g_object_unref(GFileImage);
  g_object_unref(GFileIcone);
  g_object_unref(GDirIcone);

}

/*
 * vim:et:ts=8:sts=2:sw=2
 */
