/* callbacks.c
 * Copyright (C) 2004, 2005 Sylvain Cresto <sylvain.cresto@tiscali.fr>
 *
 * This file is part of graveman!
 *
 * graveman! is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or
 * (at your option) any later version.
 *
 * graveman! is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 * URL: http://www.nongnu.org/graveman/
 *
 */

#include "graveman.h"

static gchar *_precdirectory = NULL;  /* dernier emplacement utilis dans une boite
                                         dialogue gtk_file_chooser */

/* affichage boite de dialogue au sujet de ... */
void on_about (GtkMenuItem *Amenuitem, gpointer Adata)
{
  about_graveman();
}


gboolean on_closeabout (GtkWidget *Awidget, GdkEventButton *Aevent, gpointer Adata)
{
  return FALSE;
}

void on_togglecopiecd_clicked (GtkButton *Abutton, gpointer Adata)
{
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(Abutton), TRUE); 
}


void on_togglecdaudio_clicked (GtkButton *Abutton, gpointer Adata)
{
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(Abutton), TRUE); 
}


void on_togglecddata_clicked (GtkButton *Abutton, gpointer Adata)
{
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(Abutton), TRUE);
}

/* callback appele pour l'ajout d'une piste audio */
void _add_a_piste(gchar *Anom, GtkListStore *Aliststore, GHashTable *Ahash)
{
  guint32 *Laudiolen = (guint32 *)g_hash_table_lookup(Ahash, "audiolen");
  GtkTreeIter Liter;
  gchar *LTitle = NULL, *LAlbum = NULL, *LArtist = NULL;
  guint32 Llennbr = 0;
  gchar *Lnameutf8 = NULL, *Llengthutf8 = NULL;
  gchar *Lname;

  /* on reconnai le type fichier grace a son extension */

#ifdef ENABLE_MP3
  if (sc_str_has_casesuffix(Anom, MP3)) {
    getMp3Info(Anom, &LTitle, &LAlbum, &LArtist, &Llennbr, NULL);
  } else
#endif    
#ifdef ENABLE_OGG
  if (sc_str_has_casesuffix(Anom, OGG)) {
    getOggInfo(Anom, &LTitle, &LAlbum, &LArtist, &Llennbr, NULL);
  } else
#endif
  if (sc_str_has_casesuffix(Anom, WAV)) {
    getWavInfo(Anom, &Llennbr, NULL);
  }

  if ((!LTitle && !LAlbum && !LArtist) ||
      (LTitle && LAlbum && LArtist && !*LTitle && !*LAlbum && !*LArtist)) {
    gchar *slash = strrchr(Anom, '/');
    Lname = g_strdup(slash ? ++slash : Anom);
    Lnameutf8 = _UTF8(Lname);
  } else {
    Lname = NULL;
    Lnameutf8 = g_strdup_printf("%s - %s - %s", LArtist, LAlbum, LTitle);
  }  
  *(Laudiolen)=*(Laudiolen) + Llennbr;
  gtk_list_store_append(Aliststore, &Liter);
  Llengthutf8 = format_length(Llennbr);
  gtk_list_store_set(Aliststore, &Liter, 0, TYPE_MP3, 1, GAudioIcone, 2, Lnameutf8, 3,
                      Llengthutf8, 4, Anom, 5, Llennbr, -1);
  g_free(Llengthutf8);
  g_free(Lnameutf8);
  g_free(Lname);

  g_free(LArtist);
  g_free(LAlbum); g_free(LTitle);
}

/* callback appele pour l'ajout de chaques fichiers */
void _add_a_file(gchar *Anom, GtkTreeStore *ATreeStore, GtkTreeIter *Aparent, GHashTable *Ahash)
{
  guint32 *Ldatasize = (guint32 *)g_hash_table_lookup(Ahash, "datasize");
  GtkTreeIter Liter;
  gchar *LOnlyName;
  struct stat Lfi;
  DIR *Ldir;
  struct dirent *Lcurfic;
  gchar *Lfullname;
/*  gchar *Lonlynameutf8, *Lnomutf8, */
  gchar *Lformatsizeutf8;

  if ((LOnlyName=strrchr(Anom, '/'))) {
    LOnlyName++;
  } else {
    LOnlyName = Anom;
  }

  if (stat(Anom, &Lfi) == -1) {
    _WARN("erreur lecture fichier '%s'", Anom);
    return;
  }

  gtk_tree_store_append(ATreeStore, &Liter, Aparent); 

  if (S_ISDIR(Lfi.st_mode)) {
    /* si c'est un repertoire alors on lis tout son contenu et on ajoute
     * les fichiers qu'il contient */

/*    Lonlynameutf8 = _UTF8(LOnlyName);
    Lnomutf8 = _UTF8(Anom);*/
    gtk_tree_store_set(ATreeStore, &Liter, 0, TYPE_DIR, 1, GDirIcone, 2, LOnlyName, 3, "", 4, Anom, 5, 0, -1);
/*    g_free(Lnomutf8);
    g_free(Lonlynameutf8);*/

    Ldir = opendir(Anom);
    if (!Ldir) {
      _WARN("erreur ouverture repertoire '%s'", Anom);
      return;
    }

    while ((Lcurfic = readdir(Ldir))) {
      if (!strcmp(Lcurfic->d_name, ".") || !strcmp(Lcurfic->d_name, "..")) continue;
        
      Lfullname = g_strdup_printf("%s/%s", Anom, Lcurfic->d_name);
      _add_a_file(Lfullname, ATreeStore, &Liter, Ahash);
      g_free(Lfullname);
    }
    closedir(Ldir);
    
  } else {
/*    Lonlynameutf8 = _UTF8(LOnlyName);
    Lnomutf8 = _UTF8(Anom);*/
    Lformatsizeutf8 = format_size(Lfi.st_size);
    gtk_tree_store_set(ATreeStore, &Liter, 0, TYPE_FILE, 1, GFileIcone, 2, LOnlyName,
                                           3, Lformatsizeutf8, 4, Anom, 5, Lfi.st_size, -1);
    g_free(Lformatsizeutf8);
/*    g_free(Lnomutf8);
    g_free(Lonlynameutf8);*/

    *(Ldatasize)=*(Ldatasize) + Lfi.st_size;
  }
}

/* creer un repertoire */
void gtk_data_creerrepertoire(GtkWidget *btn, gpointer Adata)
{
  GHashTable *Lhash = (GHashTable *)Adata;
  GtkTreeView *Lliste = GTK_TREE_VIEW(g_hash_table_lookup(Lhash, "LISTEDATA"));
  GtkTreeModel *Ltreemodel = gtk_tree_view_get_model(Lliste);
  GtkTreeIter Liter, Lparent;
  GtkWidget *Lboite, *Lentry;
  GtkTreePath *Lpath = NULL;
  const gchar *Lname;

  /* on recupere l'element selectionne */
  gtk_tree_view_get_cursor(Lliste, &Lpath, NULL);
  if (!Lpath) return;
  gtk_tree_model_get_iter(Ltreemodel, &Lparent, Lpath);
  gtk_tree_path_free(Lpath);

  Lboite= gtk_dialog_new_with_buttons(_("Enter the new directory name"), NULL, GTK_DIALOG_MODAL,
                  GTK_STOCK_OK,GTK_RESPONSE_OK, GTK_STOCK_CANCEL,GTK_RESPONSE_CANCEL, NULL);
  
  Lentry = gtk_entry_new();

  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(Lboite)->vbox), Lentry, TRUE, FALSE, 0);
  gtk_widget_show_all(GTK_DIALOG(Lboite)->vbox);

  if (gtk_dialog_run(GTK_DIALOG(Lboite)) == GTK_RESPONSE_OK) {
    /* creation d'un repertoire */
    Lname = gtk_entry_get_text(GTK_ENTRY(Lentry));
    if (!Lname || !*Lname) return;

    gtk_tree_store_prepend(GTK_TREE_STORE(Ltreemodel), &Liter, &Lparent); 
    gtk_tree_store_set(GTK_TREE_STORE(Ltreemodel), &Liter, 0, TYPE_DIR, 1, GDirIcone, 2, Lname, 3, "", 4, "", 5, 0, -1);

    /* on developpe pour qu'il soit visible */
    if ((Lpath = gtk_tree_model_get_path(Ltreemodel, &Liter))) {
      gtk_tree_view_expand_to_path(Lliste, Lpath);
      gtk_tree_path_free(Lpath);
    }
  }
  gtk_widget_destroy(Lboite); 
}

/* developper tout le contenu de l'arbre */
void gtk_data_expandelement(GtkWidget *btn, gpointer Adata)
{
  GHashTable *Lhash = (GHashTable *)Adata;
  GtkTreeView *Lliste = GTK_TREE_VIEW(g_hash_table_lookup(Lhash, "LISTEDATA"));
  GtkTreePath *Lpath = NULL;

  gtk_tree_view_get_cursor(Lliste, &Lpath, NULL);
  if (!Lpath) return;

  gtk_tree_view_expand_row(Lliste, Lpath, TRUE);
  gtk_tree_path_free(Lpath);
}

/* renommer un element (fichier ou repertoire) */
void gtk_data_renommerelement(GtkWidget *Abtn, gpointer Adata)
{
  GHashTable *Lhash = (GHashTable *)Adata;
  GtkTreeView *Lliste = GTK_TREE_VIEW(g_hash_table_lookup(Lhash, "LISTEDATA"));
  GtkWidget *Lboite, *Lentry;
  GtkTreeModel *Ltreemodel = gtk_tree_view_get_model(Lliste);
  GtkTreePath *Lpath = NULL;
  gchar *Ltitle;
  gchar *Lname;
  const gchar *Lselname;
  GtkTreeIter Liter;

  /* on recupere le nom de l'element selectionne */
  gtk_tree_view_get_cursor(Lliste, &Lpath, NULL);
  if (!Lpath) return;
  gtk_tree_model_get_iter(Ltreemodel, &Liter, Lpath);
  gtk_tree_path_free(Lpath);

  gtk_tree_model_get(Ltreemodel, &Liter, 2, &Lname, -1);

  Ltitle = g_strdup_printf(Ltitle, _("Enter the new name for %s"), Lname);
 
  Lboite = gtk_dialog_new_with_buttons(Ltitle, NULL, GTK_DIALOG_MODAL,
        GTK_STOCK_OK,GTK_RESPONSE_OK, GTK_STOCK_CANCEL,GTK_RESPONSE_CANCEL, NULL);
  g_free(Ltitle);

  Lentry = gtk_entry_new();
  gtk_entry_set_text(GTK_ENTRY(Lentry), Lname);
  g_free(Lname);

  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(Lboite)->vbox), Lentry, TRUE, FALSE, 0);
  gtk_widget_show_all(GTK_DIALOG(Lboite)->vbox);

  if (gtk_dialog_run(GTK_DIALOG(Lboite)) == GTK_RESPONSE_OK) {
    Lselname = gtk_entry_get_text(GTK_ENTRY(Lentry));
    if (Lselname && *Lselname) {

      /* on definie le nouveau nom dans la liste */
      gtk_tree_store_set(GTK_TREE_STORE(Ltreemodel), &Liter, 2, Lselname, -1);
    }
  }

  gtk_widget_destroy(Lboite); 
}

/* retourne l'element selectionne ou bien le premier si aucun n'est
 * selectionne */
void get_parent_iter(GtkTreeView *Aliste, GtkTreeIter *Aiter, gint *Anb, gboolean *Aisroot)
{
  GtkTreeModel *LTreeData = gtk_tree_view_get_model(GTK_TREE_VIEW(Aliste));
  GtkTreeSelection *Lselection = gtk_tree_view_get_selection(GTK_TREE_VIEW(Aliste));
  GList *Lfiles = NULL;

  *(Aisroot) = 0;
  *(Anb) = 0;
  gtk_tree_model_get_iter_from_string(LTreeData, Aiter, "0");

  if (Lselection) {
    if (!gtk_tree_selection_iter_is_selected(Lselection, Aiter)) {
      *(Anb) = gtk_tree_selection_count_selected_rows(Lselection);
      Lfiles = gtk_tree_selection_get_selected_rows(Lselection, &LTreeData);
    } else {
      *(Aisroot)=1;
    }
  }

  if (Lfiles) {
    gtk_tree_model_get_iter(LTreeData, Aiter, (GtkTreePath*)(Lfiles->data));
    g_list_free(Lfiles);
  }
}

/* enlever des pistes a graver */
void gtk_audio_removetrack(GtkWidget *Abtn, gpointer Adata)
{
  GHashTable *Lhash = (GHashTable *)Adata;
  GtkTreeView *Lliste = GTK_TREE_VIEW(g_hash_table_lookup(Lhash, "LISTEAUDIO"));
  GtkTreeSelection *Lselection = gtk_tree_view_get_selection(GTK_TREE_VIEW(Lliste));
  GtkProgressBar *Lcontenance = GTK_PROGRESS_BAR(g_hash_table_lookup(Lhash, "audiolenbar"));
  guint32 *Laudiolen = (guint32 *)g_hash_table_lookup(Lhash, "audiolen");
  guint32 *Laudiomaxlen = (guint32 *)g_hash_table_lookup(Lhash, "audiomaxlen");
  GtkTreeIter Liter;
  GtkTreeModel *Ltreemodel = gtk_tree_view_get_model(Lliste);
  guint32 Llennbr = 0;
  GList *Ltracks = gtk_tree_selection_get_selected_rows(Lselection, &Ltreemodel);
  GList *Lrefs = NULL, *Lnode = NULL;
  gpointer Lproxy = g_object_newv(G_TYPE_OBJECT, 0, NULL);

  for (Lnode = Ltracks; Lnode; Lnode = Lnode->next) {
    Lrefs = g_list_append(Lrefs, gtk_tree_row_reference_new_proxy(Lproxy, Ltreemodel, Lnode->data));
    gtk_tree_path_free(Lnode->data);
  }
  g_list_free(Ltracks);

  for (Lnode = Lrefs; Lnode; Lnode = Lnode->next) {
    GtkTreePath *Lpath = gtk_tree_row_reference_get_path(Lnode->data);
    gtk_tree_model_get_iter(Ltreemodel, &Liter, Lpath);
 
    gtk_tree_model_get(Ltreemodel, &Liter, 5, &Llennbr, -1);
    gtk_list_store_remove(GTK_LIST_STORE(Ltreemodel), &Liter);

    *Laudiolen-=Llennbr;
    g_assert((*Laudiolen) >= 0);

    gtk_tree_row_reference_deleted(Lproxy, Lpath);
    gtk_tree_path_free(Lpath);
    gtk_tree_row_reference_free(Lnode->data);
  }
 
  g_list_free(Lrefs);
  g_object_unref(Lproxy);

  switch_pbar_status(Lcontenance, *Laudiomaxlen, *Laudiolen, PB_UPDATE_AUDIO);
}

/* parcourir tous les fils d'un element et recuperer leur taille que l'on enleve de "cursize" */
void remove_children_size(GtkTreeModel *Atreedata, GtkTreeIter *Aiter, guint32 *Acursize, GHashTable *Ahash);
void remove_children_size(GtkTreeModel *Atreedata, GtkTreeIter *Aiter, guint32 *Acursize, GHashTable *Ahash)
{
  GtkTreeIter Lcuriter;
  guint32 Lsizenbr = 0;
  int Ltype;

  if (gtk_tree_model_iter_children(Atreedata, &Lcuriter, Aiter)) {
    do {
      gtk_tree_model_get(Atreedata, &Lcuriter, 0, &Ltype, 5, &Lsizenbr, -1);
      *Acursize-=Lsizenbr;
#if 0
      if (Ltype == TYPE_IMAGEBOOT) {
        g_hash_table_replace(Lhash, "file_imageboot", gtk_tree_iter_copy(&Lnewiter));
      }
#endif

      remove_children_size(Atreedata, &Lcuriter, Acursize, Ahash);
    } while (gtk_tree_model_iter_next(Atreedata, &Lcuriter));
  }
}

/* enlever des fichiers a graver */
void gtk_data_removefiles(GtkWidget *Abtn, gpointer Adata)
{
  GHashTable *Lhash = (GHashTable *)Adata;
  GtkTreeView *Lliste = GTK_TREE_VIEW(g_hash_table_lookup(Lhash, "LISTEDATA"));
  GtkProgressBar *Lcontenance = GTK_PROGRESS_BAR(g_hash_table_lookup(Lhash, "datasizebar"));
  guint32 *Ldatasize = (guint32 *)g_hash_table_lookup(Lhash, "datasize");
  guint32 *Ldatamaxsize = (guint32 *)g_hash_table_lookup(Lhash, "datamaxsize");

  /* image de boot */
#if 0  
  GtkTreeIter *Literboot = g_hash_table_lookup(Lhash, "file_imageboot");
#endif
  /* c'est en fait bien plus simple que cela maintenant que l'on
   * ne peu selectionner qu'un seul fichier a la fois */
  GtkTreeModel *Ltreedata = gtk_tree_view_get_model(GTK_TREE_VIEW(Lliste));
  GtkTreeSelection *Lselection = gtk_tree_view_get_selection(GTK_TREE_VIEW(Lliste));
  GList *Lfiles = gtk_tree_selection_get_selected_rows(Lselection, &Ltreedata);
  GList *Lrefs = NULL;
  GList *Lnode = NULL;
  guint32 Lsizenbr = 0;
  GtkTreeIter Liter;
  gpointer Lproxy = g_object_newv(G_TYPE_OBJECT, 0, NULL);

  for (Lnode = Lfiles; Lnode; Lnode = Lnode->next) {
    Lrefs = g_list_append(Lrefs, gtk_tree_row_reference_new_proxy(Lproxy, Ltreedata, Lnode->data));
    gtk_tree_path_free(Lnode->data); /* Free unneeded tree path */
  }
  g_list_free(Lfiles); /* Emptied list */

  for (Lnode = Lrefs; Lnode; Lnode = Lnode->next) {
    GtkTreePath *Lpath = gtk_tree_row_reference_get_path(Lnode->data);

    if (Lpath) {
      gtk_tree_model_get_iter(Ltreedata, &Liter, Lpath);

      gtk_tree_model_get(Ltreedata, &Liter, 5, &Lsizenbr, -1);

      *Ldatasize-=Lsizenbr;
      g_assert((*Ldatasize) >= 0);

    /* suppresion icone "image cd de boot" */
#if 0
    if (Literboot && !memcmp(&Liter, Literboot, sizeof(Liter))) {
//printf("oui on efface Literboot!");      
      gtk_tree_iter_free(Literboot);
      g_hash_table_steal(Lhash, "file_imageboot");
    }
#endif
    /* on enleve la taille des eventuels enfants */
      remove_children_size(Ltreedata, &Liter, Ldatasize, Lhash);

      gtk_tree_store_remove(GTK_TREE_STORE(Ltreedata), &Liter);
      gtk_tree_row_reference_deleted(Lproxy, Lpath);
      gtk_tree_path_free(Lpath);
    }
    gtk_tree_row_reference_free(Lnode->data); /* No longer needed */
  }
  g_list_free(Lrefs);

  g_object_unref(Lproxy);

  switch_pbar_status(Lcontenance, *Ldatamaxsize, *Ldatasize, PB_UPDATE_DATA);

  /* on selectionne l'icone CD */
  if (gtk_tree_model_get_iter_first(Ltreedata, &Liter)) {
    gtk_tree_selection_select_iter(Lselection, &Liter);
    gtk_widget_grab_focus(GTK_WIDGET(Lliste));
  }
}

/* ajouter des pistes a graver */
void gtk_audio_addtrack(GtkWidget *Abtn, gpointer Adata)
{
  GHashTable *Lhash = (GHashTable *)Adata;
  GtkTreeView *Lliste = GTK_TREE_VIEW(g_hash_table_lookup(Lhash, "LISTEAUDIO"));
  guint32 *Laudiolen = (guint32 *)g_hash_table_lookup(Lhash, "audiolen");
  guint32 *Laudiomaxlen = (guint32 *)g_hash_table_lookup(Lhash, "audiomaxlen");
  GtkProgressBar *Lcontenance = GTK_PROGRESS_BAR(g_hash_table_lookup(Lhash, "audiolenbar"));
  GtkTreeModel *Ltreemodel = gtk_tree_view_get_model(Lliste);
  GtkWidget *Lpistesel = create_addpisteselection(NULL);
  GSList *Lfiles, *Lcur;

  if (_precdirectory) gtk_file_chooser_set_current_folder_uri(GTK_FILE_CHOOSER(Lpistesel), _precdirectory);
  if (gtk_dialog_run(GTK_DIALOG(Lpistesel))==GTK_RESPONSE_ACCEPT) {
    if (_precdirectory) g_free(_precdirectory);
    _precdirectory = gtk_file_chooser_get_current_folder_uri(GTK_FILE_CHOOSER(Lpistesel));

    Lfiles = gtk_file_chooser_get_filenames(GTK_FILE_CHOOSER(Lpistesel));

    for (Lcur = Lfiles; Lcur && Lcur->data; Lcur = Lcur->next) {
      _add_a_piste((gchar *) Lcur->data, GTK_LIST_STORE(Ltreemodel), Lhash);
    }

    g_slist_free(Lfiles);
  }

  gtk_widget_destroy(Lpistesel);

  switch_pbar_status(Lcontenance, *Laudiomaxlen, *Laudiolen, PB_UPDATE_AUDIO);
}

/* ajouter des repertoires a graver */
void gtk_data_adddirectory(GtkWidget *btn, gpointer Adata)
{
  GHashTable *Lhash = (GHashTable *)Adata;
  GtkTreeView *Lliste = GTK_TREE_VIEW(g_hash_table_lookup(Lhash, "LISTEDATA"));
  GtkTreeSelection *Lselection = gtk_tree_view_get_selection(GTK_TREE_VIEW(Lliste));
  GtkTreeModel *Ltreemodel = gtk_tree_view_get_model(GTK_TREE_VIEW(Lliste));
  GtkWidget *Lfilesel = create_adddirselection(NULL);
  GtkTreeIter Liter;
  GSList *Lfiles, *Lcur;
  GtkProgressBar *Lcontenance = GTK_PROGRESS_BAR(g_hash_table_lookup(Lhash, "datasizebar"));
  guint32 *Ldatasize = (guint32 *)g_hash_table_lookup(Lhash, "datasize");
  guint32 *Ldatamaxsize = (guint32 *)g_hash_table_lookup(Lhash, "datamaxsize");
  gint Lnumsel = gtk_tree_selection_count_selected_rows(Lselection);
  GtkTreePath *Lpath = NULL;

  /* focus sur le premier element si pas de focus */
  if (!Lnumsel) {
    if (!gtk_tree_model_get_iter_first(Ltreemodel, &Liter)) return;

    gtk_tree_selection_select_iter(Lselection, &Liter);
    gtk_widget_grab_focus(GTK_WIDGET(Lliste));
  } else {
    /* si plusieurs elements de selectionne alors on pointe sur celui etant
     * sous le curseur */
    gtk_tree_view_get_cursor(GTK_TREE_VIEW(Lliste), &Lpath, NULL);
    if (!Lpath) return;
    gtk_tree_model_get_iter(Ltreemodel, &Liter, Lpath);
    gtk_tree_path_free(Lpath);
  }

  if (_precdirectory) gtk_file_chooser_set_current_folder_uri(GTK_FILE_CHOOSER(Lfilesel), _precdirectory);
  if (gtk_dialog_run(GTK_DIALOG(Lfilesel))==GTK_RESPONSE_ACCEPT) {
    if (_precdirectory) g_free(_precdirectory);
    _precdirectory = gtk_file_chooser_get_current_folder_uri(GTK_FILE_CHOOSER(Lfilesel));

    Lfiles = gtk_file_chooser_get_filenames(GTK_FILE_CHOOSER(Lfilesel));
	
    for (Lcur = Lfiles; Lcur && Lcur->data; Lcur = Lcur->next) {
      _add_a_file((gchar *) Lcur->data, (GtkTreeStore *)Ltreemodel, &Liter, Lhash);

    }
    g_slist_free(Lfiles);

    if ((Lpath = gtk_tree_model_get_path(Ltreemodel, &Liter))) {
      gtk_tree_view_expand_row(Lliste, Lpath, TRUE);
      gtk_tree_path_free(Lpath);
    }
  }
  gtk_widget_destroy(Lfilesel);

  switch_pbar_status(Lcontenance, *Ldatamaxsize, *Ldatasize, PB_UPDATE_DATA);
}


/* ajouter des fichiers a graver */
void gtk_data_addfile(GtkWidget *btn, gpointer Adata)
{
  GHashTable *Lhash = (GHashTable *)Adata;
  GtkTreeView *Lliste = GTK_TREE_VIEW(g_hash_table_lookup(Lhash, "LISTEDATA"));
  GtkTreeSelection *Lselection = gtk_tree_view_get_selection(GTK_TREE_VIEW(Lliste));
  guint32 *Ldatasize = (guint32 *)g_hash_table_lookup(Lhash, "datasize");
  guint32 *Ldatamaxsize = (guint32 *)g_hash_table_lookup(Lhash, "datamaxsize");
  GtkProgressBar *Lcontenance = GTK_PROGRESS_BAR(g_hash_table_lookup(Lhash, "datasizebar"));
  GtkTreeModel *Ltreemodel = gtk_tree_view_get_model(GTK_TREE_VIEW(Lliste));
  GtkWidget *Lfilesel = create_addfileselection(NULL);
  GtkTreeIter Liter;
  GSList *Lfiles, *Lcur;
  gint Lnumsel = gtk_tree_selection_count_selected_rows(Lselection);
  GtkTreePath *Lpath = NULL;

  /* focus sur le premier element si pas de focus */
  if (!Lnumsel) {
    if (!gtk_tree_model_get_iter_first(Ltreemodel, &Liter)) return;

    gtk_tree_selection_select_iter(Lselection, &Liter);
    gtk_widget_grab_focus(GTK_WIDGET(Lliste));
  } else {
    /* si plusieurs elements de selectionne alors on pointe sur celui etant
     * sous le curseur */
    gtk_tree_view_get_cursor(GTK_TREE_VIEW(Lliste), &Lpath, NULL);
    if (!Lpath) return;
    gtk_tree_model_get_iter(Ltreemodel, &Liter, Lpath);
    gtk_tree_path_free(Lpath);
  }

  if (_precdirectory) gtk_file_chooser_set_current_folder_uri(GTK_FILE_CHOOSER(Lfilesel), _precdirectory);
  if (gtk_dialog_run(GTK_DIALOG(Lfilesel))==GTK_RESPONSE_ACCEPT) {
    if (_precdirectory) g_free(_precdirectory);
    _precdirectory = gtk_file_chooser_get_current_folder_uri(GTK_FILE_CHOOSER(Lfilesel));

    Lfiles = gtk_file_chooser_get_filenames(GTK_FILE_CHOOSER(Lfilesel));
	
    for (Lcur = Lfiles; Lcur && Lcur->data; Lcur = Lcur->next) {
      _add_a_file((gchar *) Lcur->data, GTK_TREE_STORE(Ltreemodel), &Liter, Lhash);

    }
    g_slist_free(Lfiles);

    if ((Lpath = gtk_tree_model_get_path(Ltreemodel, &Liter))) {
      gtk_tree_view_expand_row(Lliste, Lpath, TRUE);
      gtk_tree_path_free(Lpath);
    }
  }
  gtk_widget_destroy(Lfilesel);

  switch_pbar_status(Lcontenance, *Ldatamaxsize, *Ldatasize, PB_UPDATE_DATA);
}

/* l'utilisateur veut editer un device */
void gtk_devices_edit(GtkWidget *Abtn, gpointer Adata)
{
  GHashTable *Lhash = (GHashTable *) Adata;
  GtkWidget *Lparent = GTK_WIDGET(g_hash_table_lookup(Lhash, "window"));
  GtkTreeView *Lliste = GTK_TREE_VIEW(g_hash_table_lookup(Lhash, "periphdata"));
  GtkTreeSelection *Lselection = gtk_tree_view_get_selection(GTK_TREE_VIEW(Lliste));
  GtkTreeIter Liter;
  GtkTreeModel *Ltreemodel;

  if (gtk_tree_selection_get_selected(Lselection, &Ltreemodel, &Liter)) {
    GHashTable *Ldialoghash;
    GtkWidget *Lwineditdevice;
    Tdriveinfo *Ldrive;
    gint Lnum;
    gint Lbus;
    
    gtk_tree_model_get(Ltreemodel, &Liter, 0, &Lnum, -1);
    Ldrive = (Tdriveinfo *)g_slist_nth_data(Glistdrives, Lnum);
    Ldialoghash = create_dialog_edit_device(Lparent, Ldrive);
    Lwineditdevice = g_hash_table_lookup(Ldialoghash, "window");

    if (gtk_dialog_run(GTK_DIALOG(Lwineditdevice)) != GTK_RESPONSE_CANCEL) {
      GtkEntry *Ldevicename = g_hash_table_lookup(Ldialoghash, "devicename");

      Lbus = get_combo_intvalue(g_hash_table_lookup(Ldialoghash, "devicebus"));
      Ldrive->actuperiph = Lbus;

      /* on remplace le nom dans la liste des lecteurs */
      g_free(Ldrive->name);
      Ldrive->name = g_strdup(gtk_entry_get_text(Ldevicename));
      /* ainsi que dans la liste affiche */
      gtk_list_store_set(GTK_LIST_STORE(Ltreemodel), &Liter, 2, (gchar *)g_slist_nth_data(Ldrive->dev, Ldrive->actuperiph),
          4, Ldrive->name, -1);
    }
    gtk_widget_destroy(Lwineditdevice);
    g_hash_table_destroy(Ldialoghash);
  }

}

/* l'utilisateur a cliquer sur supprimer un device */
void gtk_devices_remove(GtkWidget *Abtn, gpointer Adata)
{
  GHashTable *Lhash = (GHashTable *)Adata;
  GtkWidget *Lwindow1 = GTK_WIDGET(g_hash_table_lookup(Lhash, "topwindow"));
  GtkWidget *Lconfirm;
  gint Lrep;
  
  /* confirmation debut de l'operation */ 
  Lconfirm = gtk_message_dialog_new(GTK_WINDOW(Lwindow1),
                      GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION,
                      GTK_BUTTONS_YES_NO,
                      _("Do you really want to remove this device ?"));
  Lrep = gtk_dialog_run(GTK_DIALOG(Lconfirm));
  gtk_widget_destroy(Lconfirm);

  if (Lrep == GTK_RESPONSE_YES) {
    /* oui on supprime un device */
    GtkTreeView *Lliste = GTK_TREE_VIEW(g_hash_table_lookup(Lhash, "periphdata"));
    GtkTreeSelection *Lselection = gtk_tree_view_get_selection(GTK_TREE_VIEW(Lliste));
    GtkTreeIter Liter;
    GtkTreeModel *Ltreemodel;
    gint Lnum;

    if (gtk_tree_selection_get_selected(Lselection, &Ltreemodel, &Liter)) {
      gtk_tree_model_get(Ltreemodel, &Liter, 0, &Lnum, -1);

      _DEB("ON SUPIMME LE LEC = %d\n", Lnum);
      Glistdrives = g_slist_remove(Glistdrives, g_slist_nth_data(Glistdrives, Lnum));
      gtk_list_store_remove(GTK_LIST_STORE(Ltreemodel), &Liter);
    } 
  }

}

/* ajouter manuelement un device */
void gtk_devices_add(GtkWidget *Abtn, gpointer Adata)
{
  GHashTable *Lhash = (GHashTable *) Adata;
  GtkWidget *Lparent = GTK_WIDGET(g_hash_table_lookup(Lhash, "window"));
  GtkTreeView *Lliste = GTK_TREE_VIEW(g_hash_table_lookup(Lhash, "periphdata"));
  GHashTable *Ldialoghash = create_dialog_add_device(Lparent);
  GtkWidget *Lwinadddevice = g_hash_table_lookup(Ldialoghash, "window");
  GtkWidget *Lmessage;

  while (1) {
    if (gtk_dialog_run(GTK_DIALOG(Lwinadddevice)) != GTK_RESPONSE_CANCEL) {
      GtkEntry *Ldevicebus = GTK_ENTRY(g_hash_table_lookup(Ldialoghash, "devicebus"));
      GtkEntry *Ldevicename = GTK_ENTRY(g_hash_table_lookup(Ldialoghash, "devicename"));
      gchar *Lbus = (gchar *)gtk_entry_get_text(Ldevicebus);
      Tdriveinfo *Ldrive = g_malloc0(sizeof(Tdriveinfo));
    
      maj_drive_info(Ldrive, Lbus, NULL);

      if (Ldrive->type == 0) {
        Lmessage = gtk_message_dialog_new(GTK_WINDOW(Lparent),
                                     GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK,
                                     _("Cannot add this drive !"));
      } else {
        Lmessage = gtk_message_dialog_new(GTK_WINDOW(Lparent),
                                     GTK_DIALOG_MODAL, GTK_MESSAGE_INFO, GTK_BUTTONS_OK,
                                     _("Drive succesfully added !"));
      }
      
      gtk_dialog_run(GTK_DIALOG(Lmessage));
      gtk_widget_destroy(Lmessage);

      if (Ldrive->type > 0) {
        /* on complate la structure drive avant de l'ajouter */
        Ldrive->manual = TRUE;
        Ldrive->actuperiph = 0;
        Ldrive->name = g_strdup(gtk_entry_get_text(Ldevicename));
        Ldrive->dev = g_slist_append(Ldrive->dev, g_strdup(Lbus));
        Ldrive->bus = g_slist_append(Ldrive->bus, g_strdup("MANU"));

        Glistdrives = g_slist_append(Glistdrives, Ldrive);

        /* mise a jour de la liste des peripheriques */
        remplirelistegraveur(Lliste);
        break;
      }
      g_free(Ldrive);
    } else {
      break;
    }
  }
  gtk_widget_destroy(Lwinadddevice);
  g_hash_table_destroy(Ldialoghash);
}

  
/* selection d'une image iso */
void gtk_file_sel(GtkWidget *Abtn, gpointer Adata)
{
  GHashTable *Lhash = (GHashTable *)Adata;
  const gchar *Lname = glade_get_widget_name(Abtn);
  GtkWidget *Ltextdest = (GtkWidget *) sc_hash_table_lookupv(Lhash, "%svalue", Lname);
  gint resp;
  GtkWidget *Lfilesel;
  GtkFileChooserAction Ldialogtype = !strncmp(Lname, "src", 3) ?
                                        GTK_FILE_CHOOSER_ACTION_OPEN : GTK_FILE_CHOOSER_ACTION_SAVE;
_DEB("=>%s\n", Lname);
  if (!strncmp(Lname, "dir", 3)) {
    Ldialogtype = GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER;
  }
  Lfilesel = create_fileselection1(NULL, Ldialogtype);
  if (_precdirectory) gtk_file_chooser_set_current_folder_uri(GTK_FILE_CHOOSER(Lfilesel), _precdirectory);
  resp=gtk_dialog_run(GTK_DIALOG(Lfilesel));
  gtk_widget_hide (Lfilesel);
  while (gtk_events_pending())
    gtk_main_iteration();

  if (resp == GTK_RESPONSE_ACCEPT) {
    gchar *Lfilenamebrut = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER ( Lfilesel));
    gchar *Lfilename = _UTF8(Lfilenamebrut);
    if (_precdirectory) g_free(_precdirectory);
    _precdirectory = gtk_file_chooser_get_current_folder_uri(GTK_FILE_CHOOSER(Lfilesel));
    gtk_entry_set_text(GTK_ENTRY(Ltextdest), Lfilename);
    g_free(Lfilename);
    g_free(Lfilenamebrut);
  }

  gtk_widget_destroy(Lfilesel);
}

/* lors de la selection d'un lecteur / graveur */
void on_selectgraveur(GtkWidget *Acombo, gpointer Adata)
{
  GHashTable *Lhash = (GHashTable *)Adata;
  GtkWidget *Lpanel;
  GtkWidget *Lvitesse, *Lobj;
  GtkTreeModel *Lmodel = gtk_combo_box_get_model(GTK_COMBO_BOX(Acombo));
  GtkTreeIter Liter;
  gboolean Lisimgiso = FALSE;
  const gchar *Lname = glade_get_widget_name(Acombo);
  gchar *Laskname;
  gchar *Llecteur = NULL;
  guint Lident = 0;
  gint i;
  Tdriveinfo *Ldrive;

  if (g_str_has_suffix(Lname, "combo")==FALSE) return;
        
  if (!gtk_combo_box_get_active_iter(GTK_COMBO_BOX(Acombo), &Liter)) return;
  gtk_tree_model_get(Lmodel, &Liter, 0, &Llecteur, 3, &Lident, -1);

  Ldrive = (Tdriveinfo *) g_slist_nth_data(Glistdrives, Lident);

  Lisimgiso = !strcmp(Llecteur, "iso"); 

  Laskname = g_strdup(Lname);
  _SWAP_COMBO(Laskname, "speed");
  Lvitesse = (GtkWidget *)g_hash_table_lookup(Lhash, Laskname);
  g_free(Laskname);

  Laskname = g_strdup(Lname);
  _SWAP_COMBO(Laskname, "table");
  Lpanel = (GtkWidget *)g_hash_table_lookup(Lhash, Laskname);
  g_free(Laskname);

  
  /* on cache ou montre la zone de saisie du nom de l'image iso */
  if (GTK_IS_WIDGET(Lpanel)) {

    if (Lisimgiso) {
      /* on montre le champ de selection de l'image iso */
      gtk_widget_show(Lpanel);
    } else {
      /* on le cache */
      gtk_widget_hide(Lpanel);
    }
    if (GTK_IS_WIDGET(Lvitesse)) {
      /* selection de la vitesse non active lorsque l'on a selectionne une image iso .. */
      gtk_widget_set_sensitive(Lvitesse, Lisimgiso ? FALSE : TRUE);
    }
  } 

  if (!Lisimgiso && GTK_IS_WIDGET(Lvitesse)) {
    remplirecombovitesse(GTK_COMBO_BOX(Lvitesse), Llecteur); 
  }

  for (i=0; ((Lobj = sc_hash_table_lookupv(Lhash, "%s_isotodisabled%d", Lname, i)) && GTK_IS_WIDGET(Lobj)); i++) {
    /* disable si image iso, enable sinon */
    gtk_widget_set_sensitive (Lobj, !Lisimgiso);
  }

  for (i=0; ((Lobj = sc_hash_table_lookupv(Lhash, "%s_notcdrwtodisabled%d", Lname, i)) && GTK_IS_WIDGET(Lobj)); i++) {
    /* disable si lecteur non cdrw */
    gtk_widget_set_sensitive (Lobj, DRIVE_WRITER(Ldrive));
  }

  g_free(Llecteur);
}

/* confirmer l'annulation de la gravure */
gboolean abort_gravure(GtkWidget *Abtn, gpointer Adata)
{
  GHashTable *Lhash = (GHashTable *) Adata;
  gboolean *Labort = (gboolean *)g_hash_table_lookup(Lhash, "gabort");
  GtkWidget *Lwindow = GTK_WIDGET(g_hash_table_lookup(Lhash, "window_burn"));
  gint Lret;

  g_assert(Labort);

  GtkWidget *Lconfirm = gtk_message_dialog_new(GTK_WINDOW(Lwindow),
                      GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION,
                      GTK_BUTTONS_YES_NO, _("Do you really want to abort operation ?"));

  Lret = gtk_dialog_run(GTK_DIALOG(Lconfirm));
      
  if (Lret == GTK_RESPONSE_YES) {
    gint *Lpid = (gint *)g_hash_table_lookup(Lhash, "pid");
    if (*Lpid) {
      /* on envoi un TERM au process (cdrecord...) pour qu'il s'arrete ! */
      kill(*Lpid, SIGTERM);
    }
    *Labort = TRUE;
  }

  gtk_widget_destroy(Lconfirm);

  return Lret == GTK_RESPONSE_YES ? TRUE : FALSE;
}

gboolean on_deleteevent_gravure(GtkWidget *Awidget, GdkEvent *Aevent, gpointer Adata)
{

  abort_gravure(NULL, Adata);

  return TRUE;
}

/* confirmer la cloture d'un cd */
void confirm_fixcd(GtkWidget *Abtn, gpointer Adata)
{
  GHashTable *Lhash = (GHashTable *)Adata;
  GtkWidget *Lwindow1 = GTK_WIDGET(g_hash_table_lookup(Lhash, "topwindow"));
  GtkWidget *Lconfirm;
  gint Lrep;

  /* confirmation debut de l'operation */ 
  Lconfirm = gtk_message_dialog_new(GTK_WINDOW(Lwindow1),
                      GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION,
                      GTK_BUTTONS_YES_NO,
                      _("Do you really want to fix the CD-R ?"));
  Lrep = gtk_dialog_run(GTK_DIALOG(Lconfirm));

  gtk_widget_destroy(Lconfirm);

  if (Lrep == GTK_RESPONSE_YES) {
    /* ok go ! */
    show_fixcdwindow(Lhash);
  }
}

/* confirmer l'effacement d'un cdrw */
void confirm_erasecdrw(GtkWidget *Abtn, gpointer Adata)
{
  GHashTable *Lhash = (GHashTable *)Adata;
  GtkWidget *Lwindow1 = GTK_WIDGET(g_hash_table_lookup(Lhash, "topwindow"));
  GtkWidget *Lconfirm;
  gint Lrep;

  /* confirmation debut de l'operation */ 
  Lconfirm = gtk_message_dialog_new(GTK_WINDOW(Lwindow1),
                      GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION,
                      GTK_BUTTONS_YES_NO,
                      _("Do you really want to erase the CD-RW ?"));
  Lrep = gtk_dialog_run(GTK_DIALOG(Lconfirm));

  gtk_widget_destroy(Lconfirm);

  if (Lrep == GTK_RESPONSE_YES) {
    /* ok go ! */
    show_erasecdrwwindow(Lhash);
  }

}

/* confirmer la debut de la gravure */
void confirm_burn (GtkWidget *Abtn, gpointer Adata)
{
  GHashTable *Lhash = (GHashTable *)Adata;
  gint Lrep;
  GtkWidget *Lconfirm;
  const gchar *Lname;
  gchar *Ltxt = NULL;
  gchar *Ltitle = NULL;
  GtkWidget *Lwindow1 = GTK_WIDGET(g_hash_table_lookup(Lhash, "topwindow"));

  Lname = gtk_widget_get_name(Abtn);

  if (!Lname) return;
  if (g_str_has_prefix(Lname, "btnburnaudio")) {
    GtkTreeIter Liter;
    GtkTreeModel *Ltreemodel = gtk_tree_view_get_model(
        GTK_TREE_VIEW(g_hash_table_lookup(Lhash, "LISTEAUDIO")));
    
    /* gravure cd audio, on verifie d'abord qu'il y ai au
     * moins une piste dans la liste .. */
    if (!gtk_tree_model_get_iter_first(Ltreemodel, &Liter)) {
      Lconfirm = gtk_message_dialog_new(GTK_WINDOW(Lwindow1),
                                        GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING,
                                        GTK_BUTTONS_CANCEL, 
                                        _("You must add at least one track to write !"));
      gtk_dialog_run(GTK_DIALOG(Lconfirm));
      gtk_widget_destroy(Lconfirm);
      return;
    }
    Ltxt = _("Do you really want to create an audio cd ?");
    Ltitle = _("Writing audio cd in progress...");
  } else if (g_str_has_prefix(Lname, "btnburndata")) {
    GtkTreeIter Liter;
    GtkTreeModel *Ltreemodel = gtk_tree_view_get_model(GTK_TREE_VIEW(g_hash_table_lookup(Lhash, "LISTEDATA")));
    /* gravure cd de donnee, on verifie qu'il y ai au
     * moins un fichier/repertoire dans la liste */

    if (!gtk_tree_model_get_iter_first(Ltreemodel, &Liter) ||
        !gtk_tree_model_iter_has_child(Ltreemodel, &Liter)) {

      Lconfirm = gtk_message_dialog_new(GTK_WINDOW(Lwindow1),
                                        GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING,
                                        GTK_BUTTONS_CANCEL, 
                              _("You must add at least one file to write !"));
      gtk_dialog_run(GTK_DIALOG(Lconfirm));
      gtk_widget_destroy(Lconfirm);
      return;

    }
    Ltxt = _("Do you really want to create a data cd ?");
    Ltitle = _("Writing data cd in progress...");
  } else {
    /* copie de cd */
    Ltxt = _("Do you really want to start the copy ?");
    Ltitle = _("Copying in progress...");
  }
 
  /* confirmation debut de l'operation */ 
  Lconfirm = gtk_message_dialog_new(GTK_WINDOW(Lwindow1),
                      GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION,
                      GTK_BUTTONS_YES_NO,
                      Ltxt);
  Lrep = gtk_dialog_run(GTK_DIALOG(Lconfirm));

  gtk_widget_destroy(Lconfirm);

  if (Lrep == GTK_RESPONSE_YES) {
    /* ok go ! */
    show_graverwindow(Lhash, (gchar *)Lname, Ltitle);
  }
}

/* popup ajouter des fichiers */
void view_popupmenu_addfile(GtkWidget *Aliste, GdkEventButton *Aevent, gpointer Adata) {
  GtkMenu *Lpopupm = create_gtkpopupmenudata(Aliste, Adata);
  gtk_menu_popup(Lpopupm, NULL, NULL, NULL, Aliste, Aevent->button, Aevent->time);
}
void key_popupmenu_addfile(GtkWidget *Aliste, gpointer Adata) {
  GtkMenu *Lpopupm = create_gtkpopupmenudata(Aliste, Adata);
  gtk_menu_popup(Lpopupm, NULL, NULL, NULL, Aliste, 0, 0);
}


/* popup ajouter des pistes audio */
void view_popupmenu_addaudio(GtkWidget *Aliste, GdkEventButton *Aevent, gpointer Adata) {
  GtkMenu *Lpopupm = create_gtkpopupmenuaudio(Aliste, Adata);
  gtk_menu_popup(Lpopupm, NULL, NULL, NULL, Aliste, Aevent->button, Aevent->time);
}
void key_popupmenu_addaudio(GtkWidget *Aliste, gpointer Adata) {
  GtkMenu *Lpopupm = create_gtkpopupmenuaudio(Aliste, Adata);
  gtk_menu_popup(Lpopupm, NULL, NULL, NULL, Aliste, 0, 0);
}


/* popup gestion des peripheriques */
void view_popupmenu_devices(GtkWidget *Aliste, GdkEventButton *Aevent, gpointer Adata) {
  GtkMenu *Lpopupm = create_gtkpopupmenudevices(Aliste, Adata);
  gtk_menu_popup(Lpopupm, NULL, NULL, NULL, Aliste, Aevent->button, Aevent->time);
}
void key_popupmenu_devices(GtkWidget *Aliste, gpointer Adata) {
  GtkMenu *Lpopupm = create_gtkpopupmenudevices(Aliste, Adata);
  gtk_menu_popup(Lpopupm, NULL, NULL, NULL, Aliste, 0, 0);
}

/* clique sur la souris, gestion des popups */
gboolean gtk_do_eventbuttonpress(GtkWidget *Aliste, GdkEventButton *Aevent, gpointer Adata)
{
  if (!Aevent) return FALSE;

  if (Aevent->type == GDK_BUTTON_PRESS) {
    if (Aevent->button == 3) {
      const gchar *Lname = glade_get_widget_name(Aliste);
      if (!strcmp(Lname, "LISTEDATA")) {
        view_popupmenu_addfile(Aliste, Aevent, Adata);
      } else if (!strcmp(Lname, "LISTEAUDIO")) {
        view_popupmenu_addaudio(Aliste, Aevent, Adata);
      } else if (!strcmp(Lname, "periphdata")) {
        view_popupmenu_devices(Aliste, Aevent, Adata);
      }
      return TRUE;
    }
  } else if (Aevent->type == GDK_2BUTTON_PRESS) {
    if (Aevent->button == 1) {
      const gchar *Lname = glade_get_widget_name(Aliste);
      /* double clique sur la fenetre des lecteurs, on edite le lecteur */
      if (!strcmp(Lname, "periphdata")) {
        gtk_devices_edit(NULL, Adata);
      }
      return TRUE;
    }
  }
  return FALSE;
}

/* callback lorsque l'on selectionne un fichier pour activer/desactiver
 * le bouton "ajouter des fichiers" */
gboolean on_select_files (GtkTreeSelection *Aselection, GtkTreeModel *Amodel,
                          GtkTreePath *Apath, gboolean Apath_currently_selected,
                          gpointer Adata)
{
  GtkTreeIter Liter;
  GtkWidget *Lbtn = (GtkWidget *) Adata; 
  gboolean Ltodisable;
  
  if (Lbtn && !Apath_currently_selected && gtk_tree_model_get_iter(Amodel, &Liter, Apath)) {
    gint Ltype;

    gtk_tree_model_get(Amodel, &Liter, 0, &Ltype, -1);

    Ltodisable = (Ltype != TYPE_FILE);

    gtk_widget_set_sensitive(GTK_WIDGET(Lbtn), Ltodisable);
  }
  return TRUE;
}

/* passage a l'onglet suivante */
void gonextpage(GtkWidget *Antn, GtkNotebook *Anotebook)
{
  gtk_notebook_next_page(Anotebook);
}

/* clique sur l'un des boutons du menu de gauche */
void changemenu(GtkToggleButton *Abutton, gpointer Adata)
{
  GHashTable *Lhash = (GHashTable *)Adata;
  GtkNotebook *Lnotebook, *Lnotebookactif = g_hash_table_lookup(Lhash, "_menuactif");
  const gchar *Lname = glade_get_widget_name(GTK_WIDGET(Abutton));
  gchar *Ltmp;
  gchar *Llstclick = g_hash_table_lookup(Lhash, "_lstclick");

  if (!Lname || !*Lname) return;

  Lnotebook = sc_hash_table_lookupv(Lhash, "body%s", Lname+strlen("btn"));

  if (Llstclick && !strcmp(Llstclick, Lname)) {
    if (gtk_toggle_button_get_active(Abutton)) return;

    gtk_toggle_button_set_active(Abutton, TRUE);

    return ;
  }

  Ltmp = Llstclick ? g_strdup(Llstclick) : NULL;
  if (gtk_toggle_button_get_active(Abutton)) {
    if (Llstclick) g_free(Llstclick);
    Llstclick = g_strdup(Lname);
    g_hash_table_replace(Lhash, "_lstclick", Llstclick);
    gtk_widget_show(GTK_WIDGET(Lnotebook));
    if (GTK_IS_WIDGET(Lnotebookactif)) gtk_widget_hide(GTK_WIDGET(Lnotebookactif));
    g_hash_table_replace(Lhash, "_menuactif", Lnotebook);
  }
 
  if (Ltmp) {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(g_hash_table_lookup(Lhash, Ltmp)), FALSE);
    g_free(Ltmp);
  }
}

/* callback pour verifier la longueur des textes buffer */
void text_buffer_callback(GtkTextBuffer *Aobj, gpointer Adata)
{
  GtkTextIter Lstart_iter;
  GtkTextIter Lend_iter;
  gchar *Ltext;
  gint Lmax_len;

  Lmax_len = GPOINTER_TO_INT (g_object_get_data (G_OBJECT (Aobj), "max-length"));
  if (Lmax_len == 0) return;

  gtk_text_buffer_get_bounds (Aobj, &Lstart_iter, &Lend_iter);
  Ltext = gtk_text_buffer_get_text (Aobj, &Lstart_iter, &Lend_iter, FALSE);

  if (strlen(Ltext)>Lmax_len) {
    gtk_text_buffer_get_iter_at_offset (Aobj, &Lstart_iter, Lmax_len);
    gtk_text_buffer_delete (Aobj, &Lstart_iter, &Lend_iter);
  }

  g_free(Ltext);
}

/* clique sur le menu, on active un onglet */
void menu_active_panel(GtkWidget *Amenuitem, gpointer Adata)
{
  GHashTable *Lhash = (GHashTable *)Adata;
  const gchar *Lname = glade_get_widget_name(Amenuitem);
  GtkToggleButton *Ltbtn = (GtkToggleButton *)sc_hash_table_lookupv(Lhash, "btn%s", Lname+strlen("menu"));

  if (!GTK_IS_WIDGET(Ltbtn)) return;
  
  gtk_toggle_button_set_active(Ltbtn, TRUE);
}

/* changement d'onglet */
void switchpage(GtkNotebook *Anotebook, GtkNotebookPage *Anotebookpage, guint Apagenum, gpointer Adata)
{
  GHashTable *Lhash = (GHashTable *)Adata;
  GtkWidget *Ldatavoli = g_hash_table_lookup(Lhash, "datavoli");
  GtkTreeModel *LTreeModel = gtk_tree_view_get_model(GTK_TREE_VIEW(g_hash_table_lookup(Lhash, "LISTEDATA")));
  GtkTreeIter Liter;
  gchar *Lnom;
  
  if (Apagenum != 0 && Apagenum != 2) return;
  /* il devrait normalement toujours y avoir une entree dans la liste, au moins le nom du cd ! */
  if (!gtk_tree_model_get_iter_first(LTreeModel, &Liter)) return;

  gtk_tree_model_get(LTreeModel, &Liter, 2, &Lnom, -1);
  if (Apagenum == 2) {
    /* mise a jour du champ "Nom du volume" */
    gtk_entry_set_text(GTK_ENTRY(Ldatavoli), Lnom);
  } else if (Apagenum == 0) {
    /* mise a jour de l'entre contenant le nom du volume */
    gtk_tree_store_set(GTK_TREE_STORE(LTreeModel), &Liter, 2, gtk_entry_get_text(GTK_ENTRY(Ldatavoli)), -1);
  }

  g_free(Lnom);
}

/* activer la boite de dialogue proprietes */
void menu_active_proprietes(GtkWidget *Amenuitem, gpointer Adata)
{
  GHashTable *Lhash = (GHashTable *) Adata;
  GtkWidget *Lparent = GTK_WIDGET(g_hash_table_lookup(Lhash, "topwindow"));
  GHashTable *Ldialoghash = create_dialog_proprietes(Lparent);
  GtkWidget *Lwinproprietes = g_hash_table_lookup(Ldialoghash, "window");
  GError *Aerror = NULL;
  GtkWidget *Lptr;
  TProgRequis *Lcurentry;
  gchar *Lconffile;
  gchar Ltmp[256];

  gtk_dialog_run(GTK_DIALOG(Lwinproprietes));

  /* recuperation des valeurs a sauver */
  Lptr = g_hash_table_lookup(Ldialoghash, "dirtmpvalue");
  conf_store_value("tmpdir", (gchar *)gtk_entry_get_text(GTK_ENTRY(Lptr)));
  Lptr = g_hash_table_lookup(Ldialoghash, "overburn");
  conf_store_value("overburn", _BOOLEAN_CONF(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(Lptr))));
  Lptr = g_hash_table_lookup(Ldialoghash, "fastblank");
  conf_store_value("fastblank", _BOOLEAN_CONF(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(Lptr))));
  Lptr = g_hash_table_lookup(Ldialoghash, "eject");
  conf_store_value("eject", _BOOLEAN_CONF(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(Lptr))));
#if 0  
  Lptr = g_hash_table_lookup(Ldialoghash, "extended");
  conf_store_value("extended", _BOOLEAN_CONF(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(Lptr))));
#endif


  /* on sauve les parametres utilisateurs a passer aux programmes externes */
  for (Lcurentry = Glisteprogrequis; Lcurentry->entry; Lcurentry++) {
    if (Lcurentry->type != CONF_PROG) continue;
    g_snprintf(Ltmp, sizeof(Ltmp)-1, "%spara", Lcurentry->entry);

    Lptr = g_hash_table_lookup(Ldialoghash, Ltmp);
    if (!GTK_IS_WIDGET(Lptr)) continue;

    conf_store_value(Ltmp, (gchar *)gtk_entry_get_text(GTK_ENTRY(Lptr)));
  }
  
  /* sauvegarde configuration */
  Lconffile = get_config_file_name();
  write_conf(Lconffile, &Aerror);
  g_free(Lconffile);

  /* mise a jour des listes contenant les lecteurs */
  update_combo_graveur(Lhash);

  gtk_widget_destroy(Lwinproprietes);

  _DEB("avant free");
  g_hash_table_destroy(Ldialoghash);
  _DEB("apres free");
}

gboolean encours_callback(gpointer Adata)
{
  GHashTable *Lhash = (GHashTable *)Adata;
  GtkProgressBar *Lprog = GTK_PROGRESS_BAR(g_hash_table_lookup(Lhash, "progress"));
  gint *Lcont = (gint *)g_hash_table_lookup(Lhash, "cont");

  gtk_progress_bar_pulse(Lprog);

  if ((*Lcont) == 1) (*Lcont) = 0;
  
  return (*Lcont) > 0 ? TRUE : FALSE;
}

/* chercher (a nouveau) les programmes */
void chercheprog(GtkWidget *Aobj, gpointer Adata)
{
  GHashTable *Lhash = (GHashTable *)Adata;
  GtkWidget *Lstatusbox;
  GtkWidget *Lwindow1 = g_hash_table_lookup(Lhash, "window");

  /* mise a jour de la configuration */
  manage_new_config(Lhash, SEARCH_PROG, NULL);
  clean_config();

  maj_proprietes_prog(Lhash);

  /* boite de dialoge operation terminee */
  Lstatusbox = gtk_message_dialog_new(GTK_WINDOW(Lwindow1), GTK_DIALOG_MODAL,
      GTK_MESSAGE_INFO, GTK_BUTTONS_OK, _("configuration updated."));
  gtk_dialog_run(GTK_DIALOG(Lstatusbox));
  gtk_widget_destroy(Lstatusbox);
}

/* chercher (a nouveau) les lecteurs */
void cherchelecteur(GtkWidget *Aobj, gpointer Adata)
{
  GHashTable *Lparenthash = (GHashTable *)Adata;
  GtkWidget *Lwindow1 = g_hash_table_lookup(Lparenthash, "window");
  GladeXML *Lxmlencours = create_window_encours(Lwindow1);
  GtkWidget *Lstatusbox;
  GtkWidget *Lwin;
  GtkTreeView *Ldata;
  GtkWidget *Lprogressbar;
  GtkWidget *Llabel;
  GtkWidget *Lcancel;
  gboolean Labort = FALSE;
  gint Lcont = 2;
  gchar *Ltxt;
  GHashTable *Lhash = _hash();
  GSList *Lcur;
  Tdriveinfo *Ldrive;
  
  Lwin = glade_xml_get_widget(Lxmlencours, "window_inprogress"); 

  Llabel = glade_xml_get_widget(Lxmlencours, "labelava");
  Lprogressbar = glade_xml_get_widget(Lxmlencours, "progress");
  g_hash_table_insert(Lhash, "cont", &Lcont);
  g_hash_table_insert(Lhash, "gabort", &Labort);
  g_hash_table_insert(Lhash, "labelava", Llabel);
  g_hash_table_insert(Lhash, "progress", Lprogressbar);

  /* bouton annuler */
  Lcancel = glade_xml_get_widget(Lxmlencours, "cancelbtn");
  g_signal_connect(G_OBJECT(Lcancel), "clicked", G_CALLBACK(abort_encours), (GtkWidget *)Lhash);

  gtk_widget_show(Lwin);
  g_timeout_add(500, encours_callback, Lhash);

  scan_for_drives(Lhash, NULL);

  if (Labort == FALSE) {
    for (Lcur = Glistdrives; Lcur; Lcur = g_slist_next(Lcur)) {
      Ldrive = (Tdriveinfo *)Lcur->data;
      if (g_slist_length(Ldrive->dev)>0) {
        Ltxt = g_strdup_printf(_("Scanning drive \"%s\"..."), Ldrive->name);
        gtk_label_set_text(GTK_LABEL(Llabel), Ltxt); g_free(Ltxt);
        while(gtk_events_pending()) gtk_main_iteration();

        maj_drive_info(Ldrive, (gchar *)g_slist_nth_data(Ldrive->dev, 0), NULL);
      }
    }
  }

  /* on attend la fin d'execution de la popup d'attente */
  Lcont = 1;
  while (Lcont > 0) { while(gtk_events_pending()) gtk_main_iteration(); }

  gtk_widget_destroy(Lwin);
  g_hash_table_destroy(Lhash);
  if (GTK_IS_WIDGET(Aobj) && Labort == FALSE) {
    Ldata = GTK_TREE_VIEW(g_hash_table_lookup(Lparenthash, "periphdata"));
    remplirelistegraveur(Ldata);

    /* boite de dialoge operation terminee */
    Lstatusbox = gtk_message_dialog_new(GTK_WINDOW(Lwindow1), GTK_DIALOG_MODAL, GTK_MESSAGE_INFO, GTK_BUTTONS_OK,
        _("configuration updated."));
    gtk_dialog_run(GTK_DIALOG(Lstatusbox));
    gtk_widget_destroy(Lstatusbox);
  }

  g_free(Lxmlencours);
}

void abort_encours(GtkWidget *Abtn, gpointer Adata)
{
  GHashTable *Lhash = (GHashTable *)Adata;
  gint *Lcont = (gint *)g_hash_table_lookup(Lhash, "cont");
  gboolean *Labort = (gboolean *)g_hash_table_lookup(Lhash, "gabort");

  (*Labort) = TRUE;
  (*Lcont) = 1; /* on passe Lcont de 2 a 1 */
}

/* on quitte l'application .. */
void menu_quit(GtkWidget *Aobj1, gpointer Adata)
{
  GHashTable *Lhash = (GHashTable *)Adata;

  /* on sauve la position et taille de la fenetre */
  manage_new_config(Lhash, UPDATE_SIZE + WRITE_CONFIG, NULL);

  gtk_main_quit();
}

void delete_event_quit(GtkWidget *Awidget, GdkEvent *Aevent, gpointer Adata)
{
  menu_quit(Awidget, Adata);
}

#if 0
void on_addmediaformat(GtkWidget *Abtn, gpointer Adata)
{
  GHashTable *Lmediahash = addmediaformat(Adata);
  GtkDialog *Ldialog = GTK_DIALOG(g_hash_table_lookup(Lmediahash, "dialog_media"));

  gtk_dialog_run(Ldialog);
  gtk_widget_destroy(GTK_WIDGET(Ldialog));

  g_hash_table_destroy(Lmediahash);
}
#endif

/* mise a jour type cdr destination, on mets donc a jour la barre de remplissage */
void change_remplissage(GtkWidget *Acombo, gpointer Adata)
{
  GHashTable *Lhash = (GHashTable *)Adata;
  const gchar *Lname = glade_get_widget_name(Acombo);
  gchar *Lvalue = get_combo_value(Acombo);
  GtkProgressBar *Lcontenance;
  guint32 *Lmaxlen;
  guint32 *Llen;

  if (!strcmp(Lname, "listeremplidata")) {
    Lcontenance = GTK_PROGRESS_BAR(g_hash_table_lookup(Lhash, "datasizebar"));
    Lmaxlen = (guint32 *)g_hash_table_lookup(Lhash, "datamaxsize");
    Llen = (guint32 *)g_hash_table_lookup(Lhash, "datasize");
    (*Lmaxlen) = strtoul(Lvalue, NULL, 10) * 1024 * 1024;
  } else {
    Lcontenance = GTK_PROGRESS_BAR(g_hash_table_lookup(Lhash, "audiolenbar"));
    Lmaxlen = (guint32 *)g_hash_table_lookup(Lhash, "audiomaxlen");
    Llen = (guint32 *)g_hash_table_lookup(Lhash, "audiolen");
    (*Lmaxlen) = strtoul(Lvalue, NULL, 10);
  }

  switch_pbar_status(Lcontenance, *Lmaxlen, *Llen, PB_NONE);
}

/* gestion drag and drop */
void audio_dnd_data_received (GtkWidget *Aliste, GdkDragContext *Acontext, gint Ax, gint Ay, GtkSelectionData *Aseldata, guint Ainfo, guint Atime, gpointer Adata)
{
  GHashTable *Lhash = (GHashTable *)Adata;
  GtkTreeModel *Ltreemodel = gtk_tree_view_get_model(GTK_TREE_VIEW(Aliste));
  guint32 *Laudiolen = (guint32 *)g_hash_table_lookup(Lhash, "audiolen");
  guint32 *Laudiomaxlen = (guint32 *)g_hash_table_lookup(Lhash, "audiomaxlen");
  GtkProgressBar *Lcontenance = GTK_PROGRESS_BAR(g_hash_table_lookup(Lhash, "audiolenbar"));

  if ((Aseldata->length >= 0) && (Aseldata->format == 8))
  {
    gchar *Lunfic;
    gint i;
    gchar **Lallname = g_strsplit(Aseldata->data, "\r\n", 0);
    gchar *Lfilename = NULL;

    for (i=0; ((Lallname[i])); i++) {
      Lunfic = g_strchomp(Lallname[i]);
      /* on ne gere que les fichiers locaux pour le moment, et c'est deja a !! */
      if (g_ascii_strncasecmp(Lunfic, "file://", 7) || (
            ! (
#ifdef ENABLE_MP3
             sc_str_has_casesuffix(Lunfic, MP3) || 
#endif
#ifdef ENABLE_OGG             
             sc_str_has_casesuffix(Lunfic, OGG) ||
#endif
             sc_str_has_casesuffix(Lunfic, WAV)))) continue;

      Lfilename = g_filename_from_uri(Lunfic, NULL, NULL);
      _add_a_piste(Lfilename, GTK_LIST_STORE(Ltreemodel), Lhash);
      g_free(Lfilename);
    }

    g_strfreev(Lallname);
    
    /* mise a jour barre de remplissage */
    switch_pbar_status(Lcontenance, *Laudiomaxlen, *Laudiolen, PB_UPDATE_AUDIO);

    gtk_drag_finish (Acontext, TRUE, FALSE, Atime);
    return;
  } else {
    GtkTreePath *Lpathsrc = NULL;
    GtkTreePath *Lpathdst = NULL;
    GtkTreeIter Litersrc;
    GtkTreeIter Literdst;
    gtk_tree_view_get_dest_row_at_pos(GTK_TREE_VIEW(Aliste), Ax, Ay, &Lpathdst, NULL); 
    if (Lpathdst) {
      gtk_tree_view_get_cursor(GTK_TREE_VIEW(Aliste), &Lpathsrc, NULL);
      if (Lpathsrc) {
        gtk_tree_model_get_iter(Ltreemodel, &Litersrc, Lpathsrc);
        gtk_tree_model_get_iter(Ltreemodel, &Literdst, Lpathdst);
        gtk_list_store_move_after(GTK_LIST_STORE(Ltreemodel), &Litersrc, &Literdst); 
        gtk_tree_path_free(Lpathsrc);
        gtk_drag_finish (Acontext, TRUE, FALSE, Atime);
      }
      gtk_tree_path_free(Lpathdst);
    }
  }
  gtk_drag_finish (Acontext, FALSE, FALSE, Atime);
}

void data_dnd_data_received (GtkWidget *Aliste, GdkDragContext *Acontext, gint Ax, gint Ay, GtkSelectionData *Aseldata, guint Ainfo, guint Atime, gpointer Adata)
{
  GHashTable *Lhash = (GHashTable *)Adata;
  guint32 *Ldatasize = (guint32 *)g_hash_table_lookup(Lhash, "datasize");
  guint32 *Ldatamaxsize = (guint32 *)g_hash_table_lookup(Lhash, "datamaxsize");
  GtkProgressBar *Lcontenance = GTK_PROGRESS_BAR(g_hash_table_lookup(Lhash, "datasizebar"));
  GtkTreeModel *Ltreemodel = gtk_tree_view_get_model(GTK_TREE_VIEW(Aliste));

  if ((Aseldata->length >= 0) && (Aseldata->format == 8))
  {
    gchar *Lunfic;
    gint i;
    gchar **Lallname = g_strsplit(Aseldata->data, "\r\n", 0);
    gchar *Lfilename = NULL;
    GtkTreeIter Liter;
    GtkTreePath *Lpath = NULL;

    gtk_tree_view_get_cursor(GTK_TREE_VIEW(Aliste), &Lpath, NULL);
    if (!Lpath) {
      if (!gtk_tree_model_get_iter_first(Ltreemodel, &Liter)) {
        gtk_drag_finish (Acontext, FALSE, FALSE, Atime);
        return;
      }
    } else {
      gtk_tree_model_get_iter(Ltreemodel, &Liter, Lpath);
      gtk_tree_path_free(Lpath);
    }

    for (i=0; ((Lallname[i])); i++) {
      Lunfic = g_strchomp(Lallname[i]);
      if (!*Lunfic) continue;

      Lfilename = g_filename_from_uri(Lunfic, NULL, NULL);

      _add_a_file(Lfilename, GTK_TREE_STORE(Ltreemodel), &Liter, Lhash);
      
      g_free(Lfilename);
    }

    g_strfreev(Lallname);

    /* expand element ajoute */
    if ((Lpath = gtk_tree_model_get_path(Ltreemodel, &Liter))) {
      gtk_tree_view_expand_row(GTK_TREE_VIEW(Aliste), Lpath, TRUE);
      gtk_tree_path_free(Lpath);
    }

    /* mise a jour barre de remplissage */
    switch_pbar_status(Lcontenance, *Ldatamaxsize, *Ldatasize, PB_UPDATE_DATA);
    
    gtk_drag_finish (Acontext, TRUE, FALSE, Atime);
    return;
  } else {
    GtkTreePath *Lpathsrc = NULL;
    GtkTreePath *Lpathdst = NULL;
    GtkTreeIter Litersrc, Literdst, Liternew;
    gint Ltype;
    gtk_tree_view_get_dest_row_at_pos(GTK_TREE_VIEW(Aliste), Ax, Ay, &Lpathdst, NULL); 
    if (Lpathdst) {
      gtk_tree_view_get_cursor(GTK_TREE_VIEW(Aliste), &Lpathsrc, NULL);
      if (Lpathsrc) {
        if (gtk_tree_path_is_descendant(Lpathdst, Lpathsrc)) {

          gtk_tree_path_free(Lpathsrc);
          gtk_tree_path_free(Lpathdst);
          gtk_drag_finish (Acontext, FALSE, FALSE, Atime);
          return;
        }
        
        gtk_tree_model_get_iter(Ltreemodel, &Litersrc, Lpathsrc);
        gtk_tree_model_get_iter(Ltreemodel, &Literdst, Lpathdst);
        gtk_tree_model_get(Ltreemodel, &Literdst, 0, &Ltype, -1);
       
        if (Ltype == TYPE_FILE) {
          gtk_tree_store_insert_after(GTK_TREE_STORE(Ltreemodel), &Liternew, NULL, &Literdst);
        } else {
          gtk_tree_store_insert_after(GTK_TREE_STORE(Ltreemodel), &Liternew, &Literdst, NULL);
        }

        /* copie recursive de l'element et des enfants */
        sc_line_data_copy(Ltreemodel, &Litersrc, &Liternew);

        gtk_tree_path_free(Lpathsrc);
        gtk_tree_path_free(Lpathdst);
        gtk_drag_finish (Acontext, TRUE, TRUE, Atime);

        return;
      }
      gtk_tree_path_free(Lpathdst);
    }
  }

  gtk_drag_finish (Acontext, FALSE, FALSE, Atime);
}

#if 0
void update_media_unit_range(gchar *Aunit)
{
//  gtk_spin_button_set_range

}
    
void update_media_unit(GtkWidget *Acombo, gpointer Adata)
{
  GHashTable *Lhash = (GHashTable *)Adata;
  GtkWidget *Ldataentry = GTK_WIDGET(g_hash_table_lookup(Lhash, "mediadata"));

  gtk_widget_grab_focus(Ldataentry);
}

/* mise a jour des champs dans la fenetre "configuration des medias" */
gboolean update_media_fields(GtkWidget *Awidget, gpointer Adata)
{
  GHashTable *Lhash = (GHashTable *)Adata;
  const gchar *Lname = glade_get_widget_name(GTK_WIDGET(Awidget));
  gulong Lnewsize;
  gulong Lasksize;
  gulong *Lsize = (gulong *)g_hash_table_lookup(Lhash, "fullsize");
  GtkComboBox *Lmediadataunit = GTK_COMBO_BOX(g_hash_table_lookup(Lhash, "mediadataunit"));
  gchar *Lcharunit = get_combo_value(GTK_WIDGET(Lmediadataunit));

 // printf("l'unite est => %s\n", Lcharunit);
  Lasksize = (gulong) gtk_spin_button_get_value(GTK_SPIN_BUTTON(Awidget));
  
//      printf("oui [%c]\n", *Lcharunit);
    /* mise a jour depuis la taille */
//  printf("asjsize avant => %ld\n", Lasksize);
    if (*Lcharunit == 'g') {
      Lasksize*=1024 * 1024 * 1024;
    } else if (*Lcharunit == 'm') {
      Lasksize*=1024 * 1024;
     } else {
 //     printf("oui kb\n");
      Lasksize*= 1024;
   }

    gtk_spin_button_set_value(Lmediaaudio, Lasksize );
    *Lsize = Lasksize;
//printf("la taille est donc de = %ld\n", *Lsize);

    g_free(Lcharunit);
  }

  return FALSE;
}
#endif

/* debuter un nouveau projet */
void menu_start_new(GtkMenuItem *Amenuitem, gpointer Adata)
{
  GHashTable *Lhash = (GHashTable *)Adata;
  GtkNotebook *Lnotebookactif = g_hash_table_lookup(Lhash, "_menuactif");
  const gchar *Lname = glade_get_widget_name(GTK_WIDGET(Lnotebookactif));

  if (!strcmp(Lname, "bodycdaudio")) {
    /* on est sur l'onglet cd audio, on vide la liste */
    GtkTreeView *Lliste = GTK_TREE_VIEW(g_hash_table_lookup(Lhash, "LISTEAUDIO"));
    GtkTreeModel *Ltreemodel = gtk_tree_view_get_model(Lliste);
    GtkProgressBar *Lcontenance = GTK_PROGRESS_BAR(g_hash_table_lookup(Lhash, "audiolenbar"));
    guint32 *Laudiolen = (guint32 *)g_hash_table_lookup(Lhash, "audiolen");
    guint32 *Laudiomaxlen = (guint32 *)g_hash_table_lookup(Lhash, "audiomaxlen");
    (*Laudiolen) = 0;

    gtk_list_store_clear(GTK_LIST_STORE(Ltreemodel));
    switch_pbar_status(Lcontenance, *Laudiomaxlen, *Laudiolen, PB_UPDATE_AUDIO);

  } else if (!strcmp(Lname, "bodycddata")) {
    /* on est sur l'onglet cd data, on vide la liste */
    GtkTreeView *Lliste = GTK_TREE_VIEW(g_hash_table_lookup(Lhash, "LISTEDATA"));
    GtkTreeModel *Ltreemodel = gtk_tree_view_get_model(GTK_TREE_VIEW(Lliste));
    GtkProgressBar *Lcontenance = GTK_PROGRESS_BAR(g_hash_table_lookup(Lhash, "datasizebar"));
    guint32 *Ldatasize = (guint32 *)g_hash_table_lookup(Lhash, "datasize");
    guint32 *Ldatamaxsize = (guint32 *)g_hash_table_lookup(Lhash, "datamaxsize");
    GtkTreeIter Liter;
#if 0    
    = g_hash_table_lookup(Lhash, "file_imageboot");
#endif
    (*Ldatasize) = 0;

    gtk_tree_store_clear(GTK_TREE_STORE(Ltreemodel));
    /* icone de base dans la liste des fichiers */
    gtk_tree_store_append(GTK_TREE_STORE(Ltreemodel), &Liter, NULL);
    gtk_tree_store_set(GTK_TREE_STORE(Ltreemodel), &Liter, 0, TYPE_CD, 1, GCDpetiteIcone, 2, _("New CD"), 3, "", 4, "", 5, 0, -1);

    
    switch_pbar_status(Lcontenance, *Ldatamaxsize, *Ldatasize, PB_UPDATE_AUDIO);
#if 0
    if (Liter) {
      gtk_tree_iter_free(Liter);
      g_hash_table_steal(Lhash, "file_imageboot");
    }
#endif
  }
}

/* definir/enlever l'image de boot */
void gtk_def_imageboot(GtkWidget *Abtn, gpointer Adata)
{
  GHashTable *Lhash = (GHashTable *)Adata;
  GtkTreeView *Lliste = GTK_TREE_VIEW(g_hash_table_lookup(Lhash, "LISTEDATA"));
  GtkTreeModel *Ltreemodel;
  GtkTreeSelection *Lselection = gtk_tree_view_get_selection(GTK_TREE_VIEW(Lliste));
  GtkTreeIter *Liter = g_hash_table_lookup(Lhash, "file_imageboot");
  GtkTreeIter Lnewiter;

  if (!gtk_tree_selection_get_selected(Lselection, &Ltreemodel, &Lnewiter)) return;

  if (Liter) {
    gtk_tree_store_set(GTK_TREE_STORE(Ltreemodel), Liter, 1, GFileIcone, -1);
    gtk_tree_iter_free(Liter);
  }

  gtk_tree_store_set(GTK_TREE_STORE(Ltreemodel), &Lnewiter, 0, TYPE_IMAGEBOOT, 1, GFileImage, -1);

  g_hash_table_replace(Lhash, "file_imageboot", gtk_tree_iter_copy(&Lnewiter));
}

/*
 * vim:et:ts=8:sts=2:sw=2
 )*/
