/* main.c
 * Copyright (C) 2004, 2005 Sylvain Cresto <sylvain.cresto@tiscali.fr>
 *
 * This file is part of graveman!
 *
 * graveman! is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or
 * (at your option) any later version.
 * 
 * graveman! is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA. 
 * 
 * URL: http://scresto.site.voite.fr/
 *
 */

#include "graveman.h"

GladeXML *Gxml = NULL;

gboolean graveman_init(gint Aargc, gchar *Aargv[]) {
  gint i;
  gchar *ptr;
  for (i = 1; i <= Aargc; i++) {
    ptr = Aargv[i-1];
    while (*ptr=='-') ptr++;
    if (*ptr == 'v') {
      g_printf("%s\n", VERSION);
      return FALSE;
    } else if (*ptr == 'V') {
      g_printf("%s: %s\n", _("Version"), VERSION);
      g_printf("%s: %s\n", _("Compiled with ogg vorbis support"), 
#ifdef ENABLE_OGG
          _("yes")
#else
          _("no")
#endif
          );
      g_printf("%s: %s\n", _("Compiled with mp3 support"), 
#ifdef ENABLE_MP3
          _("yes")
#else
          _("no")
#endif
          );
      g_printf("%s %s\n", _("Compiled"), 
#ifdef DEBUG
          _("with debug support")
#else
          _("without debug support")
#endif
          );
      return FALSE;
    } else if (*ptr == 'h') {
      g_printf("%s %s\n", PACKAGE, VERSION); 
      g_printf(_("By Sylvain Cresto <sylvain.cresto@tiscali.fr>\n\n"));
      g_printf("  %s %s %s\n"
               "\t-v\t%s\n"
               "\t-V\t%s\n\n",
              _("Usage:"), Aargv[0], _("[options]"), _("show version number."),
               _("show compilation informations."));
      return FALSE;
    }

  }

  return TRUE;
}

gboolean graveman_glade_init(gchar *Afilename) {
  if (!Gxml) {
    if (!(Gxml = glade_xml_new(Afilename,NULL,NULL))) {
      g_warning("Error init glade !\n");
      return FALSE;
    }

    glade_xml_signal_autoconnect(Gxml);
  }
  return TRUE;
}

/* programme principal ! */
gint main (gint Aargc, gchar *Aargv[])
{
  GError *Lerror = NULL;
  GtkWidget *Lwindow1;
  guint32 Laudiolen = 0, Ldatasize = 0;
  guint32 Laudiomaxlen = 4800;  /* par defaut, cd audio de 80 minutes */
  guint32 Ldatamaxsize = 700 * 1024 * 1024; /* par defaut, cd de donnee de 700 Mb */

  if (!graveman_init(Aargc, Aargv)) return EXIT_SUCCESS;

#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif

  gtk_init (&Aargc, &Aargv);

  add_pixmap_directory (PACKAGE_DATA_DIR "/" PACKAGE );
//  graveman_glade_init(PACKAGE_DATA_DIR "/" PACKAGE "/" PACKAGE ".glade");

  /* on regarde si il y a un fichier de configuration present, si non on en
   * genere un nouveau */
  config_init();
  if (!is_config_valide()) {
    GHashTable *Lhash = _hash();
    manage_new_config(Lhash, SEARCH_LECTEUR + SEARCH_PROG + WRITE_CONFIG, &Lerror);
    g_free(Lhash);
    welcome_to_graveman();
  } else {
    read_config(&Lerror);
  }

  GDirIcone = create_pixbuf("folder5-petit.png");
  GFileIcone = create_pixbuf("stock_new.png");
  GFileImage = create_pixbuf("file_image.png");
  GCDIcone = create_pixbuf("gnome-dev-cdrom.png");
  GAudioIcone = create_pixbuf("gnome-dev-cdrom-audio-24.png");
  GCDRWIcone = create_pixbuf("i-cdrom.png");
  GCDRWpetiteIcone = create_pixbuf("petitcdrw.png");
  GCDpetiteIcone = create_pixbuf("petitcd.png");
  GISOpetiteIcone = create_pixbuf("petitiso.png");
  GpetiteGraver = create_pixbuf("graver-petite.png");
  GGraver = create_pixbuf("graver.png");
  GEraseCdrw = create_pixbuf("erase-cdrw.png");

  Lwindow1 = manage_main_window (&Laudiolen, &Laudiomaxlen, &Ldatasize, &Ldatamaxsize);  
  gtk_main ();
  /* on libere avant de quitter */
  if (Lerror) g_error_free(Lerror);
  if (GTK_IS_WIDGET(Lwindow1)) {
    gtk_widget_destroy(Lwindow1);
  }

  g_object_unref(GEraseCdrw);
  g_object_unref(GGraver);
  g_object_unref(GISOpetiteIcone);
  g_object_unref(GpetiteGraver);
  g_object_unref(GCDRWpetiteIcone);
  g_object_unref(GCDRWIcone);
  g_object_unref(GAudioIcone);
  g_object_unref(GCDIcone);
  g_object_unref(GFileImage);
  g_object_unref(GFileIcone);
  g_object_unref(GDirIcone);

  return EXIT_SUCCESS;
}

/*
 * vim:et:ts=8:sts=2:sw=2
 */
