/* mkisofs.c
 * Copyright (C) 2004, 2005 Sylvain Cresto <scresto@gmail.com>
 *
 * This file is part of graveman!
 *
 * graveman! is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or
 * (at your option) any later version.
 * 
 * graveman! is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA. 
 * 
 * URL: http://www.nongnu.org/graveman/
 *
 */

#include "graveman.h"

/* communication avec mkisofs */

#define MKISOFS_ESTIMATE "done, estimate finish"
#define MKISOFS_ERROR "mkisofs:"
#define MKISOFS_IGNORE "-follow-links does not always"
#define MKISOFS_OK "Total translation table size"
#define MKISOFS_NOSPACE "No space left on device"
#define MKISOFS_SUPPORT_ISOV2 "Set ISO9660 conformance level (1..3) or 4 for ISO9660 version 2"

/* on verifie si le support iso9660 version 2 est disponnible ou non */
gboolean check_mkisofs()
{
  gchar *Lmkisofs = conf_get_string("mkisofs");
  gchar *Lcommandline, *Lerr = NULL;
  gboolean Lstatus;
  gint Lexit = 0;
  if (!Lmkisofs || !*Lmkisofs) return FALSE;

  Lcommandline = g_strdup_printf("%s -help", conf_get_string("mkisofs"));
  Lstatus = g_spawn_command_line_sync(Lcommandline, NULL, &Lerr, &Lexit, NULL);
  g_free(Lcommandline);

  Lstatus = (Lstatus == TRUE && Lerr && ((strstr(Lerr, MKISOFS_SUPPORT_ISOV2))));
  g_free(Lerr);

  return Lstatus;
}

/* recherche les parametres supplementaires a passer a mkisofs */
gchar *make_image_getextrapara(GHashTable *Ahash, gchar *Aop)
{
  const gchar *Ldatavoli = gtk_entry_get_text(GTK_ENTRY(sc_hash_table_lookupv(Ahash, "%svoli", Aop)));
  const gchar *Ldatapubl = gtk_entry_get_text(GTK_ENTRY(sc_hash_table_lookupv(Ahash, "%spubl", Aop)));
  const gchar *Ldataprep = gtk_entry_get_text(GTK_ENTRY(sc_hash_table_lookupv(Ahash, "%sprep", Aop)));
  const gchar *Ldatabibl = gtk_entry_get_text(GTK_ENTRY(sc_hash_table_lookupv(Ahash, "%sbibl", Aop)));
  const gchar *Ldatacopy = gtk_entry_get_text(GTK_ENTRY(sc_hash_table_lookupv(Ahash, "%scopy", Aop)));
  const gchar *Ldataabst = gtk_entry_get_text(GTK_ENTRY(sc_hash_table_lookupv(Ahash, "%sabst", Aop)));
  gchar *Lreturn;
  gchar *Lextra = NULL;
  GtkTextIter Lstart, Lend;
  GtkTextBuffer *Lbufappi = gtk_text_view_get_buffer (GTK_TEXT_VIEW (sc_hash_table_lookupv(Ahash, "%sappi", Aop)));
  char *Ldataappi, *Ltmpappi;
  gtk_text_buffer_get_bounds (Lbufappi, &Lstart, &Lend);
  Ltmpappi = gtk_text_iter_get_text (&Lstart, &Lend);
  Ldataappi = g_strescape(Ltmpappi, "");
  g_free(Ltmpappi);

  if (!strcmp(Aop, "data")) { /* data cd */
    gboolean Lrockridge = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(g_hash_table_lookup(Ahash, "datarockridge")));
    gboolean Ljoliet = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(g_hash_table_lookup(Ahash, "datajoliet")));
    gchar *Lisolevel = get_combo_value(g_hash_table_lookup(Ahash, "dataisolevel"));

    Lextra = g_strdup_printf("%s %s -iso-level %s", Lrockridge == TRUE ? "-r" : "", Ljoliet ? "-J" : "", Lisolevel);
    g_free(Lisolevel);
  } else {  /* data dvd */
    Lextra = g_strdup("-R -J");
  }

  Lreturn = g_strdup_printf("-V \"%s\" -A \"%s\" -publisher \"%s\" -p \"%s\" -biblio \"%s\" -copyright \"%s\" "
            "-abstract \"%s\" %s",
            _NN(Ldatavoli), _NN(Ldataappi), _NN(Ldatapubl), _NN(Ldataprep), _NN(Ldatabibl), _NN(Ldatacopy),
            _NN(Ldataabst), Lextra);
  g_free(Lextra);

  return Lreturn;
}

gboolean mkisofs_makeimage_callback(GIOChannel *Astd, GIOCondition Acond, gpointer Adata)
{
  GIOStatus Lstatus;
  GHashTable *Lhash = (GHashTable *)Adata;
  gint *Lcont = (gint *) g_hash_table_lookup(Lhash, "cont"); /* on traite encore des donnees ? */
  GError **Lerreur = (GError **) g_hash_table_lookup(Lhash, "gerror"); /* pointeur erreur */
  gint *Ltodo = (gint *) g_hash_table_lookup(Lhash, "todo"); /* nombre de piste a traiter */
  gint *Ldone = (gint *) g_hash_table_lookup(Lhash, "done"); /* nombre de piste deja traite */
  GtkProgressBar *Lprogressbar = GTK_PROGRESS_BAR(g_hash_table_lookup(Lhash, "pb_total"));
  GtkProgressBar *Lprogressbar2 = GTK_PROGRESS_BAR(g_hash_table_lookup(Lhash, "pb_step"));
  gchar *Lbuffer = NULL, *f, *Ltxt; 
  gdouble Lpct, Ltava;
  gchar Lsbuf[100], Lsbuf2[100];

  /* fin du callback lorsque l'on recoi un signal comme quoi le pipe est ferme */
  if (Acond == G_IO_HUP || Acond == G_IO_ERR) {
    *Lcont = 0;
    return FALSE;
  }
  Lstatus = g_io_channel_read_line(Astd, &Lbuffer, NULL, NULL, NULL);    
  if (!Lbuffer || Lstatus == G_IO_STATUS_ERROR || Lstatus == G_IO_STATUS_AGAIN) return FALSE;
_DEB("on recoi => '%s'\n", Lbuffer);

  if ((strstr(Lbuffer, MKISOFS_ESTIMATE)) && Lbuffer[3]=='.') {
    Lbuffer[3]=0;
    f=ltrim(Lbuffer);

    /* avancement tache */
    Lpct = 0.01 * atof(f);
    gtk_progress_bar_set_fraction(Lprogressbar2, Lpct);
    g_snprintf(Lsbuf, sizeof(Lsbuf)-1, "%s%%", f);
    gtk_progress_bar_set_text(Lprogressbar2, Lsbuf);
    /* avancement total */
    Ltava = (1.0 / (*Ltodo)) * ((*Ldone)-1+Lpct);
    gtk_progress_bar_set_fraction(Lprogressbar, Ltava);
    g_snprintf(Lsbuf2, sizeof(Lsbuf2)-1, "%.0f%%", Ltava*100);
    gtk_progress_bar_set_text(Lprogressbar, Lsbuf2);
  } else if ((strstr(Lbuffer, MKISOFS_ERROR)) && (!strstr(Lbuffer, MKISOFS_IGNORE))) {
    *Lcont = 0;

    if (!strstr(Lbuffer, MKISOFS_NOSPACE)) {
      Ltxt = _UTF8(Lbuffer);
    } else {
      Ltxt = g_strdup(_("Not enough free disk space to create iso image !"));
    }
    g_set_error(Lerreur, GRAVEMAN_ERROR, _ERR_MKISOFS, Ltxt);
    g_free(Ltxt);
    return FALSE;
  } else if (!strncmp(Lbuffer, MKISOFS_OK, strlen(MKISOFS_OK))) {
    gboolean *Lopstatus = (gboolean *) g_hash_table_lookup(Lhash, "operationstatus");
    /* ok tout s'est bien passe ! */
    gtk_progress_bar_set_fraction(Lprogressbar2, 1);
    gtk_progress_bar_set_text(Lprogressbar2, "100%");
    Ltava = (1.0 / (*Ltodo)) * (*Ldone);
    gtk_progress_bar_set_fraction(Lprogressbar, Ltava);
    g_snprintf(Lsbuf2, sizeof(Lsbuf2)-1, "%.0f%%", Ltava*100);
    gtk_progress_bar_set_text(Lprogressbar, Lsbuf2);
    *Lcont = 0;
    *Lopstatus = TRUE;
  }

  return TRUE;
}

/* creation image iso */
gboolean make_iso(GHashTable *Ahash, GError **Aerror)
{
  gboolean Lstatus = FALSE;
  gchar **Lcmd;
  gchar *Lcommandline;
  GIOChannel *Lcomerr, *Lcom;
  guint Lcomerrevent, Lcomevent;
  gint *Lcont = (gint *)g_hash_table_lookup(Ahash, "cont");
  gboolean *Labort = (gboolean *) g_hash_table_lookup(Ahash, "gabort");
  gchar **Ltmpdir = (gchar **)g_hash_table_lookup(Ahash, "tmpdir");
  gchar **Lextrapara = (gchar **)g_hash_table_lookup(Ahash, "extrapara");
  gint *Lpid = (gint *) g_hash_table_lookup(Ahash, "pid");
  gint *Ldone = (gint *)g_hash_table_lookup(Ahash, "done"); /* fais */
  gchar **Liso = (gchar **)g_hash_table_lookup(Ahash, "iso"); /* image iso */
  gboolean *Loperationstatus = (gboolean *)g_hash_table_lookup(Ahash, "operationstatus");
  GtkLabel *Ltitle = GTK_LABEL(g_hash_table_lookup(Ahash, "gravetitle"));
  gint g_out, g_err, Lnbrarg;

  *Loperationstatus = FALSE;
  gtk_label_set_text(Ltitle, _("Writing image..."));

  Lcommandline = g_strdup_printf("%s -f %s %s -o %s %s", conf_get_string("mkisofs"), *Lextrapara,
      conf_get_string("mkisofspara"), *Liso, *Ltmpdir);

  _DEB("execution [%s]\n", Lcommandline);
  Lstatus = g_shell_parse_argv(Lcommandline, &Lnbrarg, &Lcmd, Aerror);
  _DEB("nbr arg [%d]\n", Lnbrarg);
  g_free(Lcommandline);
  if (Lstatus == FALSE) {
    return FALSE;
  }

  Lstatus = g_spawn_async_with_pipes(NULL, Lcmd, NULL, /* env argument */
    (GSpawnFlags ) (G_SPAWN_DO_NOT_REAP_CHILD),
     NULL, NULL, Lpid, NULL, &g_out, &g_err, Aerror);
  g_strfreev(Lcmd);

  if (Lstatus == FALSE) {
    g_warning("ERROR EXECUTION !\n");
    return FALSE;
  }

  Lcom = g_io_channel_unix_new( g_out );
  g_io_channel_set_encoding (Lcom, NULL, NULL);
  g_io_channel_set_flags( Lcom, G_IO_FLAG_NONBLOCK, NULL );
  Lcomevent = g_io_add_watch (Lcom, (G_IO_IN | G_IO_HUP | G_IO_ERR | G_IO_PRI),
                                      mkisofs_makeimage_callback, Ahash);

  Lcomerr = g_io_channel_unix_new( g_err );
  g_io_channel_set_encoding (Lcomerr, NULL, NULL);
  g_io_channel_set_flags( Lcomerr, G_IO_FLAG_NONBLOCK, NULL );
  Lcomerrevent = g_io_add_watch (Lcomerr, (G_IO_IN | G_IO_HUP | G_IO_ERR | G_IO_PRI),
                                      mkisofs_makeimage_callback, Ahash); 
_DEB("debut !!");
  while (*Lcont > 0 && *Labort == FALSE) {
   gtk_main_iteration();
  }
  exit_prog(*Lpid, *Labort, Aerror, NULL);

_DEB("fin !!");

  g_source_remove(Lcomerrevent);
  g_source_remove(Lcomevent);

  /* fermeture mkisofs */
  g_io_channel_shutdown(Lcomerr, FALSE, NULL);
  g_io_channel_unref(Lcomerr);  
  g_io_channel_shutdown(Lcom, FALSE, NULL);
  g_io_channel_unref(Lcom);
  g_spawn_close_pid(*Lpid);
  *Lpid = 0;

  if (*Aerror) {
    return FALSE;
  }

  (*Ldone)++;
  return TRUE;  
}

/*
 * vim:et:ts=8:sts=2:sw=2
 */
