/* interface.c
 * Copyright (C) 2004, 2005 Sylvain Cresto <scresto@gmail.com>
 * 
 * This file is part of graveman!
 *
 * graveman! is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or
 * (at your option) any later version.
 * 
 * graveman! is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA. 
 * 
 * URL: http://www.nongnu.org/graveman/
 *
 */

/* definition des fenetres */

#include "graveman.h"
/* drag and drop */

enum {
  TARGET_URI_LIST,
  TARGET_STRING
};

GtkTargetEntry Gdndaudio[] = { {"text/uri-list", 0, TARGET_URI_LIST } };
GtkTargetEntry Gdnddata[] = { {"text/uri-list", 0, TARGET_URI_LIST } };

/* liste des medias */
GSList *Gmedialist = NULL;

#if 0
Tmediaentry Gdefaultmedia[] = {
  { 665600, N_("74 min"), N_("650 mb") },
  { 716800, N_("80 min"), N_("700 mb") },
  { 808960, N_("90 min"), N_("790 mb") },
  { 889856, N_("99 min"), N_("869 mb") },
  { 899072, N_("100 min"), N_("878 mb") },
  { 0, "", "" },
};
#endif

static Tmyentry Gtypecdaudio[] = {
  { "1260", N_("21 min"), FALSE, 0 },
  { "1380", N_("23 min"), FALSE, 0 },
  { "4440", N_("74 min"), FALSE, 0 },
  { "4800", N_("80 min"), TRUE, 0 },
  { "5400", N_("90 min"), FALSE, 0 },
  { "5940", N_("99 min"), FALSE, 0 },
  { "6000", N_("100 min"), FALSE, 0 },
  { NULL }
};

static Tmyentry Gtypecddata[] = {
  { "180", N_("180 mb"), FALSE, 0 },
  { "202", N_("202 mb"), FALSE, 0 },
  { "650", N_("650 mb"), FALSE, 0 },
  { "700", N_("700 mb"), TRUE, 0 },
  { "790", N_("790 mb"), FALSE ,0 },
  { "869", N_("869 mb"), FALSE, 0 },
  { "878", N_("878 mb"), FALSE, 0 },
  { NULL }
};

static Tmyentry Gtypedvddata[] = {
  { "4482", N_("4.7 gb"), TRUE, 0 },
  { "8964", N_("9.4 gb"), FALSE, 0 },
  { NULL }
};

static Tmyentry Gtypeicosize[] = {
  { "16", N_("16x16 px"), FALSE, 0 },
  { "24", N_("24x24 px"), FALSE, 0 },
  { "32", N_("32x32 px"), FALSE, 0 },
  { "48", N_("48x48 px"), FALSE, 0 },
  { NULL }
};

/*
static Tmyentry Gtypeunit[] = {
  { "kb", N_("kb"), TRUE },
  { "mb", N_("mb"), FALSE },
  { "gb", N_("gb"), FALSE },
};*/

static Tmyentry Gmodburn[] = {
    { "dao", N_("Disk At Once - DAO (default)"), TRUE, 0 },
    { "tao", N_("Track At Once  - TAO"), FALSE, 0 },
    { "raw96r", N_("RAW writing - raw96r"), FALSE, 0 },
    { "raw96", N_("RAW writing - raw96"), FALSE, 0 },
    { "raw96p", N_("RAW writing - raw96p"), FALSE, 0 },
    { NULL }
  };

static Tmyentry Gisolevel[] = {
  { "1", N_("ISO 9660 level 1"), FALSE, 0 },
  { "2", N_("ISO 9660 level 2 (default)"), TRUE, 0 },
  { "3", N_("ISO 9660 level 3"), FALSE, 0 },
  { "4", N_("ISO 9660 version 2"), FALSE, 1 },
  { NULL }
};

static Tmyentry Gformatcd[] = {
    { "data", N_("CD-Rom Mode 1 (default)"), TRUE, 0 },
    { "mode2", N_("CD-Rom Mode 2"), FALSE, 0 },
    { "xa1", N_("CD-Rom XA Mode 1"), FALSE, 0 },
    { "xa2", N_("CD-Rom XA Mode 2"), FALSE, 0 },
    { NULL }
  };

void remplire_combo_vitesse(GtkComboBox *Acombo, gchar *Alecident, gchar *Aselvalue)
{
  GtkListStore *Ldata = GTK_LIST_STORE(gtk_combo_box_get_model(Acombo));
  const gchar *Lname = glade_get_widget_name(GTK_WIDGET(Acombo));
  gchar *Llabel, *Lident;  
  gint i;
  gint passe = 0;
  GtkTreeIter Liter;
  gint Lmaxspeed = MAX_SPEED;
  gboolean Lselok = FALSE;
  gboolean Lisdvd = FALSE;

  

  if (Alecident && *Alecident) {
    Tdriveinfo *Lundrive = find_drive(Alecident);

    if (strstr(Lname, "dvd")) Lisdvd = TRUE;
    Lmaxspeed = Lisdvd ? Lundrive->vitessedvd : Lundrive->vitesse;
  }

  gtk_list_store_clear(Ldata);

  for (i=1; 1; i++) {
    if (!Lisdvd) {
      passe = ! passe;
      if (passe) continue;
    }
    Llabel = g_strdup_printf("%dx", i);
    Lident = g_strdup_printf("%d", i);    
    gtk_list_store_append(Ldata, &Liter);
    gtk_list_store_set(Ldata, &Liter, 0, Lident, 1, Llabel, -1);

    if (Aselvalue && *Aselvalue && Lselok == FALSE) {
      if (!strcmp(Lident, Aselvalue)) {
        gtk_combo_box_set_active_iter(Acombo, &Liter);
        Lselok = TRUE;
      }
    }

    g_free(Llabel); g_free(Lident);
    
    if (i >= Lmaxspeed) break;
  }

  gtk_list_store_append(Ldata, &Liter);
  gtk_list_store_set(Ldata, &Liter, 0, "0", 1, _("Full speed"), -1);
  
  if (Lselok == FALSE) gtk_combo_box_set_active_iter(Acombo, &Liter);
}

void remplirecombo_full (GtkComboBox *Acombo, gchar *Abasename, Tmyentry *Aentry, gboolean Adoinit, gchar *Aselvalue, gint Afiltre)
{
  GtkListStore *Ldata;
  gchar *Lident;
  Tmyentry *Lcurentry;
  GtkTreeIter Liter;
  gboolean Lselok = FALSE;

  if (Adoinit == FALSE) {
    Ldata = GTK_LIST_STORE(gtk_combo_box_get_model(Acombo));
  } else {
    GtkCellRenderer *Lcellrender;

    Ldata = gtk_list_store_new(2, G_TYPE_STRING, G_TYPE_STRING);  
    gtk_combo_box_set_model(Acombo, GTK_TREE_MODEL(Ldata));

    gtk_cell_layout_clear(GTK_CELL_LAYOUT(Acombo));
    Lcellrender = GTK_CELL_RENDERER(gtk_cell_renderer_text_new());
    gtk_cell_layout_pack_start(GTK_CELL_LAYOUT(Acombo), Lcellrender, TRUE);
    gtk_cell_layout_set_attributes(GTK_CELL_LAYOUT(Acombo), Lcellrender,
      "text", 1, NULL);
  }

  gtk_list_store_clear(Ldata);
  
  for (Lcurentry = Aentry; Lcurentry->label; Lcurentry++) {
    if (Afiltre > -1 && Lcurentry->filtre > Afiltre) continue;
    
    Lident = g_strdup_printf("%s%s", Abasename, Lcurentry->basecode);
    gtk_list_store_append(Ldata, &Liter);
    gtk_list_store_set(Ldata, &Liter, 0, Lident, 1, _(Lcurentry->label), -1); 

    if (!Aselvalue || !*Aselvalue) {
      if (Lcurentry->defaut == TRUE) {
        gtk_combo_box_set_active_iter(Acombo, &Liter);
        Lselok = TRUE;
      }
    } else {
      if (!strcmp(Aselvalue, Lident)) { 
        gtk_combo_box_set_active_iter(Acombo, &Liter);
        Lselok = TRUE;
      }
    }
    g_free(Lident);
  }

  /* si pas de selection alors on met le premier par defaut */
  if (Lselok == FALSE) gtk_combo_box_set_active(Acombo, 0);
}

void remplirecombograveur(GtkComboBox *Acombo, gint Aquoi, gchar *Aselvalue)
{
  GtkListStore *Ldata = GTK_LIST_STORE(gtk_combo_box_get_model(Acombo));
  GtkTreeIter Liter;
  GSList *Lcur;
  Tdriveinfo *Ldrive;
  gint i;
  gboolean Lselok = FALSE;
  gchar *Lcurdrive;

  gtk_list_store_clear(Ldata);
 
  for (Lcur = Glistdrives, i=0; Lcur; Lcur = g_slist_next(Lcur), i++) { 
    Ldrive = (Tdriveinfo *)Lcur->data;
    if ((Aquoi & TYPE_ALLWRITER) && (! DRIVE_WRITER(Ldrive))) continue;
    if ((Aquoi & TYPE_DVDWRITER) && (! DRIVE_DVDWRITER(Ldrive))) continue;
    
    gtk_list_store_append(Ldata, &Liter);

    Lcurdrive =g_slist_nth_data(Ldrive->dev, Ldrive->actuperiph);
    
    gtk_list_store_set(Ldata, &Liter, 0, Lcurdrive, 1, 
      DRIVE_ICONE(Ldrive), 2, Ldrive->name, 3, i, -1);
    
    if (Aselvalue && *Aselvalue && Lselok==FALSE) {
      if (!strcmp(Aselvalue, Lcurdrive)) { 
        gtk_combo_box_set_active_iter(Acombo, &Liter); 
        Lselok = TRUE;
      }
    }
  }
  
  if (Aquoi & TYPE_ISO) { 
    gtk_list_store_append(Ldata, &Liter);
    gtk_list_store_set(Ldata, &Liter, 0, "iso", 1, GISOpetiteIcone, 2, _("ISO file..."), 3, -1, -1);

    if (Aselvalue && Lselok==FALSE && !strcmp(Aselvalue, "iso")) {
      gtk_combo_box_set_active_iter(Acombo, &Liter); 
      Lselok = TRUE;
    }
  }

/* si pas de selection alors on met le premier par defaut */
  if (Lselok == FALSE) gtk_combo_box_set_active(Acombo, 0);
}

void remplirelistegraveur(GtkTreeView *Aliste)
{
  GtkListStore *Ldata = GTK_LIST_STORE(gtk_tree_view_get_model(Aliste));
  GtkTreeIter Liter;
  gint i;
  gchar Llabeldevice[50];
  GSList *Lcur;
  Tdriveinfo *Ldrive;

  gtk_list_store_clear(Ldata);

  for (Lcur = Glistdrives, i=0; Lcur; Lcur = g_slist_next(Lcur), i++) {
    Ldrive = (Tdriveinfo *)Lcur->data;

    gtk_list_store_append(Ldata, &Liter);

    put_devicelabel(Ldrive, Llabeldevice, sizeof(Llabeldevice)-1);
    gtk_list_store_set(Ldata, &Liter, 0, i, 1, DRIVE_ICONE(Ldrive), 2,
          (gchar *)g_slist_nth_data(Ldrive->dev, Ldrive->actuperiph), 3, 
          Llabeldevice, 4, Ldrive->name, -1);
  }
}

#if 0
void remplirelistemedia(GtkTreeView *Aliste)
{
  GtkListStore *Ldata = GTK_LIST_STORE(gtk_tree_view_get_model(Aliste));
  GtkTreeIter Liter;
  GSList *Lcur;
  Tmediaentry *Lcurmedia;

  gtk_list_store_clear(Ldata);

  for (Lcur = Gmedialist; Lcur; Lcur = g_slist_next(Lcur)) {
    Lcurmedia = (Tmediaentry *)Lcur->data;
    gtk_list_store_append(Ldata, &Liter);
    gtk_list_store_set(Ldata, &Liter, 0, Lcurmedia->labeldata, 1, Lcurmedia->labelaudio, -1);
  }
}
#endif
/* menu popup sur les lecteurs/graveurs */
GtkMenu *create_gtkpopupmenudevices(GtkWidget *Aliste, GHashTable *Ahash)
{
  GtkMenu *Lmenu = GTK_MENU(g_hash_table_lookup(Ahash, "popupdevices"));
  GtkWidget *Litem;
  GtkTreePath *Lpath = NULL;

  /* on cherche l'object selectionne, on est pas sur qu'il y en ai un car
   * il n'y a pas forcement de peripheriques de detect */
  gtk_tree_view_get_cursor(GTK_TREE_VIEW(Aliste), &Lpath, NULL);

  Litem = GTK_WIDGET(g_hash_table_lookup(Ahash, "popupdevices_edit"));
  gtk_widget_set_sensitive(Litem, Lpath ? TRUE : FALSE);
  Litem = GTK_WIDGET(g_hash_table_lookup(Ahash, "popupdevices_remove"));
  gtk_widget_set_sensitive(Litem, Lpath ? TRUE : FALSE);

  if (Lpath) gtk_tree_path_free(Lpath);

  return Lmenu;
}

/* menu popup sur le formatage d'un dvd */
GtkMenu *create_gtkpopupmenuformatdvd(GHashTable *Ahash)
{
  GtkMenu *Lmenu = GTK_MENU(g_hash_table_lookup(Ahash, "popupformatdvd"));

  return Lmenu;
}

/* menu popup sur les pistes audio */
GtkMenu *create_gtkpopupmenuaudio(GtkWidget *Aliste, GHashTable *Ahash)
{
  GtkMenu *Lmenu = GTK_MENU(g_hash_table_lookup(Ahash, "popupaudio"));
  GtkWidget *Litem;
  GtkTreePath *Lpath = NULL;

  /* on cherche l'object selectionne, on est pas sur qu'il y en ai un car
   * on est en SELECTION_MULTIPLE */
  gtk_tree_view_get_cursor(GTK_TREE_VIEW(Aliste), &Lpath, NULL);

  Litem = GTK_WIDGET(g_hash_table_lookup(Ahash, "popupaudio_removetrack"));
  if (Lpath) {
    gtk_widget_set_sensitive(Litem, TRUE);
  } else {
    gtk_widget_set_sensitive(Litem, FALSE);
  }

  if (Lpath) gtk_tree_path_free(Lpath);
   
  return Lmenu;
}

/* creation popup "affichage" */
GtkMenu *create_gtkpopupmenudisplay(GtkWidget *Aliste, GHashTable *Ahash)
{
  GtkMenu *Lmenu = GTK_MENU(g_hash_table_lookup(Ahash, "popupdisplay"));
  gboolean Ldispsb = conf_get_boolean("statusbar");
  GtkWidget *Litem, *Litem2;
  

  Litem = g_hash_table_lookup(Ahash, "popupdisp_showstatusbar");
  Litem2 = g_hash_table_lookup(Ahash, "popupdisp_hidestatusbar");
  if (Ldispsb) {
    gtk_widget_hide(Litem);
    gtk_widget_show(Litem2);
  } else {
    gtk_widget_show(Litem);
    gtk_widget_hide(Litem2);
  }

  Litem = sc_hash_table_lookupv(Ahash, "popupdisp_iconsize_%s", conf_get_string("iconsize"));
  if (GTK_IS_WIDGET(Litem)) gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(Litem), TRUE);
  
  return Lmenu;
}

/* creation popup "cd/dvd data" */
GtkMenu *create_gtkpopupmenudata(GtkWidget *Aliste, GHashTable *Ahash)
{
  GtkMenu *Lmenu = GTK_MENU(g_hash_table_lookup(Ahash, "popupdata"));
  GtkTreeModel *Lmodel = gtk_tree_view_get_model(GTK_TREE_VIEW(Aliste));
  GtkWidget *Litem, *Litem2, *Lsep;
  GtkTreeSelection *Lselection = gtk_tree_view_get_selection(GTK_TREE_VIEW(Aliste));
  GtkTreeIter Liter;
  gint type;
  gint Lnumsel = gtk_tree_selection_count_selected_rows(Lselection);
  gboolean Lonlyone = TRUE;
  const gchar *Llistename = glade_get_widget_name(Aliste);
  GtkTreePath *Lpath = NULL;

  /* on cherche l'object selectionne, il peu y en avoir plusieur
   * car on est en SELECTION_MULTIPLE */

  /* focus sur le premier element si pas de focus */
  if (!Lnumsel) {
    if (!gtk_tree_model_get_iter_first(Lmodel, &Liter)) return NULL;

    gtk_tree_selection_select_iter(Lselection, &Liter);
    gtk_widget_grab_focus(Aliste);
  } else {
    /* si plusieurs elements de selectionne alors on pointe sur celui etant
     * sous le curseur */
    gtk_tree_view_get_cursor(GTK_TREE_VIEW(Aliste), &Lpath, NULL);
    if (!Lpath) {
      gtk_widget_grab_focus(Aliste);
      gtk_tree_view_get_cursor(GTK_TREE_VIEW(Aliste), &Lpath, NULL);
      if (!Lpath) return NULL;
    }
    gtk_tree_model_get_iter(Lmodel, &Liter, Lpath);
    gtk_tree_path_free(Lpath);

    Lonlyone = (Lnumsel == 1 ? TRUE : FALSE);
  }

  
  /* type nous permet de savoir le type de ligne selectionne (CD, DIR, FILE...) */
  gtk_tree_model_get(Lmodel, &Liter, 0, &type, -1);

  /* RENOMMER LE CD */
  Litem = g_hash_table_lookup(Ahash, "popupdata_renamecd");
  Litem2 = g_hash_table_lookup(Ahash, "popupdata_renamedvd");
  if (!strcmp(Llistename, "LISTEDVDDATA")) {
    if (type == TYPE_CD && Lonlyone) {
      gtk_widget_show(Litem2);
    } else {
      gtk_widget_hide(Litem2);
    } 
    gtk_widget_hide(Litem);
  } else {
    if (type == TYPE_CD && Lonlyone) {
      gtk_widget_show(Litem);
    } else {
      gtk_widget_hide(Litem);
    }
    gtk_widget_hide(Litem2);
  }

  /* EXPAND */
  Litem = g_hash_table_lookup(Ahash, "popupdata_expand");
  if (type != TYPE_FILE && Lonlyone) {
    gtk_widget_show (Litem);
  } else {
    gtk_widget_hide(Litem);
  }

  /* RENOMMER L'ELEMENT SELECTIONNE */
  Litem = g_hash_table_lookup(Ahash, "popupdata_renamedirectory");
  if (type == TYPE_DIR && Lonlyone) {
    gtk_widget_show (Litem);
  } else {
    gtk_widget_hide (Litem);
  }
  Litem = g_hash_table_lookup(Ahash, "popupdata_renamefile");
  if (type == TYPE_FILE && Lonlyone) {
    gtk_widget_show (Litem);
  } else {
    gtk_widget_hide (Litem);
  }

  /* CREER UN REPERTOIRE */
  Litem = g_hash_table_lookup(Ahash, "popupdata_createdirectory");
  if (type != TYPE_FILE && Lonlyone) {
    gtk_widget_show (Litem);
  } else {
    gtk_widget_hide (Litem);
  }

  /* AJOUTER DES FICHIERS */
  /* AJOUTER DES REPERTOIRES */
  Lsep = g_hash_table_lookup(Ahash, "popupdata_sep1");
  Litem = g_hash_table_lookup(Ahash, "popupdata_addfile");
  Litem2 = g_hash_table_lookup(Ahash, "popupdata_adddirectory");
  if (type != TYPE_FILE && Lonlyone) {
    gtk_widget_show (Lsep);
    gtk_widget_show (Litem);
    gtk_widget_show (Litem2);
  } else {
    gtk_widget_hide (Lsep);
    gtk_widget_hide (Litem);
    gtk_widget_hide (Litem2);
  }

  /* SUPPRIMER DE LA LISTE */
  Lsep = g_hash_table_lookup(Ahash, "popupdata_sep2");
  Litem = g_hash_table_lookup(Ahash, "popupdata_remove");
  if (type != TYPE_CD) {
    if (Lonlyone) {
      gtk_widget_show (Lsep);
    } else {
      gtk_widget_hide (Lsep);
    }
    gtk_widget_set_sensitive(Litem, TRUE);
    gtk_widget_show (Litem);

    /* suppresion des fichiers */
  } else {
    gtk_widget_hide (Lsep);
    if (Lonlyone) {
      gtk_widget_hide (Litem);
    } else {
      /* si plusieurs elements de selectionne mais que le focus
       * est sur le CD alors on affiche quand meme l'action "suppresion
       * des fichiers" dans le popup en la grisant pour que le popup
       * ne soit pas entierement vide */
      gtk_widget_set_sensitive(Litem, FALSE);
      gtk_widget_show (Litem);
    }
  }

  /* IMAGE DE BOOT */
/*  Lsep = g_hash_table_lookup(Ahash, "popupdata_sep3");
  Litem = g_hash_table_lookup(Ahash, "popupdata_imageboot");
  if (type == TYPE_FILE) {
    gtk_widget_show (Lsep);
    gtk_widget_show (Litem);

  } else {
    gtk_widget_hide (Lsep);
    gtk_widget_hide (Litem);
  }*/

  return Lmenu;
}

void prepare_popups(GladeXML *Axml, GHashTable *Ahash)
{
  /* popup cd audio */
  glade_to_hash(Axml, Ahash, "popupaudio");
  g_signal_connect(G_OBJECT(glade_to_hash(Axml, Ahash, "popupaudio_addtrack")),
      "activate", G_CALLBACK(gtk_audio_addtrack), Ahash);
  g_signal_connect(G_OBJECT(glade_to_hash(Axml, Ahash, "popupaudio_removetrack")),
      "activate", G_CALLBACK(gtk_audio_removetrack), Ahash);

  /* popup cd data */
  glade_to_hash(Axml, Ahash, "popupdata");
  g_signal_connect(G_OBJECT(glade_to_hash(Axml, Ahash, "popupdata_renamecd")),
      "activate", G_CALLBACK(gtk_data_renommerelement), Ahash);
  g_signal_connect(G_OBJECT(glade_to_hash(Axml, Ahash, "popupdata_renamedvd")),
      "activate", G_CALLBACK(gtk_data_renommerelement), Ahash);

  g_signal_connect(G_OBJECT(glade_to_hash(Axml, Ahash, "popupdata_expand")),
      "activate", G_CALLBACK(gtk_data_expandelement), Ahash);
  g_signal_connect(G_OBJECT(glade_to_hash(Axml, Ahash, "popupdata_renamefile")),
      "activate", G_CALLBACK(gtk_data_renommerelement), Ahash);
  g_signal_connect(G_OBJECT(glade_to_hash(Axml, Ahash, "popupdata_renamedirectory")),
      "activate", G_CALLBACK(gtk_data_renommerelement), Ahash);
  g_signal_connect(G_OBJECT(glade_to_hash(Axml, Ahash, "popupdata_createdirectory")),
      "activate", G_CALLBACK(gtk_data_creerrepertoire), Ahash);
  glade_to_hash(Axml, Ahash, "popupdata_sep1");
  g_signal_connect(G_OBJECT(glade_to_hash(Axml, Ahash, "popupdata_addfile")),
      "activate", G_CALLBACK(gtk_data_addfile), Ahash);
  g_signal_connect(G_OBJECT(glade_to_hash(Axml, Ahash, "popupdata_adddirectory")),
      "activate", G_CALLBACK(gtk_data_adddirectory), Ahash);

  glade_to_hash(Axml, Ahash, "popupdata_sep2");
  g_signal_connect(G_OBJECT(glade_to_hash(Axml, Ahash, "popupdata_remove")),
      "activate", G_CALLBACK(gtk_data_removefiles), Ahash);

#if 0
  glade_to_hash(Axml, Ahash, "popupdata_sep3");
  g_signal_connect(G_OBJECT(glade_to_hash(Axml, Ahash, "popupdata_imageboot")),
      "activate", G_CALLBACK(gtk_def_imageboot), Ahash);
#endif

  /* popup affichage */
  glade_to_hash(Axml, Ahash, "popupdisplay");
  g_signal_connect(G_OBJECT(glade_to_hash(Axml, Ahash, "popupdisp_iconsize_48")),
      "activate", G_CALLBACK(gtk_display_updatesize), Ahash);
  g_signal_connect(G_OBJECT(glade_to_hash(Axml, Ahash, "popupdisp_iconsize_32")),
      "activate", G_CALLBACK(gtk_display_updatesize), Ahash);
  g_signal_connect(G_OBJECT(glade_to_hash(Axml, Ahash, "popupdisp_iconsize_24")),
      "activate", G_CALLBACK(gtk_display_updatesize), Ahash);
  g_signal_connect(G_OBJECT(glade_to_hash(Axml, Ahash, "popupdisp_iconsize_16")),
      "activate", G_CALLBACK(gtk_display_updatesize), Ahash);

  g_signal_connect(G_OBJECT(glade_to_hash(Axml, Ahash, "popupdisp_showstatusbar")),
      "activate", G_CALLBACK(gtk_display_switchstatusbar), Ahash);
  g_signal_connect(G_OBJECT(glade_to_hash(Axml, Ahash, "popupdisp_hidestatusbar")),
      "activate", G_CALLBACK(gtk_display_switchstatusbar), Ahash);

  /* popup formater un dvd */
  glade_to_hash(Axml, Ahash, "popupformatdvd");
  g_signal_connect(G_OBJECT(glade_to_hash(Axml, Ahash, "popupform_format")),
      "activate", G_CALLBACK(gtk_confirm_dvdoperation), Ahash);
  g_signal_connect(G_OBJECT(glade_to_hash(Axml, Ahash, "popupform_blank")),
      "activate", G_CALLBACK(gtk_confirm_dvdoperation), Ahash);
  g_signal_connect(G_OBJECT(glade_to_hash(Axml, Ahash, "popupform_blankfull")),
      "activate", G_CALLBACK(gtk_confirm_dvdoperation), Ahash);
}

GtkAlignment *new_seliso(gchar *Aname, GtkWidget *Aparent)
{
  GtkHBox *Lnewhbox = GTK_HBOX(gtk_hbox_new (FALSE, 3));
  GtkAlignment *Lnewboxalignement = GTK_ALIGNMENT(gtk_alignment_new (1, 0.5, 0, 0));
  GtkHBox *Lbtnbox = GTK_HBOX(gtk_hbox_new (FALSE, 2));
  GtkEntry *Lisoname = GTK_ENTRY(gtk_entry_new());
  GtkButton *Lbutton = GTK_BUTTON(gtk_button_new());
  GtkAlignment *Lalignement = GTK_ALIGNMENT(gtk_alignment_new (0.5, 0.5, 0, 0));
  GtkImage *Lbuttonimg;
  GtkLabel *Lbuttonlbl;
  gchar *Lentryname;

  gtk_widget_show (GTK_WIDGET(Lnewhbox));
  gtk_widget_show (GTK_WIDGET(Lbutton));
  gtk_widget_show (GTK_WIDGET(Lisoname));
  
  gtk_widget_show (GTK_WIDGET(Lalignement));
  gtk_container_add(GTK_CONTAINER(Lbutton), GTK_WIDGET(Lalignement));
  
  gtk_widget_show (GTK_WIDGET(Lbtnbox));
  gtk_container_add (GTK_CONTAINER (Lalignement), GTK_WIDGET(Lbtnbox));
  
  Lbuttonimg = GTK_IMAGE(gtk_image_new_from_stock("gtk-jump-to", GTK_ICON_SIZE_BUTTON));
  gtk_widget_show (GTK_WIDGET(Lbuttonimg));
  gtk_box_pack_start (GTK_BOX(Lbtnbox), GTK_WIDGET(Lbuttonimg), FALSE, FALSE, 0);
  Lbuttonlbl = GTK_LABEL(gtk_label_new_with_mnemonic (_("O_pen")));

  gtk_widget_show(GTK_WIDGET(Lbuttonlbl));
  gtk_box_pack_start (GTK_BOX(Lbtnbox), GTK_WIDGET(Lbuttonlbl), FALSE, FALSE, 0);

  gtk_container_add (GTK_CONTAINER (Lnewhbox), GTK_WIDGET(Lisoname));
  gtk_container_add (GTK_CONTAINER (Lnewhbox), GTK_WIDGET(Lbutton));

  gtk_container_add(GTK_CONTAINER(Lnewboxalignement), GTK_WIDGET(Lnewhbox));

  gtk_widget_set_name(GTK_WIDGET(Lbutton), Aname);
  g_signal_connect(G_OBJECT(Lbutton), "clicked", G_CALLBACK(gtk_file_sel), Lisoname);

  Lentryname = g_strdup_printf("%svalue", Aname);
  GLADE_HOOKUP_OBJECT(Aparent, GTK_WIDGET(Lisoname), Lentryname);
  g_free(Lentryname);

  return Lnewboxalignement;
}

/* fenetre principal */
GtkWidget* manage_main_window (guint64 *Aaudiolen, guint64 *Aaudiomaxlen,
    guint64 *Adatasize, guint64 *Adatamaxsize, guint64 *Advddatasize, guint64 *Advddatamaxsize)
{
  gchar *Ltemplate = PACKAGE_DATA_DIR "/" PACKAGE "/window_main.glade";
  GladeXML *Lxml = glade_xml_new(Ltemplate, NULL,NULL);
  GtkWidget *Lwindow;
  GtkNotebook *Lbodycdaudio, *Lbodycddata, *Lbodycdcopy, *Lbodycdother, *Lbodydvddata;
  GtkHBox *Lmainbody;
  GtkComboBox *Lcombo;
  GtkButton *Lbtnerasecdrw, *Lbtnformatdvdrw;
  GtkTreeView *Ltreeaudio, *Ltreedata, *Ltopmenu, *Ltreedvddata;
  GHashTable *Lhash = _hash();

  if (!Lxml) {
    g_error("Cannot load '%s': %s\n", Ltemplate, g_strerror(errno));
  }

  Lmainbody = GTK_HBOX(glade_xml_get_widget(Lxml, "mainbody"));
  Lwindow = GTK_WIDGET(glade_to_hash(Lxml, Lhash, "topwindow"));
  g_hash_table_insert(Lhash, "window", Lwindow);
  g_hash_table_insert(Lhash, "audiolen", Aaudiolen);
  g_hash_table_insert(Lhash, "audiomaxlen", Aaudiomaxlen);
  g_hash_table_insert(Lhash, "datasize", Adatasize);
  g_hash_table_insert(Lhash, "datamaxsize", Adatamaxsize);
  g_hash_table_insert(Lhash, "dvddatasize", Advddatasize);
  g_hash_table_insert(Lhash, "dvddatamaxsize", Advddatamaxsize);

  /* onglets page de droite */
  Lbodycdaudio = GTK_NOTEBOOK(glade_to_hash(Lxml, Lhash, "bodycdaudio"));
  gtk_widget_reparent(GTK_WIDGET(Lbodycdaudio), GTK_WIDGET(Lmainbody));
  Lbodycddata = GTK_NOTEBOOK(glade_to_hash(Lxml, Lhash, "bodycddata"));
  gtk_widget_reparent(GTK_WIDGET(Lbodycddata), GTK_WIDGET(Lmainbody));
  Lbodydvddata = GTK_NOTEBOOK(glade_to_hash(Lxml, Lhash, "bodydvddata"));
  gtk_widget_reparent(GTK_WIDGET(Lbodydvddata), GTK_WIDGET(Lmainbody));
  Lbodycdcopy = GTK_NOTEBOOK(glade_to_hash(Lxml, Lhash, "bodycdcopy"));
  gtk_widget_reparent(GTK_WIDGET(Lbodycdcopy), GTK_WIDGET(Lmainbody));
  Lbodycdother = GTK_NOTEBOOK(glade_to_hash(Lxml, Lhash, "bodycdother"));
  gtk_widget_reparent(GTK_WIDGET(Lbodycdother), GTK_WIDGET(Lmainbody));
  g_hash_table_replace(Lhash, "_lstclicked", Lbodycdaudio);

  /* mise a jour des label lorsque l'on change d'onglet dans la partie "graver un cd de donnee" */
  g_signal_connect(G_OBJECT(Lbodycddata), "switch-page", G_CALLBACK(switchpage), Lhash);
  /* mise a jour des label lorsque l'on change d'onglet dans la partie "graver un dvd de donnee" */
  g_signal_connect(G_OBJECT(Lbodydvddata), "switch-page", G_CALLBACK(switchpage), Lhash);

  /* bouttons barre de gauche */
  Ltopmenu = GTK_TREE_VIEW(glade_to_hash(Lxml, Lhash, "topmenu"));
  glade_to_hash(Lxml, Lhash, "statusbar");

  glade_to_hash(Lxml, Lhash, "dataisolevel");
  manage_interface(Lhash, MENU_NEW + COMBO_UPDATE);
  update_status_bar_display(Lhash);

  g_signal_connect(G_OBJECT(Ltopmenu), "button-press-event", G_CALLBACK(gtk_do_eventbuttonpress), Lhash);
  g_signal_connect(G_OBJECT(Ltopmenu), "popup-menu", G_CALLBACK(key_popupmenu_display), Lhash);


  /* signaux sur le menu */
  g_signal_connect(G_OBJECT(glade_xml_get_widget(Lxml, "menustartnew")), "activate",
      G_CALLBACK(menu_start_new), Lhash);

  g_signal_connect(G_OBJECT(glade_xml_get_widget(Lxml, "menucdaudio")), "activate",
      G_CALLBACK(menu_active_panel), Lhash);
  g_signal_connect(G_OBJECT(glade_xml_get_widget(Lxml, "menucddata")), "activate",
      G_CALLBACK(menu_active_panel), Lhash);
  g_signal_connect(G_OBJECT(glade_xml_get_widget(Lxml, "menudvddata")), "activate",
      G_CALLBACK(menu_active_panel), Lhash);
  g_signal_connect(G_OBJECT(glade_xml_get_widget(Lxml, "menucdcopy")), "activate",
      G_CALLBACK(menu_active_panel), Lhash);
  g_signal_connect(G_OBJECT(glade_xml_get_widget(Lxml, "menucdother")), "activate",
      G_CALLBACK(menu_active_panel), Lhash);
  g_signal_connect(G_OBJECT(glade_xml_get_widget(Lxml, "menuproperties")), "activate",
      G_CALLBACK(menu_active_proprietes), Lhash);
  g_signal_connect(G_OBJECT(glade_xml_get_widget(Lxml, "menuquit")), "activate",
      G_CALLBACK(menu_quit), Lhash);
  g_signal_connect(G_OBJECT(glade_xml_get_widget(Lxml, "menuabout")), "activate",
      G_CALLBACK(on_about), Lhash);

  
  prepare_combobox_vitesse(GTK_COMBO_BOX(glade_to_hash(Lxml, Lhash, "dstaudiospeed")));
  glade_to_hash(Lxml, Lhash, "srccopytable");
  prepare_combobox_vitesse(GTK_COMBO_BOX(glade_to_hash(Lxml, Lhash, "dstcopyspeed")));
  glade_to_hash(Lxml, Lhash, "dstcopytable");
  prepare_combobox_vitesse(GTK_COMBO_BOX(glade_to_hash(Lxml, Lhash, "dstdataspeed")));
  glade_to_hash(Lxml, Lhash, "dstdatatable");
  prepare_combobox_vitesse(GTK_COMBO_BOX(glade_to_hash(Lxml, Lhash, "dstdvddataspeed")));
  glade_to_hash(Lxml, Lhash, "dstdvddatatable");

  /* onglet graver un cd audio */
  glade_to_hash_list(Lxml, Lhash, "audiosimul", "audionotfix", "audiodao", "nbrcdaudio", NULL);

  /* onglet graver un cd de donnee */
  glade_to_hash_list(Lxml, Lhash, "datavoli", "datapubl", "dataprep", "databibl", "datacopy", "dataabst",
      "datarockridge", "datajoliet", NULL);
  glade_to_hash_list(Lxml, Lhash, "dataappi", "nbrcddata", "datamulti", "datanotfix", "datasimul", NULL);

  /* onglet graver un dvd de donnee */
  glade_to_hash_list(Lxml, Lhash, "dvddatavoli", "dvddatapubl", "dvddataprep", "dvddatabibl", "dvddatacopy",
      "dvddataabst", NULL);
  glade_to_hash_list(Lxml, Lhash, "dvddataappi", "nbrdvddata", "dvddatanotfix", "dvddatasimul", NULL);
 
  /* onglet copier un cd */
  glade_to_hash_list(Lxml, Lhash, "nbrcdcopy", "copysimul", NULL);

  /* tous les combo contenant la liste des lecteurs */
  prepare_combobox_graveur(Lxml, Lhash, "dstaudio");
  
  prepare_combobox_graveur(Lxml, Lhash, "dstdata");
  prepare_disable_when_iso(Lhash, "dstdatacombo", "nbrcddata", "datamulti", "datanotfix", "datasimul", NULL);

  prepare_combobox_graveur(Lxml, Lhash, "dstdvddata");
  prepare_disable_when_iso(Lhash, "dstdvddatacombo", "nbrdvddata", "dvddatanotfix", "dvddatasimul", NULL);

  prepare_combobox_graveur(Lxml, Lhash, "srccopy");
  prepare_combobox_graveur(Lxml, Lhash, "dstcopy");
  prepare_disable_when_iso(Lhash, "dstcopycombo", "nbrcdcopy", "copysimul", NULL);

  Lbtnerasecdrw = GTK_BUTTON(glade_to_hash(Lxml, Lhash, "btnerasecdrwother1"));
  Lbtnformatdvdrw = GTK_BUTTON(glade_to_hash(Lxml, Lhash, "btnformatdvdrwother1"));
  prepare_combobox_graveur(Lxml, Lhash, "dstother");
  prepare_disable_when(Lhash, "dstothercombo_notcdrw", "btnerasecdrwother1", NULL);
  prepare_disable_when(Lhash, "dstothercombo_notdvdrw", "btnformatdvdrwother1", NULL);
  
  /* on rempli les autres combo */
  remplirecombo(GTK_COMBO_BOX(glade_to_hash(Lxml, Lhash, "dataformat")), "", Gformatcd,
      TRUE, conf_get_string("dataformat"));
  remplirecombo(GTK_COMBO_BOX(glade_to_hash(Lxml, Lhash, "datamodburn")), "", Gmodburn,
      TRUE, conf_get_string("datamodburn"));
  Lcombo = GTK_COMBO_BOX(glade_to_hash(Lxml, Lhash, "listeremplidata"));
  remplirecombo(Lcombo, "", Gtypecddata, TRUE, conf_get_string("listeremplidata")); 
  g_signal_connect(G_OBJECT(Lcombo), "changed", G_CALLBACK(change_remplissage), Lhash);

  Lcombo = GTK_COMBO_BOX(glade_to_hash(Lxml, Lhash, "listeremplidvddata"));
  remplirecombo(Lcombo, "", Gtypedvddata, TRUE, conf_get_string("listeremplidvddata")); 
  g_signal_connect(G_OBJECT(Lcombo), "changed", G_CALLBACK(change_remplissage), Lhash);

  Lcombo = GTK_COMBO_BOX(glade_to_hash(Lxml, Lhash, "listerempliaudio"));
  remplirecombo(Lcombo, "", Gtypecdaudio, TRUE, conf_get_string("listerempliaudio"));
  g_signal_connect(G_OBJECT(Lcombo), "changed", G_CALLBACK(change_remplissage), Lhash);
 
  /* boutons "page suivante" */
  g_signal_connect(G_OBJECT(glade_xml_get_widget(Lxml, "btnnextaudio1")), "clicked", G_CALLBACK(gonextpage), Lbodycdaudio);
  g_signal_connect(G_OBJECT(glade_xml_get_widget(Lxml, "btnnextdata1")), "clicked", G_CALLBACK(gonextpage), Lbodycddata);
  g_signal_connect(G_OBJECT(glade_xml_get_widget(Lxml, "btnnextdata2")), "clicked", G_CALLBACK(gonextpage), Lbodycddata);
  g_signal_connect(G_OBJECT(glade_xml_get_widget(Lxml, "btnnextdvddata1")), "clicked", G_CALLBACK(gonextpage), Lbodydvddata);
  g_signal_connect(G_OBJECT(glade_xml_get_widget(Lxml, "btnnextdvddata2")), "clicked", G_CALLBACK(gonextpage), Lbodydvddata);

  /* boutons "graver" */
  g_signal_connect(G_OBJECT(glade_to_hash(Lxml, Lhash, "btnburnaudio2")), "clicked", G_CALLBACK(confirm_burn), Lhash);
  g_signal_connect(G_OBJECT(glade_to_hash(Lxml, Lhash, "btnburndata2")), "clicked", G_CALLBACK(confirm_burn), Lhash);
  g_signal_connect(G_OBJECT(glade_to_hash(Lxml, Lhash, "btnburndata3")), "clicked", G_CALLBACK(confirm_burn), Lhash);
  g_signal_connect(G_OBJECT(glade_to_hash(Lxml, Lhash, "btnburndvddata2")), "clicked", G_CALLBACK(confirm_burn), Lhash);
  g_signal_connect(G_OBJECT(glade_to_hash(Lxml, Lhash, "btnburndvddata3")), "clicked", G_CALLBACK(confirm_burn), Lhash);
  g_signal_connect(G_OBJECT(glade_to_hash(Lxml, Lhash, "btnburncopy1")), "clicked", G_CALLBACK(confirm_burn), Lhash);

  /* boutons de la page "autres operations" */
  g_signal_connect(G_OBJECT(Lbtnerasecdrw), "clicked", G_CALLBACK(confirm_erasecdrw), Lhash);
  g_signal_connect(G_OBJECT(Lbtnformatdvdrw), "clicked", G_CALLBACK(popup_formatdvdrw), Lhash);
  g_signal_connect(G_OBJECT(glade_to_hash(Lxml, Lhash, "btnfixcdother1")), "clicked", G_CALLBACK(confirm_fixcd), Lhash);
  
  update_combo_graveur(Lhash);

  /* menu popup sur les listes */
  glade_to_hash_list(Lxml, Lhash, "audiolenbar", "datasizebar", "dvddatasizebar", NULL);
  Ltreeaudio = GTK_TREE_VIEW(glade_to_hash(Lxml, Lhash, "LISTEAUDIO"));
  prepare_popups(Lxml, Lhash);
  prepare_listeaudio(Ltreeaudio);
  g_signal_connect(G_OBJECT(Ltreeaudio), "button-press-event", G_CALLBACK(gtk_do_eventbuttonpress), Lhash);
  g_signal_connect(G_OBJECT(Ltreeaudio), "popup-menu", G_CALLBACK(key_popupmenu_addaudio), Lhash);
  g_signal_connect(G_OBJECT(glade_xml_get_widget(Lxml, "btnaddtrack")), "clicked", G_CALLBACK(gtk_audio_addtrack), Lhash);

  Ltreedata = GTK_TREE_VIEW(glade_to_hash(Lxml, Lhash, "LISTEDATA"));
  prepare_listedata(Ltreedata, _("New CD"));
  g_signal_connect(G_OBJECT(Ltreedata), "button-press-event", G_CALLBACK(gtk_do_eventbuttonpress), Lhash);
  g_signal_connect(G_OBJECT(Ltreedata), "popup-menu", G_CALLBACK(key_popupmenu_addfile), Lhash);
  g_signal_connect(G_OBJECT(glade_xml_get_widget(Lxml, "btnaddfile")), "clicked", G_CALLBACK(gtk_data_addfile), Lhash);
  g_signal_connect(G_OBJECT(glade_xml_get_widget(Lxml, "btnadddirectory")), "clicked",
      G_CALLBACK(gtk_data_adddirectory), Lhash);

  Ltreedvddata = GTK_TREE_VIEW(glade_to_hash(Lxml, Lhash, "LISTEDVDDATA"));
  prepare_listedata(Ltreedvddata, _("New DVD"));
  g_signal_connect(G_OBJECT(Ltreedvddata), "button-press-event", G_CALLBACK(gtk_do_eventbuttonpress), Lhash);
  g_signal_connect(G_OBJECT(Ltreedvddata), "popup-menu", G_CALLBACK(key_popupmenu_addfile), Lhash);
  g_signal_connect(G_OBJECT(glade_xml_get_widget(Lxml, "btndvdaddfile")), "clicked", G_CALLBACK(gtk_data_addfile), Lhash);
  g_signal_connect(G_OBJECT(glade_xml_get_widget(Lxml, "btndvdadddirectory")), "clicked",
      G_CALLBACK(gtk_data_adddirectory), Lhash);


  /* drag and drop */
  /* audio */
  gtk_tree_view_enable_model_drag_source (GTK_TREE_VIEW (Ltreeaudio),
           GDK_BUTTON1_MASK, Gdndaudio, G_N_ELEMENTS (Gdndaudio), GDK_ACTION_MOVE|GDK_ACTION_COPY);
  gtk_tree_view_enable_model_drag_dest (GTK_TREE_VIEW (Ltreeaudio),
               Gdndaudio, G_N_ELEMENTS (Gdndaudio), GDK_ACTION_MOVE|GDK_ACTION_COPY);
  g_signal_connect(G_OBJECT(Ltreeaudio), "drag-data-received", G_CALLBACK(audio_dnd_data_received), Lhash);

  /* cd data */
  gtk_tree_view_enable_model_drag_source (GTK_TREE_VIEW (Ltreedata),
           GDK_BUTTON1_MASK, Gdnddata, G_N_ELEMENTS (Gdnddata), GDK_ACTION_MOVE|GDK_ACTION_COPY|GDK_ACTION_LINK);
  gtk_tree_view_enable_model_drag_dest (GTK_TREE_VIEW (Ltreedata),
           Gdnddata, G_N_ELEMENTS (Gdnddata), GDK_ACTION_MOVE|GDK_ACTION_COPY|GDK_ACTION_LINK);
  g_signal_connect(G_OBJECT(Ltreedata), "drag-data-received", G_CALLBACK(data_dnd_data_received),
      Lhash);
  /* dvd data */
  gtk_tree_view_enable_model_drag_source (GTK_TREE_VIEW (Ltreedvddata),
           GDK_BUTTON1_MASK, Gdnddata, G_N_ELEMENTS (Gdnddata), GDK_ACTION_MOVE|GDK_ACTION_COPY);
  gtk_tree_view_enable_model_drag_dest (GTK_TREE_VIEW (Ltreedvddata),
           Gdnddata, G_N_ELEMENTS (Gdnddata), GDK_ACTION_MOVE|GDK_ACTION_COPY);
  g_signal_connect(G_OBJECT(Ltreedvddata), "drag-data-received", G_CALLBACK(data_dnd_data_received),
      Lhash);

  /* evenement fermer la fenetre */
  g_signal_connect(G_OBJECT(Lwindow), "delete-event", G_CALLBACK(delete_event_quit), Lhash);

  /* on restaure la taille et la position que la fenetre avait lors de la derniere utilisation */ 
  restore_main_window_pos(Lwindow); 

  /* on restaure les dernieres valeurs utilisees pour certains champs */
  restore_last_used_values(Lhash);
  
  gtk_widget_show(Lwindow);

  return Lwindow;
}

/* mise a jour des listes contenant les lecteurs */
void update_combo_graveur(GHashTable *Ahash)
{
  GtkComboBox *Lsrccopycombo = GTK_COMBO_BOX(g_hash_table_lookup(Ahash, "srccopycombo"));
  GtkComboBox *Ldstcopycombo = GTK_COMBO_BOX(g_hash_table_lookup(Ahash, "dstcopycombo"));
  GtkComboBox *Ldstdatacombo = GTK_COMBO_BOX(g_hash_table_lookup(Ahash, "dstdatacombo"));
  GtkComboBox *Ldstdvddatacombo = GTK_COMBO_BOX(g_hash_table_lookup(Ahash, "dstdvddatacombo"));
  GtkComboBox *Ldstaudiocombo = GTK_COMBO_BOX(g_hash_table_lookup(Ahash, "dstaudiocombo"));
  GtkComboBox *Ldstothercombo = GTK_COMBO_BOX(g_hash_table_lookup(Ahash, "dstothercombo"));
  GtkButton *Lbtnburnaudio1 = g_hash_table_lookup(Ahash, "btnburnaudio1");
  GtkButton *Lbtnburnaudio2 = g_hash_table_lookup(Ahash, "btnburnaudio2");
  GtkButton *Lbtnburncopy1 = g_hash_table_lookup(Ahash, "btnburncopy1");
  GtkButton *Lbtnfixcdother1 = g_hash_table_lookup(Ahash, "btnfixcdother1");
  GtkButton *Lbtnerasecdrwother1 = g_hash_table_lookup(Ahash, "btnerasecdrwother1");
  gboolean Lreadcd, Lwritecdr, Lwritecdrw, Lreaddvd, Lwritedvd;

  get_current_matos(&Lreadcd, &Lwritecdr, &Lwritecdrw, &Lreaddvd, &Lwritedvd);

  remplirecombograveur(Lsrccopycombo, TYPE_ALL + TYPE_ISO, conf_get_string("srccopycombo"));
  
  remplirecombograveur(Ldstcopycombo, TYPE_ALLWRITER + TYPE_ISO, conf_get_string("dstcopycombo"));
  
  remplirecombograveur(Ldstdatacombo, TYPE_ALLWRITER + TYPE_ISO, conf_get_string("dstdatacombo"));

  remplirecombograveur(Ldstdvddatacombo, TYPE_DVDWRITER + TYPE_ISO, conf_get_string("dstdvddatacombo"));
  
  remplirecombograveur(Ldstaudiocombo, TYPE_ALLWRITER, conf_get_string("dstaudiocombo"));

  remplirecombograveur(Ldstothercombo, TYPE_ALLWRITER, conf_get_string("dstothercombo"));

  if (Lreadcd == FALSE) {
    gtk_widget_set_sensitive(GTK_WIDGET(Lbtnburncopy1), FALSE);
  }
  if (Lwritecdr == FALSE) {
    gtk_widget_set_sensitive(GTK_WIDGET(Lbtnburnaudio1), FALSE);
    gtk_widget_set_sensitive(GTK_WIDGET(Lbtnburnaudio2), FALSE);
    gtk_widget_set_sensitive(GTK_WIDGET(Lbtnfixcdother1), FALSE);
  }
  if (Lwritecdrw == FALSE) {
    gtk_widget_set_sensitive(GTK_WIDGET(Lbtnerasecdrwother1), FALSE);
  }
/*if (Lwritedvd == FALSE) { et l'image iso ?! 
    gtk_widget_set_sensitive(GTK_WIDGET(Lbtnburndvddata2), FALSE);
    gtk_widget_set_sensitive(GTK_WIDGET(Lbtnburndvddata3), FALSE);
  }*/
}

GtkWidget* create_fileselection1 (GtkWindow *AParent, GtkFileChooserAction AType)
{
  GtkWidget *fileselection1;

  GtkFileFilter *filterall, *filteriso;

  /* filtres pour la selection de fichiers */
  filterall = gtk_file_filter_new ();
  gtk_file_filter_set_name (filterall, _("All files (*.*)"));
  gtk_file_filter_add_pattern(filterall, "*");
  filteriso = gtk_file_filter_new ();
  gtk_file_filter_set_name (filteriso, _("Iso images only (*.iso)"));
  gtk_file_filter_add_pattern(filteriso, "*.iso");

  fileselection1 = gtk_file_chooser_dialog_new(AType == GTK_FILE_CHOOSER_ACTION_OPEN ? 
                                                _("Select iso image source") : _("Select iso image destination"),
                        AParent, AType, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
				      GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
				      NULL);

  gtk_dialog_set_default_response (GTK_DIALOG (fileselection1), GTK_RESPONSE_ACCEPT);
  gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (fileselection1), filteriso);
  gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (fileselection1), filterall);

  return fileselection1;
}

GtkWidget* create_addfileselection (GtkWindow *AParent)
{
  GtkWidget *fileselection1;

  GtkFileFilter *filterall;

  /* filtres pour la selection de fichiers */
  filterall = gtk_file_filter_new ();
  gtk_file_filter_set_name (filterall, _("All files (*.*)"));
  gtk_file_filter_add_pattern(filterall, "*");

  fileselection1 = gtk_file_chooser_dialog_new(_("Select iso image source"),
      AParent, GTK_FILE_CHOOSER_ACTION_OPEN, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
      GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT, NULL);

  gtk_file_chooser_set_select_multiple(GTK_FILE_CHOOSER(fileselection1), TRUE);
  gtk_dialog_set_default_response (GTK_DIALOG (fileselection1), GTK_RESPONSE_ACCEPT);
  gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (fileselection1), filterall);

  return fileselection1;
}

GtkWidget* create_addpisteselection (GtkWindow *AParent)
{
  GtkWidget *fileselection1;
  GtkFileFilter *filterall, *filterwav, *filteraudio;
  gchar *Ltxt;
#ifdef ENABLE_MP3
  GtkFileFilter *filtermp3;
#endif
#ifdef ENABLE_OGG
  GtkFileFilter *filterogg;
#endif

  /* filtres pour la selection de fichiers */
  filterall = gtk_file_filter_new ();
  gtk_file_filter_set_name (filterall, _("All files (*.*)"));
  gtk_file_filter_add_pattern(filterall, "*");

  filteraudio = gtk_file_filter_new ();

  if (GsupportMp3 && GsupportOgg) {
    Ltxt = _("All audio files (*.mp3 *.ogg *.wav)");
  } else if (GsupportMp3) {
    Ltxt = _("All audio files (*.mp3 *.wav)");
  } else if (GsupportOgg) {
    Ltxt = _("All audio files (*.ogg *.wav)");
  } else {
    Ltxt = _("All audio files (*.wav)");
  }
  
  gtk_file_filter_set_name (filteraudio, Ltxt);

#ifdef ENABLE_MP3
  if (GsupportMp3) {
    gtk_file_filter_add_pattern(filteraudio, "*.mp3");
    filtermp3 = gtk_file_filter_new ();
    gtk_file_filter_set_name (filtermp3, _("Mp3 files (*.mp3)"));
    gtk_file_filter_add_pattern(filtermp3, "*.mp3");
  }
#endif
#ifdef ENABLE_OGG
  if (GsupportOgg) {
    gtk_file_filter_add_pattern(filteraudio, "*.ogg");
    filterogg = gtk_file_filter_new ();
    gtk_file_filter_set_name (filterogg, _("Ogg files (*.ogg)"));
    gtk_file_filter_add_pattern(filterogg, "*.ogg");
  }
#endif
  gtk_file_filter_add_pattern(filteraudio, "*.wav");

  filterwav = gtk_file_filter_new ();
  gtk_file_filter_set_name (filterwav, _("Wav files (*.wav)"));
  gtk_file_filter_add_pattern(filterwav, "*.wav");

  fileselection1 = gtk_file_chooser_dialog_new(_("Sectect an audio file to add"),
      AParent, GTK_FILE_CHOOSER_ACTION_OPEN, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
      GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT, NULL);

  gtk_file_chooser_set_select_multiple(GTK_FILE_CHOOSER(fileselection1), TRUE);
  gtk_dialog_set_default_response (GTK_DIALOG (fileselection1), GTK_RESPONSE_ACCEPT);
  gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (fileselection1), filteraudio);
#ifdef ENABLE_MP3
  if (GsupportMp3) {
    gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (fileselection1), filtermp3);
  }
#endif
#ifdef ENABLE_OGG
  if (GsupportOgg) {
    gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (fileselection1), filterogg);
  }
#endif  
  gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (fileselection1), filterwav);
  gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (fileselection1), filterall);

  return fileselection1;
}

GtkWidget* create_adddirselection (GtkWindow *AParent)
{
  GtkWidget *Lfileselection;
  GtkFileFilter *Lfilterall;

  /* filtres pour la selection de fichiers */
  Lfilterall = gtk_file_filter_new ();
  gtk_file_filter_set_name (Lfilterall, _("All files (*.*)"));
  gtk_file_filter_add_pattern(Lfilterall, "*");
  Lfileselection = gtk_file_chooser_dialog_new(_("Select a directory to add"),
      AParent, GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
      GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT, NULL);

  gtk_file_chooser_set_select_multiple(GTK_FILE_CHOOSER(Lfileselection), TRUE);
  gtk_dialog_set_default_response (GTK_DIALOG (Lfileselection), GTK_RESPONSE_ACCEPT);
  gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (Lfileselection), Lfilterall);

  return Lfileselection;
}

/* boite de dialogue "edition media" */
#if 0
GHashTable *addmediaformat(GHashTable *Aparent)
{
  gchar *Ltemplate = PACKAGE_DATA_DIR "/" PACKAGE "/dialog_media.glade";
  GladeXML *Lxml = glade_xml_new(Ltemplate, NULL,NULL);
  GtkWidget *Ldialog;
  GHashTable *Lhash = _hash();
  gulong Lsize = 0;
  GtkComboBox *Lcombo;

  if (!Lxml) {
    g_error("Cannot load '%s': %s\n", Ltemplate, g_strerror(errno));
  }
  Ldialog = glade_to_hash(Lxml, Lhash, "dialog_media"); 

  g_hash_table_insert(Lhash, "fullsize", &Lsize);
  
  g_signal_connect(G_OBJECT(glade_to_hash(Lxml, Lhash, "mediadata")), "value-changed",
      G_CALLBACK(update_media_fields), Lhash);

  Lcombo = GTK_COMBO_BOX(glade_to_hash(Lxml, Lhash, "mediadataunit"));
  remplirecombo(Lcombo, "", Gtypeunit, TRUE);
  g_signal_connect(G_OBJECT(Lcombo), "changed", G_CALLBACK(update_media_unit), Lhash);

  glade_to_hash(Lxml, Lhash, "labelmediadata");
  glade_to_hash(Lxml, Lhash, "labelmediaaudio");

  return Lhash;
}
#endif

/* boite de dialogue "editer un peripherique" */
GHashTable *create_dialog_edit_device(GtkWidget *Aparent, Tdriveinfo *Adrive)
{
  gchar *Ltemplate = PACKAGE_DATA_DIR "/" PACKAGE "/dialog_device.glade";
  GladeXML *Lxml = glade_xml_new(Ltemplate, NULL,NULL);
  GtkWidget *Ldialog;
  GHashTable *Lhash = _hash();
  GtkComboBox *Lcombobox;

  if (!Lxml) {
    g_error("Cannot load '%s': %s\n", Ltemplate, g_strerror(errno));
  }

  Ldialog = glade_xml_get_widget(Lxml, "dialog_device");
  gtk_window_set_transient_for(GTK_WINDOW(Ldialog), GTK_WINDOW(Aparent));
  g_hash_table_insert(Lhash, "window", Ldialog);

  gtk_entry_set_text(GTK_ENTRY(glade_to_hash(Lxml, Lhash, "devicename")), Adrive->name);
  Lcombobox = GTK_COMBO_BOX(glade_to_hash(Lxml, Lhash, "devicebus"));

  manage_combobox_devicebus(Lcombobox, Adrive);

  return Lhash;
}

/* boite de dialogue "ajouter un peripherique" */
GHashTable *create_dialog_add_device(GtkWidget *Aparent)
{
  gchar *Ltemplate = PACKAGE_DATA_DIR "/" PACKAGE "/dialog_add_device.glade";
  GladeXML *Lxml = glade_xml_new(Ltemplate, NULL,NULL);
  GtkWidget *Ldialog;
  GHashTable *Lhash = _hash();

  if (!Lxml) {
    g_error("Cannot load '%s': %s\n", Ltemplate, g_strerror(errno));
  }

  Ldialog = glade_xml_get_widget(Lxml, "dialog_add_device");
  gtk_window_set_transient_for(GTK_WINDOW(Ldialog), GTK_WINDOW(Aparent));
  g_hash_table_insert(Lhash, "window", Ldialog);

  gtk_entry_set_text(GTK_ENTRY(glade_to_hash(Lxml, Lhash, "devicename")), _("New device"));
  glade_to_hash(Lxml, Lhash, "devicebus");


  return Lhash;
}


/* boite de dialogue "a propos de ..." */
void about_graveman (void)
{
  gchar *Ltemplate = PACKAGE_DATA_DIR "/" PACKAGE "/dialog_about.glade";
  GladeXML *Lxml = glade_xml_new(Ltemplate, NULL,NULL);
  GtkWidget *Ldialog;
  GtkLabel *Llabelversion;
  gchar *Ltmp;

  if (!Lxml) {
    g_error("Cannot load '%s': %s\n", Ltemplate, g_strerror(errno));
  }

  Llabelversion = GTK_LABEL(glade_xml_get_widget(Lxml, "version"));

  Ltmp = g_strdup_printf(_("version %s - http://www.nongnu.org/graveman"), VERSION);
  gtk_label_set_label(Llabelversion, Ltmp);
  g_free(Ltmp);

  Ldialog = glade_xml_get_widget(Lxml, "dialog_about"); 

  gtk_dialog_run(GTK_DIALOG(Ldialog));
  gtk_widget_destroy(Ldialog);

  g_free(Lxml);
}

void hide_some_progressbar(GHashTable *Ahash)
{
  GtkWidget *Lpbfifo = g_hash_table_lookup(Ahash, "pb_fifo");
  GtkWidget *Lpbbuffer = g_hash_table_lookup(Ahash, "pb_buffer");
  GtkWidget *Llfifo = g_hash_table_lookup(Ahash, "l_fifo");
  GtkWidget *Llbuffer = g_hash_table_lookup(Ahash, "l_buffer");

  gtk_widget_hide(Lpbfifo); 
  gtk_widget_hide(Llfifo); 
  gtk_widget_hide(Lpbbuffer); 
  gtk_widget_hide(Llbuffer); 
}

/* fenetre gravure d'un cd en cours */
void show_graverwindow (GHashTable *Ahash, gchar *Aaction, gchar *Atitle)
{
  gchar *Ltemplate = PACKAGE_DATA_DIR "/" PACKAGE "/window_burn.glade";
  GladeXML *Lxml = glade_xml_new(Ltemplate, NULL,NULL);
  GtkWidget *Lwindowburn;
  GtkLabel *Ltitle, *Lavancement;
  GtkProgressBar *Lpbtotal, *Lpbstep, *Lpbfifo, *Lpbbuffer;
  gint Ltotaldone = 0;
  gint Lpid = 0, Lpid2 = 0;
  gboolean Labort = FALSE;
  gboolean Lbackvalue = FALSE;
  gint Lcont = 1;
  GtkWidget *Lstatusbox = NULL;
  GtkWidget *Lparent = GTK_WIDGET(g_hash_table_lookup(Ahash, "topwindow"));
  GError *Lerror = NULL;

  if (!Lxml) {
    g_error("Cannot load '%s': %s\n", Ltemplate, g_strerror(errno));
  }

  Lwindowburn = glade_xml_get_widget(Lxml, "window_burn"); 
  gtk_window_set_transient_for(GTK_WINDOW(Lwindowburn), GTK_WINDOW(Lparent));

  /* titres avancement */
  Ltitle = GTK_LABEL(glade_to_hash(Lxml, Ahash, "gravetitle"));
  Lavancement = GTK_LABEL(glade_to_hash(Lxml, Ahash, "avancement"));
  
  /* barres de progression */
  Lpbtotal = GTK_PROGRESS_BAR(glade_to_hash(Lxml, Ahash, "pb_total"));
  Lpbstep = GTK_PROGRESS_BAR(glade_to_hash(Lxml, Ahash, "pb_step"));
  /* pour la conversion des fichiers audio et la pulse bar */
  g_hash_table_insert(Ahash, "progress", Lpbstep);
  Lpbfifo = GTK_PROGRESS_BAR(glade_to_hash(Lxml, Ahash, "pb_fifo"));
  Lpbbuffer = GTK_PROGRESS_BAR(glade_to_hash(Lxml, Ahash, "pb_buffer"));
  glade_to_hash_list(Lxml, Ahash, "l_fifo", "l_buffer", NULL);

  /* on attache les variables utilisees lors de l'operation */
  g_hash_table_insert(Ahash, "totaldone", &Ltotaldone);
  g_hash_table_insert(Ahash, "gabort", &Labort);  /* operation annulee par l'utilisateur ? */
  g_hash_table_insert(Ahash, "pid", &Lpid);
  g_hash_table_insert(Ahash, "cont", &Lcont);
  g_hash_table_insert(Ahash, "pid2", &Lpid2);

  /* bouton annuler l'operation */
  g_signal_connect(G_OBJECT(glade_xml_get_widget(Lxml, "btncancelburn")), "clicked", G_CALLBACK(abort_gravure), Ahash);
  g_signal_connect(G_OBJECT(Lwindowburn), "delete_event", GTK_SIGNAL_FUNC(on_deleteevent_gravure), Ahash);

  /* lancement de l'operation en elle meme */
  if (g_str_has_prefix(Aaction, "btnburncopy")) {
    Lbackvalue = burn_copy(Ahash, &Lerror);

    
  } else if (g_str_has_prefix(Aaction, "btnburnaudio")) {
    Lbackvalue = burn_audio(Ahash, &Lerror);
  } else if (g_str_has_prefix(Aaction, "btnburndata")) {
    Lbackvalue = burn_data(Ahash, &Lerror);
  } else if (g_str_has_prefix(Aaction, "btnburndvddata")) {
    hide_some_progressbar(Ahash);
    Lbackvalue = burn_dvddata(Ahash, &Lerror);
  }

  if (Labort) {
    Lstatusbox = gtk_message_dialog_new(GTK_WINDOW(Lwindowburn),
                                     GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK,
                                     _("Operation aborted by user !"));
  } else {
    /* pour plus de beaute on s'assure que les barres de progression aient les bonnes
     * valeurs :-) */
    gtk_progress_bar_set_fraction(Lpbtotal, 1);
    gtk_progress_bar_set_fraction(Lpbstep, 1);
    gtk_progress_bar_set_fraction(Lpbfifo, 0);
    gtk_progress_bar_set_fraction(Lpbbuffer, 0);
    gtk_progress_bar_set_text(Lpbtotal, "100%");
    gtk_progress_bar_set_text(Lpbstep, "100%");
    gtk_progress_bar_set_text(Lpbfifo, "0%");
    gtk_progress_bar_set_text(Lpbbuffer, "0%");
    
    if (Lbackvalue == FALSE) {
      gtk_label_set_text(Ltitle, _("Operation failed"));
      
      Lstatusbox = gtk_message_dialog_new(GTK_WINDOW(Lwindowburn),
                      GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK,
                      Lerror ? Lerror->message : _("Operation failed"));
    } else {
      gtk_label_set_text(Ltitle, _("Operation successful."));

      Lstatusbox = gtk_message_dialog_new(GTK_WINDOW(Lwindowburn),
                GTK_DIALOG_MODAL, GTK_MESSAGE_INFO, GTK_BUTTONS_OK,
                _("Operation successful"));
    }
  }

  if (Lstatusbox) {
    gtk_dialog_run(GTK_DIALOG(Lstatusbox));
    gtk_widget_destroy(Lstatusbox);
  }

  gtk_widget_destroy(Lwindowburn);
  if (Lerror) g_error_free(Lerror);
}
  
/* fenetre "operation en cours" */
GladeXML *create_window_encours(GtkWidget *Aparent)
{
  gchar *Ltemplate = PACKAGE_DATA_DIR "/" PACKAGE "/window_inprogress.glade";
  GladeXML *Lxml = glade_xml_new(Ltemplate, NULL,NULL);

  if (!Lxml) {
    g_error("Cannot load '%s': %s\n", Ltemplate, g_strerror(errno));
  }

  if (GTK_IS_WIDGET(Aparent)) {
    GtkWidget *Lwin = glade_xml_get_widget(Lxml, "window_inprogress");
    gtk_window_set_transient_for(GTK_WINDOW(Lwin), GTK_WINDOW(Aparent));
  }

  return Lxml;
}

void prepare_combobox_vitesse(GtkComboBox *Acombobox)
{
  if (GTK_IS_WIDGET(Acombobox)) {
    GtkListStore *Lmodel = gtk_list_store_new(2, G_TYPE_STRING, G_TYPE_STRING);  
    GtkCellRenderer *Lcellrender = GTK_CELL_RENDERER(gtk_cell_renderer_text_new());
    gtk_combo_box_set_model(Acombobox, GTK_TREE_MODEL(Lmodel));
    
    gtk_cell_layout_clear(GTK_CELL_LAYOUT(Acombobox));
    gtk_cell_layout_pack_start(GTK_CELL_LAYOUT(Acombobox), Lcellrender, TRUE);
    gtk_cell_layout_set_attributes(GTK_CELL_LAYOUT(Acombobox), Lcellrender,
      "text", 1, NULL);
  }
}

/* objets a cacher lorsque l'on selectionne une image iso en tant que source ou destination */
void prepare_disable_when_iso(GHashTable *Ahash, gchar *Abasename, const gchar *Afirst, ...)
{
  va_list Largs;
  gchar *Lbuf = (gchar *) Afirst;
  gint Lnbr = 0;
  gchar *Lname = g_strdup_printf("%s_isotodisabled%d", Abasename, Lnbr++);
  gchar *Lcur;

  g_hash_table_insert(Ahash, Lname, g_hash_table_lookup(Ahash, Afirst));

  va_start(Largs, Afirst);
  while (*Lbuf++) {
    if (!(Lcur = va_arg(Largs, gchar *))) break;
    
    Lname = g_strdup_printf("%s_isotodisabled%d", Abasename, Lnbr++);
    g_hash_table_insert(Ahash, Lname, g_hash_table_lookup(Ahash, Lcur));
  }

  va_end(Largs);
}

/* objets a cacher lorsque l'on selectionne une image iso en tant que source ou destination */
void prepare_disable_when(GHashTable *Ahash, gchar *Abasename, const gchar *Afirst, ...)
{
  va_list Largs;
  gchar *Lbuf = (gchar *) Afirst;
  gint Lnbr = 0;
  gchar *Lname = g_strdup_printf("%stodisabled%d", Abasename, Lnbr++);
  gchar *Lcur;

  g_hash_table_insert(Ahash, Lname, g_hash_table_lookup(Ahash, Afirst));

  va_start(Largs, Afirst);
  while (*Lbuf++) {
    if (!(Lcur = va_arg(Largs, gchar *))) break;
    
    Lname = g_strdup_printf("%stodisabled%d", Abasename, Lnbr++);
    g_hash_table_insert(Ahash, Lname, g_hash_table_lookup(Ahash, Lcur));
  }

  va_end(Largs);
} 

void gtk_toggle_top_menu(GtkTreeView *Atopmenu, gpointer Adata)
{
  GHashTable *Lhash = (GHashTable *)Adata;
  GtkTreeModel *Ltreemodel = gtk_tree_view_get_model(Atopmenu);
  GtkTreeIter Liter;
  gchar *Lident;
  GtkNotebook *Llstclick = g_hash_table_lookup(Lhash, "_lstclicked"); /* dernier element ayant eu le focus */
  GtkNotebook *Lnewclick;
  GtkTreeSelection *Lselection = gtk_tree_view_get_selection(Atopmenu);

  if (!gtk_tree_selection_get_selected(Lselection, &Ltreemodel, &Liter)) return;

  gtk_tree_model_get(Ltreemodel, &Liter, 0, &Lident, -1);

  Lnewclick = g_hash_table_lookup(Lhash, Lident);
  if (GTK_IS_NOTEBOOK(Lnewclick)) {
  
    if (GTK_IS_NOTEBOOK(Llstclick)) {
      gtk_widget_hide(GTK_WIDGET(Llstclick));
    }
    g_hash_table_replace(Lhash, "_lstclicked", Lnewclick);

    gtk_widget_show(GTK_WIDGET(Lnewclick));

    /* pointeur sur la liste courante pour plus de simplicite */
    if (!strcmp(Lident, "bodycddata")) {
      g_hash_table_replace(Lhash, "_current_list", g_hash_table_lookup(Lhash, "LISTEDATA"));
    } else if (!strcmp(Lident, "bodydvddata")) {
      g_hash_table_replace(Lhash, "_current_list", g_hash_table_lookup(Lhash, "LISTEDVDDATA"));
    }
  }
    
  g_free(Lident);
}

/* status bar */
void update_status_bar_display(GHashTable *Ahash)
{
  gboolean Ldispsb = conf_get_boolean("statusbar");
  GtkWidget *Ldisp = g_hash_table_lookup(Ahash, "statusbar");

  if (Ldispsb) {
    gtk_widget_show(Ldisp);
  } else {
    gtk_widget_hide(Ldisp);
  }
}

/* mise a jour interface */
void manage_interface(GHashTable *Ahash, gint Aaction)
{
  GtkListStore *Lmodel;
  GtkTreeView *Ltopmenu = g_hash_table_lookup(Ahash, "topmenu");
  GtkTreeSelection *Lselection = gtk_tree_view_get_selection(Ltopmenu);
  GtkTreeIter Liter;
  GtkCellRenderer *Lcellrender;
  GtkTreeViewColumn *Lcell;
  GtkComboBox *Lisolevel;

  if (Aaction & MENU_NEW) {
    Lmodel = gtk_list_store_new(3, G_TYPE_STRING, GDK_TYPE_PIXBUF, G_TYPE_STRING);
    gtk_tree_selection_set_mode(Lselection, GTK_SELECTION_BROWSE);
    gtk_tree_view_set_model(Ltopmenu, GTK_TREE_MODEL(Lmodel));

    /* creation colonnes */
    Lcellrender = gtk_cell_renderer_pixbuf_new();
    Lcell = gtk_tree_view_column_new_with_attributes("", Lcellrender, "pixbuf", 1, NULL);
     gtk_tree_view_append_column(GTK_TREE_VIEW(Ltopmenu), Lcell);
	
    Lcellrender = gtk_cell_renderer_pixbuf_new();
    Lcellrender = gtk_cell_renderer_text_new();
    Lcell = gtk_tree_view_column_new_with_attributes("", Lcellrender, "text", 2, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(Ltopmenu), Lcell);
    Lcellrender = gtk_cell_renderer_pixbuf_new();

    g_signal_connect(G_OBJECT(Ltopmenu), "cursor-changed", G_CALLBACK(gtk_toggle_top_menu), Ahash); 
  } else {
    Lmodel = GTK_LIST_STORE(gtk_tree_view_get_model(Ltopmenu));
    gtk_list_store_clear(Lmodel);
  }

  /* les icones en elles meme */
  prepare_menu_images(Ahash);

  gtk_list_store_append(Lmodel, &Liter);
  gtk_list_store_set(Lmodel, &Liter, 0, "bodycdaudio", 1, GMenuAudio, 2, _("Audio CD"), -1);
  gtk_tree_selection_select_iter(Lselection, &Liter);
  gtk_toggle_top_menu(Ltopmenu, Ahash);

  gtk_list_store_append(Lmodel, &Liter);
  gtk_list_store_set(Lmodel, &Liter, 0, "bodycddata", 1, GMenuData, 2, _("Data CD"), -1);

  gtk_list_store_append(Lmodel, &Liter);
  gtk_list_store_set(Lmodel, &Liter, 0, "bodydvddata", 1, GMenuData, 2, _("Data DVD"), -1);

  gtk_list_store_append(Lmodel, &Liter);
  gtk_list_store_set(Lmodel, &Liter, 0, "bodycdcopy", 1, GMenuCopy, 2, _("Duplicate CD"), -1);

  gtk_list_store_append(Lmodel, &Liter);
  gtk_list_store_set(Lmodel, &Liter, 0, "bodycdother", 1, GMenuOther, 2, _("Other operations"), -1);
 
  gtk_tree_view_columns_autosize(Ltopmenu); 

  /* mise a jour combo "iso level" */
  if (Aaction & COMBO_UPDATE) {
    Lisolevel = g_hash_table_lookup(Ahash, "dataisolevel");
    remplirecombo_full(Lisolevel, "", Gisolevel,
        TRUE, conf_get_string("dataisolevel"), conf_get_int("mkisofs_support_isov2"));
  }
}

    
/* preparation du combo contenant la liste du peripherique a utiliser */
void prepare_combobox_graveur(GladeXML *Axml, GHashTable *Ahash, gchar *Abasename)
{
  GtkComboBox *Lcombobox = GTK_COMBO_BOX(glade_to_hashv(Axml, Ahash, "%scombo", Abasename));
  if (GTK_IS_COMBO_BOX(Lcombobox)) {
    GtkListStore *Lmodel = gtk_list_store_new(4, G_TYPE_STRING, GDK_TYPE_PIXBUF, G_TYPE_STRING, G_TYPE_INT);
    GtkCellRenderer *Lcellrender;
    GtkWidget *Lbtniso = sc_glade_xml_get_widgetv(Axml, "%sbtn", Abasename);
 
    gtk_combo_box_set_model(Lcombobox, GTK_TREE_MODEL(Lmodel));
    Lcellrender = GTK_CELL_RENDERER(gtk_cell_renderer_pixbuf_new());
    gtk_cell_layout_pack_start(GTK_CELL_LAYOUT(Lcombobox), Lcellrender, TRUE);
    gtk_cell_layout_set_attributes(GTK_CELL_LAYOUT(Lcombobox), Lcellrender,
      "pixbuf", 1, NULL);                    
    Lcellrender = GTK_CELL_RENDERER(gtk_cell_renderer_text_new());
    gtk_cell_layout_pack_start(GTK_CELL_LAYOUT(Lcombobox), Lcellrender, TRUE);
    gtk_cell_layout_set_attributes(GTK_CELL_LAYOUT(Lcombobox), Lcellrender,
      "text", 2, NULL);

    g_signal_connect(G_OBJECT(Lcombobox), "changed", G_CALLBACK(on_selectgraveur), Ahash);
      /* il y a peutetre un champ "image iso" associe a ce combo graveur */

    if (GTK_IS_BUTTON(Lbtniso)) {
      glade_to_hashv(Axml, Ahash, "%sbtnvalue", Abasename);
      g_signal_connect(G_OBJECT(Lbtniso), "clicked", G_CALLBACK(gtk_file_sel), Ahash);
    }
  }
}

void manage_combobox_devicebus(GtkComboBox *Acombobox, Tdriveinfo *Adrive)
{
  GtkListStore *Lmodel = gtk_list_store_new(2, G_TYPE_INT, G_TYPE_STRING);
  GtkCellRenderer *Lcellrender = GTK_CELL_RENDERER(gtk_cell_renderer_text_new());
  GtkTreeIter Liter;
  GSList *Lcur;
  gint i;

  gtk_combo_box_set_model(Acombobox, GTK_TREE_MODEL(Lmodel));

  gtk_cell_layout_clear(GTK_CELL_LAYOUT(Acombobox));
  gtk_cell_layout_pack_start(GTK_CELL_LAYOUT(Acombobox), Lcellrender, TRUE);
  gtk_cell_layout_set_attributes(GTK_CELL_LAYOUT(Acombobox), Lcellrender,
    "text", 1, NULL);
  
  for(Lcur = Adrive->dev, i=0; Lcur; Lcur = g_slist_next(Lcur), i++) {
    gtk_list_store_append(Lmodel, &Liter);
    gtk_list_store_set(Lmodel, &Liter, 0, i, 1, (gchar *)Lcur->data, -1);
    if (i==Adrive->actuperiph) gtk_combo_box_set_active_iter(Acombobox, &Liter);
  }
}

#if 0
void prepare_properties_mediatreeview(GtkTreeView *Atreeview)
{
  GtkListStore *Lmodel = gtk_list_store_new(2, G_TYPE_STRING, G_TYPE_STRING);
  GtkCellRenderer *Lcellrender;
  GtkTreeViewColumn *Lcell;

  gtk_tree_view_set_model(Atreeview, GTK_TREE_MODEL(Lmodel));

  /* creation colonnes */
  Lcellrender = gtk_cell_renderer_text_new();
  Lcell = gtk_tree_view_column_new_with_attributes(("Label for Audio media"), Lcellrender, "text", 0, NULL);
  gtk_tree_view_append_column(GTK_TREE_VIEW(Atreeview), Lcell);

  Lcellrender = gtk_cell_renderer_text_new();
  Lcell = gtk_tree_view_column_new_with_attributes(("Label for Data media"), Lcellrender, "text", 1, NULL);
  gtk_tree_view_append_column(GTK_TREE_VIEW(Atreeview), Lcell);
}
#endif

void prepare_properties_devicestreeview(GtkTreeView *Atreeview)
{
  GtkListStore *Lmodel = gtk_list_store_new(5, G_TYPE_INT, GDK_TYPE_PIXBUF, G_TYPE_STRING,
                G_TYPE_STRING, G_TYPE_STRING);
  GtkCellRenderer *Lcellrender;
  GtkTreeViewColumn *Lcell;

  gtk_tree_view_set_model(Atreeview, GTK_TREE_MODEL(Lmodel));

  /* creation colonnes */
  Lcellrender = gtk_cell_renderer_pixbuf_new();
  Lcell = gtk_tree_view_column_new_with_attributes("", Lcellrender, "pixbuf", 1, NULL);
  gtk_tree_view_append_column(GTK_TREE_VIEW(Atreeview), Lcell);

  Lcellrender = gtk_cell_renderer_text_new();
  Lcell = gtk_tree_view_column_new_with_attributes(_("Location"), Lcellrender, "text", 2, NULL);
  gtk_tree_view_append_column(GTK_TREE_VIEW(Atreeview), Lcell);

  Lcellrender = gtk_cell_renderer_text_new();
  Lcell = gtk_tree_view_column_new_with_attributes(_("Type"), Lcellrender, "text", 3, NULL);
  gtk_tree_view_append_column(GTK_TREE_VIEW(Atreeview), Lcell);

  Lcellrender = gtk_cell_renderer_text_new();
  Lcell = gtk_tree_view_column_new_with_attributes(_("Name"), Lcellrender, "text", 4, NULL);
  gtk_tree_view_append_column(GTK_TREE_VIEW(Atreeview), Lcell);

}

void prepare_listeaudio(GtkTreeView *Atreeaudio)
{
  GtkTreeSelection *Lselection = gtk_tree_view_get_selection(GTK_TREE_VIEW(Atreeaudio));
  GtkListStore *Lmodel = gtk_list_store_new(7, G_TYPE_INT, GDK_TYPE_PIXBUF, G_TYPE_STRING,
                        G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_UINT);
  GtkCellRenderer *Lcellrender;
  GtkTreeViewColumn *Lcell;

  gtk_tree_selection_set_mode(Lselection, GTK_SELECTION_MULTIPLE);

  /* creation colonnes */
  Lcellrender = gtk_cell_renderer_pixbuf_new();
  Lcell = gtk_tree_view_column_new_with_attributes("", Lcellrender, "pixbuf", 1, NULL);
  gtk_tree_view_append_column(GTK_TREE_VIEW(Atreeaudio), Lcell);
	
  Lcellrender = gtk_cell_renderer_text_new();
  Lcell = gtk_tree_view_column_new_with_attributes(_("Track"), Lcellrender, "text", 2, NULL);
  gtk_tree_view_append_column(GTK_TREE_VIEW(Atreeaudio), Lcell);

  Lcellrender = gtk_cell_renderer_text_new();
  Lcell = gtk_tree_view_column_new_with_attributes(_("Length"), Lcellrender, "text", 3, NULL);
  gtk_tree_view_append_column(GTK_TREE_VIEW(Atreeaudio), Lcell);

  Lcellrender = gtk_cell_renderer_text_new();
  Lcell = gtk_tree_view_column_new_with_attributes(_("Location"), Lcellrender, "text", 4, NULL);
  gtk_tree_view_append_column(GTK_TREE_VIEW(Atreeaudio), Lcell);

  gtk_tree_view_set_model(Atreeaudio, GTK_TREE_MODEL(Lmodel));
}

void prepare_listedata(GtkTreeView *Atreedata, gchar *Atitle)
{
  GtkTreeSelection *Lselection = gtk_tree_view_get_selection(GTK_TREE_VIEW(Atreedata));
  GtkTreeStore *Lmodel = gtk_tree_store_new(7, G_TYPE_INT, GDK_TYPE_PIXBUF, G_TYPE_STRING,
                                G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_UINT);
  GtkTreeIter Liter;
  GtkCellRenderer *Lcellrender;
  GtkTreeViewColumn *Lcell;

  gtk_tree_selection_set_mode(Lselection, GTK_SELECTION_MULTIPLE);
  gtk_tree_view_set_enable_search(Atreedata, TRUE);
  gtk_tree_view_set_model(Atreedata, GTK_TREE_MODEL(Lmodel));

  /* creation colonnes */
  Lcellrender = gtk_cell_renderer_pixbuf_new();
  Lcell = gtk_tree_view_column_new_with_attributes("", Lcellrender, "pixbuf", 1, NULL);
  gtk_tree_view_append_column(Atreedata, Lcell);
	
  Lcellrender = gtk_cell_renderer_text_new();
  Lcell = gtk_tree_view_column_new_with_attributes(_("Name"), Lcellrender, "text", 2, NULL);
  gtk_tree_view_append_column(Atreedata, Lcell);

  Lcellrender = gtk_cell_renderer_text_new();
  Lcell = gtk_tree_view_column_new_with_attributes(_("Size"), Lcellrender, "text", 3, NULL);
  gtk_tree_view_append_column(Atreedata, Lcell);

  Lcellrender = gtk_cell_renderer_text_new();
  Lcell = gtk_tree_view_column_new_with_attributes(_("Location"), Lcellrender, "text", 4, NULL);
  gtk_tree_view_append_column(Atreedata, Lcell);

  /* icone de base dans la liste des fichiers */
  gtk_tree_store_append(GTK_TREE_STORE(Lmodel), &Liter, NULL);
  gtk_tree_store_set(Lmodel, &Liter, 0, TYPE_CD, 1, GCDpetiteIcone, 2, Atitle, 3, "", 4, "", 5, "", 6, 0, -1);
}

/* fenetre de confirmation avec une checkbox */
GHashTable *create_dialog_confirm_operation (GtkWidget *Aparent,
    gchar *Alabel, gchar *Acheckboxlbl, gboolean Acheckboxstatus)
{
  gchar *Ltemplate = PACKAGE_DATA_DIR "/" PACKAGE "/dialog_confirm_operation.glade";
  GladeXML *Lxml = glade_xml_new(Ltemplate, NULL,NULL);
  GtkWidget *Ldialog;
  GtkLabel *Llabel;
  GtkToggleButton *Ltoggleoption;
  GHashTable *Lhash = _hash();

  if (!Lxml) {
    g_error("Cannot load '%s': %s\n", Ltemplate, g_strerror(errno));
  }

  Ldialog = glade_xml_get_widget(Lxml, "dialog_confirm_operation");
  gtk_window_set_transient_for(GTK_WINDOW(Ldialog), GTK_WINDOW(Aparent));
  g_hash_table_insert(Lhash, "window", Ldialog);

  /* titre */
  Llabel = GTK_LABEL(glade_to_hash(Lxml, Lhash, "label"));
  gtk_label_set_text(Llabel, Alabel);
  
  /* effacer les cdrw en mode fast ? */
  Ltoggleoption = GTK_TOGGLE_BUTTON(glade_to_hash(Lxml, Lhash, "checkbox"));
  if (Acheckboxlbl) {
    gtk_toggle_button_set_active(Ltoggleoption, Acheckboxstatus);
    gtk_button_set_label(GTK_BUTTON(Ltoggleoption), Acheckboxlbl);
  } else {
    gtk_widget_hide(GTK_WIDGET(Ltoggleoption));
  }

  return Lhash;
}

/* fenetre selection d'une operation sur un dvd */
GHashTable *create_dialog_select_dvdoperation (GtkWidget *Aparent)
{
  gchar *Ltemplate = PACKAGE_DATA_DIR "/" PACKAGE "/dialog_select_operation.glade";
  GladeXML *Lxml = glade_xml_new(Ltemplate, NULL,NULL);
  GtkWidget *Ldialog;
  GHashTable *Lhash = _hash();

  if (!Lxml) {
    g_error("Cannot load '%s': %s\n", Ltemplate, g_strerror(errno));
  }

  Ldialog = glade_xml_get_widget(Lxml, "dialog_select_operation");
  gtk_window_set_transient_for(GTK_WINDOW(Ldialog), GTK_WINDOW(Aparent));
  g_hash_table_insert(Lhash, "window", Ldialog);

  /* titre */
  glade_to_hash(Lxml, Lhash, "label");
  
  /* commencer une session ou merger ? */
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(glade_to_hash(Lxml, Lhash, "burninitial")), TRUE);
  glade_to_hash(Lxml, Lhash, "burnmerge");

  return Lhash;
}
/* fenetre proprietes */
GHashTable *create_dialog_proprietes (GtkWidget *Aparent)
{
  gchar *Ltemplate = PACKAGE_DATA_DIR "/" PACKAGE "/dialog_properties.glade";
  GladeXML *Lxml = glade_xml_new(Ltemplate, NULL,NULL);
  GtkToggleButton *Ltoggleoption;
  GtkEntry *Ldirtmpvalue;
  GtkTreeView *Ltreeview;
  GtkWidget *Ldialog;
  GtkButton *Lbtn;
  GHashTable *Lhash = _hash();

  if (!Lxml) {
    g_error("Cannot load '%s': %s\n", Ltemplate, g_strerror(errno));
  }

  Ldialog = glade_xml_get_widget(Lxml, "dialog_properties");
  gtk_window_set_transient_for(GTK_WINDOW(Ldialog), GTK_WINDOW(Aparent));
  g_hash_table_insert(Lhash, "window", Ldialog);

  /** onglet "General" **/
  
  /* overburn actif ? */
  Ltoggleoption = GTK_TOGGLE_BUTTON(glade_to_hash(Lxml, Lhash, "overburn"));
  gtk_toggle_button_set_active(Ltoggleoption, conf_get_boolean("overburn"));

  /* effacer les cdrw avant ecriture */
  Ltoggleoption = GTK_TOGGLE_BUTTON(glade_to_hash(Lxml, Lhash, "autoblank"));
  gtk_toggle_button_set_active(Ltoggleoption, conf_get_boolean("autoblank"));

  /* effacer les cdrw en mode fast ? */
  Ltoggleoption = GTK_TOGGLE_BUTTON(glade_to_hash(Lxml, Lhash, "fastblank"));
  gtk_toggle_button_set_active(Ltoggleoption, conf_get_boolean("fastblank"));

  /* ejecter le cdr apres l'operation ? */
  Ltoggleoption = GTK_TOGGLE_BUTTON(glade_to_hash(Lxml, Lhash, "eject"));
  gtk_toggle_button_set_active(Ltoggleoption, conf_get_boolean("eject"));

  /* afficher le status bar ? */
  Ltoggleoption = GTK_TOGGLE_BUTTON(glade_to_hash(Lxml, Lhash, "statusbar"));
  gtk_toggle_button_set_active(Ltoggleoption, conf_get_boolean("statusbar"));
  
  /* combo taille des icones */
  remplirecombo(GTK_COMBO_BOX(glade_to_hash(Lxml, Lhash, "iconsizelist")), "", 
      Gtypeicosize, TRUE, conf_get_string("iconsize"));

  /* sauver les donnees lorsque l'on quitte ? */
  Ltoggleoption = GTK_TOGGLE_BUTTON(glade_to_hash(Lxml, Lhash, "saveconfig"));
  gtk_toggle_button_set_active(Ltoggleoption, conf_get_boolean("saveconfig"));

  /* fonctions etendues ? */
#if 0  
  Ltoggleoption = GTK_TOGGLE_BUTTON(glade_to_hash(Lxml, Lhash, "extended"));
  gtk_toggle_button_set_active(Ltoggleoption, conf_get_boolean("extended"));
#endif

  /* repertoire temporraire */
  Ldirtmpvalue = GTK_ENTRY(glade_to_hash(Lxml, Lhash, "dirtmpvalue"));
  gtk_entry_set_text(Ldirtmpvalue, conf_get_string("tmpdir"));

  /** onglet "Format des medias" **/
#if 0
  Ltreeview = GTK_TREE_VIEW(glade_to_hash(Lxml, Lhash, "medialist"));
  prepare_properties_mediatreeview(Ltreeview);
  remplirelistemedia(Ltreeview);

  Lbtn = GTK_BUTTON(glade_xml_get_widget(Lxml, "addmediaformat"));
  g_signal_connect(G_OBJECT(Lbtn), "clicked", G_CALLBACK(on_addmediaformat), Lhash);
#endif


  /** onglet "Programmes externes" **/
  glade_to_hash_list(Lxml, Lhash, "cdrecord", "cdrecordlbl", "cdrecordpara", NULL);
  glade_to_hash_list(Lxml, Lhash, "cdrdao", "cdrdaolbl", "cdrdaopara", NULL);
  glade_to_hash_list(Lxml, Lhash, "mkisofs", "mkisofslbl", "mkisofspara", NULL);
  glade_to_hash_list(Lxml, Lhash, "readcd", "readcdlbl", "readcdpara", NULL);
  glade_to_hash_list(Lxml, Lhash, "sox", "soxlbl", "soxpara", NULL);
  glade_to_hash_list(Lxml, Lhash, "growisofs", "growisofslbl", "growisofspara", NULL);
  glade_to_hash_list(Lxml, Lhash, "dvd+rw-mediainfo", "dvd+rw-mediainfolbl", "dvd+rw-mediainfopara", NULL);
  glade_to_hash_list(Lxml, Lhash, "dvd+rw-format", "dvd+rw-formatlbl", "dvd+rw-formatpara", NULL);
  glade_to_hash(Lxml, Lhash, "popupdevices");

  /** onglet "Lecteurs" **/
  Ltreeview = GTK_TREE_VIEW(glade_to_hash(Lxml, Lhash, "periphdata"));
  prepare_properties_devicestreeview(Ltreeview);
  g_signal_connect(G_OBJECT(Ltreeview), "button-press-event", G_CALLBACK(gtk_do_eventbuttonpress), Lhash);
  g_signal_connect(G_OBJECT(Ltreeview), "popup-menu", G_CALLBACK(key_popupmenu_devices), Lhash);

  /* popup sur les peripheriques */
  g_signal_connect(G_OBJECT(glade_to_hash(Lxml, Lhash, "popupdevices_edit")),
      "activate", G_CALLBACK(gtk_devices_edit), Lhash);
  g_signal_connect(G_OBJECT(glade_to_hash(Lxml, Lhash, "popupdevices_remove")),
      "activate", G_CALLBACK(gtk_devices_remove), Lhash);

  g_hash_table_insert(Lhash, "topwindow", Aparent);
  
  maj_proprietes_prog(Lhash);
  remplirelistegraveur(Ltreeview);

  Lbtn = GTK_BUTTON(glade_xml_get_widget(Lxml, "dirtmp"));
  g_signal_connect(G_OBJECT(Lbtn), "clicked", G_CALLBACK(gtk_file_sel), Lhash);

  Lbtn = GTK_BUTTON(glade_xml_get_widget(Lxml, "scanprog"));
  g_signal_connect(G_OBJECT(Lbtn), "clicked", G_CALLBACK(chercheprog), Lhash);

  Lbtn = GTK_BUTTON(glade_xml_get_widget(Lxml, "scandevice"));
  g_signal_connect(G_OBJECT(Lbtn), "clicked", G_CALLBACK(cherchelecteur), Lhash);

  Lbtn = GTK_BUTTON(glade_to_hash(Lxml, Lhash, "adddevice"));
  g_signal_connect(G_OBJECT(Lbtn), "clicked", G_CALLBACK(gtk_devices_add), Lhash);
  
 
  return Lhash;
}

/* premiere utilisation de graveman, bienvenue ! */
void welcome_to_graveman(void)
{
  gchar *Ltemplate = PACKAGE_DATA_DIR "/" PACKAGE "/dialog_welcome.glade";
  GladeXML *Lxml = glade_xml_new(Ltemplate, NULL,NULL);
  GtkWidget *Ldialog;

  if (!Lxml) {
    g_error("Cannot load '%s': %s\n", Ltemplate, g_strerror(errno));
  }

  Ldialog = glade_xml_get_widget(Lxml, "dialog_welcome"); 

  gtk_dialog_run(GTK_DIALOG(Ldialog));
  gtk_widget_destroy(Ldialog);

  g_free(Lxml);
}

/* mise a jour d'une bar indicant le remplissage, passage en rouge si le cd est plein */
void switch_pbar_status(GtkProgressBar *Apbar, guint64 Amaxlen, guint64 Acurlen, Ttypemajpbar Aupdatetext) {
  gdouble Lpremp = (1.0/Amaxlen)*Acurlen;
  if (Lpremp>1) { 
    GdkColor Lcolor;
    gdk_color_parse ("red", &Lcolor);
    Lpremp = 1;
    gtk_widget_modify_bg (GTK_WIDGET(Apbar), GTK_STATE_NORMAL, &Lcolor);
    gtk_widget_modify_bg (GTK_WIDGET(Apbar), GTK_STATE_ACTIVE, &Lcolor);
    gtk_widget_modify_bg (GTK_WIDGET(Apbar), GTK_STATE_PRELIGHT, &Lcolor);
    gtk_widget_modify_bg (GTK_WIDGET(Apbar), GTK_STATE_SELECTED, &Lcolor);
  } else {
    gtk_widget_modify_bg (GTK_WIDGET(Apbar), GTK_STATE_NORMAL, NULL);
    gtk_widget_modify_bg (GTK_WIDGET(Apbar), GTK_STATE_ACTIVE, NULL);
    gtk_widget_modify_bg (GTK_WIDGET(Apbar), GTK_STATE_PRELIGHT, NULL);
    gtk_widget_modify_bg (GTK_WIDGET(Apbar), GTK_STATE_SELECTED, NULL);
  }
  gtk_progress_bar_set_fraction(Apbar, Lpremp);

  if (Aupdatetext != PB_NONE) {
    gchar *Ltmp = Aupdatetext == PB_UPDATE_AUDIO ? format_length(Acurlen) : format_size(Acurlen);
    gtk_progress_bar_set_text(GTK_PROGRESS_BAR(Apbar), Ltmp);
    g_free(Ltmp);
  }
}

/* effacer un cd reinscriptible */
void show_erasecdrwwindow(GHashTable *Ahash)
{
  GtkWidget *Lwindow1 = g_hash_table_lookup(Ahash, "window");
  GladeXML *Lxmlencours = create_window_encours(Lwindow1);
  gint Lcont = 2;
  gint Lpid;
  gboolean Loperationstatus = FALSE;
  gboolean Labort = FALSE;
  GtkWidget *Lprogressbar;
  GtkLabel *Llabel;
  GtkWidget *Lcancel;
  GtkWidget *Lwin;
  GHashTable *Lerasecdhash = _hash();
  GError *Lerror = NULL;
  GtkWidget *Lstatusbox = NULL;

  Lwin = glade_xml_get_widget(Lxmlencours, "window_inprogress"); 
  Llabel = GTK_LABEL(glade_xml_get_widget(Lxmlencours, "labelava"));
  gtk_label_set_text(Llabel, _("Erasing CD-RW in progress, please wait..."));

  
  Lprogressbar = glade_xml_get_widget(Lxmlencours, "progress");
  g_hash_table_insert(Lerasecdhash, "cont", &Lcont);
  g_hash_table_insert(Lerasecdhash, "pid", &Lpid);
  g_hash_table_insert(Lerasecdhash, "gabort", &Labort);
  g_hash_table_insert(Lerasecdhash, "gerror", &Lerror);
  g_hash_table_insert(Lerasecdhash, "operationstatus", &Loperationstatus);
  g_hash_table_insert(Lerasecdhash, "labelava", Llabel);
  g_hash_table_insert(Lerasecdhash, "progress", Lprogressbar);
  g_hash_table_insert(Lerasecdhash, "dstothercombo", g_hash_table_lookup(Ahash, "dstothercombo"));
  g_hash_table_insert(Lerasecdhash, "usefastblank", g_hash_table_lookup(Ahash, "usefastblank"));

  /* bouton annuler */
  Lcancel = glade_xml_get_widget(Lxmlencours, "cancelbtn");
  g_signal_connect(G_OBJECT(Lcancel), "clicked", G_CALLBACK(abort_encours), Lerasecdhash);
  g_signal_connect(G_OBJECT(Lwin), "delete-event", G_CALLBACK(delete_event_encours), Lerasecdhash);

  gtk_widget_show(Lwin);
  g_timeout_add(500, encours_callback, Lerasecdhash);

  /* operation en elle meme */
  perform_erase_cdrw(Lerasecdhash, &Lerror);
  
  if (Labort) {
    Lstatusbox = gtk_message_dialog_new(GTK_WINDOW(Lwin),
                                     GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK,
                                     _("Operation aborted by user !"));
  } else if (Lerror) {
    Lstatusbox = gtk_message_dialog_new(GTK_WINDOW(Lwin),
                      GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK,
                      Lerror->message);
  } else {
     Lstatusbox = gtk_message_dialog_new(GTK_WINDOW(Lwin),
               GTK_DIALOG_MODAL, GTK_MESSAGE_INFO, GTK_BUTTONS_OK,
               _("Operation successful"));
  }
  gtk_dialog_run(GTK_DIALOG(Lstatusbox));
  gtk_widget_destroy(Lstatusbox);
  
  gtk_widget_destroy(Lwin);
  g_hash_table_destroy(Lerasecdhash);

  if (Lerror) g_error_free(Lerror);
}

/* cloturer un cd */
void show_fixcdwindow(GHashTable *Ahash)
{
  GtkWidget *Lwindow1 = g_hash_table_lookup(Ahash, "window");
  GladeXML *Lxmlencours = create_window_encours(Lwindow1);
  gint Lcont = 2;
  gint Lpid;
  gboolean Loperationstatus = FALSE;
  gboolean Labort = FALSE;
  GtkWidget *Lprogressbar;
  GtkLabel *Llabel;
  GtkWidget *Lcancel;
  GtkWidget *Lwin;
  GHashTable *Lfixcdhash = _hash();
  GError *Lerror = NULL;
  GtkWidget *Lstatusbox = NULL;

  Lwin = glade_xml_get_widget(Lxmlencours, "window_inprogress"); 
  Llabel = GTK_LABEL(glade_xml_get_widget(Lxmlencours, "labelava"));
  gtk_label_set_text(Llabel, _("Fixating CD-R in progress, please wait..."));

  
  Lprogressbar = glade_xml_get_widget(Lxmlencours, "progress");
  g_hash_table_insert(Lfixcdhash, "cont", &Lcont);
  g_hash_table_insert(Lfixcdhash, "pid", &Lpid);
  g_hash_table_insert(Lfixcdhash, "gabort", &Labort);
  g_hash_table_insert(Lfixcdhash, "gerror", &Lerror);
  g_hash_table_insert(Lfixcdhash, "operationstatus", &Loperationstatus);
  g_hash_table_insert(Lfixcdhash, "labelava", Llabel);
  g_hash_table_insert(Lfixcdhash, "progress", Lprogressbar);
  g_hash_table_insert(Lfixcdhash, "dstothercombo", g_hash_table_lookup(Ahash, "dstothercombo"));

  /* bouton annuler */
  Lcancel = glade_xml_get_widget(Lxmlencours, "cancelbtn");
  g_signal_connect(G_OBJECT(Lcancel), "clicked", G_CALLBACK(abort_encours), Lfixcdhash);
  g_signal_connect(G_OBJECT(Lwin), "delete-event", G_CALLBACK(delete_event_encours), Lfixcdhash);

  gtk_widget_show(Lwin);
  g_timeout_add(500, encours_callback, Lfixcdhash);

  /* operation en elle meme */
  perform_fix_cd(Lfixcdhash, &Lerror);
  
  if (Labort) {
    Lstatusbox = gtk_message_dialog_new(GTK_WINDOW(Lwin),
                                     GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK,
                                     _("Operation aborted by user !"));
  } else if (Lerror) {
    Lstatusbox = gtk_message_dialog_new(GTK_WINDOW(Lwin),
                      GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK,
                      Lerror->message);
  } else {
     Lstatusbox = gtk_message_dialog_new(GTK_WINDOW(Lwin),
               GTK_DIALOG_MODAL, GTK_MESSAGE_INFO, GTK_BUTTONS_OK,
               _("Operation successful"));
  }
  gtk_dialog_run(GTK_DIALOG(Lstatusbox));
  gtk_widget_destroy(Lstatusbox);
  
  gtk_widget_destroy(Lwin);
  g_hash_table_destroy(Lfixcdhash);

  if (Lerror) g_error_free(Lerror);
}

/* formater un dvd */
void show_dvdformatwindow(GHashTable *Ahash, gchar *Atitle, Ttypeformatdvd Aoperation)
{
  GtkWidget *Lwindow1 = g_hash_table_lookup(Ahash, "window");
  GladeXML *Lxmlencours = create_window_encours(Lwindow1);
  gint Lcont = 2;
  gint Lpid;
  gboolean Loperationstatus = FALSE;
  gboolean Labort = FALSE;
  GtkWidget *Lprogressbar;
  GtkLabel *Llabel;
  GtkWidget *Lcancel;
  GtkWidget *Lwin;
  GHashTable *Lformatdvdhash = _hash();
  GError *Lerror = NULL;
  GtkWidget *Lstatusbox = NULL;

  Lwin = glade_xml_get_widget(Lxmlencours, "window_inprogress"); 
  Llabel = GTK_LABEL(glade_xml_get_widget(Lxmlencours, "labelava"));
  gtk_label_set_text(Llabel, Atitle);

  
  Lprogressbar = glade_xml_get_widget(Lxmlencours, "progress");
  g_hash_table_insert(Lformatdvdhash, "cont", &Lcont);
  g_hash_table_insert(Lformatdvdhash, "pid", &Lpid);
  g_hash_table_insert(Lformatdvdhash, "gabort", &Labort);
  g_hash_table_insert(Lformatdvdhash, "gerror", &Lerror);
  g_hash_table_insert(Lformatdvdhash, "operationstatus", &Loperationstatus);
  g_hash_table_insert(Lformatdvdhash, "labelava", Llabel);
  g_hash_table_insert(Lformatdvdhash, "progress", Lprogressbar);
  g_hash_table_insert(Lformatdvdhash, "dstothercombo", g_hash_table_lookup(Ahash, "dstothercombo"));

  /* bouton annuler */
  Lcancel = glade_xml_get_widget(Lxmlencours, "cancelbtn");
  g_signal_connect(G_OBJECT(Lcancel), "clicked", G_CALLBACK(abort_encours), Lformatdvdhash);
  g_signal_connect(G_OBJECT(Lwin), "delete-event", G_CALLBACK(delete_event_encours), Lformatdvdhash);

  gtk_widget_show(Lwin);
//  g_timeout_add(500, encours_callback, Lformatdvdhash);
  /* operation en elle meme */
  perform_format_dvd(Lformatdvdhash, Aoperation, &Lerror);
  
  if (Labort) {
    Lstatusbox = gtk_message_dialog_new(GTK_WINDOW(Lwin),
                                     GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK,
                                     _("Operation aborted by user !"));
  } else if (Lerror) {
    Lstatusbox = gtk_message_dialog_new(GTK_WINDOW(Lwin),
                      GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK,
                      Lerror->message);
  } else {
     Lstatusbox = gtk_message_dialog_new(GTK_WINDOW(Lwin),
               GTK_DIALOG_MODAL, GTK_MESSAGE_INFO, GTK_BUTTONS_OK,
               _("Operation successful"));
  }
  gtk_dialog_run(GTK_DIALOG(Lstatusbox));
  gtk_widget_destroy(Lstatusbox);
  
  gtk_widget_destroy(Lwin);
  g_hash_table_destroy(Lformatdvdhash);

  if (Lerror) g_error_free(Lerror);
}

/*
 * vim:et:ts=8:sts=2:sw=2
 */
