/* matos.c
 * Copyright (C) 2004, 2005 Sylvain Cresto <scresto@gmail.com>
 *
 * This file is part of graveman!
 *
 * graveman! is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or
 * (at your option) any later version.
 * 
 * graveman! is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA. 
 * 
 * URL: http://www.nongnu.org/graveman/
 *
 */

/* initialisation des devices */

#include "graveman.h"

GSList *Glistdrives = NULL;

Tdriveinfo *find_drive(gchar *Aident) {
  GSList *Lcur, *Lcurdev;
  Tdriveinfo *Ldrive;
 
  for (Lcur = Glistdrives; Lcur; Lcur = g_slist_next(Lcur)) { 
    Ldrive = (Tdriveinfo *)Lcur->data;

    for (Lcurdev = Ldrive->dev; Lcurdev; Lcurdev = g_slist_next(Lcurdev)) {

  _DEB("om compare [%s] et [%s]\n", Aident, (gchar *)Lcurdev->data);
      if (!strcmp(Aident, (gchar *)Lcurdev->data)) {
        _DEB("ici GL vitesse => %d\n", Ldrive->vitesse);
        return Ldrive;
      }
    }
  }

  return NULL;
}

/* ajout d'un lecteur a la liste des lecteurs */
void append_this_drive(Tdriveinfo *Adrive) {
  Glistdrives=g_slist_append(Glistdrives, Adrive);
}

/* liberation de la zone memoire occupe par une structure lecteur */
void free_this_drive(Tdriveinfo *Adrive) {
  GSList *Lcur;
  if (g_slist_length(Adrive->dev)) {
    for (Lcur = Adrive->dev; Lcur; Lcur = g_slist_next(Lcur)) {
      g_free((gchar *)Lcur->data);
    }
    g_slist_free(Adrive->dev);
  }
  if (g_slist_length(Adrive->bus)) {
    for (Lcur = Adrive->bus; Lcur; Lcur = g_slist_next(Lcur)) {
      g_free((gchar *)Lcur->data);
    }
    g_slist_free(Adrive->bus);
  }

  g_free(Adrive->name);
}

void free_drives(gboolean Aremovemanu)
{
  GSList *Ltmp = Glistdrives, *Lcurlist;
  gboolean Ldonotdel;
  Tdriveinfo *Lcur;

  while (Ltmp) {
    Lcurlist = Ltmp;
    Lcur = (Tdriveinfo *)Ltmp->data;

    Ldonotdel = (Lcur->manual == TRUE && Aremovemanu==FALSE);

    Ltmp = g_slist_next(Ltmp);

    if (Ldonotdel == FALSE) {
      free_this_drive((Tdriveinfo *)Lcurlist->data);
    
      Glistdrives = g_slist_delete_link(Glistdrives, Lcurlist);
    }
  }

  if (g_slist_length(Glistdrives)==0) Glistdrives = NULL;
}

void get_current_matos(gboolean *Areadcd, gboolean *Awritecdr, gboolean *Awritecdrw, gboolean *Areaddvd, gboolean *Awritedvd)
{
  GSList *Lcur;
  Tdriveinfo *Ldrive;

  if (Areadcd) *Areadcd = FALSE;
  if (Awritecdr) *Awritecdr = FALSE;
  if (Awritecdrw) *Awritecdrw = FALSE;
  if (Areaddvd) *Areaddvd = FALSE;
  if (Awritedvd) *Awritedvd = FALSE;

  for (Lcur = Glistdrives; Lcur; Lcur = g_slist_next(Lcur)) { 
    Ldrive = (Tdriveinfo *)Lcur->data;

    if (DRIVE_READER(Ldrive) && Areadcd) *Areadcd = TRUE;
    if (DRIVE_WRITER(Ldrive) && Awritecdr) *Awritecdr = TRUE; 
    if (DRIVE_CDRW_WRITER(Ldrive) && Awritecdrw) *Awritecdrw = TRUE; 
    if (DRIVE_DVDREADER(Ldrive) && Areaddvd) *Areaddvd = TRUE;
    if (DRIVE_DVDWRITER(Ldrive) && Awritedvd) *Awritedvd = TRUE;
  }
}

void insert_or_update_drive(gchar *Adev, gchar *Amarque, gchar *Amodel, gchar *Aquoi, Tsearchdrive *Adrivedesc)
{
  /* on commence par construire l'identifiant */
  gchar *Lident = g_strdup_printf("%s %s %s", Amarque, Amodel, Aquoi);
  GSList *Lcur = NULL;
  Tdriveinfo *Ldrive;

  for (Lcur = Glistdrives; Lcur; Lcur = g_slist_next(Lcur)) {
    Ldrive = (Tdriveinfo *)Lcur->data;

    if (!strcmp(Ldrive->name, Lident) && strcmp((gchar *)g_slist_last(Ldrive->bus)->data, Adrivedesc->bus)) {
_DEB("mise a jour du lecteur [%s]\n", Lident);      
      /* oui ce lecteur existe deja, c'est donc lui qui l'on va mettre a jour */
      break;
    }
  }

  if (!Lcur) {
    /* le lecteur n'existe pas encore, on l'ajoute a la liste */

    Ldrive = g_malloc0(sizeof(Tdriveinfo));
    Ldrive->name = Lident;

    Glistdrives = g_slist_append(Glistdrives, Ldrive);
_DEB("nouveau lecteur [%s]\n", Lident);      
  } else {
    g_free(Lident);
  }

_DEB("le bus en question [%s] = [%s]\n", Adrivedesc->bus, Adev);
  Ldrive->bus = g_slist_append(Ldrive->bus, g_strdup(Adrivedesc->bus));
  Ldrive->dev = g_slist_append(Ldrive->dev,
      g_strdup_printf("%s%s", Adrivedesc->useline, strcmp(Adrivedesc->bus, "IDE") ? Adev : ""));
}

/* operation de copie */
gboolean burn_copy(GHashTable *Ahash, GError **Aerror)
{
  GtkWidget *Llecteur = g_hash_table_lookup(Ahash, "srccopycombo");
  GtkWidget *Lgraveur = g_hash_table_lookup(Ahash, "dstcopycombo");
  GtkEntry *Llecteuriso = GTK_ENTRY(g_hash_table_lookup(Ahash, "srccopybtnvalue"));
  GtkEntry *Lgraveuriso = GTK_ENTRY(g_hash_table_lookup(Ahash, "dstcopybtnvalue"));
  gboolean *Labort = (gboolean *)g_hash_table_lookup(Ahash, "gabort");
  gchar *Lsrc = get_combo_value(Llecteur);
  gchar *Ldst = get_combo_value(Lgraveur);
  gchar *Liso = NULL;
  gchar *Ltxt;
  gboolean Lstatus;
  gboolean Loperationstatus = FALSE;
  gboolean Lsimul = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(g_hash_table_lookup(Ahash, "copysimul")));
  gint Ltodo = gtk_spin_button_get_value(GTK_SPIN_BUTTON(g_hash_table_lookup(Ahash, "nbrcdcopy")));
  gint Ldone = 1;
  gchar *Ltmpdir = NULL;
  const gchar *Lptriso;
_DEB("DEBUT COPIE !! 0");

  if (!strcmp(Lsrc, "iso") && !strcmp(Ldst, "iso")) {
    g_set_error(Aerror, GRAVEMAN_ERROR, _ERR_INAPPROPRIATE_MODE, 
      _("Cannot duplicate an iso image to an another iso image with graveman, just copy this file !"));
    return FALSE;
  }

  /* referecement variables */
  g_hash_table_insert(Ahash, "todo", &Ltodo); /* a faire */
  g_hash_table_insert(Ahash, "done", &Ldone); /* fais */
  g_hash_table_insert(Ahash, "operationstatus", &Loperationstatus); /* resultat de l'operation */
  g_hash_table_insert(Ahash, "tmpdir", &Ltmpdir); /* repertoire temporraire */
  g_hash_table_insert(Ahash, "gerror", Aerror);  /* pointeur retour des erreurs */

  if (!strcmp(Lsrc, "iso")) {
    /* copie d'une image vers un cd */
    Lptriso = gtk_entry_get_text(Llecteuriso);
    Liso = _FILENAME(Lptriso);

    /* on test si on a bien acces au fichier iso source */
    if (!*Liso) {
      g_set_error(Aerror, GRAVEMAN_ERROR, _ERR_INAPPROPRIATE_DATA, 
          _("A valid iso image location is required in the \"Duplicate from\" field."));
      Lstatus = FALSE;
    } else if (access(Liso, R_OK + F_OK)==-1) {
      g_set_error(Aerror, G_FILE_ERROR, g_file_error_from_errno(errno), "%s:%s\n%s",
          _("Cannot read iso image source file"),
          Liso, g_strerror(errno));
      Lstatus = FALSE;
    } else {
      g_hash_table_insert(Ahash, "iso", &Liso); /* image iso */
      Lstatus = burn_from_image("copy", Ahash, Aerror);
      g_hash_table_remove(Ahash, "iso");
    }
    g_free(Liso);
  } else if (!strcmp(Ldst, "iso")) {
    /* copie d'un cd vers une image */
    struct stat Lfstat;
    Lptriso = gtk_entry_get_text(Lgraveuriso);
    Liso = _FILENAME(Lptriso);
    /* si le fichier existe deja on demande confirmatation avant de l'ecraser */
    Ltxt = NULL;
    if (!*Liso) {
      g_set_error(Aerror, GRAVEMAN_ERROR, _ERR_INAPPROPRIATE_DATA, 
            _("A valid iso image location is required the \"Duplicate to\" field."));
      Lstatus = FALSE;
    } else if (stat(Liso, &Lfstat) == -1) {
      if (errno != ENOENT) Ltxt = _("Cannot access file");
    } else if (access(Liso, W_OK)==-1) {
      Ltxt = _("Cannot overwrite file");
    }
    if (Ltxt) {
      g_set_error(Aerror, G_FILE_ERROR, g_file_error_from_errno(errno), "%s: %s\n%s",
          Ltxt, Liso, g_strerror(errno));
      Lstatus = FALSE;
    } else {
      g_hash_table_insert(Ahash, "iso", &Liso); /* image iso */
      Lstatus = make_image(Ahash, Aerror);
      g_hash_table_remove(Ahash, "iso");
      g_free(Liso);
    }
  } else {
    gchar *Ltmpdir;
    /* on ajoute une tache pour la lecture, 
     * si il y a simulation alors ajoute une tache a faire */
    Ltodo = Ltodo + 1 + (Lsimul == TRUE ? 1 : 0);
    
      /* copie d'un cd vers un cd
       * on passe quand meme vers une image temporraire pour le moment,
       * c'est trop le bordel sinon ! */
_DEB("DEBUT COPIE !!");
    Ltmpdir = g_strdup_printf("%s/%s", conf_get_string_def("tmpdir", "/tmp"), "gravemanXXXXXX");

    if (!mkdtemp(Ltmpdir)) {
      g_set_error(Aerror, G_FILE_ERROR, g_file_error_from_errno(errno), "%s %s: %s",
              _("Cannot create directory"), Ltmpdir, g_strerror(errno));    
      Lstatus = FALSE;
    } else {
      Ltmpdir = g_realloc(Ltmpdir, strlen(Ltmpdir)+strlen("/tmpiso.raw")+1);
      strcat(Ltmpdir, "/tmpiso.raw");

      g_hash_table_insert(Ahash, "iso", &Ltmpdir); /* image iso */

      /* on copie donc vers l'iso */
      Lstatus = make_image(Ahash, Aerror);
      if (Lstatus == TRUE && *Labort == FALSE) {
        /* et maintenant dans le sens inverse si tout va toujours bien */
        Ldone++;

        /* si le lecteur et le graveur sont les meme alors on demande a l'utilisateur
         * de changer de CD.. ! */
        if (!strcmp(Lsrc, Ldst)) {
          gint Lrep;
          GtkWidget *Lconfirm = gtk_message_dialog_new(NULL,
                                              GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION,
                                              GTK_BUTTONS_YES_NO,
                 _("Reading is finished, now you should insert a CD-R, do you want to continue operation ?"));

          /* on eject le CD */
          eject_cd(Lsrc, NULL);
          
          Lrep = gtk_dialog_run(GTK_DIALOG(Lconfirm));
          gtk_widget_destroy(Lconfirm);
          if (Lrep == GTK_RESPONSE_NO) {
            /* si c'est non alors on arrete */
            *Labort = TRUE;
            Lstatus = TRUE;
          }
        }
       
        if (Lstatus == TRUE && *Labort == FALSE) { 
          Lstatus = burn_from_image("copy", Ahash, Aerror);
        }
      }
      if ((Ltxt=strrchr(Ltmpdir, '/'))) *Ltxt=0;
    
      deltempdir(Ltmpdir);

      g_hash_table_remove(Ahash, "iso");
    }
    g_free(Ltmpdir);
  }

  g_free(Ldst);
  g_free(Lsrc);
  return Lstatus;
}

/* operation gravure cd de donnee */
gboolean burn_data(GHashTable *Ahash, GError **Aerror)
{
  gint Ltodo = gtk_spin_button_get_value(GTK_SPIN_BUTTON(g_hash_table_lookup(Ahash, "nbrcddata")));
  gboolean Lsimul = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(g_hash_table_lookup(Ahash, "datasimul")));
  GtkEntry *Lgraveuriso = GTK_ENTRY(g_hash_table_lookup(Ahash, "dstdatabtnvalue"));
  GtkWidget *Lgraveur = g_hash_table_lookup(Ahash, "dstdatacombo");
  gboolean *Labort = g_hash_table_lookup(Ahash, "gabort");
  gint Ldone = 1;
  gchar *Ldst = get_combo_value(Lgraveur);
  gchar *Ltmpdir = NULL;
  gchar *Lextrapara = NULL;
  gchar *Liso = NULL;
  gboolean Loperationstatus = FALSE;
  gboolean Lstatus;

  g_hash_table_insert(Ahash, "todo", &Ltodo); /* a faire */
  g_hash_table_insert(Ahash, "done", &Ldone); /* fais */
  g_hash_table_insert(Ahash, "operationstatus", &Loperationstatus); /* resultat de l'operation */
  g_hash_table_insert(Ahash, "gerror", Aerror);  /* pointeur retour des erreurs */
  g_hash_table_insert(Ahash, "tmpdir", &Ltmpdir); /* repertoire temporraire */

  /* on retourne dans ltmp le nom du repertoire temporraire utilise pour
   * l'operation */
  Lstatus = preparedata(Ahash, Aerror);
_DEB("ici LDST => %s\n", Ldst);
  if (strcmp(Ldst, "iso")) {
    Liso = g_strdup_printf("%s.iso", Ltmpdir);
    Ltodo=Ltodo+(Lsimul ? 2 : 1); /* + 1 pour l'ecriture de l'image iso et 1 pour la simulation */
  } else {
    Liso = _FILENAME(gtk_entry_get_text(Lgraveuriso));
    Ltodo = 1;
  }
  g_hash_table_insert(Ahash, "iso", &Liso); /* image iso */
  if (Lstatus && *Labort==FALSE) {
    Lextrapara = make_image_getextrapara(Ahash, "data");
    g_hash_table_insert(Ahash, "extrapara", &Lextrapara); /* parametres supplementaires */
    Lstatus = make_iso(Ahash, Aerror);
    g_hash_table_remove(Ahash, "extrapara");
    g_free(Lextrapara);
    if (strcmp(Ldst, "iso") && Lstatus && *Labort==FALSE) {
      /* ici il faut appeler cdrecord ! */
      Lextrapara = burn_data_getextrapara(Ahash);
      g_hash_table_insert(Ahash, "extrapara", &Lextrapara); /* parametres supplementaires */
      Lstatus = burn_from_image("data", Ahash, Aerror);
      g_hash_table_remove(Ahash, "extrapara");
      g_free(Lextrapara);
    }
  }

  deltempdir(Ltmpdir);
  
  if (strcmp(Ldst, "iso") && Liso
      && g_file_test(Liso, G_FILE_TEST_EXISTS + G_FILE_TEST_IS_REGULAR)==TRUE) {
    unlink(Liso);
  }
  g_free(Liso);

  g_hash_table_remove(Ahash, "todo");
  g_hash_table_remove(Ahash, "done"); 
  g_hash_table_remove(Ahash, "tmpdir"); g_free(Ltmpdir);
  g_hash_table_remove(Ahash, "operationstatus"); 
  g_hash_table_remove(Ahash, "gerror");
  g_hash_table_remove(Ahash, "iso");

  return Lstatus;
}

/* operation gravure cd audio */
gboolean burn_audio(GHashTable *Ahash, GError **Aerror)
{
  GtkTreeModel *Ltreemodel = gtk_tree_view_get_model(GTK_TREE_VIEW(g_hash_table_lookup(Ahash, "LISTEAUDIO")));

  gint Ltodo = gtk_tree_model_iter_n_children(Ltreemodel, NULL);
  gint Ldone = 0;
  gchar *Ltmpdir = NULL;
  gboolean Lstatus, Loperationstatus = FALSE;

  g_hash_table_insert(Ahash, "todo", &Ltodo); /* a faire */
  g_hash_table_insert(Ahash, "done", &Ldone); /* fais */
  g_hash_table_insert(Ahash, "operationstatus", &Loperationstatus); /* resultat de l'operation */
  g_hash_table_insert(Ahash, "gerror", Aerror);  /* pointeur retour des erreurs */
  g_hash_table_insert(Ahash, "tmpdir", &Ltmpdir); /* repertoire temporraire */

  Lstatus = preparetrack(Ahash, Aerror);

  if (Lstatus == TRUE) {
    Ldone = 1;

    Lstatus = gravepiste(Ahash, Aerror);
  }

  if (Ltmpdir) {
    _DEB("on free tmpdir !");
    deltempdir(Ltmpdir);

    g_free(Ltmpdir);
  }

  return Lstatus ? TRUE : FALSE;
}

/* on efface le repertoire temporraire */
gboolean deltempdir(gchar *Ldirpath)
{
  gchar *Lfullname;
  DIR *Ldir;
  struct dirent *Lunfic;

  if (!Ldirpath || !*Ldirpath) return TRUE;

  Ldir = opendir(Ldirpath);
  if (!Ldir) {
    g_warning("erreur lors de l'ouverture de [%s]: %s\n", Ldirpath, strerror(errno));
    return FALSE;
  }

  while ((Lunfic = readdir(Ldir))) {
    if (!strcmp(Lunfic->d_name, ".") || !strcmp(Lunfic->d_name, "..")) continue;

    Lfullname = g_strdup_printf("%s/%s", Ldirpath, Lunfic->d_name);

    if (g_file_test(Lfullname, G_FILE_TEST_IS_DIR)) {
      /* on vide le repertoire avant */
      if (FALSE==deltempdir(Lfullname)) return FALSE;
    } else {
      if (unlink(Lfullname)==-1) {
        _WARN("erreur lors de la suppresion de [%s]\n", Lfullname);
      }
    }

    g_free(Lfullname);
  }

  closedir(Ldir);

  _DEB("on efface => %s\n", Ldirpath);
  if (rmdir(Ldirpath)==-1) {
    _WARN("erreur lors de la suppresion du repertoire [%s]: %s\n", Ldirpath, strerror(errno));
    return FALSE;
  }
_DEB("ok fin efface");
  return TRUE;
}

/* retourne le type d'un peripherique */
void put_devicelabel(Tdriveinfo *Adrive, gchar *Abuf, gint Asizemax) {
  if (DRIVE_DVDWRITER(Adrive)) {
    g_strlcpy(Abuf, _("DVD Recorder"), Asizemax);
  } else if (DRIVE_WRITER(Adrive)) {
    g_strlcpy(Abuf, _("CD Recorder"), Asizemax);
  } else if (DRIVE_DVDREADER(Adrive)) {
    g_strlcpy(Abuf, _("DVD Reader"), Asizemax);
  } else if (DRIVE_READER(Adrive)) {
    g_strlcpy(Abuf, _("CD Reader"), Asizemax);
  } else {
    g_strlcpy(Abuf, _("Other device"), Asizemax);
  }
}

extern Tdriveinfo *get_drive_cmb(GtkComboBox *Acombo)
{
  GtkTreeModel *Lmodel = gtk_combo_box_get_model(GTK_COMBO_BOX(Acombo));
  GtkTreeIter Liter;
  gint Lvalue = -1;
  if (!gtk_combo_box_get_active_iter(Acombo, &Liter)) return NULL;

  gtk_tree_model_get(Lmodel, &Liter, 3, &Lvalue, -1);

  return (Tdriveinfo *) g_slist_nth_data(Glistdrives, Lvalue);
}

/* operation gravure dcd de donnee */
gboolean burn_dvddata(GHashTable *Ahash, GError **Aerror)
{
  gint Ltodo = gtk_spin_button_get_value(GTK_SPIN_BUTTON(g_hash_table_lookup(Ahash, "nbrdvddata")));
  gboolean Lsimul = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(g_hash_table_lookup(Ahash, "dvddatasimul")));
  GtkEntry *Lgraveuriso = GTK_ENTRY(g_hash_table_lookup(Ahash, "dstdvddatabtnvalue"));
  GtkWidget *Lgraveur = g_hash_table_lookup(Ahash, "dstdvddatacombo");
  gint Ldone = 1;
  gchar *Ldst = get_combo_value(Lgraveur);
  gchar *Ltmpdir = NULL;
  gchar *Lextrapara = NULL;
  gchar *Liso = NULL;
  gboolean Loperationstatus = FALSE;
  gboolean Lstatus;

  g_hash_table_insert(Ahash, "todo", &Ltodo); /* a faire */
  g_hash_table_insert(Ahash, "done", &Ldone); /* fais */
  g_hash_table_insert(Ahash, "operationstatus", &Loperationstatus); /* resultat de l'operation */
  g_hash_table_insert(Ahash, "gerror", Aerror);  /* pointeur retour des erreurs */
  g_hash_table_insert(Ahash, "tmpdir", &Ltmpdir); /* repertoire temporraire */

  /* on retourne dans ltmp le nom du repertoire temporraire utilise pour
   * l'operation */
  Lstatus = preparedata(Ahash, Aerror);
_DEB("ici LDST => %s\n", Ldst);

  Lextrapara = make_image_getextrapara(Ahash, "dvddata");
  g_hash_table_insert(Ahash, "extrapara", &Lextrapara); /* parametres supplementaires */
  if (strcmp(Ldst, "iso")) {
    if (Lsimul) Ltodo++; /* 1 pour la simulation */

    Lstatus = burn_dvd(Ahash, Aerror);

  } else {
    Liso = _FILENAME(gtk_entry_get_text(Lgraveuriso));
    Ltodo = 1;
    g_hash_table_insert(Ahash, "iso", &Liso); /* image iso */
    Lstatus = make_iso(Ahash, Aerror);
    g_hash_table_remove(Ahash, "iso");
    g_free(Liso);
  }
  g_hash_table_remove(Ahash, "extrapara");
  g_free(Lextrapara);

  deltempdir(Ltmpdir);

  g_hash_table_remove(Ahash, "todo");
  g_hash_table_remove(Ahash, "done"); 
  g_hash_table_remove(Ahash, "tmpdir"); g_free(Ltmpdir);
  g_hash_table_remove(Ahash, "operationstatus"); 
  g_hash_table_remove(Ahash, "gerror");

  return Lstatus;
}

/*
 * vim:et:ts=8:sts=2:sw=2
 */
