/* audio.c
 * Copyright (C) 2004, 2005 Sylvain Cresto <sylvain.cresto@tiscali.fr>
 *
 * This file is part of graveman!
 *
 * graveman! is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or
 * (at your option) any later version.
 * 
 * graveman! is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA. 
 * 
 * URL: http://www.nongnu.org/graveman/
 *
 */

#include "graveman.h"

/* appele pour chaque entree de la liste */
gboolean foreachtracks(GtkTreeModel *Amodel, GtkTreePath *Apath, GtkTreeIter *Aiter, gpointer Adata)
{
  GHashTable *Lhash = (GHashTable *) Adata;
  GtkLabel *LTitle = GTK_LABEL(g_hash_table_lookup(Lhash, "gravetitle"));
  gchar **Ltmpdir = (gchar **) g_hash_table_lookup(Lhash, "tmpdir");
  gint *Ldone = (gint *) g_hash_table_lookup(Lhash, "done");  
  gint *Lcont = (gint *) g_hash_table_lookup(Lhash, "cont");
  GError **Lerreur = (GError **) g_hash_table_lookup(Lhash, "gerror");  
  
  gboolean Lreturn = FALSE;
  gchar *Lutf8, *Lvers, *Lfichierlcl, *Lfichierutf8, *Lficname;
  gchar *Lext;
  
  *Lcont = 2;
  
  gtk_tree_model_get(Amodel, Aiter, 4, &Lfichierutf8, 5, &Lfichierlcl, -1);
  Lext = strrchr(Lfichierlcl, '.');
  g_assert(Lext);
  
  Lext++;

  Lficname = strrchr(Lfichierlcl, '/');
  if (Lficname) { Lficname++; } else { Lficname = Lfichierlcl; };

  /* mise a jour label */
  Lutf8 = g_strdup_printf(_("Conversion in progress... %s"), Lfichierutf8);
  gtk_label_set_text(LTitle, Lutf8);
  g_free(Lutf8);

  Lvers = g_strdup_printf("%s/piste_%d.cdr", *Ltmpdir, (*Ldone)++);
  
  /* conversion pistes audio en piste cdr pour la gravure */ 
  Lreturn = (SoundToCdr(Lhash, Lfichierlcl, Lvers, Lerreur) == TRUE ? FALSE : TRUE);
  g_free(Lvers);  
  g_free(Lfichierlcl); g_free(Lfichierutf8);

  return Lreturn;
}

gchar *make_audio_fileslist(gint Anbrfiles)
{
  gint i;
  gchar Lunfile[50];
  gchar *Lreturn = NULL;
  gint Lsize = 20 * Anbrfiles;

  Lreturn = (gchar *) g_malloc0(Lsize);
  g_assert(Lreturn);
  if (!Lreturn) return NULL;
  
  for (i=0; i < Anbrfiles; i++) {
    g_snprintf(Lunfile, sizeof(Lunfile)-1, "piste_%d.cdr ", i);
    strncat(Lreturn, Lunfile, Lsize-1);
  }

  return Lreturn;
}
  
gboolean preparetrack(GHashTable *Ahash, GError **Aerror) {
  gchar **Ltmpdir = (gchar **)g_hash_table_lookup(Ahash, "tmpdir");
  gboolean *Labort = (gboolean *)g_hash_table_lookup(Ahash, "gabort");
  gint *Lcont = (gint *)g_hash_table_lookup(Ahash, "cont");
  gchar *Lnamedir;
  GtkTreeModel *Ltreemodel = gtk_tree_view_get_model(GTK_TREE_VIEW(g_hash_table_lookup(Ahash, "LISTEAUDIO")));
  GtkProgressBar *Lprogressbar2 = GTK_PROGRESS_BAR(g_hash_table_lookup(Ahash, "pb_step"));
  g_assert(GTK_IS_TREE_MODEL(Ltreemodel));

  Lnamedir = g_strdup_printf("%s/%s", conf_get_string_def("tmpdir", "/tmp"), "gravemanXXXXXX");

  if (!mkdtemp(Lnamedir)) {
    g_set_error(Aerror, G_FILE_ERROR, g_file_error_from_errno(errno), "%s %s: %s",
      _("Cannot create directory"), Lnamedir, g_strerror(errno));
    g_free(Lnamedir);
    return FALSE;
  }

  *Ltmpdir = Lnamedir;

  *Lcont = 2;
  g_timeout_add(500, encours_callback, Ahash);

  /* conversion de chaques fichiers */
  gtk_tree_model_foreach(Ltreemodel, foreachtracks, Ahash);

  /* on attend la fin du timeout */
  *Lcont = 1;
  while (*Lcont > 0) gtk_main_iteration(); 

  gtk_progress_bar_set_fraction(Lprogressbar2, 0);
  gtk_progress_bar_set_text(GTK_PROGRESS_BAR(Lprogressbar2), "0%");

  if (*Labort==TRUE) return FALSE;
  if ((GError *)*Aerror) {
    deltempdir(Lnamedir);
    *Ltmpdir = NULL;
    g_free(Lnamedir);
    return FALSE;
  }

  return TRUE;
}

/*
 * vim:et:ts=8:sts=2:sw=2
 */
