/* images.c
 * Copyright (C) 2005 Sylvain Cresto <scresto@gmail.com>
 *
 * This file is part of graveman!
 *
 * graveman! is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or
 * (at your option) any later version.
 * 
 * graveman! is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA. 
 * 
 * URL: http://www.nongnu.org/graveman/
 *
 */


#include "graveman.h"


GHashTable *Gimages = NULL;
GHashTable *Ganimationpath = NULL;

/*GdkPixbuf *GDirIcone, *GFileIcone, *GCDIcone, *GAudioIcone, *GCDRWIcone, *GCDpetiteIcone,
  *GCDRWpetiteIcone, *GpetiteGraver, *GGraver, *GISOpetiteIcone, *GEraseCdrw, *GFileImage,
  *GDVDpetiteIcone, *GDVDRWpetiteIcone, *GcharsetpetiteIcone, *GiconeOK, *GiconePASOK, *GiconeMITIGE,
  *GMenuAudio = NULL, *GMenuData = NULL, *GMenuCopy = NULL, *GMenuOther = NULL, *GMenuDvd = NULL;*/

Timages Lotherimages[] = {
    { "DirIcon",          "directory icon",      _IMG_PNG },
    { "FileIcon",         "file icon",           _IMG_PNG },
    { "FileImage",        "file image",          _IMG_PNG },
    { "CDIcon",           "cd icon",             _IMG_PNG },
    { "AudioIcon",        "audio icon",          _IMG_PNG },
    { "CDRWIcon",         "cdrw icon",           _IMG_PNG },
    { "CDRWsmallIcon",    "cdrw small icon",     _IMG_PNG },
    { "DVDsmallIcon",     "dvd small icon",      _IMG_PNG },
    { "DVDRWsmallIcon",   "dvdrw small icon",    _IMG_PNG },
    { "CDsmallIcon",      "cd small icon",       _IMG_PNG },
    { "ISOsmallIcon",     "iso small icon",      _IMG_PNG },
    { "BurnsmallIcon",    "burn small icon",     _IMG_PNG },
    { "BurnIcon",         "burn icon",           _IMG_PNG },
    { "EraseCDRWIcon",    "erase cdrw icon",     _IMG_PNG },
    { "CharsetSmallIcon", "charset small icon",  _IMG_PNG },
    { "OKIcon",           "ok icon",             _IMG_PNG },
    { "BADIcon",          "bad icon",            _IMG_PNG },
    { "WARNIcon",         "warning icon",        _IMG_PNG },
    { "Themes",           "theme icon",          _IMG_PNG },
    { "Working",          "graveman animation",  _IMG_MNG },
    { NULL }
  };

Timages Lmenuimages[] = {
    { "Menu-Audio-",      "menu audio icon",     _IMG_PNG },
    { "Menu-Data-",       "menu data icon",      _IMG_PNG },
    { "Menu-Dvd-",        "menu dvd icon",       _IMG_PNG },
    { "Menu-Copy-",       "menu copy icon",      _IMG_PNG },
    { "Menu-Other-",      "menu other icon",     _IMG_PNG },
    { NULL }
  };

/* charger toutes les images a partir du bon rpertoire */
gboolean load_all_images()
{
  GHashTable *Limagespath = get_imagespath_plus_from_theme(Lotherimages, conf_get_string("theme"), NULL, NULL);
  gchar *Lpath;
  gboolean Laumoinsun = FALSE;
  Timages *Lcurimage;

  if (!Limagespath) return FALSE;

  Gimages = _hash();
  Ganimationpath = _hash();

  for (Lcurimage = Lotherimages; Lcurimage->code; Lcurimage++) {
    Lpath = g_hash_table_lookup(Limagespath, Lcurimage->code);
    if (!Lpath) continue;
    if (Lcurimage->type == _IMG_PNG) {
      g_hash_table_insert(Gimages, Lcurimage->code, gdk_pixbuf_new_from_file((const gchar *)Lpath, NULL));
      g_free(Lpath);
    } else {
      g_hash_table_insert(Ganimationpath, Lcurimage->code, Lpath);
    }
    Laumoinsun = TRUE;
  }

  g_hash_table_destroy(Limagespath);
  return Laumoinsun;
}

GdkPixbuf *get_image(gchar *Aident)
{
  return (GdkPixbuf *) g_hash_table_lookup(Gimages, Aident);
}

gchar *get_animation(gchar *Aident)
{
  return (gchar *) g_hash_table_lookup(Ganimationpath, Aident);
}

gboolean load_menu_images(gchar *Lquel) {
  Timages *Lcurimages;
  GdkPixbuf *Limg;
  GHashTable *Limagespath = get_imagespath_plus_from_theme(Lmenuimages,
                              conf_get_string("theme"), Lquel, NULL);
  Timages *Lcurimage;
  gboolean Laumoinsun = FALSE;
  gchar *Lpath;

  if (!Limagespath) return FALSE;

  if (Gimages) {
    for (Lcurimages = Lmenuimages; Lcurimages->code; Lcurimages++) {
      Limg = (GdkPixbuf *) g_hash_table_lookup(Gimages, Lcurimages->code);

      if (Limg) {
        g_object_unref(Limg);
        g_hash_table_remove(Gimages, Lcurimages->code);
      }
    }
  }

  for (Lcurimage = Lmenuimages; Lcurimage->code; Lcurimage++) {
    Lpath = g_hash_table_lookup(Limagespath, Lcurimage->code);
    if (!Lpath) continue;

    g_hash_table_insert(Gimages, Lcurimage->code, gdk_pixbuf_new_from_file((const gchar *)Lpath, NULL));
    Laumoinsun = TRUE;

    g_free(Lpath);
  }

  g_hash_table_destroy(Limagespath);

  return Laumoinsun;
}

gboolean prepare_menu_images(Tgrave *Ag)
{
  gchar *Limg = conf_get_string("iconsize");
  gchar *Lcurrent = sc_grave_get_data(Ag, "_current_size");
  gboolean Lstatus = TRUE;

  if (!Lcurrent || strcmp(Lcurrent, Limg)) {
    Lstatus = load_menu_images(Limg);

    g_free(Lcurrent);
    sc_grave_replace_data(Ag, g_strdup(Limg), "_current_size");
  }

  return Lstatus;
}


void free_all_images()
{
/*  g_object_unref(GiconeOK);
  g_object_unref(GiconePASOK);
  g_object_unref(GiconeMITIGE);
  g_object_unref(GcharsetpetiteIcone);
  g_object_unref(GEraseCdrw);
  g_object_unref(GGraver);
  g_object_unref(GISOpetiteIcone);
  g_object_unref(GpetiteGraver);
  g_object_unref(GDVDRWpetiteIcone);
  g_object_unref(GCDRWpetiteIcone);
  g_object_unref(GDVDpetiteIcone);
  g_object_unref(GCDpetiteIcone);
  if (G_IS_OBJECT(GMenuOther)) g_object_unref(GMenuOther);
  if (G_IS_OBJECT(GMenuCopy)) g_object_unref(GMenuCopy);
  if (G_IS_OBJECT(GMenuData)) g_object_unref(GMenuData);
  if (G_IS_OBJECT(GMenuDvd)) g_object_unref(GMenuDvd);
  if (G_IS_OBJECT(GMenuAudio)) g_object_unref(GMenuAudio);
  g_object_unref(GCDRWIcone);
  g_object_unref(GAudioIcone);
  g_object_unref(GCDIcone);
  g_object_unref(GFileImage);
  g_object_unref(GFileIcone);
  g_object_unref(GDirIcone);
*/
}

/*
 * vim:et:ts=8:sts=2:sw=2
 */
