#
# $Id$
#
# This file is part of GraphTool.
#
# GraphTool is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# GraphTool is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GraphTool; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
import gobject
import gtk
import types

def disconnect_func (data):
    gobject.GObject.disconnect(data.instance, data.id)

def value_changed (entry, object, prop):
    try:
        prop[2](prop[3](entry.get_text()))
    except ValueError:
        print ('Unable to set value', entry.get_text(), 'to', object,
               ': type error')

def property_widget (object, prop):
    # prop : [label, getter, setter, type_of_value, tips]
    prop_edit = gtk.Entry()
    if prop[1]:
        prop_edit.set_text (str(prop[1]()))
    if prop[2]:
        prop_edit.connect('activate', value_changed, object, prop)
    else:
        prop_edit.setEditable(False)
    return prop_edit
 
# construit l'diteur de proprit associ  un objet
def create_prop_editor (object):
    # en cours de rflexion
##     try:
##         win = object._prop_editor_win
##         win.show_all()
##         return win
##     except AttributeError:
##         pass
    
    win = gtk.Window()
    tips = gtk.Tooltips()
    win.connect('destroy', gtk_object_destroy, tips)
#    object._prop_editor_win = win

    win.set_title ('Properties of object ' + gobject.type_name(object) +
                   ' (' + gobject.type_name(object) + ')')

    tab = object.get_accessors()
    # tab : [label, getter, setter, type_of_value, tips]
    
    if not len (tab):
        vbox = gtk.VBox()
        vbox.pack_start(gtk.Label('This object has no editable properties'))
        but = gtk.Button('Fermer')
        but.connect('clicked', close_window, win)
        vbox.pack_start(but)
        win.add(vbox)
#        win.set_default_size(100, 150)
        win.show_all()
        return win

    table = gtk.Table (len(tab), 2, False)
    table.set_col_spacing (0, 10)
    table.set_row_spacings (3)

    count = 0

    for prop in tab:
        label = gtk.Label (prop[0])
        label.set_alignment (0.0, 0.5)
        table.attach_defaults (label, 0, 1, count, count + 1)

        prop_edit = property_widget (object, prop)
        if prop_edit:
            table.attach_defaults (prop_edit, 1, 2, count, count + 1)

        count = count + 1

    vbox = gtk.VBox()
    vbox.pack_start(table)
    sw = gtk.ScrolledWindow()
    sw.set_policy(gtk.POLICY_NEVER, gtk.POLICY_AUTOMATIC)
    sw.add_with_viewport (vbox)
    vbox = gtk.VBox()
    vbox.pack_start(sw)
    but = gtk.Button('Fermer')
    but.connect('clicked', close_window, win)
    vbox.pack_start(but)
    win.add(vbox)
#    win.set_default_size(300, 150)
    win.show_all()

    return win

def close_window (obj, win):
    win.hide()

def gtk_object_destroy (o, junk=None):
    o.hide()
    return 1
