#
# $Id$
#
# This file is part of GraphTool.
#
# GraphTool is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# GraphTool is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GraphTool; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
import vcnode
import interactive as inter

class Node(vcnode.VcNode, inter.Interactive):
    def __init__(self, graph, name):
        vcnode.VcNode.__init__(self)
        inter.Interactive.__init__(self)
        self._graph = graph
        self._name = name
        self._out_edges = []
        self._in_edges = []

    def __del__(self):
        vcnode.VcNode.__del__(self)

    def delete (self):
        #on itre sur une *copie* de la liste des edges
        edges = self._out_edges + self._in_edges
        for edge in edges:
            edge.delete ()
        self._graph.remove_node (self)
         
    def get_name (self):
        return self._name

    def get_out_edges (self):
        return self._out_edges

    def get_in_edges (self):
        return self._in_edges

    def is_connected (self):
        if (len (self._out_edges) == 0) and \
           (len (self._in_edges) == 0):
            return False
        return True
    
    def get_predecessors (self):
        predecessors = []
        if (len (self._in_edges) > 0):
            for edge in self._in_edges:
                predecessors.append (edge.get_first_node ())
        return predecessors

    def get_successors (self):
        successors = []
        if (len (self._out_edges) > 0):
            for edge in self._out_edges:
                successors.append (edge.get_second_node ())
        return successors
        
    def add_out_edge (self, edge):
        self._out_edges.append (edge)
            
    def add_in_edge (self, edge):
        self._in_edges.append (edge)
        
    def remove_out_edge (self, edge):
        self._out_edges.remove (edge)
        
    def remove_in_edge (self, edge):
        self._in_edges.remove (edge)
        

    ##AJOUT D'ATTRIBUTS
    def add_attribute (self, attribute_name, attribute_value):
        if (not hasattr (self, attribute_name)):
            setattr (self, attribute_name, attribute_value)
            return 1
        return 0

    
