/* lists.h

   Written by Frederic Bois
   22 June 2014

   Copyright (c) 2014 Frederic Bois.

   This code is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   See the GNU General Public License at <http://www.gnu.org/licenses/> 

   -- Revisions -----
     Logfile:  %F%
    Revision:  %I%
        Date:  %G%
     Modtime:  %U%
      Author:  @a
   -- SCCS  ---------

*/

#ifndef LISTS_H_DEFINED


/* ----------------------------------------------------------------------------
   Typedefs
*/

typedef struct tagLISTELEMI { // List element record for integers
  int    iVal;
  struct tagLISTELEMI *pleInitialNext; // Next in the list at initialization
  struct tagLISTELEMI *next;           // Next in the list
} LISTELEMI, *PLISTELEMI;

typedef struct tagLISTELEML { // List element record for longs
  long   lVal;
  struct tagLISTELEML *pleInitialNext; // Next in the list at initialization
  struct tagLISTELEML *next;           // Next in the list
} LISTELEML, *PLISTELEML;

typedef struct tagLISTELEMD { // List element record for doubles
  double dVal;
  struct tagLISTELEMD *pleInitialNext; // Next in the list at initialization
  struct tagLISTELEMD *next;           // Next in the list
} LISTELEMD, *PLISTELEMD;

typedef struct tagLISTELEMS { // List element record for strings
  long   nodeID;
  struct tagLISTELEMS *pleInitialNext; // Next in the list at initialization
  struct tagLISTELEMS *next;           // Next in the list
} LISTELEMS, *PLISTELEMS;

typedef struct tagLISTI {  // List record for integers
  PLISTELEMI Head;         // First elem in list
  PLISTELEMI Tail;         // Last elem in list
  PLISTELEMI OriginalHead;
  PLISTELEMI Point_to_Head;
  long       lSize;        // Number of elems in list
} LISTI, *PLISTI;

typedef struct tagLISTL {  // List record for longs
  PLISTELEML Head;         // First elem in list
  PLISTELEML Tail;         // Last elem in list
  PLISTELEML OriginalHead;
  PLISTELEML Point_to_Head;
  long       lSize;        // Number of elems in list
} LISTL, *PLISTL;

typedef struct tagLISTD {  // List record for doubles
  PLISTELEMD Head;         // First elem in list
  PLISTELEMD Tail;         // Last elem in list
  PLISTELEMD OriginalHead;
  PLISTELEMD Point_to_Head;
  long       lSize;        // Number of elems in list
} LISTD, *PLISTD;

typedef struct tagLISTS {  // List record for strings
  PLISTELEMS Head;         // First elem in list
  PLISTELEMS Tail;         // Last elem in list
  PLISTELEMS OriginalHead;
  PLISTELEMS Point_to_Head;
  long       lSize;        // Number of elems in list
} LISTS, *PLISTS;


/* ----------------------------------------------------------------------------
   Prototypes
*/

void   FreedList (PLISTD *pplist);
void   FreeiList (PLISTI *pplist);
void   FreelList (PLISTL *pplist);
PLISTD InitdList (void);
PLISTI InitiList (void);
PLISTI InitlList (void);
PLISTS InitsList (void);
void   PrintdList (FILE *pFile, PLISTELEMD pfrom, PLISTELEMD pto);
void   PrintiList (FILE *pFile, PLISTELEMI pfrom, PLISTELEMI pto);
void   QueuedListItem (PLISTD plist, double dVal);
void   QueueiListItem (PLISTI plist, int    iVal);
void   QueuelListItem (PLISTL plist, long   lVal);


/* End */

#define LISTS_H_DEFINED
#endif  /* LISTS_H_DEFINED */

