/*
 *  HutchinsTM
 *
 *  Copyright (C) 2008 by Eric Hutchins
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **/

#ifndef __TRANSITION_H__
#define __TRANSITION_H__

#include <string>
#include <vector>
using namespace std;

#include "state.h"

class Transition
{
  private:
    State* m_begin_state;
    vector<string> m_input_symbols;
    vector<string> m_output_symbols;
    vector<int> m_movement;
    State* m_end_state;
  public:
    /*
    Transition(State* begin_state, string input_symbol, string output_symbol, 
               int movement, State* end_state);
	       */
    Transition(State* begin_state, vector<string> input_symbols, 
               vector<string> output_symbols, vector<int> movement, 
               State* end_state);
    ~Transition();
    vector<string> getInputSymbols() { return m_input_symbols; }
    vector<string> getOutputSymbols() { return m_output_symbols; }
    State* getBeginState() { return m_begin_state; }
    vector<int> getMovement() { return m_movement; }
    State* getEndState() { return m_end_state; }
};

#endif

