/*
 *  Graphical Turing Machine
 *
 *  Copyright (C) 2008 by Eric Hutchins
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **/

#ifndef __TM_H__
#define __TM_H__

#include <fstream>
#include <sstream>
#include <vector>
#include <iostream>
using namespace std;

#include "stateset.h"
#include "transition.h"
#include "tapedrive.h"

class TM
{
  protected:
    StateSet* m_state_set;
    map<string,Transition*> m_delta;
    State* m_start_state;
    map<string,State*> m_final_state_set;
    vector<TapeDrive*> m_tape_drives;
    State* m_current_state;
    bool m_accept;
    bool m_reject;
  public:
    TM();
    TM(string tm_file, int tape_count);
    ~TM();
    void loadTM(string filename);
    void loadInput(string filename);
    void loadInput(vector<string> filenames);
    void print();
    void printInfo();
    bool cycle();
    void clearAcceptReject();
    bool isInFinalState()
    {
      return m_final_state_set[m_current_state->getName()] != NULL;
    }
    void moveToStartState() { m_current_state = m_start_state; }
};

#endif
