/*
 *  Graphical Turing Machine
 *
 *  Copyright (C) 2008 by Eric Hutchins
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **/

#ifndef __TAPEDRIVE_H__
#define __TAPEDRIVE_H__

#include <string>
#include <vector>
#include <iostream>
using namespace std;

class TapeDrive
{
  private:
    vector<string> m_tape;
    int m_pos;
  public:
    TapeDrive();
    ~TapeDrive();
    string read();
    void write(string symbol);
    void shift(int k);
    void reset();
    void clear();
    string getHead();
    string getTail();
    vector<string> getHeadTail();
    vector<string> getTape() { return m_tape; }
    int getPos() { return m_pos; }
};

#endif
