/*
 *  Graphical Turing Machine
 *
 *  Copyright (C) 2008 by Eric Hutchins
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **/

#include "tapedrive.h"

TapeDrive::TapeDrive()
{
}

TapeDrive::~TapeDrive()
{
}

void TapeDrive::write(string symbol)
{
  while(m_tape.size() <= m_pos) m_tape.push_back("_");
  m_tape[m_pos] = symbol;
}

string TapeDrive::read()
{
  if(m_pos < m_tape.size())
    return m_tape[m_pos];
  else return "_";
}

void TapeDrive::shift(int k)
{
  m_pos += k;
}

void TapeDrive::reset()
{
  m_pos = 0;
}

void TapeDrive::clear()
{
  while(m_tape.size())
    m_tape.erase(m_tape.begin());
  m_pos = 0;
}

string TapeDrive::getHead()
{
  if(m_pos == 0) return "";
  string temp = "[";
  for(int i = 0; i < m_pos; i++)
    if(i < m_pos - 1)
      temp += m_tape[i] + ", ";
    else temp += m_tape[i];
  temp += "]";
  return temp;
}

string TapeDrive::getTail()
{
  if(m_tape.size() == m_pos) return "";
  string temp = "[";
  for(int i = m_pos; i < m_tape.size(); i++)
    if(i < m_tape.size() - 1)
      temp += m_tape[i] + ", ";
    else temp += m_tape[i];
  temp += "]";
  return temp;
}

vector<string> TapeDrive::getHeadTail()
{
  vector<string> result;
  result.push_back(getHead());
  result.push_back(getTail());
  return result;
}

